module Formula (Formula(..), tosmt, formulaChangeCore) where

formulaChangeCore :: (a -> b) -> (Formula a) -> (Formula b)
formulaChangeCore f (AND s lst) = AND  s (map (formulaChangeCore f) lst)
formulaChangeCore f (OR   lst)  = OR    (map (formulaChangeCore f) lst)
formulaChangeCore f (EQUIV a b) = EQUIV (formulaChangeCore f a) (formulaChangeCore f b)
formulaChangeCore f (IMPL a b)  = IMPL  (formulaChangeCore f a) (formulaChangeCore f b)
formulaChangeCore f (NOT  a)    = NOT   (formulaChangeCore f a)
formulaChangeCore f (BASIC a)   = BASIC (f a)

data Formula a = AND String [Formula a] | OR [Formula a]
               | EQUIV (Formula a) (Formula a)
               | IMPL (Formula a) (Formula a)
               | NOT (Formula a)
               | BASIC a
tosmt :: Int -> (a->String) -> (Formula a) -> String
tosmt _ _ (AND _ []) = "true"
tosmt _ _ (OR    []) = "false"
tosmt i ds x = "("++tosmt' x++")"
 where idt = "\n"++take i (repeat ' ')
       m op a b = op++idt ++ tosmt (i+1) ds a ++ idt ++ tosmt (i+(length op)) ds b
       tosmt' (IMPL a b)     = m "=>" a b
       tosmt' (EQUIV a b)      = m "=" a b
       tosmt' (AND s as)       = "and ; "++s++ concat [idt ++ tosmt (i+2) ds a | a <- as]
       tosmt' (OR  as)       = "or" ++ concat [idt ++ tosmt (i+2) ds a | a <- as]
       tosmt' (NOT a)        = "not "++tosmt (i+5) ds a
       tosmt' (BASIC a)      = ds a