extern bool* sure;

void propagate_liveness_backward (int curr, int out_port);
void propagate_liveness_forward (int curr, int in_port) {
	if (sure[curr]) return;
	if (curr == -1) return;
	switch (xMas_network[curr].type) {
		case buffer:
		case queue:
printf("Queue %s is live.\n", xMas_network[curr].id);
		case function:
		case source:
		case merge:
			sure[curr] = true;
//printf("Component %s is live.\n", xMas_network[curr].id);
			propagate_liveness_forward(xMas_network[curr].out[0], xMas_network[curr].in_port_connected_to_out[0]);
			return;
		case sink:
			return;
		case xfork:
		case xswitch:
		case aswitch:
//printf("Component %s is live.\n", xMas_network[curr].id);
			sure[curr] = true;
			propagate_liveness_forward(xMas_network[curr].out[0], xMas_network[curr].in_port_connected_to_out[0]);
			propagate_liveness_forward(xMas_network[curr].out[1], xMas_network[curr].in_port_connected_to_out[1]);
			// For switches we assume that routing does not route all packets to one of the outputs
			return;
		case join:
		case synch: {
//printf("Component %s is live.\n", xMas_network[curr].id);
			sure[curr] = true;
			int in,out;
			for (out=0;out<xMas_network[curr].num_of_outs;out++)
				propagate_liveness_forward(xMas_network[curr].out[out], xMas_network[curr].in_port_connected_to_out[out]);
			for (in=0;in<xMas_network[curr].num_of_ins;in++) {
				if (in != in_port)
					propagate_liveness_backward(xMas_network[curr].in[in], xMas_network[curr].out_port_connected_to_in[in]);
			}
			return;
		}
	}
	printf("ERROR: unknown component\n");
	assert(false);
}

void propagate_liveness_backward (int curr, int out_port) {
	if (sure[curr]) return;
	if (curr == -1 || (xMas_network[curr].type != source && xMas_network[curr].in[0] == -1)) return;
	if (out_port == -1) return;
	switch (xMas_network[curr].type) {
		case buffer:
		case queue:
printf("Queue %s is live.\n", xMas_network[curr].id);
		case function:
//printf("Component %s is live.\n", xMas_network[curr].id);
			sure[curr] = true;
			propagate_liveness_backward(xMas_network[curr].in[0], xMas_network[curr].out_port_connected_to_in[0]);
			return;
		case source:
		case merge:
		case xswitch:
		case aswitch:
			return;
		case join:
//printf("Component %s is live.\n", xMas_network[curr].id);
			sure[curr] = true;
			propagate_liveness_backward(xMas_network[curr].in[0], xMas_network[curr].out_port_connected_to_in[0]);
			propagate_liveness_backward(xMas_network[curr].in[1], xMas_network[curr].out_port_connected_to_in[1]);
			return;
		case xfork:
		case synch: {
//printf("Component %s is live.\n", xMas_network[curr].id);
			sure[curr] = true;
			int in,out;
			for (out=0;out<xMas_network[curr].num_of_outs;out++) {
				if (out != out_port)
					propagate_liveness_forward(xMas_network[curr].out[out], xMas_network[curr].in_port_connected_to_out[out]);
			}
			for (in=0;in<xMas_network[curr].num_of_ins;in++)
				propagate_liveness_backward(xMas_network[curr].in[in], xMas_network[curr].out_port_connected_to_in[in]);
			return;
		}
	}
	printf("ERROR: unknown component\n");
	assert(false);
}

