#include<stdio.h>
#include<stdlib.h>
#include<stdarg.h>
#include<memory.h>
#include<setjmp.h>
#include "interface_to_SMT.c"


extern inv_t* invariants;
extern bool* queue_subject_to_invariants;
extern bool* type_specific_queues;
bool* pruning_is_full = NULL;
bool pruning_full(int curr) {
        if (pruning_is_full != NULL)
                return pruning_is_full[curr];
        return false;
}


void get_vars(Z3_context c, FILE * out, Z3_ast v, Z3_ast** vars, int* num_vars, int* vars_size) 
{
    switch (Z3_get_ast_kind(c, v)) {
    case Z3_APP_AST: {
        unsigned i;
        Z3_app app = Z3_to_app(c, v);
        unsigned num_fields = Z3_get_app_num_args(c, app);
        Z3_func_decl d = Z3_get_app_decl(c, app);
        if (num_fields > 0) {
            for (i = 0; i < num_fields; i++) {
				get_vars(c, out, Z3_get_app_arg(c, app, i), vars, num_vars, vars_size);
            }
        }
		else {
			if (*num_vars >= *vars_size) {
				(*vars_size) *= 2;
				(*vars) = (Z3_ast*) realloc(*vars, (*vars_size) * sizeof(Z3_ast));
				assert ((*vars) != NULL);
			}
			int i;
			bool found = false;
			for (i=0;i<*num_vars&&!found;i++)
				found |= Z3_is_eq_ast(c, (*vars)[i], v);
			if (!found)
				(*vars)[(*num_vars)++] = v;
		}
        break;
    }
    default:
		break;
    }
}


void analyze_queue_subject_to_invariants(inv_t* inv) {
	Z3_ast* vars = malloc(10 * sizeof(Z3_ast));
	int num_vars = 0, vars_size = 10;
	get_vars(inv->ctx,stdout,inv->f,&vars,&num_vars,&vars_size);

	int i,j;
	bool found;
	for (i=0;i<num_vars;i++) {
		char* name = (char*) Z3_get_symbol_string(inv->ctx, Z3_get_decl_name(inv->ctx, Z3_get_app_decl(inv->ctx, Z3_to_app(inv->ctx, vars[i]))));
		char queue_name[100];

		int index_of_dot = -1;
		for (j=0;j<strlen(name)&&index_of_dot==-1;j++)
			index_of_dot = name[j] == '.' ? j : -1;
		if (index_of_dot == -1) {
			strncpy(queue_name, name, strlen(name));
			queue_name[strlen(name)] = '\0';
		}
		else {
			strncpy(queue_name, name, index_of_dot);
			queue_name[index_of_dot] = '\0';
		}

		found = false;
		for (j=0;j<xMas_network_size&&!found;j++)
			found |= !strcmp(xMas_network[j].id, queue_name);
		if (found) {
			if (queue_subject_to_invariants[j-1] == false) {
				assert_queue_size(inv, j-1);
				queue_subject_to_invariants[j-1] = true;
			}
		}
	}
	free(vars);
}
void analyze_type_specific_queues(inv_t* inv) {
	Z3_ast* vars = malloc(10 * sizeof(Z3_ast));
	int num_vars = 0, vars_size = 10;
	get_vars(inv->ctx,stdout,inv->f,&vars,&num_vars,&vars_size);

	int i,j;
	bool found;
	for (i=0;i<num_vars;i++) {
		char* name = (char*) Z3_get_symbol_string(inv->ctx, Z3_get_decl_name(inv->ctx, Z3_get_app_decl(inv->ctx, Z3_to_app(inv->ctx, vars[i]))));
		int index_of_dot = -1;
		for (j=0;j<strlen(name)&&index_of_dot==-1;j++)
			index_of_dot = name[j] == '.' ? j : -1;
		if (index_of_dot != -1) {
			char queue_name[100];
			strncpy(queue_name, name, index_of_dot);
			queue_name[index_of_dot] = '\0';
			/*char packet_name[100];
			strncpy(packet_name, name+index_of_dot+1, strlen(name) - index_of_dot);
			queue_name[strlen(name) - index_of_dot] = '\0';
			printf("P = %s\n", packet_name);*/
			found = false;
			for (j=0;j<xMas_network_size&&!found;j++)
				found |= !strcmp(xMas_network[j].id, queue_name);
			if (found)
				type_specific_queues[j-1] = true;
		}
	}
	free(vars);
}

inv_t* read_invariants() {
    Z3_ast fs;
    LOG_MSG("smt2parser_example");

    Z3_context ctx_invariants = mk_context();

    fs  = Z3_parse_smtlib2_file(ctx_invariants, INVARIANTS_FILE, 0, 0, 0, 0, 0, 0);
    //printf("formulas: %s\n", Z3_ast_to_string(ctx_invariants, fs));
    int i;
	Z3_assert_cnstr(ctx_invariants,fs);

    //Z3_del_context(ctx);
	inv_t* ret = malloc(sizeof(inv_t));
	ret->ctx = ctx_invariants;
	ret->f = fs;
	return ret;
}
