#ifndef PATHS
#define PATHS
#include "formula.c"
#include "interface_to_SMT.c"


extern bool* eqns_full;
extern int* eqns_gt1;
extern bool** eqns_zero;
extern path* curr_path;
extern const int PATH_SIZE;
extern bool idle_equation_set;
extern bool pruning_full(int curr);
extern bool* queue_subject_to_invariants;
extern struct set_of_paths** bl_paths;
extern struct set_of_paths*** id_paths;
extern formula*** bl_formula;
extern formula**** id_formula;
extern const int PATH_SIZE;
extern int const NUM_OF_PATHS_PER_QUEUE;

//-----CREATING CURRENT PATH EQUATIONS-----//
/* There is a conjunction of equations corresponding to the path leading from the initial queue to the current node.
   These are stored using boolean arrays, and in the path struct called curr_path (see `DATA STRUCTURES').
   The following function write to these arrays, but only as long as the conjunction of all equations is still true.
   I.e., these functions ensure the structure is always internally consistent.
*/


/* Assert that queue 'curr' is full
This is not done if currently the queue is empty or if the pruning says the queue can never be full.
*/
int add_eqns_full_queue(int curr) {
		if (eqns_zero[curr][NUM_OF_HEADERS])
				return -1;
		else if (pruning_full(curr))
				return -1;
		else {
			eqns_full[curr] = true;
			//if (queue_subject_to_invariants[curr]) {
				assert(curr_path->num_of_elts < PATH_SIZE);
				literal lit = {curr, 0, IS_FULL};
				curr_path->elts[curr_path->num_of_elts++] = lit;
				return 1;
			//}
			return 0;
		}
		return -1;
}
/* Assert that queue 'curr' contains a packet
This is not done if currently the queue is empty or if the queue is empty for packets with the header
Returns the yices id of the assertion if an assertion has been made, otherwise -1.
*/
int add_eqns_packet_in_queue(int curr, int header) {
		if (eqns_zero[curr][header] || eqns_zero[curr][NUM_OF_HEADERS])
				return -1;
		else {
			eqns_gt1[curr] = header;
			//if (queue_subject_to_invariants[curr]) {
				assert(curr_path->num_of_elts < PATH_SIZE);
				literal lit = {curr, header, IS_GT_ONE};
				curr_path->elts[curr_path->num_of_elts++] = lit;
				return 1;
			//}
			return 0;
		}
		return -1;
}
/* Assert that queue 'curr' contains no packet with the header.
if header == NUM_OF_HEADERS, then the queue is asserted to completely empty.
The queue is not asserted to be completely empty if ot is already full.
The queue cannot be empty for packets with the header if it contains a packet with header.
Returns the yices id of the assertion if an assertion has been made, otherwise -1.
*/
int add_eqns_empty_queue(int curr, int header) {
		if ((eqns_full[curr] && header == NUM_OF_HEADERS) || eqns_gt1[curr] == header)
				return -1;


		else {
			eqns_zero[curr][header] = true;
			//if (queue_subject_to_invariants[curr]) {
				assert(curr_path->num_of_elts < PATH_SIZE);
				literal lit = {curr, header, IS_ZERO};
				curr_path->elts[curr_path->num_of_elts++] = lit;
				return 1;
			//}
			return 0;
		}
		return -1;
}
/* Retract the last made assertion.
*/
void retract_curr_path(int id) {
	if (id == 1) {
		assert(curr_path->num_of_elts > 0);
		curr_path->num_of_elts--;
	}
}
/* Print the equations of the path stored in the 'eqns_' arrays*/
void print_eqns() {
		int i,h;
		for (i=0;i<xMas_network_size;i++)
				if (xMas_network[i].type == queue || xMas_network[i].type == buffer) {
						if (eqns_full[i])
								printf("%s = %s.size\n", xMas_network[i].id, xMas_network[i].id);
						for (h=0;h<NUM_OF_HEADERS;h++) {
								if (eqns_gt1[i] == h)
										printf("%s.%s >= 1\n", xMas_network[i].id, print_header(h));
								if (eqns_zero[i][h])
										printf("%s.%s = 0\n", xMas_network[i].id, print_header(h));
						}
						if (eqns_zero[i][NUM_OF_HEADERS])
								printf("%s = 0\n", xMas_network[i].id);
				}
}


//----REPORT DEADLOCKS----//

/* Stores a path of an lp_solve call, i.e., which relevant variables are involved in the call.
   These paths can later be used to minimize the number of lp_solve calls.
*/
formula* curr_path_to_formula() {
	formula* ret = singleton_formula(0,0,IS_TRUE);
	int i, h;
	for (i=0;i<curr_path->num_of_elts;i++) {
		switch(curr_path->elts[i].constraint) {
		case IS_FULL:
		case IS_ZERO:
			h = curr_path->elts[i].header;
			break;
		case IS_GT_ONE:
			h = type_specific_queues[curr_path->elts[i].queue] ? curr_path->elts[i].header : NUM_OF_HEADERS;
			break;
		default:
			assert(false);
		}
		if (queue_subject_to_invariants[curr_path->elts[i].queue])
			ret = conjunct(singleton_formula(curr_path->elts[i].queue, h, curr_path->elts[i].constraint), ret);
	}
	return ret;
}



/* The following function is called each time a closed subgraph is detected.
   If it is feasible, a deadlock is reported.
   Otherwise the function simply returns false.
*/

bool path_member(path* p, literal l) {
		int i;
		bool ret = false;
		for (i=0;i<p->num_of_elts&&!ret;i++)
				ret = equal_literals(l, p->elts[i]);
		return ret;
}
bool subsumed_by(path* p1, path* p2) {
		int i;
		bool ret = true;
		for (i=0;i<p2->num_of_elts&&ret;i++)
				ret = path_member(p1, p2->elts[i]);
		return ret;
}


int subsumed_by_earlier_bl_visit(path * path, int curr) {
		int i;
		bool ret = false;
		for (i=0;i<bl_paths[curr]->num_of_paths&&!ret;i++)
				ret = subsumed_by(path, bl_paths[curr]->paths[i]);
		return ret ? i-1 : -1;
}
int subsumed_by_earlier_id_visit(path * path, int curr, int header) {
		int i;
		bool ret = false;
		for (i=0;i<id_paths[curr][header]->num_of_paths&&!ret;i++)
				ret = subsumed_by(path, id_paths[curr][header]->paths[i]);
		return ret ? i-1 : -1;
}




void store_bl_formula_for_path(int curr, path* p, formula* f) {
		if	(bl_paths[curr]->num_of_paths >= NUM_OF_PATHS_PER_QUEUE) { 
			printf("Increase number of paths stored per queue\n");
			printf("curr === %s, path == \n", xMas_network[curr].id);
			print_path(p);
			printf("\nformula == ");
			print_formula(f);
			printf("\n");
			
			assert(false);
		}
//printf("Storing bl formula\n");print_formula(f);printf("\nWith path: ");
//print_path(p);
//printf("\nCurr (bl) = %s\n\n", xMas_network[curr].id);
		int i = bl_paths[curr]->num_of_paths++;
		bl_paths[curr]->paths[i] = copy_path(p);
		bl_formula[curr][i] = f;
}
void store_id_formula_for_path(int curr, int header, path* p, formula* f) {
		if	(id_paths[curr][header]->num_of_paths >= NUM_OF_PATHS_PER_QUEUE) {
			printf("Increase number of paths stored per queue\n");
			printf("curr === %s, path == \n", xMas_network[curr].id);
			print_path(p);
			printf("\nformula == ");
			print_formula(f);
			printf("\n");
			
			assert(false);
		}
//printf("Storing id formula\n");print_formula(f);printf("\nWith path: ");
//print_path(p);
//printf("\nCurr (id) = %s, header = %s\n\n", xMas_network[curr].id, print_header(header));
		int i = id_paths[curr][header]->num_of_paths++;
		id_paths[curr][header]->paths[i] = copy_path(p);
		id_formula[curr][header][i] = f;
}




bool check_consistency_path2() {
		formula* f = curr_path_to_formula();//curr_path_to_invariants(lp);
		if (is_formula_true(f))
			return true;
		else if (is_formula_false(f))
			return false; 
		else
			return check_feasibility_formula(f, false);
		return true;
}



bool formula_subsumed_by_path(formula* f, path* p) {
	if (f->type == CONJ)
		return formula_subsumed_by_path(f->formula1, p) && formula_subsumed_by_path(f->formula2, p);
	else if (f->type == LIT)
		return path_member(p, f->lit);
	else
		return false;
}

#endif
