#ifndef SIMULATION
#define SIMULATION

#include <limits.h>
#include "parse_invariants.c"

//#define DEBUG


formula*** equivalence_classes;
const int NUM_OF_ECS = 100;
extern inv_t* invariants;
bool* type_specific_queues;
bool* queue_subject_to_invariants;
extern bool garbage_collection;


formula* get_equivalence_class(int curr, int header, int in_port) {
	if (xMas_network[curr].type == queue || xMas_network[curr].type == buffer)
		return singleton_formula(curr,0,IS_FULL);
	else if (xMas_network[curr].type == function)
		return get_equivalence_class(xMas_network[curr].out[0], ((int (*)(int)) (xMas_network[curr].field[0]))(header), xMas_network[curr].in_port_connected_to_out[0]);
	else if (xMas_network[curr].type == source)
		return get_equivalence_class(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0]);
	else if (xMas_network[curr].type == sink)
		return singleton_formula(curr,0,IS_FULL);
	else if (xMas_network[curr].type == xfork)
		return conjunct(get_equivalence_class(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0]),
						get_equivalence_class(xMas_network[curr].out[1], header, xMas_network[curr].in_port_connected_to_out[1]));
	else if (xMas_network[curr].type == xswitch) {
		if (((int (*)(int)) (xMas_network[curr].field[0]))(header))
			return get_equivalence_class(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0]);
		else
			return get_equivalence_class(xMas_network[curr].out[1], header, xMas_network[curr].in_port_connected_to_out[1]);
	}
	else if (xMas_network[curr].type == merge)
		return get_equivalence_class(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0]);
	else if (xMas_network[curr].type == join) {
		int token_input = ((int*) (xMas_network[curr].field[0]))[0];
		if (in_port == token_input)
			return singleton_formula(curr, 0, IS_FULL);
		else
			return get_equivalence_class(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0]);
	}
	else if (xMas_network[curr].type == aswitch) {
		formula*ret = singleton_formula(0,0,IS_FALSE);
		int o;
		for (o=0;o<xMas_network[curr].num_of_outs;o++)
			if (((int (*)(int)) (xMas_network[curr].field[o]))(header))
				ret = disjunct(ret, get_equivalence_class(xMas_network[curr].out[o], header, xMas_network[curr].in_port_connected_to_out[o]));
		return ret;
	}
	else if (xMas_network[curr].type == synch) {
		return get_equivalence_class(xMas_network[curr].out[in_port], header, xMas_network[curr].in_port_connected_to_out[in_port]);
	}
	assert(false);
	return NULL;
}
bool in_existing_equivalence_class(int curr, int header) {
	formula* ec = get_equivalence_class(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0]);
	int i = 0;
	while (equivalence_classes[curr][i] != NULL) {
		if (equal_formulas(equivalence_classes[curr][i], ec)) {
			return true;
		}
		i++;
	}
	equivalence_classes[curr][i] = ec;
	assert(i+1<NUM_OF_ECS);
	equivalence_classes[curr][i+1] = NULL;
	assert(i+2<NUM_OF_ECS);
	return false;
}

bool add_type(int q0, int header) {
	int i=0;
	bool found=false;
	for (i=0;i<xMas_network[q0].types[0]->num_of_elts&&!found;i++) {
		found = (xMas_network[q0].types[0]->array[i] == header);
	}
	if (!found) {
		dyn_array_add_elt(xMas_network[q0].types[0], header);
		#ifdef DEBUG
			printf("Adding type %s to queue %s\n", print_header(header), xMas_network[q0].id);
		#endif
		if (!in_existing_equivalence_class(q0,header)) {
			#ifdef DEBUG
				printf("Adding EC %s to queue %s\n", print_header(header), xMas_network[q0].id);
			#endif
			dyn_array_add_elt(xMas_network[q0].ecs[0], header);
		}
		else {
			#ifdef DEBUG
				printf("Not adding EC header %s to queue %s\n", print_header(header), xMas_network[q0].id);
			#endif
		}
	}
	return !found;
}
//TODO make this function only used function to add types:
void add_type_merge(int merge, int header, int in_port) {
	int i=0;
	bool found=false;
	for (i=0;i<xMas_network[merge].types[in_port]->num_of_elts&&!found;i++)
		found = (xMas_network[merge].types[in_port]->array[i] == header);
	if (!found) {
		#ifdef DEBUG
			printf("Adding type %s to in %i of merge %s\n", print_header(header), in_port, xMas_network[merge].id);
		#endif
		dyn_array_add_elt(xMas_network[merge].types[in_port], header);
	}
}



struct dyn_array**  dyn_array_array_copy(struct dyn_array ** vis_headers) {
	int i;
	struct dyn_array** ret = malloc(xMas_network_size * sizeof(struct dyn_array*));
	for(i=0;i<xMas_network_size;i++) {
		ret[i] = dyn_array_clone(vis_headers[i]);
	}
	return ret;
}
void dyn_array_array_init(struct dyn_array ** vis_headers) {
	int i;
	for(i=0;i<xMas_network_size;i++) {
		vis_headers[i] = malloc(sizeof(struct dyn_array));
		if (vis_headers[i] == NULL) printf("Malloc error\n");
		dyn_array_init(vis_headers[i], 10);
	}
}
void dyn_array_array_reinit(struct dyn_array ** vis_headers) {
	int i;
	for(i=0;i<xMas_network_size;i++)
		dyn_array_free(vis_headers[i]);
}
void dyn_array_array_free(struct dyn_array ** vis_headers) {
	int i;
	for(i=0;i<xMas_network_size;i++) {
		dyn_array_free(vis_headers[i]);
		free(vis_headers[i]);
	}
	free(vis_headers);
}


// Simulates the injection of a packet with the header 'header' at xMas component 'curr'.
// To ensure termination, we keep track of which queues are visited in this simulation.
// First searches all queues connected to component 'curr'.
// For each queue, add the waiting relation from 'curr' to that queue (assuming 'curr' is a queue).
// If the waiting relation has already been added, then there is no need to proceed with simulation.
// Otherwise, recursively proceed with simulation.
// Does not terminate if there is a cycle without any queues.
bool simulate_packet_injection(int curr, int header, int in_port, struct dyn_array ** vis_headers, int * stack, int * stack_size) { 
	#ifdef DEBUG
		printf("%s with header %s\n", xMas_network[curr].id, print_header(header));
	#endif

	if (!dyn_array_add_if_new(vis_headers[curr], header)) {
		printf("Livelock detected:\n");
		int i;
		for (i=0;i<*stack_size;i++)
			printf("%s,", xMas_network[stack[i]].id);
		printf("\n");
		return true;
	}
	
	stack[*stack_size] = curr;
	(*stack_size)++;


	if (xMas_network[curr].type == queue || xMas_network[curr].type == buffer) {
		// We have found a queue.
		// Add the type and continue if a new label is added
		bool new_label_added = add_type(curr, header);
		if (new_label_added)
			simulate_packet_injection(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0], vis_headers, stack, stack_size);
	}
	else if (xMas_network[curr].type == function) {
		// We apply the function corresponding to the xmas-element to the header and then recursively proceed the search.
		// The field of the xMas component is of type (void*).
		// In case of the xMas component "function", the field is a pointer to a function representing the function.
		// Thus we cast the field of the xMas component to a function of type int --> int and apply this function to the header.
		// This yeilds the new header.
		add_type(curr, header);
		int new_header = ((int (*)(int)) (xMas_network[curr].field[0]))(header);
		simulate_packet_injection(xMas_network[curr].out[0], new_header, xMas_network[curr].in_port_connected_to_out[0], vis_headers, stack, stack_size);
	}
	else if (xMas_network[curr].type == source) {
		// Proceed the search inductively from out[0] of the source.
		simulate_packet_injection(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0], vis_headers, stack, stack_size);
	}
	else if (xMas_network[curr].type == sink) {
		// We have encountered a sink.
		// Return no result.
	}
	else if (xMas_network[curr].type == xfork) {
		struct dyn_array** vis_headers2 = dyn_array_array_copy(vis_headers);
		int * stack2 = malloc(xMas_network_size * sizeof(int));
		int i;
		for (i=0;i<xMas_network_size;i++)
			stack2[i] = stack[i];
		int stack_size2 = *stack_size;
		simulate_packet_injection(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0], vis_headers, stack, stack_size);
		simulate_packet_injection(xMas_network[curr].out[1], header, xMas_network[curr].in_port_connected_to_out[1], vis_headers2, stack2, &stack_size2);
		dyn_array_array_free(vis_headers2);
		free(stack2);
	}
	else if (xMas_network[curr].type == xswitch) {
		// We have to proceed the search in either out[0] or out[1], depending on the header and the condition corresponding to the xmas-switch.
		// The field of the xMas component is of type (void*).
		// In case of the xMas component "xswitch", the field is a pointer to a function representing the condition.
		// Thus we cast the field of the xMas component to a function of type int --> int and apply this function to the header.
		// If the result is true, we take the first out, otherwise the second out.
		add_type(curr, header);
		bool b = ((int (*)(int)) (xMas_network[curr].field[0]))(header);
		if (b)
			simulate_packet_injection(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0], vis_headers, stack, stack_size);
		else
			simulate_packet_injection(xMas_network[curr].out[1], header, xMas_network[curr].in_port_connected_to_out[1], vis_headers, stack, stack_size);
	}
	else if (xMas_network[curr].type == merge) {
		// Proceed the search inductively from out[0] of the merge.
		add_type_merge(curr, header, in_port);
		simulate_packet_injection(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0], vis_headers, stack, stack_size);
	}
	else if (xMas_network[curr].type == join) {
		// Proceed the search inductively from out[0] of the join.
		int token_input = ((int*) (xMas_network[curr].field[0]))[0];
		if (in_port != token_input)
			simulate_packet_injection(xMas_network[curr].out[0], header, xMas_network[curr].in_port_connected_to_out[0], vis_headers, stack, stack_size);
	}
	else if (xMas_network[curr].type == aswitch) {
		add_type(curr, header);
		int o;
		for (o=0;o<xMas_network[curr].num_of_outs;o++) {
			bool b = ((int (*)(int)) (xMas_network[curr].field[o]))(header);
			if (b) {
				struct dyn_array** vis_headers2 = dyn_array_array_copy(vis_headers);
				int * stack2 = malloc(xMas_network_size * sizeof(int));
				int i;
				for (i=0;i<xMas_network_size;i++)
					stack2[i] = stack[i];
				int stack_size2 = *stack_size;
				simulate_packet_injection(xMas_network[curr].out[o], header, xMas_network[curr].in_port_connected_to_out[o], vis_headers2, stack2, &stack_size2);
				dyn_array_array_free(vis_headers2);
				free(stack2);
			}
		}
	}
	else if (xMas_network[curr].type == synch) {
		//add_type_join(curr, header, in_port);
		simulate_packet_injection(xMas_network[curr].out[in_port], header, xMas_network[curr].in_port_connected_to_out[in_port], vis_headers, stack, stack_size);
	}
	(*stack_size)--;
	return false;
}






void perform_simulations() {
	int i,j;
	int *stack = malloc (xMas_network_size * (sizeof (int)));
	struct dyn_array ** vis_headers = malloc (xMas_network_size * (sizeof (struct dyn_array*)));
	dyn_array_array_init(vis_headers);
	int stack_size = 0;
	int num_of_srcs = 0;

	for (i=0;i<xMas_network_size;i++) {
		if (xMas_network[i].type == queue || xMas_network[i].type == buffer || xMas_network[i].type == xswitch || xMas_network[i].type == aswitch || xMas_network[i].type == function) {
			xMas_network[i].ecs[0]->array = malloc(NUM_OF_ECS * sizeof(int));
			xMas_network[i].ecs[0]->allocated = NUM_OF_ECS;
		}
	}

	for (j=0;j<xMas_network_size;j++) {
		if (xMas_network[j].type == source) {
			num_of_srcs++;
			//if (num_of_srcs % 10 == 0) printf("Src %i\n", num_of_srcs-1);
			// For all sources:
			for (i=1;i<((int*)(xMas_network[j].field[0]))[0]+1;i++) {
				// For all headers that can be injected by the source:
				int header = ((int*) (xMas_network[j].field[0]))[i];
				simulate_packet_injection(j, header, xMas_network[j].in_port_connected_to_out[0], vis_headers, stack, &stack_size);
				dyn_array_array_reinit(vis_headers);
			}
		}
	}
	
	for (i=0;i<xMas_network_size;i++)
		if (xMas_network[i].type == queue || xMas_network[i].type == buffer || xMas_network[i].type == xswitch || xMas_network[i].type == aswitch || xMas_network[i].type == function)
			free(equivalence_classes[i]);
	free(equivalence_classes);
	dyn_array_array_free(vis_headers);
	free(stack);
}

void store_types_in_file() {
	FILE * fp;
 	fp = fopen (TYPING_FILE, "wb");
	int i;
	for (i=0;i<xMas_network_size;i++) {
		if (xMas_network[i].type == queue || xMas_network[i].type == buffer) {
			fwrite(&(xMas_network[i].types[0]->num_of_elts), sizeof(int), 1, fp);
			fwrite(xMas_network[i].types[0]->array, sizeof(int), xMas_network[i].types[0]->num_of_elts, fp);
		}
		else if (xMas_network[i].type == merge) {
			fwrite(&(xMas_network[i].types[0]->num_of_elts), sizeof(int), 1, fp);
			fwrite(xMas_network[i].types[0]->array, sizeof(int), xMas_network[i].types[0]->num_of_elts, fp);
			fwrite(&(xMas_network[i].types[1]->num_of_elts), sizeof(int), 1, fp);
			fwrite(xMas_network[i].types[1]->array, sizeof(int), xMas_network[i].types[1]->num_of_elts, fp);
		}
		else if (xMas_network[i].type == xswitch || xMas_network[i].type == aswitch || xMas_network[i].type == function) {
			fwrite(&(xMas_network[i].types[0]->num_of_elts), sizeof(int), 1, fp);
			fwrite(xMas_network[i].types[0]->array, sizeof(int), xMas_network[i].types[0]->num_of_elts, fp);
		}
		// TODO this is the generally applicable code:
		//else if (xMas_network[i].type == synch) {
		//	int in;
		//	for (in=0;in<xMas_network[i].num_of_ins;in++) {
		//		fwrite(&(xMas_network[i].types[in]->num_of_elts), sizeof(int), 1, fp);
		//		fwrite(xMas_network[i].types[in]->array, sizeof(int), xMas_network[i].types[in]->num_of_elts, fp);
		//	}
		//}
	}
	for (i=0;i<xMas_network_size;i++) {
		if (xMas_network[i].type == queue || xMas_network[i].type == buffer || xMas_network[i].type == xswitch || xMas_network[i].type == aswitch || xMas_network[i].type == function) {
			fwrite(&(xMas_network[i].ecs[0]->num_of_elts), sizeof(int), 1, fp);
			fwrite(xMas_network[i].ecs[0]->array, sizeof(int), xMas_network[i].ecs[0]->num_of_elts, fp);
		}
	}
	fclose(fp);
}

void read_types_from_file() {
	FILE * fp;
 	fp = fopen (TYPING_FILE, "rb");
	int i;
	for (i=0;i<xMas_network_size;i++) {
		if (xMas_network[i].type == queue || xMas_network[i].type == buffer) {
			int num_of_types = 0;
			fread(&num_of_types, sizeof(int), 1, fp);
			if (num_of_types > 0) {
				xMas_network[i].types[0]->array = malloc(num_of_types * sizeof(int));
				fread(xMas_network[i].types[0]->array, sizeof(int), num_of_types, fp);
			}
			xMas_network[i].types[0]->num_of_elts = num_of_types;
			xMas_network[i].types[0]->allocated = num_of_types;
		}
		else if (xMas_network[i].type == merge) {
			int num_of_types = 0;
			fread(&num_of_types, sizeof(int), 1, fp);
			if (num_of_types > 0) {
				xMas_network[i].types[0]->array = malloc(num_of_types * sizeof(int));
				fread(xMas_network[i].types[0]->array, sizeof(int), num_of_types, fp);
			}
			xMas_network[i].types[0]->num_of_elts = num_of_types;
			xMas_network[i].types[0]->allocated = num_of_types;
			int num_of_types2 = 0;
			fread(&num_of_types2, sizeof(int), 1, fp);
			if (num_of_types2 > 0) {
				xMas_network[i].types[1]->array = malloc(num_of_types2 * sizeof(int));
				fread(xMas_network[i].types[1]->array, sizeof(int), num_of_types2, fp);
			}
			xMas_network[i].types[1]->num_of_elts = num_of_types2;
			xMas_network[i].types[1]->allocated = num_of_types2;
		}
		else if (xMas_network[i].type == xswitch || xMas_network[i].type == aswitch || xMas_network[i].type == function) {
			int num_of_types = 0;
			fread(&num_of_types, sizeof(int), 1, fp);
			if (num_of_types > 0) {
				xMas_network[i].types[0]->array = malloc(num_of_types * sizeof(int));
				fread(xMas_network[i].types[0]->array, sizeof(int), num_of_types, fp);
			}
			xMas_network[i].types[0]->num_of_elts = num_of_types;
			xMas_network[i].types[0]->allocated = num_of_types;
		}
		// TODO: the following code is generally applicable:
		//else if (xMas_network[i].type == synch) {
		//	int in;
		//	for (in=0;in<xMas_network[i].num_of_ins;in++) {
		//		int num_of_types = 0;
		//		fread(&num_of_types, sizeof(int), 1, fp);
		//		if (num_of_types > 0) {
		//			xMas_network[i].types[in]->array = malloc(num_of_types * sizeof(int));
		//			fread(xMas_network[i].types[in]->array, sizeof(int), num_of_types, fp);
		//		}
		//		xMas_network[i].types[in]->num_of_elts = num_of_types;
		//		xMas_network[i].types[in]->allocated = num_of_types;
		//	}
		//}
	}
	for (i=0;i<xMas_network_size;i++) {
		if (xMas_network[i].type == queue || xMas_network[i].type == buffer || xMas_network[i].type == xswitch || xMas_network[i].type == aswitch || xMas_network[i].type == function) {
			int num_of_ecs = 0;
			fread(&num_of_ecs, sizeof(int), 1, fp);
			if (num_of_ecs > 0) {
				xMas_network[i].ecs[0]->array = malloc(num_of_ecs * sizeof(int));
				fread(xMas_network[i].ecs[0]->array, sizeof(int), num_of_ecs, fp);
			}
			xMas_network[i].ecs[0]->num_of_elts = num_of_ecs;
			xMas_network[i].ecs[0]->allocated = num_of_ecs;
		}
	}
	fclose(fp);
}

//ZCHAFF 
/*
void analyze_type_specific_queues(formula* f) {
	if (no_formula(f))
		assert(false);
	switch (f->type) {
		case CONJ:
		case DISJ:
			analyze_type_specific_queues(f->formula1);
			analyze_type_specific_queues(f->formula2);
			return;
		case LIT: {
			if ((f->lit.constraint == IS_GT_ONE || f->lit.constraint == IS_ZERO) && f->lit.header != NUM_OF_HEADERS)
				type_specific_queues[f->lit.queue] = true;
			return;
		}
		case NOT:
			analyze_type_specific_queues(f->formula1);
			return;
	}
	assert(false);
}

void analyze_queue_subject_to_invariants(formula* f) {
	if (no_formula(f))
		assert(false);
	switch (f->type) {
		case CONJ:
		case DISJ:
			analyze_queue_subject_to_invariants(f->formula1);
			analyze_queue_subject_to_invariants(f->formula2);
			return;
		case LIT: {
				queue_subject_to_invariants[f->lit.queue] = true;
			return;
		}
		case NOT:
			analyze_queue_subject_to_invariants(f->formula1);
			return;
	}
	assert(false);
}
*/

void analyze_typing_information() {
	int i;
	equivalence_classes = malloc(xMas_network_size * sizeof (formula**));
	for (i=0;i<xMas_network_size;i++) {
		if (xMas_network[i].type == queue || xMas_network[i].type == buffer || xMas_network[i].type == xswitch || xMas_network[i].type == aswitch || xMas_network[i].type == function) {
			equivalence_classes[i] = malloc(NUM_OF_ECS * sizeof(formula*));
			equivalence_classes[i][0] = NULL;

			struct dyn_array * ecs = (struct dyn_array*) malloc(sizeof (struct dyn_array));
   		    dyn_array_init(ecs, NUM_OF_ECS);
   		    xMas_network[i].ecs = malloc(sizeof(struct dyn_array*));
   		    xMas_network[i].ecs[0] = ecs;
		}
	}

	// First, determine whether there is a file containing the typing information.
	// If not, perform exhaustive simulation to obtain the information and write this to file for future use.
	// If so, simply load the file.
	FILE * fp = fopen (TYPING_FILE, "rb");
	if (fp == NULL) {
		//printf("Could not read file %s with typing information. Starting exhaustive simulations.\n", TYPING_FILE);
		fclose(fp);
		perform_simulations();
		//printf("Writing typing information to file %s.\n", TYPING_FILE);
		store_types_in_file();
	}
	else {
		fclose(fp);
		//printf("Reading typing information from file %s.\n", TYPING_FILE);
		read_types_from_file();
	}

}
void initialize_types() {
	analyze_typing_information();
	// Second, load the file with the invariants and add some standard constraints to it (i.e., typing information, sizes are at least 1, etc.)
	invariants = NULL;
	//ZCHAFF int fresh = 1;
	//ZCHAFF garbage_collection = false;
	invariants = read_invariants();//ZCHAFF normalize_formula(read_invariants(), &fresh);
	//ZCHAFF garbage_collection = true;
	type_specific_queues = calloc(xMas_network_size, sizeof (bool));
	queue_subject_to_invariants = calloc(xMas_network_size, sizeof (bool));
  	if(invariants == NULL) {
    	printf("Unable to read invariants.lp\nProceeding with deadlock search.\n");
		invariants = NULL;//singleton_formula(0,0,IS_TRUE);
	}
	analyze_queue_subject_to_invariants(invariants);
	analyze_type_specific_queues(invariants);
}

#endif
