var echo;
if(typeof console=="undefined") echo=print; else echo=console.log; // else echo=print;
//echo = (console ? console.log : print);
var args;
// since we use phantom on the windows systems, the input size of the file would be limited if we input it as an argument. Hence we input its filename as an argument instead of the entire file.
if(typeof phantom!="undefined"){
    var system = require('system');
    if (system.args.length === 1) {
        console.log('Try to pass some args when invoking this script!');
        phantom.exit();
    } else {
        args ='';
        var fs = require('fs');
        args = fs.read(system.args[1]);
    }
}else args = arguments;
if(args==""){
  echo("Please supply the json file as argument!");
  quit();
}

/*
function functionWtoC(ins,outs,codeX){
  // create a c-function from wicked notation
  // the function has ins# ins and outs# outs, so:
  // 0 1 -> source
  // 1 0 -> target (returns true/false)
  // 1 1 -> function (or a part of a fork)
  // 2 1 -> join
  var o="return ";
  var code;
  if(codeX.fields) code=codeX.fields; else code=codeX;
  if(code[0]) {if(code[0]['function'] && code[0]['function']!="") o+=code[0]['function']; else o+="header";}
  else if(code['function'] && code['function']!="") o+=code['function'];
  else if(code!="") o+=code;
  else o+="header";
  return o+";";
}
*/


var xmas_object;
var output = "";
var output_prelude = "";
var index = 0;
var indices_of_components = {};
var schema;

function clone(obj) {
  var newObj = (this instanceof Array) ? [] : {};
  for (i in obj) {
    if (i == 'clone') continue;
    if (obj[i] && typeof obj[i] == "object") {
      newObj[i] = clone(obj[i]);
    } else newObj[i] = obj[i];
  } return newObj;
}


// In a string containg c code, add declarations for the variables
// instantiated in `var_subst'.
function add_var_decl_to_c_code(code, var_subst) {
	var ret = "\t" + code;
	for (var var_name in var_subst)
		if (!(var_name in xmas_object.VARS))
			ret = "\tint " + var_name + " = " + var_subst[var_name] + ";\n" + ret;
	return ret;
}
// Given a string containing javascript code, add declarations for the variables
// instantiated in `var_subst' and executes the code.
function compute_parameter(param, var_subst) {
	var p = "" + param;
	for (var var_name in var_subst)
		p = "var " + var_name + " = " + var_subst[var_name] + "; " + p;
	var ret = eval(p);
	for (var var_name in var_subst)
		delete(var_name);
	return ret;
}
// Given a type of a composite object, return the JSON structure
// containing the interface/architecture of the object.
function get_composite_object(type) {
	for (var i=0;i<xmas_object.COMPOSITE_OBJECTS.length;i++) {
		if (xmas_object.COMPOSITE_OBJECTS[i].type == type)
			return xmas_object.COMPOSITE_OBJECTS[i];
	}
	return "ERROR";
}


// The following function is essential to the translation:
// it computes a unique name for each component, based on the id,
// the current hierarchie of composite objects and the current assignment
// of values to variables.
// It also takes care of the connection between the interface of composite objects
// and the network. That is, if the given component is a outs[n] inside a composite object 
// e.g. `outs[1]', the function goes one level up in the hierarchie to determine what the 
// second out connects to. If the component is an in channel of a composite object
// it goes one level lower in the hierarchie, i.e., inside the composite object, to
// figure where the in channel connects to inside the component.
function create_var_name(comp, hierarchie, var_subst, outs) {
	// If the component declares parameters, compute their value
	var var_subst2 = clone(var_subst);
	for (param in comp.parameters) {
		var value_of_param = compute_parameter(comp.parameters[param], var_subst2);
		var_subst2[param] = value_of_param;
	}
	// If the component is an out of a composite object, use `outs' to determine which
	// component is the output.
	// Go one level up in the hierarchie
	if (comp.id.substring(5,0) == "outs[") {
		var hierarchie2 = hierarchie.slice(0);
		var outs2 = outs.slice(0);
		var comp2 = eval("outs[" + (outs.length-1) + "]" + comp.id.substring(4));
		hierarchie2.pop();
		outs2.pop();
		return create_var_name(comp2, hierarchie2, var_subst2, outs2);
	}
	// If the object is a composite object, use the interface of the object to determine
	// which internal component is the input.
	// Go one level down in the hierarchie
	var comp_obj = get_composite_object(comp.type)
	if (comp_obj != "ERROR") {
		var comp2 = comp_obj.interface.ins[comp.in_port];
		var hierarchie2 = hierarchie.slice(0);
		hierarchie2[hierarchie2.length] = [comp.id , comp.type];
		return create_var_name(comp2, hierarchie2, var_subst2, outs);
	}
	// If the component is a regular component, determine its name using
	// the current hierarchie, variable substitutions and the id.
	var ret = "";
	for (var i=0;i<hierarchie.length;i++)
		ret += hierarchie[i][0] + "_";
	ret += comp.id;
	for (var key in var_subst2)
		if (xmas_object.VARS[key] == undefined)
			ret += key + "_" +  var_subst2[key];
	return [ret, comp.in_port];	
}

function regular_xmas_object(component) {
	return (component.type == "source" || component.type == "queue" || component.type == "sink" || component.type == "merge" || component.type == "xswitch");
}
function compute_index_of_component(comp, hierarchie, var_subst, outs) {
	var name = create_var_name(comp, hierarchie, var_subst, outs);
	return "INDEX_OF(\"" + name[0] + "\")";
}


function trim(s) {
    var l=0; var r=s.length -1;
    while(l < s.length && s[l] == ' ')
    {     l++; }
    while(r > l && s[r] == ' ')
    {     r-=1;     }
    return s.substring(l, r+1);
} 

function translate_init_types(init_types) {


	var e = RegExp("\{([^\\|\{\}]+) in ([^\\|\{\}]+)\\|([^\{\}]+)\}");
	var match = e.exec(init_types);
	var ret = "";

	var packet_name = trim(RegExp.$1);
	var packet_domain = trim(RegExp.$2);
	var packet_condition = trim(RegExp.$3);

	ret += "struct dyn_array * src_types = (struct dyn_array*) malloc(sizeof (struct dyn_array));\n\tdyn_array_init(src_types, ceil((double) NUM_OF_HEADERS/10));\n";
	ret += "\tdyn_array_add_elt(src_types, 0);\n";
	ret += "\tint " + packet_name + ";\n";
	for(var var_name in xmas_object.PACKET_TYPE)
		ret += "\tint " + packet_name + "_" + var_name + ";\n";
	for(var var_name in xmas_object.PACKET_TYPE)
		ret += "\tfor(" + packet_name + "_" + var_name + "=0;" + packet_name + "_" + var_name + "<" + xmas_object.PACKET_TYPE[var_name] + ";" + packet_name + "_" + var_name + "++) {\n";
	ret += "\t\tif (" + packet_condition + ") {\n";
	ret += "\t\t\t" + packet_name + " = " + code_to_convert_packet_struct_to_int(packet_name) + ";\n";
	ret += "\t\t\tdyn_array_add_elt(src_types, " + packet_name + ");\n";
	ret += "\t\t\tsrc_types->array[0]++;\n";
	ret += "\t\t}\n\t";
	for(var var_name in xmas_object.PACKET_TYPE)
		ret += "}";
	ret += "\n";
	return ret;
	
}

function translate_source(src, hierarchie, var_subst, outs) {
	var varname = create_var_name(src, hierarchie, var_subst, outs)[0];
	var outs_var_names = new Array();
	//struct xMas_component src; init_xMas_component(&src, "...", source, 1, 0);
	var ret = "\tstruct xMas_component " + varname + ";\n\tinit_xMas_component(&" + varname + ", \"" + varname + "\", source, 1, 0);\n";
	// initialize types
	var f;
	if(src.fields && src.fields[0] && src.fields[0].init_types){ // old style
		f = add_var_decl_to_c_code(translate_init_types(src.fields[0].init_types, 0),var_subst);
	}//else{
	 // if(src.fields) f=functionWtoC(0,1,src);
	 // else f="return 0;";}
	ret += "{\n" + f; 
	//src.field = malloc(sizeof(void*));
	ret += "\t" + varname + ".field = (void**) malloc(sizeof(void*));\n"
	//src.field[0] = (void*)src_field;
	ret += "\t" + varname + ".field[0] = (void*)src_types->array;\n\tfree(src_types);\n}\n";
	// outputs:
	for (var j=0;j<1;j++) {
		var name_port_out = create_var_name(src.outs[j], hierarchie, var_subst, outs);
		outs_var_names.push(name_port_out);
		//src.out[0] = ...;
		ret += "\t" + varname + ".out[" + j + "] = INDEX_OF(\"" + name_port_out[0] + "\");\n";
		//src.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".in_port_connected_to_out[" + j + "] = " + name_port_out[1] + ";\n";
	}
	// xMas_network[...] = src;
	ret += "\txMas_network[" + index + "] = " + varname + ";\n";
	indices_of_components[varname] = [index, outs_var_names];

	return ret;
}
function translate_queue(q, hierarchie, var_subst, outs) {
	var varname = create_var_name(q, hierarchie, var_subst, outs)[0];
	var outs_var_names = new Array();
	//struct xMas_component q; init_xMas_component(&q, "...", queue, 1, 1);
	var ret = "\tstruct xMas_component " + varname + ";\n\tinit_xMas_component(&" + varname + ", \"" + varname + "\", queue, 1, 1);\n";
	// outputs:
	for (var j=0;j<1;j++) {
		var name_port_out = create_var_name(q.outs[j], hierarchie, var_subst, outs);
		outs_var_names.push(name_port_out);
		//q.out[0] = ...;
		ret += "\t" + varname + ".out[" + j + "] = INDEX_OF(\"" + name_port_out[0] + "\");\n";
		//q.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".in_port_connected_to_out[" + j + "] = " + name_port_out[1] + ";\n";
	}
	// inputs:
	for (var j=0;j<1;j++) {
		//q.in[0] = ...;
		ret += "\t" + varname + ".in[" + j + "] = INDEX_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
		//q.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".out_port_connected_to_in[" + j + "] = OUT_PORT_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
	}
	//struct dyn_array * q_types = (struct dyn_array*) malloc(sizeof (struct dyn_array));
	ret += "\tstruct dyn_array * " + varname + "_types = (struct dyn_array*) malloc(sizeof (struct dyn_array));\n";
	//dyn_array_init(q_types, NUM_OF_HEADERS);
	ret += "\tdyn_array_init(" + varname + "_types, NUM_OF_HEADERS);\n";
	//q.types = malloc(sizeof (struct dyn_array*));
	ret += "\t" + varname + ".types = (struct dyn_array**) malloc(sizeof (struct dyn_array*));\n";
 	//q.types[0] = q_types;
 	ret += "\t" + varname + ".types[0] = " + varname + "_types;\n";

    //{int* field = malloc(sizeof(int*));
	ret += "\t{int* field = (int*) malloc(sizeof(int*));\n";
	//field[0] = (int) ...;
	ret += "\tfield[0] = (int) " + q.fields[0].size + ";\n";
    //q.field = (void**) malloc(sizeof(void*));
	ret += "\t" + varname + ".field = (void**) malloc(sizeof(void*));\n";
    //q.field[0] = (void*)field};
    ret += "\t" + varname + ".field[0] = (void*) field;}\n";

	// xMas_network[...] = q;
	ret += "\txMas_network[" + index + "] = " + varname + ";\n";
	indices_of_components[varname] = [index, outs_var_names];
	return ret;
}
function translate_sink(sink, hierarchie, var_subst, outs) {
	var varname = create_var_name(sink, hierarchie, var_subst, outs)[0];
	//struct xMas_component sink; init_xMas_component(&sink, "...", sink, 0, 1);
	var ret = "\tstruct xMas_component " + varname + ";\n\tinit_xMas_component(&" + varname + ", \"" + varname + "\", sink, 0, 1);\n";
	// inputs:
	for (var j=0;j<1;j++) {
		//sink.in[0] = ...;
		ret += "\t" + varname + ".in[" + j + "] = INDEX_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
		//sink.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".out_port_connected_to_in[" + j + "] = OUT_PORT_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
	}	
	// xMas_network[...] = sink;
	ret += "\txMas_network[" + index + "] = " + varname + ";\n";
	indices_of_components[varname] = [index, []];

	return ret;
}
function translate_merge(m, hierarchie, var_subst, outs) {
	var varname = create_var_name(m, hierarchie, var_subst, outs)[0];
	var outs_var_names = new Array();
	var num_outs = m.outs.length;
	var num_ins = 2;
	//struct xMas_component m; init_xMas_component(&m, "...", merge, 1, 2);
	var ret = "\tstruct xMas_component " + varname + ";\n\tinit_xMas_component(&" + varname + ", \"" + varname + "\", merge, " + num_outs + ", " + num_ins + ");\n";
	// outputs:
	for (var j=0;j<num_outs;j++) {
		var name_port_out = create_var_name(m.outs[j], hierarchie, var_subst, outs);
		outs_var_names.push(name_port_out);
		//m.out[ ] = ...;
		ret += "\t" + varname + ".out[" + j + "] = INDEX_OF(\"" + name_port_out[0] + "\");\n";
		//m.in_port_connected_to_out[ ] = ...;
		ret += "\t" + varname + ".in_port_connected_to_out[" + j + "] = " + name_port_out[1] + ";\n";
	}
	// inputs:
	for (var j=0;j<num_ins;j++) {
		//m.in[...] = ...;
		ret += "\t" + varname + ".in[" + j + "] = INDEX_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
		//m.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".out_port_connected_to_in[" + j + "] = OUT_PORT_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
	}
    //merge.types = malloc(2*sizeof(struct dyn_array*));
	ret += "\t" + varname + ".types = (struct dyn_array**) malloc(" + num_ins + "*sizeof(struct dyn_array*));\n";
	// { int i; for (i=0;i<2;i++) {
	ret += "\t{\n\tint i;\n\tfor (i=0;i<" + num_ins + ";i++) {\n";
	//struct dyn_array * types = (struct dyn_array*) malloc(sizeof (struct dyn_array));
	ret += "\t\tstruct dyn_array * types = (struct dyn_array*) malloc(sizeof (struct dyn_array));\n";
	//dyn_array_init(types, NUM_OF_HEADERS);
	ret += "\t\tdyn_array_init(types, NUM_OF_HEADERS);\n";
	//join.types[i] = types;
	ret += "\t\t" + varname + ".types[i] = types;\n";
	// }}
	ret += "\t}}\n";
	// xMas_network[...] = q;
	ret += "\txMas_network[" + index + "] = " + varname + ";\n";
	indices_of_components[varname] = [index, outs_var_names];

	return ret;
}
function translate_switch(s, hierarchie, var_subst, outs) {
	var varname = create_var_name(s, hierarchie, var_subst, outs)[0];
	var outs_var_names = new Array();
	var num_outs = s.outs.length;
	var num_ins = 1;
	//struct xMas_component s; init_xMas_component(&s, "...", xswitch, 2, 1);
	var ret = "\tstruct xMas_component " + varname + ";\n\tinit_xMas_component(&" + varname + ", \"" + varname + "\", xswitch, " + num_outs + ", " + num_ins + ");\n";
	// outputs:
	for (var j=0;j<num_outs;j++) {
		var name_port_out = create_var_name(s.outs[j], hierarchie, var_subst, outs);
		outs_var_names.push(name_port_out);
		//m.out[ ] = ...;
		ret += "\t" + varname + ".out[" + j + "] = INDEX_OF(\"" + name_port_out[0] + "\");\n";
		//m.in_port_connected_to_out[ ] = ...;
		ret += "\t" + varname + ".in_port_connected_to_out[" + j + "] = " + name_port_out[1] + ";\n";
	}
	// inputs:
	for (var j=0;j<num_ins;j++) {
		//s.in[...] = ...;
		ret += "\t" + varname + ".in[" + j + "] = INDEX_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
		//s.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".out_port_connected_to_in[" + j + "] = OUT_PORT_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
	}
	//s.field = malloc(sizeof(void*));
	ret += "\t" + varname + ".field = (void**) malloc(sizeof(void*));\n";
	//s.field[0] = (void*) s_func;
	ret += "\t" + varname + ".field[0] = (void*)" + varname + "_func;\n";
	//struct dyn_array * s_types = (struct dyn_array*) malloc(sizeof (struct dyn_array));
	ret += "\tstruct dyn_array * " + varname + "_types = (struct dyn_array*) malloc(sizeof (struct dyn_array));\n";
	//dyn_array_init(s_types, NUM_OF_HEADERS);
	ret += "\tdyn_array_init(" + varname + "_types, NUM_OF_HEADERS);\n";
	//s.types = (struct dyn_array**) malloc(sizeof (struct dyn_array*));
	ret += "\t" + varname + ".types = (struct dyn_array**) malloc(sizeof (struct dyn_array*));\n";
 	//s.types[0] = s_types;
 	ret += "\t" + varname + ".types[0] = " + varname + "_types;\n";
	// xMas_network[...] = s;
	ret += "\txMas_network[" + index + "] = " + varname + ";\n";
	indices_of_components[varname] = [index, outs_var_names];

	output_prelude += "bool " + varname + "_func (int header) {\n";
	var ret2 = "";
	if(s.fields && s.fields[0] && s.fields[0].function){ // old style
		ret2+=code_to_convert_int_to_packet_struct("header", "p", "\t");
		ret2+=add_var_decl_to_c_code(s.fields[0].function,var_subst);
	}//else{
	 // if(src.fields){
	 // f=functionWtoC(0,1,src);
	 // }
	 //else f="return 0;";}
	output_prelude += ret2;
	output_prelude += "\n}\n";

	return ret;
}

function code_to_convert_int_to_packet_struct(packet_name, target_packet_name, depth) {
	var i = 0;
	var ret = "";
	var num_of_packet_types = 0;
	for(var var_name in xmas_object.PACKET_TYPE)
		num_of_packet_types++;

	if (num_of_packet_types == 0) return ret;

	for(var var_name in xmas_object.PACKET_TYPE) {
		ret += depth + "int " + target_packet_name + "_" + var_name + " = (" + packet_name + " ";
		if (i < num_of_packet_types-1) {
			ret += ">> (";
			var found_var_name = false;
			var just_found_var_name = true;
			for(var var_name2 in xmas_object.PACKET_TYPE) {
				if (found_var_name) {
					if (!just_found_var_name)
						ret += " + ";
					else
						just_found_var_name = false;
					ret += "" + Math.ceil(Math.log(xmas_object.PACKET_TYPE[var_name2]) / Math.log(2));
				}
				if (var_name2 == var_name)
					found_var_name = true;
			}
			ret += ")";
		}
		ret += ") & ((1 << " + Math.ceil(Math.log(xmas_object.PACKET_TYPE[var_name]) / Math.log(2)) + ") - 1);\n";
		i++;
	}
	return ret;
}

function default_values_function() {
	var ret = "";
    var i = 0;
	for(var var_name in xmas_object.PACKET_TYPE) {
        i++;
		ret += "\tint ret_" + var_name + " = p_" + var_name + ";\n";
    }
    if (i == 0)
        ret += "\tint ret;\n";
	return ret;
}

function code_to_convert_packet_struct_to_int(packet_name) {
	var i = 0;
	var num_of_packet_types = 0;
	var ret = "";
	for(var var_name in xmas_object.PACKET_TYPE)
		num_of_packet_types++;
	if (num_of_packet_types == 0) return packet_name;
	for(var var_name in xmas_object.PACKET_TYPE) {
		ret += "(" + packet_name + "_" + var_name + " ";
		if (i < num_of_packet_types-1) {
			ret += "<< (";
			var found_var_name = false;
			var just_found_var_name = true;
			for(var var_name2 in xmas_object.PACKET_TYPE) {
				if (found_var_name) {
					if (!just_found_var_name)
						ret += " + ";
					else
						just_found_var_name = false;
					ret += "" + Math.ceil(Math.log(xmas_object.PACKET_TYPE[var_name2]) / Math.log(2));
				}
				if (var_name2 == var_name)
					found_var_name = true;
			}
			ret += ")) | ";
		}
		i++;
	}
	ret += ")";
	return ret;
}



function translate_function(f, hierarchie, var_subst, outs) {
	var varname = create_var_name(f, hierarchie, var_subst, outs)[0];
	var outs_var_names = new Array();
	var num_outs = f.outs.length;
	var num_ins = 1;
	//struct xMas_component f; init_xMas_component(&f, "...", function, 1, 1);
	var ret = "\tstruct xMas_component " + varname + ";\n\tinit_xMas_component(&" + varname + ", \"" + varname + "\", function, " + num_outs + ", " + num_ins + ");\n";
	// outputs:
	for (var j=0;j<num_outs;j++) {
		var name_port_out = create_var_name(f.outs[j], hierarchie, var_subst, outs);
		outs_var_names.push(name_port_out);
		//f.out[ ] = ...;
		ret += "\t" + varname + ".out[" + j + "] = INDEX_OF(\"" + name_port_out[0] + "\");\n";
		//f.in_port_connected_to_out[ ] = ...;
		ret += "\t" + varname + ".in_port_connected_to_out[" + j + "] = " + name_port_out[1] + ";\n";
	}
	// inputs:
	for (var j=0;j<num_ins;j++) {
		//f.in[...] = ...;
		ret += "\t" + varname + ".in[" + j + "] = INDEX_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
		//f.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".out_port_connected_to_in[" + j + "] = OUT_PORT_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
	}
	//struct dyn_array * f_types = (struct dyn_array*) malloc(sizeof (struct dyn_array));
	ret += "\tstruct dyn_array * " + varname + "_types = (struct dyn_array*) malloc(sizeof (struct dyn_array));\n";
	//dyn_array_init(f_types, NUM_OF_HEADERS);
	ret += "\tdyn_array_init(" + varname + "_types, NUM_OF_HEADERS);\n";
	//f.types = malloc(sizeof (struct dyn_array*));
	ret += "\t" + varname + ".types = (struct dyn_array**) malloc(sizeof (struct dyn_array*));\n";
 	//f.types[0] = f_types;
 	ret += "\t" + varname + ".types[0] = " + varname + "_types;\n";
	//f.field = malloc(sizeof(void*));
	ret += "\t" + varname + ".field = (void**) malloc(sizeof(void*));\n";
	//f.field[0] = (void*) f_func;
	ret += "\t" + varname + ".field[0] = (void*)" + varname + "_func;\n";
	// xMas_network[...] = f;
	ret += "\txMas_network[" + index + "] = " + varname + ";\n";
	indices_of_components[varname] = [index, outs_var_names];

	output_prelude += "int " + varname + "_func (int header) {\n";
	var ret2 = "";
	if(f.fields && f.fields[0] && f.fields[0].function){ // old style
		ret2+=code_to_convert_int_to_packet_struct("header", "p", "\t");
		ret2+=default_values_function();
	  	ret2+=add_var_decl_to_c_code(f.fields[0].function,var_subst);
		ret2+="\n\treturn " + code_to_convert_packet_struct_to_int("ret") + ";\n";
	}//else{
	 // if(src.fields) f=functionWtoC(0,1,src);
	 // else f="return 0;";}
	output_prelude += ret2;
	output_prelude += "}\n";

	return ret;
}

function translate_fork(f, hierarchie, var_subst, outs) {
	var varname = create_var_name(f, hierarchie, var_subst, outs)[0];
	var outs_var_names = new Array();
	var num_outs = f.outs.length;
	var num_ins = 1;
	//struct xMas_component f; init_xMas_component(&f, "...", xfork, 2, 1);
	var ret = "\tstruct xMas_component " + varname + ";\n\tinit_xMas_component(&" + varname + ", \"" + varname + "\", xfork, " + num_outs + ", " + num_ins + ");\n";
	// outputs:
	for (var j=0;j<num_outs;j++) {
		var name_port_out = create_var_name(f.outs[j], hierarchie, var_subst, outs);
		outs_var_names.push(name_port_out);
		//f.out[ ] = ...;
		ret += "\t" + varname + ".out[" + j + "] = INDEX_OF(\"" + name_port_out[0] + "\");\n";
		//f.in_port_connected_to_out[ ] = ...;
		ret += "\t" + varname + ".in_port_connected_to_out[" + j + "] = " + name_port_out[1] + ";\n";
	}
	// inputs:
	for (var j=0;j<num_ins;j++) {
		//f.in[...] = ...;
		ret += "\t" + varname + ".in[" + j + "] = INDEX_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
		//f.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".out_port_connected_to_in[" + j + "] = OUT_PORT_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
	}
	// xMas_network[...] = f;
	ret += "\txMas_network[" + index + "] = " + varname + ";\n";
	indices_of_components[varname] = [index, outs_var_names];

	return ret;
}
function translate_join(join, hierarchie, var_subst, outs) {
	var varname = create_var_name(join, hierarchie, var_subst, outs)[0];
	var outs_var_names = new Array();
	var num_outs = join.outs.length;
	var num_ins = 2;
	//struct xMas_component f; init_xMas_component(&f, "...", join, 1, 2);
	var ret = "\tstruct xMas_component " + varname + ";\n\tinit_xMas_component(&" + varname + ", \"" + varname + "\", join, " + num_outs + ", " + num_ins + ");\n";
	// outputs:
	for (var j=0;j<num_outs;j++) {
		var name_port_out = create_var_name(join.outs[j], hierarchie, var_subst, outs);
		outs_var_names.push(name_port_out);
		//join.out[ ] = ...;
		ret += "\t" + varname + ".out[" + j + "] = INDEX_OF(\"" + name_port_out[0] + "\");\n";
		//join.in_port_connected_to_out[ ] = ...;
		ret += "\t" + varname + ".in_port_connected_to_out[" + j + "] = " + name_port_out[1] + ";\n";
	}
	// inputs:
	for (var j=0;j<num_ins;j++) {
		//join.in[...] = ...;
		ret += "\t" + varname + ".in[" + j + "] = INDEX_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
		//join.in_port_connected_to_out[0] = ...;
		ret += "\t" + varname + ".out_port_connected_to_in[" + j + "] = OUT_PORT_OF_PARENT_OF(\"" + varname + "\"," + j + ");\n";
	}
    //{int* field = malloc(sizeof(int*));
	ret += "\t{int* field = (int*) malloc(sizeof(int*));\n";
	//field[0] = (int) ...;
	ret += "\tfield[0] = (int) " + join.fields[0].function + ";\n";
    //join.field = (void**) malloc(sizeof(void*));
	ret += "\t" + varname + ".field = (void**) malloc(sizeof(void*));\n";
    // join.field[0] = (void*)field};
    ret += "\t" + varname + ".field[0] = (void*) field;}\n";
	// xMas_network[...] = join;
	ret += "\txMas_network[" + index + "] = " + varname + ";\n";
	indices_of_components[varname] = [index, outs_var_names];

	return ret;
}

function translate_components(components, hierarchie, var_subst, outs) {
	var ret = "";
	for(var component_index=0;component_index<components.length;component_index++) {
		var component = components[component_index];
		component.type=component.type.toLowerCase();
		if (component.type == "source" || component.type == "in") {
			ret += translate_source(component, hierarchie, var_subst, outs);
			index++;
		}
		else if (component.type == "queue") {
			ret += translate_queue(component, hierarchie, var_subst, outs);
			index++;
		}
		else if (component.type == "sink" || component.type == "out") {
			ret += translate_sink(component, hierarchie, var_subst, outs);
			index++;
		}
		else if (component.type == "merge") {
			ret += translate_merge(component, hierarchie, var_subst, outs);
			index++;
		}
		else if (component.type == "xswitch" || component.type == "switch") {
			ret += translate_switch(component, hierarchie, var_subst, outs);
			index++;
		}
		else if (component.type == "function") {
			ret += translate_function(component, hierarchie, var_subst, outs);
			index++;
		}
		else if (component.type == "xfork" || component.type=="fork") {
			ret += translate_fork(component, hierarchie, var_subst, outs);
			index++;
		}
		else if (component.type == "join") {
			ret += translate_join(component, hierarchie, var_subst, outs);
			index++;
		}
		else if (component.type == "repeat") {
			for (var j=compute_parameter(component.start, var_subst);j<compute_parameter(component.end, var_subst);j++) {
				var backup = var_subst[component.var];
				var_subst[component.var] = j;
				ret += translate_components(component.components, hierarchie, var_subst, outs);
				var_subst[component.var] = backup;
			}
		}
		else { // Composite object
			var comp_obj = get_composite_object(component.type);
			var var_subst2 = clone(var_subst);
			var hierarchie2 = hierarchie.slice(0);
			var outs2 = outs.slice(0);
			hierarchie2[hierarchie2.length] = [component.id , component.type];
			outs2[outs2.length] = component.outs;

			if (component.parameters != undefined) {
				for (param in comp_obj.parameters) {
					var value_of_param = compute_parameter(component.parameters[comp_obj.parameters[param]], var_subst2);
					var_subst2[comp_obj.parameters[param]] = value_of_param;
				}
			}
			ret += translate_components(comp_obj.architecture, hierarchie2, var_subst2, outs2);
		}
		ret += "\n";
	}
	return  ret;
}

function INDEX_OF(comp_id) {
	if (indices_of_components[comp_id] == undefined)
		return undefined;
	return indices_of_components[comp_id][0];
}
function INDEX_OF_PARENT_OF(comp_id, in_port) {
	for (var comp in indices_of_components) {
		for (var i=0;i<indices_of_components[comp][1].length;i++) {
			if (indices_of_components[comp][1][i][0] == comp_id && indices_of_components[comp][1][i][1] == in_port) {
				return indices_of_components[comp][0];
			}
		}
	}
	return undefined;
}
function OUT_PORT_OF_PARENT_OF(comp_id, in_port) {
	for (var comp in indices_of_components) {
		for (var i=0;i<indices_of_components[comp][1].length;i++) {
			if (indices_of_components[comp][1][i][0] == comp_id && indices_of_components[comp][1][i][1] == in_port) {
				return i;
			}
		}
	}
	return undefined;
}

function compute_num_of_headers() {
	var num_of_packet_types = 1;
	for(var var_name in xmas_object.PACKET_TYPE)
		num_of_packet_types *= Math.pow(2, (Math.ceil(Math.log(xmas_object.PACKET_TYPE[var_name])/Math.log(2))));
	return num_of_packet_types;
}

function code_for_header_to_int() {
    var ret = "";
	var num_of_packet_types = 0;
	for(var var_name in xmas_object.PACKET_TYPE)
		num_of_packet_types++;
	ret += "int header_to_int (char* packet) {\n";
    ret += "\tif (!strncmp(packet, \"ANY\", 3)) return NUM_OF_HEADERS;\n";
    if (num_of_packet_types == 0)
		ret += "\tint ret;\n\tsscanf(packet, \"%i\", &ret);\n\treturn ret;\n";
	else {
        for(var var_name in xmas_object.PACKET_TYPE) {
	    	ret += "\tint p_" + var_name + ";\n";
        }
		ret += "\tsscanf(packet, \"";
		var i = 0;
		for(var var_name in xmas_object.PACKET_TYPE) {
			ret += i++ == 0 ? "" : "_";
			ret += var_name + "%i";
		}
		ret  += "\"";
		for(var var_name in xmas_object.PACKET_TYPE) {
			ret += (", &p_" + var_name);
		}
        ret += ");\n";

        ret += "\treturn ";
        i = 0;
        for(var var_name in xmas_object.PACKET_TYPE) {
            ret += "(p_" + var_name;
            if (i < num_of_packet_types -1) {
                ret += "<< (";
                var j = 0;
                for (var var_name2 in xmas_object.PACKET_TYPE) {
                    if (j > i) {
                        if (j>i+1) ret += " + ";
                        ret += (Math.ceil(Math.log(xmas_object.PACKET_TYPE[var_name2])/Math.log(2)));
                    }
                    j++;
                }
                ret +=  ")) |";
            }
            i++;
        }
        ret += ");\n";
	}
	ret += "}\n";
	return ret;
}

function code_for_print_header() {
	var ret = "";
	var num_of_packet_types = 0;
    var length_of_var_names = 0;
	for(var var_name in xmas_object.PACKET_TYPE) {
		num_of_packet_types++;
        length_of_var_names += var_name.length;
    }
	ret += "char * print_header (int header) {\n";
	if (num_of_packet_types == 0)
		ret += "\tchar* ret = (char*) malloc(8*sizeof(char));\n\tif (header == NUM_OF_HEADERS)\n\t\tsprintf(ret, \"ANY\");\n\telse\n\t\tsprintf(ret, \"%i\", header);\n\treturn ret;\n";
	else {
		ret += code_to_convert_int_to_packet_struct("header", "p", "\t");
		ret += "\tchar* ret = (char*) malloc(" + ((num_of_packet_types*3)+length_of_var_names+4) + "*sizeof(char));\n";
        ret += "\tif (header == NUM_OF_HEADERS)\n\t\tsprintf(ret, \"ANY\");\n\telse\n";
		ret += "\t\tsprintf(ret, \"";
		var i = 0;
		for(var var_name in xmas_object.PACKET_TYPE) {
			ret += i++ == 0 ? "" : "_";
			ret += var_name + "%i";
		}
		ret  += "\"";
		for(var var_name in xmas_object.PACKET_TYPE) {
			ret += ", p_" + var_name;
		}
		ret += ");\n\treturn ret;\n";
	}
	ret += "}\n";
	return ret;
}

// load("json-schema.js");
var glob_var_subst = {};
var top_level_hierarchie = new Array();
var top_level_outs = new Array();
xmas_object = JSON.parse(args);
// Constants
output += "#include \"../datastructures.c\"\n#include <stdlib.h>\n#include <stdbool.h>\n#include <stdio.h>\n#include <math.h>\n#include <string.h>\n\n";
for(var var_name in xmas_object.VARS) {
		output += "#define " + var_name + " " + xmas_object.VARS[var_name] + "\n";
		glob_var_subst[var_name] = xmas_object.VARS[var_name];
}
output += "int xMas_network_size = NETWORKSIZENETWORKSIZENETWORKSIZE;\n";
output += "int const OUTDEGREE = 10;\n";
output += "int const NUM_OF_HEADERS = " + compute_num_of_headers() + ";\n";
output += "\n";
// The xmas network data structure
output += "struct xMas_component* xMas_network;\n\n"
// The print_header function
output += code_for_print_header();
// The header_to_int function
output += code_for_header_to_int();
/*output += "char * print_header (int header) {\n";
if(xmas_object.PRINT_HEADER.length){
output += "\t" + xmas_object.PRINT_HEADER;
}else{ // some default headers
output += "char* ret = (char*) (malloc (3 * sizeof(char))); sprintf(ret, \"h%d\", header); return ret;"
}
output += "\n}\n\n";
*/
// The prelude
output += "\nPRELUDEPRELUDEPRELUDE\n\n";
// The xmas component initializer
output += "void init_xMas_component(struct xMas_component* x, char* id, int type, int num_of_outs, int num_of_ins) {\n\tx->id = id;\n\tx->type = type;\n\tx->num_of_outs = num_of_outs;\n\tx->out = (int*) malloc(num_of_outs * sizeof(int));";
output += "\n\tx->in_port_connected_to_out = (int*) malloc(num_of_outs * sizeof(int));\n\tx->num_of_ins = num_of_ins;\n\tx->in = (int*) malloc(num_of_ins * sizeof(int));\n\tx->out_port_connected_to_in = (int*) malloc(num_of_ins * sizeof(int));\n}\n\n";
// the fucntion intstantiating the network
output += "void init_xMas_network(void) {\n";
output += "\txMas_network = (struct xMas_component*) malloc (xMas_network_size * (sizeof (struct xMas_component)));\n";
output += translate_components(xmas_object.NETWORK, top_level_hierarchie, glob_var_subst, top_level_outs);
output += "}\n";
output += "void queue_to_coor(int q, int* dim) {}\n";

output = output.replace("NETWORKSIZENETWORKSIZENETWORKSIZE", index);
output = output.replace("PRELUDEPRELUDEPRELUDE", output_prelude);
output = output.replace(/(INDEX_OF\(\"\w*\"\))/g, function (expr) { return eval(expr); });
output = output.replace(/(INDEX_OF_PARENT_OF\(\"\w*\",\w*\))/g, function (expr) { return eval(expr); });
output = output.replace(/(OUT_PORT_OF_PARENT_OF\(\"\w*\",\w*\))/g, function (expr) { return eval(expr); });
if(typeof phantom!="undefined"){
  console.log(output);
  phantom.exit();
}else echo(output);
