# Forward sampling for an illustrated example Pump <- AMI-> Enz
library(LaplacesDemon)
# N = 100 # number of discrete-time slice
forwardHF <- function(N, q1, q2, q3, q4, q5, q6, Pump.tran){
  
A.traj = c() # time trajectory for discrete-time variable
B.traj = c() # time trajectory for continuous-time variable
AMI.ind = c()

# sampled states
Pump.states = c()
AMI.states = c()
Enz.states = c()
# CPTs in the inital BN
Pump.theta = c(0.2, 0.8)
AMI.theta = c(0.4, 0.6)
Enz.theta = c(0.3,0.7)
# CPT for Pump given the configuration of AMI
# Pump.tran = as.data.frame(matrix(c(0.9,0.1,0.2,0.8), ncol = 2, byrow = TRUE))
# Pump.tran[,,1]: when Pump[t] = 1
# Pump.tran[1,,1]: when Pump[t] = 1 and AMI[t+1] = 1

# generate sampling at time 1, no dependencies
Pump.currstate = rcat(1, Pump.theta)
AMI.currstate = rcat(1, AMI.theta)
Enz.currstate = rcat(1, Enz.theta)
# system start at time 1
currTime = 1
Pump.states = c(Pump.states, Pump.currstate)
AMI.states = c(AMI.states, AMI.currstate)
Enz.states = c(Enz.states, Enz.currstate)
# A.traj = c(A.traj, 1)
# B.traj = c(B.traj, 1)
# cat("currTime is ", currTime, "\n")
time.traj = c()
Pump.AMI.val = c()
for(i in 2:N)
{
  while(currTime < i)
  {
    q_AMI = -AMI.inten[AMI.currstate, AMI.currstate]
    q_Enz = -Enz.inten[Enz.currstate,Enz.currstate,AMI.currstate]
    q_e = q_AMI + q_Enz
    cand_dis = c(q_AMI, q_Enz)/q_e
    cand = rcat(1, cand_dis)
    time = rexp(1, rate = q_e)
    # create time trajectory
    B.traj = c(B.traj, time)
    # track current time point for continuout-time variable
    currTime <- currTime + time
    time.traj = c(time.traj, currTime)
    if(cand==1)
      AMI.currstate = setdiff(c(1,2), tail(AMI.currstate, 1))
    else
      Enz.currstate = setdiff(c(1,2), tail(Enz.currstate, 1))
    AMI.states = c(AMI.states, AMI.currstate)
    Enz.states = c(Enz.states, Enz.currstate)
  }
  curr.AMI.ind = length(AMI.states)-1
  AMI.ind = c(AMI.ind, curr.AMI.ind)
  Pump.par.var = AMI.states[curr.AMI.ind]
  Pump.AMI.val = c(Pump.AMI.val, Pump.par.var)
  Pump.curr.tran = Pump.tran[Pump.par.var,,Pump.currstate]
  Pump.currstate = rcat(1, Pump.curr.tran)
  A.traj = c(A.traj, length(A.traj) + 1)
  Pump.states = c(Pump.states, Pump.currstate)
}
return(list(Pump.par.var = Pump.par.var, Pump.AMI.val = Pump.AMI.val, Pump.states = Pump.states, A.traj = A.traj, 
            AMI.states = AMI.states, Enz.states = Enz.states, time.traj = time.traj, B.traj = B.traj))
}




  
  

n1 = 0
n2 = 0
Pump.AMI = AMI.states[AMI.ind]
Pump.states2 = Pump.states[-1]
for(i in 1: (length(Pump.AMI)-1))
{
  if(Pump.states2[i+1] == 1 & Pump.AMI[i+1] == 1 & Pump.states2[i] == 1)
    n1 = n1 + 1
  if(Pump.AMI[i+1] == 1 & Pump.states2[i] == 1)
    n2 = n2 + 1
}
cat("P(Pump_t+1 = 1| Pump_t = 1, AMI_t+1 = 1): estimated: ", n1/n2, "expected: ", Pump.tran[1,1,1], "\n")

n1 = 0
n2 = 0
Pump.AMI = AMI.states[AMI.ind]
Pump.states2 = Pump.states[-1]
for(i in 1: (length(Pump.AMI)-1))
{
  if(Pump.states2[i+1] == 1 & Pump.AMI[i+1] == 2 & Pump.states2[i] == 1)
    n1 = n1 + 1
  if(Pump.AMI[i+1] == 2 & Pump.states2[i] == 1)
    n2 = n2 + 1
}
cat("P(Pump_t+1 = 1| Pump_t = 1, AMI_t+1 = 2): estimated: ", n1/n2, "expected: ", Pump.tran[2,1,1], "\n")


n1 = 0
n2 = 0
Pump.AMI = AMI.states[AMI.ind]
Pump.states2 = Pump.states[-1]
for(i in 1: (length(Pump.AMI)-1))
{
  if(Pump.states2[i+1] == 1 & Pump.AMI[i+1] == 2 & Pump.states2[i] == 2)
    n1 = n1 + 1
  if(Pump.AMI[i+1] == 2 & Pump.states2[i] == 2)
    n2 = n2 + 1
}
cat("P(Pump_t+1 = 1| Pump_t = 2, AMI_t+1 = 2): estimated: ", n1/n2, "expected: ", Pump.tran[2,1,2], "\n")

