# Forward sampling for a continuous-time variable D -> C
library(LaplacesDemon)

N = 5000 # number of discrete-time slice
B.traj = c() # time trajectory for continuous-time variable
# q1 = sample(1:20, 1)
# q2 = sample(1:20, 1)
q1 = 3
q2 = 18
# q1 = rgamma(1, shape = 2, rate = 2)
# q2 = rgamma(1, shape = 2, rate = 2)
# list.exp.q1 = c(list.exp.q1, q1)
# list.exp.q2 = c(list.exp.q2, q2)
cat("q1 is: ", q1, "\t q2 is: ", q2, "\n")
# sampled states
C.states = c()
# CPTs for D and C, no arcs in inital BN
C.theta = c(0.4, 0.6)
# intensity matrices for C given the configuration of its parent D
intensity = as.data.frame(matrix(c(-q1,q1,q2,-q2), ncol = 2, byrow = TRUE))
C.currstate = rcat(1, C.theta)
C.states = c(C.states, C.currstate)
time.interval = c()
time.traj = c(0)
currTime = 1
for(i in 2:N)
{
  while(currTime <= i)
  {
    # choose rate 
    q = -intensity[C.currstate, C.currstate]
    time = rexp(1, rate = q)
    time.interval = c(time.interval, time)
    currTime = currTime + time
    time.traj = c(time.traj,  currTime)
    C.currstate = setdiff(c(1,2), tail(C.states, 1))
    C.states = c(C.states, C.currstate)
  }
}
# set.seed(1981)
sys_time = 0
rtp = c()
rtp_sys = c(0)
rstates = c(C.states[1])
while(sys_time <=N)
{
  time = rexp(1, rate = q)
  sys_time = sys_time + time
  rtp = c(rtp, time)
  rtp_sys = c(rtp_sys, sys_time)
}
for(i in 1:length(time.traj))
{
  t = which(rtp_sys>=time.traj[i] & rtp_sys<=time.traj[i+1])
  rstates = c(rstates, rep(C.states[i], length(t)))
}
 
# missing value
# n.sample = length(rstates)
# select = sort(sample(1:(n.sample-1), 0.1 * n.sample))
# rstates = rstates[select]
# rtp_sys = rtp_sys[select] 
# rtp = diff(rtp_sys)


# check when length(rstates) = length(rtp)




