/*
* Copyright 2012-2014 Marc Schoolderman
*
* Licensed under the EUPL, Version 1.1 or – as soon they
will be approved by the European Commission - subsequent
versions of the EUPL (the "Licence");
* You may not use this work except in compliance with the
Licence.
* You may obtain a copy of the Licence at:
*
* http://ec.europa.eu/idabc/eupl5
*
* Unless required by applicable law or agreed to in
writing, software distributed under the Licence is
distributed on an "AS IS" basis,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
express or implied.
* See the Licence for the specific language governing
permissions and limitations under the Licence.
*/

implementation module StdImperative

// this code is hairy
import StdMisc
from StdFunc import id, o, flip, seq
from StdOverloaded import class rem(rem), class toInt(toInt), class toString(toString), class +++(+++), class length(length), class fromChar(fromChar), class toChar(toChar), class fromString(fromString)
from StdTuple import fst, snd
from StdList import filter, map, hd, tl, ++, isEmpty, any, all, foldr, !!, instance length [], iterate, takeWhile, instance fromString [x] | fromChar x, instance toString [x] | toChar x, take, drop
from StdInt import instance rem Int, instance toInt {#Char}
from StdChar import instance fromChar Int , instance toChar Int
from StdString import instance +++ {#Char}, instance toString Int
from StdDebug import trace_n

import WrapEnv

:: Closure = { depth :: Int, orphan :: [(Var,Closure)], body :: Code }
:: Value :== [Int]
:: State = { vars  :: [(Var,Closure)]
           , last  :: Value
           , label :: [Label]
           , skip  :: (Continuation,Continuation)
           , out   :: Output String
           }

:: Element i = A i|B i|C i|D i|E i|F i|G i|H i|I i|J i|K i|L i|M i|N i|O i|P i|Q i|R i|S i|T i|U i|V i|W i|X i|Y i|Z i
:: Var_ i :== i -> Element i
:: Var :== Var_ Code
:: Continuation :== State->State
:: Label :== (Value, Continuation)
:: Code :== Continuation -> Continuation
:: Assignation :== Code -> WeakValue
:: WeakValue = Weak Code

box :: Int -> Value
box i = [i]

unbox :: Value -> Int
unbox []  = abort "Evaluated void value\n"
unbox [i] = i
unbox _   = abort "Array used in scalar context\n"

nontrue :: Value -> Bool
nontrue x = all (same 0) x

initial :: State
initial = { vars=[], last=void, label=[], skip=(oops,oops), out=Begin }
where oops = abort "Break or continue used outside loop\n"

void :: Value
void = [] 

dummy :: a
dummy = abort "Oops.\n"

uninited :: Var -> a
uninited v = abort ("Uninitialized variable: " +++ toString v +++ "\n")

// clean record updates force strictness, which we don't want
(<-@) infixr 1 :: State [Label] -> State
(<-@) st label = { vars=st.vars, last=st.last, skip=st.skip, label=label, out=st.out }

//(!->) infixr 1 :: (Var,Value) State -> State
//(!->) (var,val) st = { st & vars=assoc var (\_->val) st.vars }
(!->) infixr 1 :: (Var,a) State -> State | $a
(!->) (var,val) st = { st & vars=assoc var (\_ -> $$val) st.vars }

class default a :: a
instance default Int where default = 0
instance default [Int] where default = []
instance default Closure where default = $$pass

assoc :: k (a->a) [(k,a)] -> [(k,a)] | same k & default a
assoc key f [] = [(key,f default)]
assoc key f [(k,v):as] 
| same k key = [(k,f v):as]
| otherwise  = [(k,v):assoc key f as]

zipwith :: (a b->c) [a] [b] -> [c]
zipwith f [x:xs] [y:ys] = [f x y:zipwith f xs ys]
zipwith f [] [] = []
zipwith f _ _ = abort "Unmatched array sizes in assignment\n"

(<+>) infix 2 :: [Label] [Label] -> [Label]
(<+>) xs ys = xs ++ [ (y,q) \\(y,q)<-ys | all (notsame y o fst) xs ]

execute :: a -> State | yield a
execute program = $!program id {initial & label=($!program id initial).label}

labels :: a -> [String] | $a
labels p = map (toString o fst) ($p id initial).label

run :: a -> Output String | yield a
run p = (execute p).out

instance toInt Code where 
  toInt p = unbox (execute p).last

instance toString Code where 
  toString p = toString (run p)

instance toString (Output String) where
  toString Begin = ""
  toString (x >>> y) = toString x +++ y

instance toString (Var_ i) where 
    toString x = toString (x dummy)

instance toString (Element i) where
    toString (A _) = "A"
    toString (B _) = "B"
    toString (C _) = "C"
    toString (D _) = "D"
    toString (E _) = "E"
    toString (F _) = "F"
    toString (G _) = "G"
    toString (H _) = "H"
    toString (I _) = "I"
    toString (J _) = "J"
    toString (K _) = "K"
    toString (L _) = "L"
    toString (M _) = "M"
    toString (N _) = "N"
    toString (O _) = "O"
    toString (P _) = "P"
    toString (Q _) = "Q"
    toString (R _) = "R"
    toString (S _) = "S"
    toString (T _) = "T"
    toString (U _) = "U"
    toString (V _) = "V"
    toString (W _) = "W"
    toString (X _) = "X"
    toString (Y _) = "Y"
    toString (Z _) = "Z"

instance same (Var_ i)
where same x y = same (x dummy) (y dummy)

instance same (Element i)
where same (A _) (A _) = True
      same (B _) (B _) = True
      same (C _) (C _) = True
      same (D _) (D _) = True
      same (E _) (E _) = True
      same (F _) (F _) = True
      same (G _) (G _) = True
      same (H _) (H _) = True
      same (I _) (I _) = True
      same (J _) (J _) = True
      same (K _) (K _) = True
      same (L _) (L _) = True
      same (M _) (M _) = True
      same (N _) (N _) = True
      same (O _) (O _) = True
      same (P _) (P _) = True
      same (Q _) (Q _) = True
      same (R _) (R _) = True
      same (S _) (S _) = True
      same (T _) (T _) = True
      same (U _) (U _) = True
      same (V _) (V _) = True
      same (W _) (W _) = True
      same (X _) (X _) = True
      same (Y _) (Y _) = True
      same (Z _) (Z _) = True
      same _ _ = False

primary :: (Element i) -> Var
primary (A _) = A
primary (B _) = B
primary (C _) = C
primary (D _) = D
primary (E _) = E
primary (F _) = F
primary (G _) = G
primary (H _) = H
primary (I _) = I
primary (J _) = J
primary (K _) = K
primary (L _) = L
primary (M _) = M
primary (N _) = N
primary (O _) = O
primary (P _) = P
primary (Q _) = Q
primary (R _) = R
primary (S _) = S
primary (T _) = T
primary (U _) = U
primary (V _) = V
primary (W _) = W
primary (X _) = X
primary (Y _) = Y
primary (Z _) = Z

subscript :: (Element i) -> Code | $i
subscript (A x) = $x
subscript (B x) = $x
subscript (C x) = $x
subscript (D x) = $x
subscript (E x) = $x
subscript (F x) = $x
subscript (G x) = $x
subscript (H x) = $x
subscript (I x) = $x
subscript (J x) = $x
subscript (K x) = $x
subscript (L x) = $x
subscript (M x) = $x
subscript (N x) = $x
subscript (O x) = $x
subscript (P x) = $x
subscript (Q x) = $x
subscript (R x) = $x
subscript (S x) = $x
subscript (T x) = $x
subscript (U x) = $x
subscript (V x) = $x
subscript (W x) = $x
subscript (X x) = $x
subscript (Y x) = $x
subscript (Z x) = $x

yield :: (State->Value) State -> State
yield val st = {st & last=st.last ++ val st}

$? :: a (Value->Continuation) -> Continuation | $a
$? f kq = \st -> $f (\stf->kq stf.last {stf&last=st.last}) {st&last=void}

$$ :: a -> Closure | $a
$$ f = { depth = 0, orphan = [], body = $f }

class $ a :: a -> Code 

instance $ Code
where $ x = x

instance $ WeakValue
where $ (Weak x) = x

instance $ (Code->a) | $a
where $ x = $(x id)

instance $ Int 
where $ i = \k -> k o yield (\_->box i)

instance $ (Var_ i)
where $ v = open (primary (v dummy))
//where $ v = \k st -> open (getvar (v dummy) st) k st
//where $ v = \k st -> case getvar (v dummy) st of {depth,orphan,body} = body k st
//where $ v = \k -> k o yield (getvar (v dummy))

instance $ (Element i) | $i
where $ v = primary v elem subscript v

instance $ [a] | yield a
where $ v = foldr (`) pass v

instance $ Interval 
where $ (beg,end) = \k -> $?beg (\x1 -> $?end (\x2 -> k o yield (\_->range (unbox x1) (unbox x2))))
      where range x y = let op = flip if (x.<.y) (.+.) (.-.) 1 in takeWhile (notsame (op y)) (iterate op x)

instance $ Char
where $ x = $ let char_x :: Int
                  char_x = fromChar x in char_x

instance $ String
where $ s = $ let int_s :: [Int] 
                  int_s = fromString s in int_s

class yield_ a b :: a b -> Code
instance yield_ Int a | $a where yield_ _ x = $x
instance yield_ Int Assignation where yield_ _ x = \k -> $? x (\_->k)

class yield a | yield_ Int a
where $! :: a -> Code | yield a 
      $! x = yield_ 0 x

size :: a -> Code | $a
size v = \k -> $?v (\arg->k o yield (\_->box (length arg)))

(`) infixr 0 :: a b -> Code | yield a & yield b
(`) f g = $!f o $!g

(elem) infix 9 :: a b -> Code | $a & $b
(elem) arr idx = \k -> $?arr (\ar -> $?idx (\is -> k o yield (\_->map ((!!) ar) is)))

//getvar :: (Element i) State -> Value
getvar :: (Element i) State -> Closure
getvar v st = case filter (same (primary v) o fst) st.vars of
                [(_,i):_] = i
                _         = uninited (primary v)

unary :: (Value->Value) a -> Code | $a
unary op f = \k -> $?f (\val->k o yield (\_->op val))
binary :: (Int Int->Int) a b -> Code | $a & $b
binary op f g = \k -> $?f (\val1-> $?g (\val2->k o yield (\_->lift op val1 val2)))
where lift op f = box o op (unbox f) o unbox

(==) infix 5 :: a b -> Code | $a & $b
(==) f g = binary (\x y->if (same x y) 1 0) f g
(<>) infix 5 :: a b -> Code | $a & $b
(<>) f g = binary (\x y->if (same x y) 0 1) f g
(<)  infix 5 :: a b -> Code | $a & $b
(<)  f g = binary (\x y->if (x.<.y) 1 0) f g
(<=) infix 5 :: a b -> Code | $a & $b
(<=) f g = binary (\x y->if (y.<.x) 0 1) f g
(>)  infix 5 :: a b -> Code | $a & $b
(>)  f g = binary (\x y->if (y.<.x) 1 0) f g
(>=) infix 5 :: a b -> Code | $a & $b
(>=) f g = binary (\x y->if (x.<.y) 0 1) f g
(between) infixr 5 :: a (b,c) -> Code | $a & $b & $c
(between) a (b,c) = (b <= a and a <= c) or (c <= a and a <= b)

(+)  infixl 6 :: a b -> Code | $a & $b
(+) f g = binary (.+.) f g
(-)  infixl 6 :: a b -> Code | $a & $b
(-) f g = binary (.-.) f g
(*)  infixl 7 :: a b -> Code | $a & $b
(*) f g = binary (.*.) f g
(/)  infixl 7 :: a b -> Code | $a & $b
(/) f g = binary (./.) f g
(mod) infix 7 :: a b -> Code | $a & $b
(mod) f g = binary (rem) f g

(and) infixl 4 :: a b -> Code | $a & $b
(and) f g = binary (and`) f g
where and` 0 _ = 0
      and` _ 0 = 0
      and` _ _ = 1

(or) infixl 4 :: a b -> Code | $a & $b
(or) f g = binary (or`) f g
where or` 0 0 = 0
      or` _ _ = 1

not :: a -> Code | $a
not f = unary (\x -> box (if (nontrue x) 1 0)) f

class (:=) infixr 3 v a :: v a -> Assignation

(<-|) infixr 3 :: v a -> Assignation | := v a
(<-|) x y = x:=y
(|->) infixl 3 :: a v -> Assignation | := v a
(|->) y x = x:=y

updateAt :: Int a [a] -> [a] | default a
updateAt i _ _      | i.<.0 = abort "Negative array subscript used\n"
updateAt 0 v []     = [v]
updateAt i v []     = [default : updateAt (i.-.1) v []]
updateAt 0 v [x:xs] = [v : xs]
updateAt i v [x:xs] = [x : updateAt (i.-.1) v xs]

instance := (Var_ i) a | $a where 
  (:=) var e = \_ -> Weak \k -> $?e (\val->k o yield (\_->val) o (!->) (primary (var dummy),val))

instance := (Element i) a | $a & $i where 
  (:=) var e = \_ -> Weak \k -> $?(subscript var) (\subs -> $?e (\vals ste -> (k o yield \_->vals)
      {ste&vars = assoc (primary var) (\arr->
          //seq (zipwith updateAt subs vals) arr) ste.vars}))
          $$(seq (zipwith updateAt subs vals) (literal arr.body))) ste.vars}))

instance := [Var_ i] a | $a where
  (:=) vs e = \_ -> Weak \k -> $?e (\exprs ste->(k o yield \_->exprs)
      //{ste&vars = seq (zipwith (\v e->assoc (primary (v dummy)) (\_->box e)) vs exprs) ste.vars})
      {ste&vars = seq (zipwith (\v e->assoc (primary (v dummy)) (\_-> $$e)) vs exprs) ste.vars})

(+:=) infixr 3 :: (Var_ i) a -> Assignation | $a
(+:=) v e = v:=v+e
(-:=) infixr 3 :: (Var_ i) a -> Assignation | $a
(-:=) v e = v:=v-e
(*:=) infixr 3 :: (Var_ i) a -> Assignation | $a
(*:=) v e = v:=v*e
(/:=) infixr 3 :: (Var_ i) a -> Assignation | $a
(/:=) v e = v:=v/e

(||)  infixl 8 :: a b -> Code | $a & $b
(||) f g = $[$f,$g]

(||:=) infixr 3 :: (Var_ i) a -> Assignation | $a
(||:=) v e = v:=v||e

class (local) infixr 0 a :: a b -> Code | $b

instance local (Var_ i) where
  (local) var p = scope (primary (var dummy)) ($p)
instance local [Var_ i] where
  (local) vs p = foldr (local) ($p) vs

scope :: Var Code -> Code 
scope var f = \k st->f (k o leave st) (enter (push (var,getvar (var dummy) st) st)) 
//scope var f = \k st->f (k o leave st) (enter (push (var,uninited var) st)) 
  where 
    incr (k,f)  = (k,{f&depth=f.depth.+.1})
    del w (k,f) = (k,if (0.<.f.depth) {f&depth=f.depth.-.1} {f&orphan=[w:f.orphan]})
    //del w (k,f) = (k,if (0.<.f.depth) {f&depth=f.depth.-.1} ($$ (literal f.body)))
    push v st=:{vars=vs}  = {st&vars=[v:map incr vs]}
    pop st=:{vars=[w:vs]} = {st&vars=map (del w) vs}
    //push v st=:{vars=vs}  = {st&vars=[v:vs]}
    //pop st=:{vars=[_:vs]} = {st&vars=vs}
    leave :: State State -> State
    //leave st nst = pop nst <-@ st.label<+>nst.label
    leave st nst = pop nst <-@ st.label<+>[ (s,k o enter o push (var,uninited var)) \\ (s,k)<-nst.label ]
    enter :: State -> State
    enter st=:{skip=(brk,cnt)}
      = let 
          undo  = leave st
          intra = [ (s,k) \\ (s,k) <-st.label | any (same s o fst) (f id (st<-@[])).label ]
        in
          {st & skip=(brk o undo, cnt o undo), label=intra<+>[(s,k o undo) \\ (s,k)<-st.label]}

open :: Var Continuation -> Continuation
open v k = \st -> opened (getvar (v dummy) st) st
where opened {body,depth,orphan} st = body (k o unmodify) modify 
		where modify       = { st & vars=orphan ++ drop depth st.vars }
			  unmodify nst = { nst & vars=take depth st.vars ++ assoc v (\f->{f&orphan=take nvar nst.vars}) (drop nvar nst.vars) }
			  nvar = length orphan
/*
open :: Closure Continuation -> Continuation
open {depth,body} k = \st -> body (k o unmodify st) (modify st)
where modify st       = { st & vars=drop depth st.vars }
      unmodify ost st = { st & vars=take depth ost.vars ++ st.vars }
*/

pass :: Code
pass = id

when :: a Code Code -> Code | $a
when test then else
 = \k -> $?test (\r st->let tt = $then k st
                            ff = $else k st in if (nontrue r) ff tt <-@ tt.label<+>ff.label)

(do) infixr 2 :: (Code->b) a -> b | yield a
(do) f g = f ($!g)

(else) infixl 1 :: (Code->b) a -> b | $a
(else) f g = f ($g)

literal :: a -> Value | $a
literal x = ($x id initial).last

(@) infixr 0 :: lbl a -> Code | $a & $lbl
(@) str f = case literal str of
              []  = abort "No empty labels allowed\n"
              val = (\k st -> k (st <-@ [(val,k):st.label])) ` $f

goto :: a -> Code | $a
goto val = \k -> $?val \target->
           \st -> case filter (same target o fst) st.label of 
                      [(_,q):_] = q st <-@ (k st).label
                      _         = abort ("Invalid label: "+++toString target+++"\n") <-@ (k st).label

return :: a -> Code | $a
return f = \k st -> $?f (\val stt->{stt&last=val}) st <-@ (k st).label

break :: Code
break = \k st -> fst st.skip st <-@ (k st).label

continue :: Code
continue = \k st -> snd st.skip st <-@ (k st).label

repeat :: a -> a | $a
repeat x = x

(until) infixl 1 :: a b -> Code | yield a & $b
(until) body test = loop
where loop = \k st -> let
               push nst  = {nst & skip=(k o pop, decide o pop)}
               pop  nst  = {nst & skip=st.skip}
               decide st = $?test (\r stt->if (nontrue r) 
                                                (loop k stt <-@ (k stt).label) 
                                                (k stt)) st
            in
               $!body (decide o pop) (push st)

while :: a b -> Code | $a & yield b
while test body = when test (body until (not test)) pass

// safe range based for loop (variable is scoped and resists mutation)

:: LoopVar = Loop Var
for :: Var -> LoopVar
for x = Loop x

:: Interval :== (Code, Code)
(to) infixr 3 :: a b -> Interval | $a & $b
(to) beg end = ($beg,$end)

instance := LoopVar Interval where
  (:=) (Loop v) (beg,end) = 
    \body -> (Weak o scope v) \k -> $?beg (\x1 st1-> $?end (\x2 st2->
                       let (cmp, step) = if (unbox x1.<.unbox x2) (<=,v+1) (>=,v-1)
                       in while (cmp v (unbox x2))
                             (scope v body ` v:=step) k ((v,x1)!->st2)) st1)

instance := LoopVar a | $a where
  (:=) (Loop v) range = 
    \body -> (Weak o scope v) \k -> $?range (\rng-> $[ v:=val ` body \\ val <- rng ] k)

// closures - you cannot export closured
 
:: Macro = Macro Code
instance := (Var_ i) Macro where
  (:=) var (Macro cod) = \_ -> Weak \k -> k o (!->) (primary (var dummy),cod)

.\ :: a -> Macro | yield a
.\ cod = Macro ($!cod)

call :: Var -> Code
call v = $v

putstr :: a -> Code | $a
putstr str = \k -> $?str (\val st->k {st & out=st.out >>> toString val})

putint :: a -> Code | $a
putint i = \k -> $?i (\val st->k {st & out=st.out >>> toString (unbox val)})

print :: a -> Code | $a
print a = \k -> $?a (\val-> case val of //[]  = abort "Empty input to print statement\n"
                                        [x] | x.<.32  = putint val k
                                        [x] | 127.<.x = putint val k
                                        _   = putstr val k)

println :: a -> Code | $a
println a = print a ` putstr '\n'

(<<) infixl 2 :: (Code->Code) b -> (Code->Code) | $b
(<<) f x = \y -> f (print x ` y)

str :: a -> Code | $a
str a = \k -> $?a (\val->k o yield (\_->fromString (toString (unbox val))))

int :: a -> Code | $a
int a = \k -> $?a (\val->k o yield (\_->box (toInt (toString val))))

