Require Import Reals.
Require Export Fourier.

(* originally in ProofWeb.v *)
Require Import Classical.

(* backward tactics *)

Ltac con_i :=
  match goal with
  | |- _ /\ _ => split
  end ||
  fail "(the goal is not a conjunction)".

Ltac con_e1 R :=
  match goal with
  | |- ?G =>  refine (and_ind (fun (left : G) (_ : R) => left) (_ : G /\ R))
  end.

Ltac con_e2 L :=
  match goal with
  | |- ?G => refine (and_ind (fun (_ : L) (right : G) => right) (_ : L /\ G))
  end.

Ltac dis_i1 :=
  match goal with
  | |- _ \/ _ => left
  end ||
  fail "(the goal is not a disjunction)".

Ltac dis_i2 :=
  match goal with
  | |- _ \/ _ => right
  end ||
  fail "(the goal is not a disjunction)".

Ltac dis_e X H1 H2 :=
  match X with
  | ( _ \/ _ ) =>
   let x := fresh "H" in
   assert (x : X);
   [ idtac | elim x; clear x; [intro H1 | intro H2]
   ]
  end ||
  fail "(the argument is not a disjunction or the labels already exist)".

Ltac imp_i X :=
  match goal with
  | |- _ -> _ => intro X
  end ||
  fail "(the goal is not an implication)".

Ltac imp_e X := cut X.

(* Ltac neg_i X :=
  match goal with
  | |- ~ _ => intro X
  end ||
  fail "(the goal is not a negation)". *)

Ltac neg_e X := absurd X.

Ltac fls_e := apply False_ind.

Ltac tru_i := exact I ||
  fail "(the goal is not True)".

Ltac eqv_i :=
  match goal with
  | |- _ <-> _ => split
  end ||
  fail "(the goal is not an equivalence)".

Ltac eqv_e1 :=
  match goal with
  | |- (?A -> ?B) => refine (and_ind (fun (x : A -> B) (_ : B -> A) => x) (_ : A <-> B))
  end ||
  fail "(the goal is not an implication)".

Ltac eqv_e2 :=
  match goal with
  | |- (?B -> ?A) => refine (and_ind (fun (_ : A -> B) (y : B -> A) => y) (_ : A <-> B))
  end ||
  fail "(the goal is not an implication)".

Ltac iff_i H1 H2 :=
 match goal with
 | |- _ <-> _ =>
 eqv_i ; [ (imp_i H1) | (imp_i H2) ]
 end ||
 fail "(the goal is not a bi-implication)".

Ltac iff_e1 L :=
 cut L ; [ eqv_e1 | idtac ].

Ltac iff_e2 R :=
 cut R ; [ eqv_e2 | idtac ].

Ltac negneg_i :=
  match goal with
  | |- (~~ ?X) => let H := fresh "H" in intro H; apply H; clear H
  end ||
  fail "(the goal is not a double negation)".

Ltac negneg_e :=
  match goal with
  | |- ?H => apply (NNPP H)
  end.

Ltac LEM :=
  match goal with
  | |- ?H \/ ~ ?H => apply classic
  end ||
  fail "(the goal is not of the form A \/ ~A)".

Ltac PBC X :=
  negneg_e; intro X.

Ltac RAA := PBC.

Ltac MT A :=
  match goal with
  | |- (~ ?B) =>
      refine ((fun (H1 : B -> A) (H2 : ~A) (H : B) => H2 (H1 H)) _ _)
  end ||
  fail "(the goal is not a negation)".

Ltac all_i X :=
  match goal with
  | |- forall _, _ => intro X
  end ||
  fail "(the goal is not a universal quantification)".

(* Ltac all_e X :=
  match X with
  | forall _ : _ , _ => refine ((_ : X) _)
  end ||
  fail "(the argument is not a universal quantification)". *)

Ltac all_e' X A :=
  match X with
  | forall _ : _ , _ => refine ((_ : X) A)
  end ||
  fail "(the argument is not a universal quantification)".

Ltac exi_i X :=
  match goal with
  | |- exists x : _ , _ => exists X
  end ||
  fail "(the goal is not an existential quantification)".

Ltac exi_e X a H :=
  match X with
  | ex _ => refine ((fun x y => ex_ind y (x : X)) _ _) ; [idtac | all_i a ; imp_i H]
  end ||
  fail "(the argument is not an existential quantification)".

Ltac equ_i := reflexivity.

Ltac equ_e X :=
  match X with
  | (?x = ?y) => let H := fresh "H" in
      assert (H : X); [idtac | rewrite <- H; clear H]
  end ||
  fail "(argument is not an equality)".

Ltac equ_e' X Y :=
  match X with
  | (?x = ?y) => let H := fresh "H" in
      assert (H : X); [idtac | change (Y y); rewrite <- H; clear H]
  end ||
  fail "(first not an equality or second argument not a context)".

(* old tactics *)

Ltac dis_els X :=
  match X with
  | ( _ \/ _ ) =>
   assert X;
   [ idtac
     | match goal with
     | y : X |- _ => elim y; clear y
   end
   ]
  end ||
  fail "(the argument is not a disjunction)".

Ltac dn_axiom :=
  match goal with
  | |- (~~ ?X -> ?X) => apply (NNPP X)
  end ||
  fail "(the goal is not an instance of the double negation axiom)".

Ltac neg_ins X Y :=
  match goal with
  | |- ~ _ => intro Y; absurd X
  end ||
  fail "(the goal is not a negation)".

Ltac neg_els X Y := negneg_e; intro Y; absurd X.

Ltac exi_els X :=
  match X with
  | ex _ => refine (ex_ind _ (_ : X))
  end ||
  fail "(the argument is not an existential quantification)".

(* end things from ProofWeb.v *)


(* Definition B:= Prop. *)
Notation B := Prop.

(* disable a Notation *)
(* does not work Notation "x < y /\ v < z" := (x < y /\ v < z) (at level 100, y at next level, no associativity): nat_scope.*)
Open Scope nat_scope.
Notation "x <= y /\ v <= z" := (x <= y /\ v <= z) (at level 100, y at next level, no associativity).
Notation "x <= y /\ v < z" := (x <= y /\ v < z) (at level 100, y at next level, no associativity).
Notation "x < y /\ v <= z" := (x < y /\ v <= z) (at level 100, y at next level, no associativity).
Notation "x < y /\ v < z" := (x < y /\ v < z) (at level 100, y at next level, no associativity).
Close Scope nat_scope.
Open Scope N_scope.
Notation "x <= y /\ v <= z" := (x <= y /\ v <= z) (at level 100, y at next level, no associativity).
Notation "x <= y /\ v < z" := (x <= y /\ v < z) (at level 100, y at next level, no associativity).
Notation "x < y /\ v <= z" := (x < y /\ v <= z) (at level 100, y at next level, no associativity).
Notation "x < y /\ v < z" := (x < y /\ v < z) (at level 100, y at next level, no associativity).
Close Scope N_scope.
Open Scope Z_scope.
Notation "x <= y /\ v <= z" := (x <= y /\ v <= z) (at level 100, y at next level, no associativity).
Notation "x <= y /\ v < z" := (x <= y /\ v < z) (at level 100, y at next level, no associativity).
Notation "x < y /\ v <= z" := (x < y /\ v <= z) (at level 100, y at next level, no associativity).
Notation "x < y /\ v < z" := (x < y /\ v < z) (at level 100, y at next level, no associativity).
Close Scope Z_scope.
Open Scope R_scope.
Notation "x <= y /\ v <= z" := (x <= y /\ v <= z) (at level 100, y at next level, no associativity).
Notation "x <= y /\ v < z" := (x <= y /\ v < z) (at level 100, y at next level, no associativity).
Notation "x < y /\ v <= z" := (x < y /\ v <= z) (at level 100, y at next level, no associativity).
Notation "x < y /\ v < z" := (x < y /\ v < z) (at level 100, y at next level, no associativity).
Close Scope R_scope.

(* no this does not work in all cases *)
(* Ltac all_e X Y := set (X:=Y); generalize X; clear X. *)

(* renaming overwriting used names is possible *)
Ltac hyp X := exact X. (*assumption.*)
Ltac neg_i := neg_ins.
Ltac neg_e' := neg_els.
Ltac all_e := all_e'.
(* Ltac imp_i X := let Y := fresh X in intro Y. *)
(* Ltac imp_i := fun X => intro X. *)

(* unchanged names *)
(*Ltac con_i := con_i.
Ltac con_e1 := con_e1.
Ltac con_e2 := con_e2.
Ltac dis_i1 := dis_i1.
Ltac dis_i2 := dis_i2.
Ltac dis_e := dis_e.
Ltac imp_i := imp_i.
Ltac imp_e := imp_e.
Ltac neg_e := neg_e.
Ltac all_i := all_i.
Ltac exi_i := exi_i.
Ltac exi_e := exi_e.*)

(* unused tactics *)
(*Ltac eqv_in := eqv_i.
Ltac eqv_ell := eqv_e1.
Ltac eqv_elr := eqv_e2.
Ltac negneg_in := negneg_i.
Ltac equ_in := equ_i.
Ltac equ_el := equ_e.
Ltac equ_els := equ_e'.*)

(* intervals *)
Definition in_cc (a b c : R) := (b <= a)%R /\ (a <= c)%R.
Definition in_co (a b c : R) := (b <= a)%R /\ (a < c)%R.
Definition in_oc (a b c : R) := (b < a)%R /\ (a <= c)%R.
Definition in_oo (a b c : R) := (b < a)%R /\ (a < c)%R.
(* Definition in_set (a b c : Z) := (b <= a)%Z /\ (a <= c)%Z. *)
Definition in_ccZ (a b c : Z) := (b <= a)%Z /\ (a <= c)%Z.
Definition in_coZ (a b c : Z) := (b <= a)%Z /\ (a < c)%Z.
Definition in_ocZ (a b c : Z) := (b < a)%Z /\ (a <= c)%Z.
Definition in_ooZ (a b c : Z) := (b < a)%Z /\ (a < c)%Z.

Notation "a 'in' [ b , c ]" := (in_cc a b c) (at level 70) : R_scope.
Notation "a 'in' [ b , c )" := (in_co a b c) (at level 70) : R_scope.
Notation "a 'in' ( b , c ]" := (in_oc a b c) (at level 70) : R_scope.
Notation "a 'in' ( b , c )" := (in_oo a b c) (at level 70) : R_scope.
(* Notation "a 'in' { b , , c }" := (in_set a b c) (at level 70) : Z_scope. *)
Notation "a 'in' [ b , c ]" := (in_ccZ a b c) (at level 70) : Z_scope.
Notation "a 'in' [ b , c )" := (in_coZ a b c) (at level 70) : Z_scope.
Notation "a 'in' ( b , c ]" := (in_ocZ a b c) (at level 70) : Z_scope.
Notation "a 'in' ( b , c )" := (in_ooZ a b c) (at level 70) : Z_scope.

(* Notation "'forall' a 'in' [ b , c ] , P" := (forall a:R, a in [b,c], P) (at level 70) : R_scope. *)

Ltac lin_solve := try fourier ; try (
match goal with 
  | |- ?LHS = ?RHS => change (@eq R (LHS : Z) (RHS : Z)) ; ring_simplify
  | |- lt ?LHS ?RHS => change (@lt R (LHS : Z) (RHS : Z)) ; ring_simplify
  | |- le ?LHS ?RHS => change (@le R (LHS : Z) (RHS : Z)) ; ring_simplify
  | |- gt ?LHS ?RHS => change (@gt R (LHS : Z) (RHS : Z)) ; ring_simplify
  | |- ge ?LHS ?RHS => change (@ge R (LHS : Z) (RHS : Z)) ; ring_simplify
  | |- neq ?LHS ?RHS => change (@neq R (LHS : Z) (RHS : Z)) ; ring_simplify
end
) ; try (
match goal with 
  | |- ?LHS = ?RHS => change (@eq R (LHS : R) (RHS : R)) ; field
  | |- lt ?LHS ?RHS => change (@lt R (LHS : R) (RHS : R)) ; field
  | |- le ?LHS ?RHS => change (@le R (LHS : R) (RHS : R)) ; field
  | |- gt ?LHS ?RHS => change (@gt R (LHS : R) (RHS : R)) ; field
  | |- ge ?LHS ?RHS => change (@ge R (LHS : R) (RHS : R)) ; field
  | |- neq ?LHS ?RHS => change (@neq R (LHS : R) (RHS : R)) ; field
end
) ; try reflexivity ; omega.
(* Ltac lin_solve := try fourier ; try ring_simplify ; reflexivity. *)
Ltac prove_inequality := fourier.
Ltac prove_equality := try ring_simplify ; reflexivity.
Ltac interval := try unfold in_cc ; try unfold in_co ; try unfold in_oc ; try unfold in_oo ; try unfold in_ccZ ; try unfold in_coZ ; try unfold in_ocZ ; unfold in_ooZ ;unfold in_ccZ.
(* Ltac interval := try unfold in_cc ; try unfold in_co ; try unfold in_oc ; try unfold in_oo ; try unfold in_set. (*try unfold in_oo ; [try unfold element ; simpl].*) *)

(* Infix "mod" := Rmod (at level 40, no associativity) : R_scope. *)


Open Scope R_scope.
