(* Exercise 65 *) 

Require Import BenB.

Variable D : Set.
Variables P Q S T : D -> Prop.
Variable R : D -> D -> Prop.

(* On a finite domain, existence implies a disjunction
   over different elements; this is less trivial *)

Hypothesis Domain : exists x1 : D, exists x2 : D, exists x3 : D,
  (forall x : D, (x = x1 \/ x = x2 \/ x = x3)) /\ 
  ~(x1 = x2) /\ ~(x1 = x3) /\ ~(x2 = x3).

Hypothesis P_holds : exists x : D, P x.

Theorem exercise_065 : exists x1 : D, exists x2 : D, exists x3 : D, (P x1 \/ P x2 \/ P x3) /\ ~(x1 = x2)
  /\ ~(x1 = x3) /\ ~(x2 = x3).
Proof.
(*! pred_proof *)
Qed.
