(* Exercise 78 *) 

Require Import BenB.

Variable D : Set.
Variables P Q S T : D -> Prop.
Variable R : D -> D -> Prop.

(* This theorem shows that if we have a transitive
   relation on a 3-element set, and if each element has
   a successor, then some element must be reflexive for
   this relation *)

Hypothesis Domain : exists x1 : D, exists x2 : D, exists x3 : D,
  forall x : D, (x = x1 \/ x = x2 \/ x = x3). 

Hypothesis Successor : forall x : D, exists y : D, R x y.

Hypothesis Transitive : forall x y z : D, ((R x y /\ R y z) -> R x z). 

Theorem exercise_078 : exists x : D, R x x.  
Proof.
(*! pred_proof *)
Qed.
