(* Exercise 79 *) 

Require Import BenB.

Variable D : Set.
Variables P Q S T : D -> Prop.
Variable R : D -> D -> Prop.

(* The following theorem shows that under the assumption
   that our domain has 3 elements, if a property holds
   for 3 different elements, it holds for all elements.
   Because the cases that have to be considered multiply,
   the proof takes almost 400 lines. This is a good 
   demonstration of how primitive first-order logic can be.
*)

Hypothesis Domain : exists x1 : D, exists x2 : D, exists x3 : D,
  forall x : D, (x = x1 \/ x = x2 \/ x = x3).

Theorem exercise_079 : (exists x : D, exists y : D, exists z: D, P x /\ P y /\ P z /\ ~(x = y) /\ ~(x = z) /\ ~(y = z)) -> forall x : D, P x.
Proof.
(*! pred_proof *)
Qed.
