definition module EncodeDecode

// provides the encoding and decoding of information between browser and the executable
// (c) 2005 - MJP

import StdMaybe
import GenParse, GenPrint
import iDataFormData

:: HtmlState  		:== (!Formid,!Lifespan,!StorageFormat,!SerializedState)
:: Formid			:== String		// uniquely named !
:: SerializedState 	:== String 		// not encoded !

// Triplet handling

:: Triplet			:== (String,Int,UpdValue)
:: TripletUpdate	:== (Triplet,String)
:: Triplets			:== [TripletUpdate]

:: UpdValue 													// the updates that can take place	
	= UpdI Int													// new integer value
	| UpdR Real													// new real value
	| UpdB Bool													// new boolean value
	| UpdC String												// choose indicated constructor 
	| UpdS String												// new piece of text

encodeTriplet		:: !Triplet -> String						// encoding of triplets
encodeString 		:: !String  -> String						// encoding of string 
urlEncode 			:: !String ->  String
urlDecode 			:: !String -> *String

// Form submission handling

callClean 					:: !(Script -> ElementEvents) !Mode !String -> [ElementEvents]
submitscript 				::  BodyTag
globalstateform 			:: !Value -> BodyTag

// serializing, de-serializing of iData states to strings stored in the html page

EncodeHtmlStates 			:: ![HtmlState] -> String
DecodeHtmlStatesAndUpdate 	:: (Maybe [(String, String)]) -> (![HtmlState],!Triplets) // hidden state stored in Client + triplets

// serializing, de-serializing of iData state stored in files

writeState		 			:: !String !String !*NWorld -> *NWorld 
readState				 	:: !String !*NWorld -> (!String,!*NWorld) 
deleteState 				:: !String !*NWorld -> *NWorld

// constants that maybe useful

traceHtmlInput				:: !(Maybe [(String, String)]) -> BodyTag					// for debugging showing the information received from browser
trace_to_file 				:: !String !*World -> *World											// for storing debug information to file


globalFormName	:== "CleanForm"		// name of hidden Html form in which iData state information is stored
updateInpName	:== "UD"			// marks update information
globalInpName	:== "GS"			// marks global state information
selectorInpName	:== "CS_"			// marks constructor update
