module PoorMansDataBase

import StdEnv, PMDB, GenEq

Start :: !*World -> *World
Start world
	# world = testUnsafeUpdate 1 [1..10] world
	  world = testWriteRead 1 [1..30000] world
	  world = testWriteRead 2 (strictArray {"Bla", "Die", "Daa"}) world
	  world = testWriteRead 3 "Compact" world
	  world = testKeepSharing 1 'a' 'B' 'c' world
	  world = testSharedUpdate 1 'a' 'B' world
	  world = testSharedUpdate 2 "Bladiebladiebla..." "Hello world!" world
	  world = testSharedUpdate 3 (strictArray {1}) {x \\ x <- [1..10000]} world
	  world = testSharedUpdate 4 (strictArray {"Bladiebladebla!!!!"}) {"Bladiebladiebla..." \\ x <- [1..1000]} world
	  world = testSharedUpdate 5 [1] [1..10000] world
	  world = testSharedUpdate 6 "Compact?" "Packit!" world
	= world
where
	strictArray :: {!a} -> {!a}
	strictArray x = x

testWriteRead :: !Int !a !*World -> *World | gEq{|*|}, pmdb{|*|} a
testWriteRead number u world
	# (c, db, world) = openPMDB filename world
	  db = updateChunk c u db
//	  (ok, db) = refreshChunk c db
	  ok = True
	  (x, db) = chunkValue c db
	  world = closePMDB db world
	  (c, db, world) = openPMDB filename world
	  (y, db) = chunkValue c db
	#!world = closePMDB db world
	| ok && x === u && y === u = world
	= abort ("test " +++ string +++ " of reading something written failed")
where
	string = toString number
	filename = "test" +++ string +++ "ReadWrite.txt"	

testSharedUpdate :: !Int !a !a !*World -> *World | gEq{|*|}, pmdb{|*|} a
testSharedUpdate number u1 u2 world
	# (c, db, world) = openPMDB filename world
	  (x, db) = chunk db
	  db = updateChunk c (x, x) db
	  db = updateChunk x u1 db
	  world = closePMDB db world
	  (c, db, world) = openPMDB filename world
	  ((c1, c2), db) = chunkValue c db
//	  (_, db) = refreshChunk c1 db
	  db = updateChunk c1 u2 db
//	  (ok, db) = refreshChunk c2 db
	  ok = True
	  (y, db) = chunkValue c2 db
	  world = closePMDB db world
	| ok && y === u2 = world
	= abort ("test " +++ string +++ " of shared update failed")
where
	string = toString number
	filename = "test" +++ string +++ "SharedUpdate.txt"	

testKeepSharing :: !Int !a !a !a !*World -> *World | gEq{|*|}, pmdb{|*|} a
testKeepSharing number u1 u2 u3 world
	# (c, db, world) = openPMDB filename world
	  (x, db) = chunk db
	  db = updateChunk x u1 db
	  db = updateChunk c (x, x) db
	  world = closePMDB db world
	  (c, db, world) = openPMDB filename world
	  ((c1, c2), db) = chunkValue c db
//	  (_, db) = refreshChunk c1 db
	  db = updateChunk c1 u2 db
//	  (ok, db) = refreshChunk c2 db
	  ok = True
	  db = updateChunk c1 u3 db
	  (y, db) = chunkValue c2 db
	#!world = closePMDB db world
	| ok && y === u3 = world
	= abort ("test " +++ string +++ " of keep sharing failed")
where
	string = toString number
	filename = "test" +++ string +++ "KeepSharing.txt"	

testUnsafeUpdate :: !Int !a !*World -> *World | gEq{|*|}, pmdb{|*|} a
testUnsafeUpdate number u1 world
	# (c, db, world) = openPMDB filename world
	  c` = id` c
	  db = updateChunk c` u1 db
	  (x, db) = chunkValue c db
	#!world = closePMDB db world
	| x === u1 = world
	= abort ("test " +++ string +++ " of unsafe update failed")
where
	string = toString number
	filename = "test" +++ string +++ "UnsafeUpdate.txt"	
	id` :: !(Chunk a) -> Chunk a
	id` x = x

derive pmdb (,), []
derive bimap (,), (,,,,), Maybe
