#   File:       aut.make
#   Target:     aut
#   Sources:    alloc.c
#               check.c
#               compile.c
#               domain.c
#               excerpt.c
#               exp.c
#               ident.c
#               item.c
#               main.c
#               par.c
#               parse.c
#               print.c
#               same.c
#               scan.c
#               type.c
#               value.c
#   Created:    Thursday, January 7, 1999 09:31:21 PM


MAKEFILE     = aut.make
MondoBuild = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified
Includes     =
SymPPC      = 
ObjDirPPC   =
Sym68K      = 
ObjDir68K   =

PPCCOptions  = {Includes} {SymPPC} -opt speed 

COptions     = {Includes} {Sym68K} -model far 

ObjectsPPC  = 
		"{ObjDirPPC}alloc.c.x" 
		"{ObjDirPPC}check.c.x" 
		"{ObjDirPPC}compile.c.x" 
		"{ObjDirPPC}domain.c.x" 
		"{ObjDirPPC}excerpt.c.x" 
		"{ObjDirPPC}exp.c.x" 
		"{ObjDirPPC}ident.c.x" 
		"{ObjDirPPC}item.c.x" 
		"{ObjDirPPC}main.c.x" 
		"{ObjDirPPC}par.c.x" 
		"{ObjDirPPC}parse.c.x" 
		"{ObjDirPPC}print.c.x" 
		"{ObjDirPPC}same.c.x" 
		"{ObjDirPPC}scan.c.x" 
		"{ObjDirPPC}type.c.x" 
		"{ObjDirPPC}value.c.x"

Objects68K  = 
		"{ObjDir68K}alloc.c.o" 
		"{ObjDir68K}check.c.o" 
		"{ObjDir68K}compile.c.o" 
		"{ObjDir68K}domain.c.o" 
		"{ObjDir68K}excerpt.c.o" 
		"{ObjDir68K}exp.c.o" 
		"{ObjDir68K}ident.c.o" 
		"{ObjDir68K}item.c.o" 
		"{ObjDir68K}main.c.o" 
		"{ObjDir68K}par.c.o" 
		"{ObjDir68K}parse.c.o" 
		"{ObjDir68K}print.c.o" 
		"{ObjDir68K}same.c.o" 
		"{ObjDir68K}scan.c.o" 
		"{ObjDir68K}type.c.o" 
		"{ObjDir68K}value.c.o"


aut  {MondoBuild} {ObjectsPPC}
	PPCLink 
		-o {Targ} {SymPPC} 
		{ObjectsPPC} 
		-t 'MPST' 
		-c 'MPS ' 
		"{SharedLibraries}InterfaceLib" 
		"{SharedLibraries}StdCLib" 
		"{SharedLibraries}MathLib" 
		"{PPCLibraries}StdCRuntime.o" 
		"{PPCLibraries}PPCCRuntime.o" 
		"{PPCLibraries}PPCToolLibs.o"


aut  {MondoBuild} {Objects68K}
	Link 
		-o {Targ} -d {Sym68K} 
		{Objects68K} 
		-t 'MPST' 
		-c 'MPS ' 
		-model far 
		"{Libraries}Stubs.o" 
		"{Libraries}MathLib.o" 
		#"{CLibraries}Complex.o" 
		"{CLibraries}StdCLib.o" 
		"{Libraries}MacRuntime.o" 
		"{Libraries}IntEnv.o" 
		"{Libraries}ToolLibs.o" 
		"{Libraries}Interface.o"


"{ObjDirPPC}alloc.c.x"  {MondoBuild} alloc.c
	{PPCC} alloc.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}check.c.x"  {MondoBuild} check.c
	{PPCC} check.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}compile.c.x"  {MondoBuild} compile.c
	{PPCC} compile.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}domain.c.x"  {MondoBuild} domain.c
	{PPCC} domain.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}excerpt.c.x"  {MondoBuild} excerpt.c
	{PPCC} excerpt.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}exp.c.x"  {MondoBuild} exp.c
	{PPCC} exp.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}ident.c.x"  {MondoBuild} ident.c
	{PPCC} ident.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}item.c.x"  {MondoBuild} item.c
	{PPCC} item.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}main.c.x"  {MondoBuild} main.c
	{PPCC} main.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}par.c.x"  {MondoBuild} par.c
	{PPCC} par.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}parse.c.x"  {MondoBuild} parse.c
	{PPCC} parse.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}print.c.x"  {MondoBuild} print.c
	{PPCC} print.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}same.c.x"  {MondoBuild} same.c
	{PPCC} same.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}scan.c.x"  {MondoBuild} scan.c
	{PPCC} scan.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}type.c.x"  {MondoBuild} type.c
	{PPCC} type.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}value.c.x"  {MondoBuild} value.c
	{PPCC} value.c -o {Targ} {PPCCOptions}


"{ObjDir68K}alloc.c.o"  {MondoBuild} alloc.c
	{C} alloc.c -o {Targ} {COptions}

"{ObjDir68K}check.c.o"  {MondoBuild} check.c
	{C} check.c -o {Targ} {COptions}

"{ObjDir68K}compile.c.o"  {MondoBuild} compile.c
	{C} compile.c -o {Targ} {COptions}

"{ObjDir68K}domain.c.o"  {MondoBuild} domain.c
	{C} domain.c -o {Targ} {COptions}

"{ObjDir68K}excerpt.c.o"  {MondoBuild} excerpt.c
	{C} excerpt.c -o {Targ} {COptions}

"{ObjDir68K}exp.c.o"  {MondoBuild} exp.c
	{C} exp.c -o {Targ} {COptions}

"{ObjDir68K}ident.c.o"  {MondoBuild} ident.c
	{C} ident.c -o {Targ} {COptions}

"{ObjDir68K}item.c.o"  {MondoBuild} item.c
	{C} item.c -o {Targ} {COptions}

"{ObjDir68K}main.c.o"  {MondoBuild} main.c
	{C} main.c -o {Targ} {COptions}

"{ObjDir68K}par.c.o"  {MondoBuild} par.c
	{C} par.c -o {Targ} {COptions}

"{ObjDir68K}parse.c.o"  {MondoBuild} parse.c
	{C} parse.c -o {Targ} {COptions}

"{ObjDir68K}print.c.o"  {MondoBuild} print.c
	{C} print.c -o {Targ} {COptions}

"{ObjDir68K}same.c.o"  {MondoBuild} same.c
	{C} same.c -o {Targ} {COptions}

"{ObjDir68K}scan.c.o"  {MondoBuild} scan.c
	{C} scan.c -o {Targ} {COptions}

"{ObjDir68K}type.c.o"  {MondoBuild} type.c
	{C} type.c -o {Targ} {COptions}

"{ObjDir68K}value.c.o"  {MondoBuild} value.c
	{C} value.c -o {Targ} {COptions}

