module APDU

open Data

let select_application =
  (SELECT_APPLICATION)

let get_processing_options pdol_items =
  (GET_PROCESSING_OPTIONS, pdol_items)

let read_record =
  (READ_RECORD)

let verify pin = 
  (VERIFY, pin)

let generate_ac t cda_requested d =
  (GENERATE_AC, (t, cda_requested, d))

let internal_authenticate nonce = 
  (INTERNAL_AUTHENTICATE, nonce)

let select_application_response =
  ()

let get_processing_options_response (sda, dda, cda) afl =
  ((sda, dda, cda), afl)

let read_record_response signature =
  signature

let internal_authenticate_response d signature =
  (d, signature)

let verify_response success =
  success

let generate_ac_response t atc ac s =
  (t, atc, ac, s)

let parse_select_application data =
  let (SELECT_APPLICATION) = data in
    ()

let parse_get_processing_options data =
  let (GET_PROCESSING_OPTIONS, pdol) = data in
    pdol

let parse_read_record data =
  let (READ_RECORD) = data in
    ()

let parse_internal_authenticate data =
  let (INTERNAL_AUTHENTICATE, nonce) = data in
    nonce

let parse_verify data =
  let (VERIFY, pin) = data in
    pin

let parse_generate_ac d =
 let (GENERATE_AC, (ac_type, cda_requested, d2)) = d in
    (ac_type, cda_requested, d2)

let parse_select_application_response d =
  d

let parse_get_processing_options_response d = 
  let ((sda, dda, cda), afl) = d in
  ((sda, dda, cda), afl)

let parse_read_record_response response =
  response

let parse_verify_response (response) =
  response

let parse_internal_authenticate_response response =
  response

let parse_generate_ac_response response =
  response

let get_command m =
  let (c, d) = m in
  c
