module APDU

open Data

val select_application: bytes
val get_processing_options: bytes -> bytes
val read_record: bytes
val internal_authenticate: bytes -> bytes
val verify: bytes -> bytes
val generate_ac: ac_type -> bool -> bytes -> bytes

val select_application_response: bytes
val get_processing_options_response: (bool * bool * bool) -> bytes -> bytes
val read_record_response: bytes -> bytes
val internal_authenticate_response: bytes -> bytes -> bytes
val verify_response: bool -> bytes
val generate_ac_response: ac_type -> bytes -> bytes -> bytes -> bytes

val parse_select_application: bytes -> unit
val parse_get_processing_options: bytes -> unit
val parse_read_record: bytes -> unit
val parse_internal_authenticate: bytes -> bytes
val parse_verify: bytes -> bytes
val parse_generate_ac: bytes -> (ac_type * bool * bytes)

val parse_select_application_response: bytes -> bytes
val parse_get_processing_options_response: bytes -> ((bool * bool * bool) * bytes)
val parse_read_record_response: bytes -> bytes
val parse_internal_authenticate_response: bytes -> (bytes * bytes)
val parse_verify_response: bytes -> bool
val parse_generate_ac_response: bytes -> (ac_type * bytes * bytes * bytes)

val get_command: bytes -> command
