module Crypto

open Data

type key = K of Data.key

let sha1 b = (hash (b))

let freshbytes s = Pi.name s
let mkNonce () = freshbytes "nonce"

let symkeyToBytes k = keyToBytes k

let symkey b = keyFromBytes (b)
let rsaKeyToBytes k = keyToBytes k

let rsaKeyFromBytes b = keyFromBytes (b)

let hmac_keygen () = mkSymKey()
let hmacsha1 k b = mac k (b)

let hmacsha1_verify k b m =
  if hmacsha1 k b = m then () else failwith "HMAC-SHA1 verificaiton failed!"

let aes_keygen () = mkSymKey()
let aes_encrypt k b = sym_encrypt k (b)
let aes_decrypt k b = sym_decrypt k (b)

let rsa_keygen () = mkPrivateKey()
let rsa_pub k = publicKey k

let rsa_encrypt k b = asym_encrypt k (b)
let rsa_decrypt k b = asym_decrypt k (b)

let rsa_sign k b = sign k (b)

let rsa_verify k b sv = verify k (b) (sv)

let rsa_verify_no_fail k b sv = verify_no_fail k (b) (sv)

let mkNonceN (n: int) = (mkNonce ())

