module Data

type bytes
type str

type ac_type =
| ARQC
| AAC
| TC

type command =
| SELECT_APPLICATION
| GET_PROCESSING_OPTIONS
| READ_RECORD
| INTERNAL_AUTHENTICATE
| VERIFY
| GENERATE_AC

val utf8: str -> bytes    (* Encode strings as UTF8 bytestrings *) 
val iutf8: bytes -> str   (* Decode UTF8-encoded bytestrings *)

val base64: bytes -> str  (* Encode bytestrings as BASE64 strings *)
val ibase64: str -> bytes (* Decode BASE64-encoded strings *)

val concat: bytes -> bytes -> bytes (* Concatenate two bytestrings, invertibly *)
val iconcat: bytes -> (bytes * bytes) (* Extract components of concatenation *)

val equals: bytes -> bytes -> bool (* Byte array equality *)


(* The following should only be used by concrete code *)

val str: string -> str
val istr: str -> string

val bytes: byte[] -> bytes
val ibytes: bytes -> byte[]

val fpstr: out_channel -> str -> unit 
val fpbytes: out_channel -> bytes -> unit 
val size_str: str -> int
val size_bytes: bytes -> int

(* The following should only be used by symbolic models *)

type key
val random: unit -> bytes
val mkSymKey: unit -> key
val mkPrivateKey: unit -> key
val publicKey: key -> key
val keyFromBytes: bytes -> key
val keyToBytes: key -> bytes

val hash: bytes -> bytes
val mac: key -> bytes -> bytes
val sym_encrypt: key -> bytes -> bytes
val sym_decrypt: key -> bytes -> bytes

val sign: key -> bytes -> bytes
val verify: key -> bytes -> bytes -> unit
val asym_encrypt: key -> bytes -> bytes 
val asym_decrypt: key -> bytes -> bytes 

val verify_no_fail: key -> bytes -> bytes -> bool
val not: bool -> bool
