/*
 * Decompiled with CFR 0.152.
 */
package sos.smartcards.firewallhost;

import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import sos.smartcards.firewallhost.TestSuite;

public class FirewallHost {
    public static final byte[] fclient = "fclient.app1".getBytes();
    public static final byte[] fserver = "fserver.app".getBytes();
    public static final byte[] fserverms = "fserverms.app".getBytes();

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("   java sos.smartcards.firewallhost.FirewallHost [ -jc21 | -reset ]");
        System.out.println("");
        System.out.println("   -jc21   indicates that the test card is only Java Card 2.1.*");
        System.out.println("   -reset  resets inter-applet dependencies on the card for applet removal");
        System.out.println();
        System.exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].equals("-jc21")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-reset")) {
                    bl3 = true;
                    continue;
                }
                FirewallHost.usage();
            }
        }
        try {
            Object object;
            TerminalFactory terminalFactory = TerminalFactory.getInstance("PC/SC", null);
            CardChannel cardChannel = null;
            CardTerminals cardTerminals = terminalFactory.terminals();
            Card card = null;
            boolean bl4 = false;
            while (!bl4) {
                for (CardTerminal object2 : cardTerminals.list(CardTerminals.State.CARD_PRESENT)) {
                    try {
                        card = object2.connect("*");
                        card.beginExclusive();
                        ATR cardException = card.getATR();
                        cardChannel = card.getBasicChannel();
                        bl4 = true;
                    }
                    catch (CardException cardException) {
                        System.out.println("Couldn't esatablish the connection.");
                        cardException.printStackTrace();
                    }
                }
                if (bl4) continue;
                System.out.println("Waiting for a card...");
                cardTerminals.waitForChange(0L);
            }
            if (bl3) {
                object = new byte[][]{fclient, fserver, fserverms};
                CommandAPDU exception = new CommandAPDU(new byte[]{0, -86, 0, 0, 0});
                bl3 = false;
                for (Object object2 : object) {
                    try {
                        FirewallHost.selectAID(cardChannel, (byte[])object2);
                        int cardException = cardChannel.transmit(exception).getSW();
                        if (cardException != 36864) continue;
                        bl3 = true;
                        break;
                    }
                    catch (CardException cardException) {
                        // empty catch block
                    }
                }
                if (bl3) {
                    System.out.println("References reset successfully, you can remove the applets.");
                } else {
                    System.out.println("Could not reset references...");
                }
            } else {
                object = new TestSuite();
                try {
                    FirewallHost.selectAID(cardChannel, fclient);
                    ((TestSuite)object).runTests(card, cardChannel, fserver, fserverms, bl2);
                    System.out.println("Tests finished.");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception);
        }
    }

    public static byte[] selectAID(CardChannel cardChannel, byte[] byArray) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 4, 0, byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Could not select applet " + FirewallHost.byteArrayToString(byArray));
        }
        return responseAPDU.getBytes();
    }

    public static String byteArrayToString(byte[] byArray) {
        String string = "";
        String string2 = null;
        for (int i = 0; i < byArray.length; ++i) {
            string2 = Integer.toHexString(byArray[i]);
            string2 = string2.length() == 1 ? "0" + string2 : string2.substring(string2.length() - 2);
            string = string + string2.toUpperCase() + " ";
        }
        return string;
    }
}

