
public class BankAccount {

 private /*@ non_null @*/ Person owner;
 
 protected int creditLimit;
 //@ invariant creditLimit >= 0;

 protected int balance;
 //@ invariant balance >= -creditLimit;

 public /*@ pure @*/ int getBalance(){
  return balance;
 }

 public/*@ pure @*/  int getCreditLimit(){
  return creditLimit;
 }

 //@ requires (* user is authorised *);
 public /*@ pure @*/ void setCreditLimit(int newCreditLimit){
  creditLimit = newCreditLimit;
 }

}
