
public class Person {

    private /*@ spec_public non_null @*/ String name;
    //@ invariant !name.equals("");

    private /*@ spec_public @*/ int creditLimit;
    //@ invariant creditLimit >= 0;

    /*@   requires n != null && !n.equals("");  // Failures when omitted
      @   ensures n.equals(name) && creditLimit == 0;
      @*/
    public Person(String n) {
      name = n; 
      creditLimit = 0;
      accounts = new BankAccount[0];
    }

    //@  requires extra_credit > -creditLimit;
    public void increaseCreditLimit(int extra_credit) { 
      creditLimit += extra_credit;
    }

   public /*@ pure @*/ int getCreditLimit() { return creditLimit; }

    
   public /*@ pure non_null @*/ String toString() {
      return "Person(\"" + name + "\"," + creditLimit + ")";
   }

   private /*@ spec_public non_null @*/ BankAccount[] accounts;
   /*@ invariant (\forall int i; 0 <= i & i < accounts.length;
     @                           accounts[i] != null);
     @*/

   /*@ invariant (\sum int i; 0 <= i & i < accounts.length;
     @                        accounts[i].creditLimit) <= creditLimit;
     @*/
}
