;;; Proof of the Irrationality of the Square Root of a Non Perfect Square
;;;
;;; William M. Farmer
;;; 4-JAN-2002
;;;
;;; Outline of proof:
;;;
;;;   1. The notion of the "divisor power" of d in n is defined for
;;;      natural numbers d and n.  divisor%power(d,n) denotes the
;;;      greatest m such that d^m divides n (provided such an m
;;;      exists).
;;;
;;;   2. Some lemmas about divisor%power are proved.
;;;
;;;   3. The notion of a "non perfect square" is defined as a natural
;;;      number k for which there is a prime p such divisor%power(p,k)
;;;      is odd.
;;;
;;;   4. The main theorem, that the square root of a non perfect
;;;      square is irrational, is then proved as follows.  Let k be a
;;;      natural number for which there is a prime p such
;;;      divisor%power(p,k) is odd.  Assume that sqrt(k) is rational.
;;;      Then, for some natural numbers m and n, k*n*n = m*m.  It
;;;      follows that divisor%power(p,k*n*n) is odd and
;;;      divisor%power(p,m*m) is even, which is a contradiction.
;;;
;;;   5. The irrationality of the square root of 2 is proved as a
;;;      corollary of the main theorem.


(include-files
 (files (imps theories/reals/mutual-interp)
	(imps theories/reals/primes)
	(imps theories/reals/polynomials)))

(def-constant divisor%power
  "lambda(d,n:nn, 
     iota(m:nn, forsome(w:nn, n = d^m * w and not(d divides w))))"
  (theory h-o-real-arithmetic))

(def-theorem ho-exponent-non-zero-lemma-1
  exponent-non-zero-lemma-1
  ;; "forall(n:zz,x:rr, not(x=0) implies not(x^n = 0))"
  (theory  h-o-real-arithmetic)
  (translation complete-ordered-field-interpretable)
  (proof existing-theorem))

(def-theorem divisor%power-of-d-in-0-is-undefined
  "forall(d:nn, not(#(divisor%power(d,0))))"
  (theory h-o-real-arithmetic)
  (proof
   (

    direct-inference
    (unfold-single-defined-constant (0) divisor%power)
    simplify
    (apply-macete-with-minor-premises eliminate-iota-macete)
    (cut-with-single-formula "0=d or 0<d")
    (block 
     (script-comment "`cut-with-single-formula' at (0)")
     (contrapose "with(p:prop,p);") 
     (antecedent-inference-strategy (0))
     (contrapose "with(p:prop,forall(j:nn,p));") 
     (instantiate-existential ("i+1"))
     (block 
      (script-comment "`instantiate-existential' at (0 0)")
      (instantiate-existential ("w"))
      (antecedent-inference "with(p:prop,p implies p);") 
      simplify
      (block 
       (script-comment "`antecedent-inference' at (1)")
       (apply-macete-with-minor-premises sum-of-exponents-law)
       (block 
	(script-comment "`apply-macete-with-minor-premises' at (0)")
        (force-substitution "w*(d^i*d^1)" "(w*d^i)*d^1" (0))
        (block 
	 (script-comment "`force-substitution' at (0)")
	 (backchain-backwards "with(r:rr,0=r);") 
	 simplify
	 )
        (apply-macete-with-minor-premises
	 associative-law-for-multiplication-pre-reals
	 ) )
       simplify
       ) )
     simplify
     )
    simplify

    )))

(def-theorem divisor%power-characterization-lemma
  "forall(b,d,m,n,w1,w2:nn,
     b < m and not(d = 0) and n=d^b*w1 and n=d^m*w2 and not(d divides w1) 
      implies 
     b=m)"
  (theory  h-o-real-arithmetic)
  (proof
   (

    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "d^b*w1 = d^m*w2")
    (cut-with-single-formula "not(d^b = 0)")
    (block 
     (script-comment "`cut-with-single-formula' at (0)")
     (contrapose "with(w2,w1:nn,r:rr,r*w1=r*w2);")
     (force-substitution 
      "d^b*w1=d^m*w2" "((d^b)^[-1]*d^b)*w1=((d^b)^[-1]*d^m)*w2"
      (0)
      )
     (block 
      (script-comment "`force-substitution' at (0)") 
      simplify
      (contrapose "with(w1,d:nn,not(d divides w1));")
      (apply-macete-with-minor-premises divisibility-lemma)
      (instantiate-existential ("w2*d^(m-b-1)")) 
      simplify
      (block 
       (script-comment "`instantiate-existential' at (1 0)")
       (apply-macete-with-minor-premises zz-*-closed)
       (cut-with-single-formula "0=[-1]+[-1]*b+m or 0<[-1]+[-1]*b+m")
       (block 
	(script-comment "`cut-with-single-formula' at (0)")
        (antecedent-inference "with(p:prop,p or p);") 
	simplify
        (block 
	 (script-comment "`antecedent-inference' at (1)")
	 (apply-macete-with-minor-premises 
	  integer-exponentiation-definedness)
	 simplify
	 ) )
       simplify
       ) )
     (block 
      (script-comment "`force-substitution' at (1)") 
      direct-inference
      (force-substitution "(d^b)^[-1]*d^b*w1=(d^b)^[-1]*d^m*w2"
			  "(d^b)^[-1]*(d^b*w1)=(d^b)^[-1]*(d^m*w2)" (0)
			  )
      (block 
       (script-comment "`force-substitution' at (0)")
       (backchain "with(w2,w1:nn,r:rr,r*w1=r*w2);") 
       simplify
       )
      (block 
       (script-comment "`force-substitution' at (1)")
       (weaken (7 6 5 4 3 2 1 0))
       (apply-macete-with-minor-premises
        associative-law-for-multiplication-pre-reals
	) ) ) )
    (apply-macete-with-minor-premises ho-exponent-non-zero-lemma-1)

    )))

(def-theorem divisor%power-characterization
  "forall(d,n,m:nn, 
     not(d = 0)
      implies
     (m = divisor%power(d,n) 
       iff 
      forsome(w:nn, n = d^m * w and not(d divides w))))"
  reverse
  (theory h-o-real-arithmetic)
  (proof
   (

    (unfold-single-defined-constant (0) divisor%power)
    (apply-macete-with-minor-premises eliminate-iota-macete)
    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "b<m or b=m or b>m")
    (block 
     (script-comment "`cut-with-single-formula' at (0)")
     (antecedent-inference "with(p:prop,p or p or p);")
     (block 
      (script-comment "`antecedent-inference' at (0)")
      (apply-macete-with-minor-premises 
       divisor%power-characterization-lemma)
      auto-instantiate-existential
      )
     (block 
      (script-comment "`antecedent-inference' at (2)")
      (force-substitution "b=m" "m=b" (0))
      (block 
       (script-comment "`force-substitution' at (0)")
       (apply-macete-with-minor-premises 
	divisor%power-characterization-lemma)
       auto-instantiate-existential 
       (incorporate-antecedent "with(m,b:nn,b>m);")
       (unfold-single-defined-constant (0) >)
       )
      simplify
      ) )
    simplify

    )))

(def-theorem divisor%power-is-almost-total-aux
  "forall(d:nn, 
     2<=d
      implies 
     forall(n:zz, 1<=n implies lambda(n1:zz, #(divisor%power(d,n1)))(n)))"
  (theory h-o-real-arithmetic)
  (proof
   (

    (apply-macete-with-minor-premises complete-induction-schema)
    simplify
    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "d divides m or not(d divides m)")
    (block 
     (script-comment "`cut-with-single-formula' at (0)")
     (antecedent-inference "with(p:prop,p or p);")
     (block 
      (script-comment "`antecedent-inference' at (0)")
      (incorporate-antecedent "with(m:zz,d:nn,d divides m);")
      (apply-macete-with-minor-premises divisibility-lemma)
      direct-and-antecedent-inference-strategy 
      (backchain "with(r:rr,m:zz,m=r);")
      (cut-with-single-formula "1<=k and k<m")
      (block 
       (script-comment "`cut-with-single-formula' at (0)")
       (instantiate-universal-antecedent "with(p:prop,forall(k:zz,p));" ("k"))
       (incorporate-antecedent "with(n:nn,#(n));")
       (force-substitution "#(divisor%power(d,k))"
			   "forsome(m1:nn, m1=divisor%power(d,k))" (0)
			   )
       (block 
	(script-comment "`force-substitution' at (0)")
        (force-substitution "#(divisor%power(d,k*d))"
			    "forsome(m2:nn, m2=divisor%power(d,k*d))" (0)
			    )
        (block 
	 (script-comment "`force-substitution' at (0)")
	 (apply-macete-with-minor-premises divisor%power-characterization)
	 direct-and-antecedent-inference-strategy
	 (instantiate-existential ("m1+1")) 
	 auto-instantiate-existential
	 (backchain "with(w,m1,d:nn,k:zz,k=d^m1*w);")
	 (force-substitution "d^m1*w*d" "d^m1*d*w" (0)) 
	 simplify
	 (block 
	  (script-comment "`force-substitution' at (1)")
	  (force-substitution "d^m1*w*d" "d^m1*(w*d)" (0))
	  (block 
	   (script-comment "`force-substitution' at (0)")
	   (apply-macete-locally-with-minor-premises
	    commutative-law-for-multiplication-pre-reals (0) "w*d"
	    )
	   (apply-macete-with-minor-premises
	    associative-law-for-multiplication-pre-reals
            ) )
	  (apply-macete-with-minor-premises
	   associative-law-for-multiplication-pre-reals
	   ) ) )
        simplify
	)
       simplify
       )
      (block 
       (script-comment "`cut-with-single-formula' at (1)") 
       direct-inference
       (block 
	(script-comment "`direct-inference' at (0)")
        (cut-with-single-formula "0<k or 0=k or k<0")
        (block 
	 (script-comment "`cut-with-single-formula' at (0)")
	 (antecedent-inference "with(p:prop,p or p or p);") 
	 simplify
	 (block 
	  (script-comment "`antecedent-inference' at (1)")
	  (contrapose "with(d:nn,k,m:zz,m=k*d);") 
	  simplify
          )
	 (block 
	  (script-comment "`antecedent-inference' at (2)")
	  (cut-with-single-formula "k*d<0")
	  (block 
	   (script-comment "`cut-with-single-formula' at (0)")
	   (contrapose "with(r:rr,m:zz,m=r);") 
	   simplify
	   )
	  (block 
	   (script-comment "`cut-with-single-formula' at (1)")
	   (force-substitution "k*d" "d*k" (0))
	   (block 
	    (script-comment "`force-substitution' at (0)")
	    (apply-macete-with-minor-premises
	     strict-negativity-for-products
	     )
	    simplify
	    )
	   simplify
	   ) ) )
        simplify
	)
       (block 
	(script-comment "`direct-inference' at (1)")
        (backchain "with(r:rr,m:zz,m=r);") 
	(force-substitution "k*d" "d*k" (0))
        simplify 
	simplify
	) ) )
     (block 
      (script-comment "`antecedent-inference' at (1 1 (1 . 0))")
      (force-substitution "#(divisor%power(d,m))"
			  "forsome(m1:nn, m1=divisor%power(d,m))" (0)
			  )
      (block 
       (script-comment "`force-substitution' at (0)")
       (apply-macete-with-minor-premises divisor%power-characterization)
       (instantiate-existential ("0")) 
       (instantiate-existential ("m")) 
       simplify
       )
      (block 
       (script-comment "`force-substitution' at nil") 
       (weaken (3 2 1 0)) 
       simplify
       ) ) )
    simplify

    )))


(def-theorem divisor%power-is-almost-total
  "forall(d,n:nn, 2 <= d and 1 <= n implies #(divisor%power(d,n)))"
  (theory h-o-real-arithmetic)
  (proof
   (

    direct-and-antecedent-inference-strategy
    (instantiate-theorem divisor%power-is-almost-total-aux ("d"))
    (incorporate-antecedent "with(p:prop,forall(n:zz,p));")
    simplify

    )))

(def-theorem divisor%power-sum-law
  "forall(p,a,b:nn, 
     positive%prime(p) and 1 <= a and 1 <= b
      implies
     divisor%power(p,a*b) = divisor%power(p,a) + divisor%power(p,b))"
  (theory h-o-real-arithmetic)
  (proof
   (

    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "2<=p")
    (block 
     (script-comment "`cut-with-single-formula' at (0)")
     (cut-with-single-formula 
      "#(divisor%power(p,a)) and #(divisor%power(p,b))")
     (block 
      (script-comment "`cut-with-single-formula' at (0)")
      (antecedent-inference "with(p:prop,p and p);")
      (cut-with-single-formula
       "forsome(m1:nn,m1=divisor%power(p,a)) and 
        forsome(m2:nn,m2=divisor%power(p,b))"
       )
      (block 
       (script-comment "`cut-with-single-formula' at (0)")
       (antecedent-inference-strategy (0))
       (backchain-backwards "with(a,p,m1:nn,m1=divisor%power(p,a));")
       (backchain-backwards "with(b,p,m2:nn,m2=divisor%power(p,b));")
       (incorporate-antecedent "with(a,p,m1:nn,m1=divisor%power(p,a));")
       (incorporate-antecedent "with(n,m2:nn,m2=n);")
       (apply-macete-with-minor-premises divisor%power-characterization)
       direct-and-antecedent-inference-strategy
       (cut-with-single-formula "a*b=p^(m1+m2)*w*w_$0")
       (block 
	(script-comment "`cut-with-single-formula' at (0)")
        (cut-with-single-formula "not(p divides w*w_$0)")
        (block 
	 (script-comment "`cut-with-single-formula' at (0)")
	 (cut-with-single-formula
	  "forsome(w:nn, a*b = p^(m1+m2) * w and not(p divides w))"
          )
	 (block 
	  (script-comment "`cut-with-single-formula' at (0)")
	  (incorporate-antecedent "with(p:prop,forsome(w:nn,p));")
	  (apply-macete-with-minor-premises
	   rev%divisor%power-characterization
	   )
	  direct-inference
          )
	 (block 
	  (script-comment "`cut-with-single-formula' at (1)")
	  (instantiate-existential ("w*w_$0")) 
	  simplify
	  ) )
        (instantiate-theorem prime-divisor-of-a-product ("p" "w" "w_$0"))
	)
       (block 
	(script-comment "`cut-with-single-formula' at (1)")
        (backchain "with(w_$0,m2,p,b:nn,b=p^m2*w_$0);")
        (backchain "with(w,m1,p,a:nn,a=p^m1*w);")
        (force-substitution "p^m1*w*(p^m2*w_$0)" "p^m1*(p^m2*w)*w_$0" (0))
        simplify
        (block 
	 (script-comment "`force-substitution' at (1)")
	 (apply-macete-locally-with-minor-premises
	  commutative-law-for-multiplication-pre-reals (0) "p^m2*w"
          )
	 (apply-macete-with-minor-premises
	  associative-law-for-multiplication-pre-reals
          )
	 (apply-macete-with-minor-premises
	  associative-law-for-multiplication-pre-reals
	  ) ) ) )
      simplify
      )
     (block 
      (script-comment "`cut-with-single-formula' at (1)")
      (apply-macete-with-minor-premises divisor%power-is-almost-total) 
      simplify
      ) )
    (block 
     (script-comment "`cut-with-single-formula' at (1)")
     (incorporate-antecedent "with(p:nn,positive%prime(p));")
     (unfold-single-defined-constant (0) positive%prime)
     direct-and-antecedent-inference-strategy 
     simplify
     )

    )))

(def-constant non%perfect%square
  "lambda(k:nn,
     forsome(p:nn, positive%prime(p) and odd(divisor%power(p,k))))"
  (theory h-o-real-arithmetic))

(def-theorem non-perfect-squares-are-positive
  "forall(k:nn, non%perfect%square(k) implies 1 <= k)"
  (theory h-o-real-arithmetic)
  (proof
   (

    (unfold-single-defined-constant (0) non%perfect%square)
    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "#(divisor%power(p,k))")
    (cut-with-single-formula "0=k or 0<k")
    (block 
     (script-comment "`cut-with-single-formula' at (0)")
     (antecedent-inference "with(p:prop,p or p);")
     (block 
      (script-comment "`antecedent-inference' at (0)")
      (contrapose "with(n:nn,#(n));") 
      (backchain-backwards "with(k:nn,0=k);")
      (apply-macete-with-minor-premises 
       divisor%power-of-d-in-0-is-undefined)
      )
     simplify
     )
    simplify

    )))

(def-theorem sqrt-positive-is-positive
  "forall(x:rr, 0 < x implies 0 < sqrt(x))"
  (theory h-o-real-arithmetic)
  (proof
   (

    (force-substitution "sqrt(x)" "nth%root(2,x)" (0))
    (block 
     (script-comment "`force-substitution' at (0)")
     (apply-macete-with-minor-premises nth%root-positive-for-positive) 
     simplify
     )
    (block 
     (script-comment "`force-substitution' at (1)") 
     unfold-defined-constants
     simplify
     )

    )))

(def-theorem square-of-inequality-of-nonnegatives
  "forall(x,y:rr, 0 <= x and 0 <= y implies x <= y iff x^2 <= y^2)"
  (theory h-o-real-arithmetic)
  (proof
   (

    (force-substitution "x^2<=y^2" "(x-y)*(x+y)<=0" (0))
    (block 
     (script-comment "`force-substitution' at (0)")
     direct-and-antecedent-inference-strategy
     (block
      (script-comment 
       "`direct-and-antecedent-inference-strategy' at (0 0 0 0)")
      (apply-macete-with-minor-premises bifurcate-product-<=-inequality) 
      simplify
      )
     (block
      (script-comment 
       "`direct-and-antecedent-inference-strategy' at (0 0 1 0)")
      (contrapose "with(r:rr,r<=0);") 
      simplify
      ) )
    simplify

    )))

(def-theorem square-of-equation-of-nonnegatives
  "forall(x,y:rr, 0 <= x and 0 <= y implies x = y iff x^2 = y^2)"
  (theory h-o-real-arithmetic)
  (proof
   (

    (force-substitution "x=y iff x^2=y^2"
			"(x<=y and y<=x) iff (x^2<=y^2 and y^2<=x^2)" (0)
			)
    (block 
     (script-comment "`force-substitution' at (0)")
     (apply-macete-locally square-of-inequality-of-nonnegatives (0) "x<=y")
     (apply-macete-locally square-of-inequality-of-nonnegatives (0) "y<=x")
     )
    (prove-by-logic-and-simplification 0)

    )))

(def-theorem square-of-sqrt-positive
  "forall(x:rr, 0 < x implies sqrt(x)^2 = x)"
  (theory h-o-real-arithmetic)
  (proof
   (

    direct-and-antecedent-inference-strategy
    (instantiate-theorem sqrt-positive-is-positive ("x"))
    (incorporate-antecedent "with(x:rr,0<sqrt(x));")
    (unfold-single-defined-constant-globally sqrt)
    direct-inference
    (eliminate-defined-iota-expression 0 w)
    (force-substitution "x" "w*w" (0))
    (weaken (3 2 1 0))
    simplify

    )))

(def-theorem sqrt-nps-is-irrational-lemma-1
  "forall(a,b,c:nn, odd(a) implies not(a + 2*b = 2*c))"
  (theory h-o-real-arithmetic)
  (proof
   (

    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "odd(a +2*b)")
    (block 
     (script-comment "`cut-with-single-formula' at (0)")
     (cut-with-single-formula "even(2*c)")
     (block 
      (script-comment "`cut-with-single-formula' at (0)")
      (instantiate-theorem even-and-odd-natural-numbers-are-disjoint ("a+2*b"))
      (contrapose "with(p:prop,not(p));") 
      (backchain "with(r:rr,r=r);")
      )
     (block 
      (script-comment "`cut-with-single-formula' at (1)")
      (unfold-single-defined-constant (0) even) 
      (instantiate-existential ("c"))
      ) )
    (block 
     (script-comment "`cut-with-single-formula' at (1)")
     (incorporate-antecedent "with(p:prop,p);")
     (unfold-single-defined-constant-globally odd)
     direct-and-antecedent-inference-strategy 
     (instantiate-existential ("j+b"))
     (backchain "with(p:prop,p);") 
     simplify
     )

    )))

(def-theorem sqrt-nps-is-irrational-lemma-2
  "forall(n:nn, 1 <= n implies 1 <= n^2)"
  (theory h-o-real-arithmetic)
  (proof
   (

    direct-and-antecedent-inference-strategy
    (force-substitution "1<=n^2" "0<=(n-1)*(n+1)" (0))
    simplify
    simplify

    )))

(def-theorem sqrt-nps-is-irrational-lemma-3
  "forall(p,k,m,n:nn, 
     1<=k and 1<=m and 1<=n and positive%prime(p) and odd(divisor%power(p,k))
      implies
     not(divisor%power(p,k*n^2)=divisor%power(p,m^2)))"
  (theory h-o-real-arithmetic)
  (proof
   (

    direct-and-antecedent-inference-strategy
    (apply-macete-with-minor-premises divisor%power-sum-law)
    (block 
     (script-comment "`apply-macete-with-minor-premises' at (0)")
     (force-substitution "n^2" "n*n" (0))
     (block 
      (script-comment "`force-substitution' at (0)")
      (force-substitution "m^2" "m*m" (0))
      (block 
       (script-comment "`force-substitution' at (0)")
       (apply-macete-with-minor-premises divisor%power-sum-law) 
       simplify
       (apply-macete-with-minor-premises sqrt-nps-is-irrational-lemma-1)
       (block 
	(script-comment "`apply-macete-with-minor-premises' at (1)")
        (apply-macete-with-minor-premises divisor%power-is-almost-total)
        simplify
        (apply-macete-with-minor-premises divisor%power-is-almost-total)
        simplify (incorporate-antecedent "with(p:nn,positive%prime(p));")
        (unfold-single-defined-constant (0) positive%prime) 
	simplify
	)
       (block 
	(script-comment "`apply-macete-with-minor-premises' at (2)")
        (apply-macete-with-minor-premises divisor%power-is-almost-total)
        simplify
	) )
      simplify
      )
     simplify
     )
    (apply-macete-with-minor-premises sqrt-nps-is-irrational-lemma-2)

    )))

;;; The Main Theorem: The square root of a non perfect square is
;;; irrational.

(def-theorem sqrt-nps-is-irrational
  "forall(k:nn, non%perfect%square(k) implies not(#(sqrt(k),qq)))"
  (theory h-o-real-arithmetic)
  (proof
   (

    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "1<=k")
    (block 
     (script-comment "`cut-with-single-formula' at (0)")
     (incorporate-antecedent "with(k:nn,non%perfect%square(k));")
     (unfold-single-defined-constant (0) non%perfect%square)
     direct-and-antecedent-inference-strategy 
     (cut-with-single-formula "2<=p")
     (block 
      (script-comment "`cut-with-single-formula' at (0)")
      (instantiate-theorem sqrt-positive-is-positive ("k"))
      (block 
       (script-comment "`instantiate-theorem' at (0 0)")
       (contrapose "with(p:prop,not(p));") 
       simplify
       )
      (block 
       (script-comment "`instantiate-theorem' at (0 1)")
       (cut-with-single-formula "0=0") 
       (contrapose "0=0;")
       (instantiate-theorem positive-rational-characterization ("sqrt(k)"))
       (contrapose "with(r:rr,r=r);")
       (apply-macete-with-minor-premises square-of-equation-of-nonnegatives)
       (block 
	(script-comment "`apply-macete-with-minor-premises' at (0)")
        (apply-macete-with-minor-premises square-of-sqrt-positive)
        (apply-macete-with-minor-premises exponents-of-fractions)
        (apply-macete-with-minor-premises
	 right-denominator-removal-for-equalities
	 )
        (contrapose "0=0;") 
	(antecedent-inference "with(p:prop,p and p);")
        (cut-with-single-formula "divisor%power(p,k*n^2)=divisor%power(p,m^2)")
        (block 
	 (script-comment "`cut-with-single-formula' at (0)")
	 (contrapose "with(r:rr,p:nn,divisor%power(p,r)=divisor%power(p,r));")
	 (apply-macete-with-minor-premises sqrt-nps-is-irrational-lemma-3)
	 direct-and-antecedent-inference-strategy 
	 simplify 
	 simplify
	 )
        (block 
	 (script-comment "`cut-with-single-formula' at (1)")
	 (backchain "with(r:rr,r=r);") 
	 simplify
	 (apply-macete-with-minor-premises divisor%power-is-almost-total)
	 (block 
	  (script-comment "`apply-macete-with-minor-premises' at (0)")
	  simplify
	  (apply-macete-with-minor-premises sqrt-nps-is-irrational-lemma-2)
	  simplify
          )
	 simplify
	 ) )
       (block 
	(script-comment "`apply-macete-with-minor-premises' at (1)")
        (weaken (8 7 6 5 4 3 1 0))
        (apply-macete-with-minor-premises fractional-expression-manipulation)
        simplify
        (block 
	 (script-comment "`apply-macete-with-minor-premises' at (1)")
	 (contrapose "with(p:prop,p);") 
	 simplify
	 ) ) ) )
     (block 
      (script-comment "`cut-with-single-formula' at (1)")
      (incorporate-antecedent "with(p:nn,positive%prime(p));")
      (unfold-single-defined-constant (0) positive%prime) 
      simplify
      ) )
    (apply-macete-with-minor-premises non-perfect-squares-are-positive)

    )))

(def-theorem sqrt-2-is-irrational
  "not #(sqrt(2),qq)"
  (theory h-o-real-arithmetic)
  (proof
   (
 
    (apply-macete-with-minor-premises sqrt-nps-is-irrational)
    (unfold-single-defined-constant (0) non%perfect%square)
    (instantiate-existential ("2"))
    (instantiate-theorem primality-test-refinement ("2"))
    (block 
     (script-comment "`instantiate-existential' at (0 1)")
     (force-substitution "divisor%power(2,2)" "1" (0))
     (block 
      (script-comment "`force-substitution' at (0)")
      (unfold-single-defined-constant (0) odd) 
      (instantiate-existential ("0"))
      simplify
      )
     (block 
      (script-comment "`force-substitution' at (1)")
      (force-substitution "divisor%power(2,2)==1" "1=divisor%power(2,2)" (0))
      (block 
       (script-comment "`force-substitution' at (0)")
       (apply-macete-with-minor-premises divisor%power-characterization)
       (instantiate-existential ("1")) 
       simplify
       (block 
	(script-comment "`instantiate-existential' at (0 1)")
        (unfold-single-defined-constant (0) divides) 
	simplify
	) )
      simplify
      ) )

    )))

