(* $Id: CPoly_ApZero1.v,v 1.2 2000/10/30 11:03:25 freek Exp $ *)

Require Export CPoly_ApZero.
Require Export CComplex.

Section Characteristic_Zero.

Variable R : CRing.

Definition Char0 := [R:CRing](n:nat)(lt (0) n) -> ((Nring n)::R [#] Zero).

Hypothesis char0_R : (Char0 R).

Lemma nring_different : (i,j:nat)(~i = j) -> ((Nring i) [#] (Nring j)::R).
Intros.
Elim (nat_total_order i j); Intros.
Replace j with (plus i (minus j i)).
Step_ap_rht (Nring i)[+](Nring (minus j i))::R.
Step_ap_lft (Nring i)[+]Zero::R.
Apply op_lft_resp_ap.
Apply ap_symmetric_unfolded.
Apply char0_R.
Omega.
Omega.
Replace i with (plus j (minus i j)).
Step_ap_lft (Nring j)[+](Nring (minus i j))::R.
Step_ap_rht (Nring j)[+]Zero::R.
Apply op_lft_resp_ap.
Apply char0_R.
Omega.
Omega.
Auto.
Qed.

Lemma char0_OrdField : (F:COrdField)(Char0 F).
Unfold Char0.
Intros.
Apply nring_ap_zero.
Omega.
Qed.

Lemma char0_IR : (Char0 IR).
Apply char0_OrdField.
Qed.

Load Transparent_algebra.
Lemma char0_CC : (Char0 CC).
Unfold Char0.
Intros.
Step_ap_lft (cc_IR (Nring n)).
Simpl.
Unfold cc_ap.
Simpl.
Left.
Apply char0_IR.
Auto.
Qed.
Load Opaque_algebra.

End Characteristic_Zero.


Section Poly_ApZero.

Lemma poly_apzero : (R:CField)(Char0 R) ->
  (f:(cpoly_cring R))(f [#] Zero) -> (EX c | f!c [#] Zero).
Intros.
Elim (poly_ex_degree ? f). Intro n. Intros.
Cut (Distinct1 [i:nat](Nring i)::R). Intro.
Elim (poly_choose_apzero ? [i:nat](Nring i)::R H2 f n H1 H0).
Intro i. Intros.
Elim H3. Intros.
Exists (Nring i)::R.
Auto.
Unfold distinct1.
Intros.
Apply nring_different; Auto.
Qed.

Lemma poly_apzero_IR :
  (f:(cpoly_cring IR))(f [#] Zero) -> (EX c | f!c [#] Zero).
Intros.
Apply poly_apzero.
Exact char0_IR.
Auto.
Qed.

Lemma poly_apzero_CC :
  (f:(cpoly_cring CC))(f [#] Zero) -> (EX c | f!c [#] Zero).
Intros.
Apply poly_apzero.
Exact char0_CC.
Auto.
Qed.

End Poly_ApZero.


Section Poly_Extensional.

Lemma poly_extensional : (R:CField)(Char0 R) ->
  (p,q:(cpoly_cring R))((x:R)(p!x [=] q!x)) -> (p [=] q).
Intros.
Apply cg_inv_unique_2.
Apply not_ap_imp_eq. Unfold not. Intros.
Elim (poly_apzero ? H p[-]q). Intros.
Cut (p[-]q)!x [=] Zero. Intro.
Elim (eq_imp_not_ap ??? H3 H2).
Step p!x[-]q!x.
Step_final p!x[-]p!x.
Auto.
Qed.

Lemma poly_IR_extensional :
  (p,q:(cpoly_cring IR))((x:IR)(p!x [=] q!x)) -> (p [=] q).
Intros.
Apply poly_extensional.
Exact char0_IR.
Auto.
Qed.

Lemma poly_CC_extensional :
  (p,q:(cpoly_cring CC))((x:CC)(p!x [=] q!x)) -> (p [=] q).
Intros.
Apply poly_extensional.
Exact char0_CC.
Auto.
Qed.

End Poly_Extensional.


