(* $Id: CReals1.v,v 1.1 2000/11/10 11:32:10 freek Exp $ *)

Require Export CReals.

(* Tex_Prose
\begin{convention}
Let \verb!IR! be a structure for real numbers.
\end{convention}
*)

Axiom IR : CReals.

(*
Require Export R_CReals.
Definition IR : CReals := Concrete_R.
Opaque IR.
*)

Load Transparent_algebra.

(* Tex_Prose
\begin{convention}
With \verb!ZeroR! and \verb!OneR! we denote the zero and one of this structure.
\end{convention}
*)

Syntactic Definition ZeroR := (Zero::IR).
Syntactic Definition OneR := (One::IR).

Section CReals_axioms.
(* Tex_Prose
\subsection{CReals axioms}
*)

(* Begin_Tex_Verb *)
Lemma CReals_is_CReals : (is_CReals IR Lim).
(* End_Tex_Verb *)
Unfold lim.
Elim IR; Intros.
Exact crl_proof.
Qed.

(* First properties which follow trivially from the axioms *)
(* Begin_Tex_Verb *)
Lemma Lim_Cauchy : (s:(CauchySeq IR))(SeqLimit s (Lim s)).
(* End_Tex_Verb *)
Elim CReals_is_CReals.
Intros.
Apply ax_Lim.
Qed.

(* Begin_Tex_Verb *)
Lemma Archimedes : (x:IR)(Ex [n:nat](x [:<] (Nring n))).
(* End_Tex_Verb *)
Elim CReals_is_CReals.
Intros.
Apply ax_Arch.
Qed.

(* Begin_Tex_Verb *)
Definition CauchySeqR := (CauchySeq IR).
(* End_Tex_Verb *)

End CReals_axioms.

Section Cauchy_Defs.
(* Tex_Prose
\subsection{Cauchy definitions}
This section gives several definitions of Cauchy sequences. There
are no lemmas in this section.

\begin{enumerate}
\item
The current definition of Cauchy (\verb!Cauchy_prop!) is:
\[\forall \epsilon>0. \exists N. \forall m\geq N. |seq_m - seq_N| < \epsilon\]
\item
Variant 1 of Cauchy (\verb!Cauchy_prop1!) is:\\
\[\forall k. \exists N. \forall m \geq N. |seq_m - seq_N| < 1/(k+1) \]

\item
 In all of the following variants the limit occurs in the definition.
 Therefore it is useful to define an auxiliary
 predicate \verb!Cauchy_lim_prop?!,
 in terms of which \verb!Cauchy_prop?! is defined.

Variant 2 of Cauchy (\verb!Cauchy_prop2!):
\[\begin{array}{l}
\exists y. \verb!Cauchy_lim_prop2!~seq~y \text{ where }\\
\verb!Cauchy_lim_prop2!~seq~y :=
\forall \epsilon>0. \exists N. \forall m \geq N. |seq_m - y| < \epsilon
\end{array}\]

Note that \verb!Cauchy_lim_prop2! equals \verb!seqLimit!.
\item
Variant 3 of Cauchy (\verb!Cauchy_prop3!):
\[\begin{array}{l}
\exists y. \verb!Cauchy_lim_prop3!~seq~y \text{ where }\\
\verb!Cauchy_lim_prop3!~seq~y :=
\forall k. \exists N. \forall m\geq N. |seq_m - y| < 1/(k+1)
\end{array}\]
\item
 The following variant is more restricted.\\
Variant 4 of Cauchy (\verb!Cauchy_prop4!):
\[\begin{array}{l}
\exists y. \verb!Cauchy_lim_prop4!~seq~y \text{ where }\\
\verb!Cauchy_lim_prop4!~seq~y := \forall k. |seq_k - y| < 1/(k+1)
\end{array}\]
\end{enumerate}
 So
\[ \verb!Cauchy_prop4! \Rightarrow
   \verb!Cauchy_prop3! \Leftrightarrow
   \verb!Cauchy_prop2! \Leftrightarrow
   \verb!Cauchy_prop1! \Leftrightarrow
   \verb!Cauchy_prop!\]

 Note: I don't know which formulations are useful.
*)

(* Begin_Tex_Verb *)
Definition Cauchy_prop1 := [seq:(nat->IR)]
                           (k:nat)(Ex [N:nat](m:nat)((le N m) ->
                           (AbsSmall (One_div_succ k) ((seq m) [-] (seq N))))).
(* End_Tex_Verb *)


(* Begin_Tex_Verb *)
Definition Cauchy_lim_prop2 := [seq:(nat->IR)][y:IR]
                               (eps:IR)(Zero [:<] eps) ->
                               (Ex [N:nat](m:nat)((le N m) ->
                               (AbsSmall eps ((seq m) [-] y)))).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Definition Cauchy_prop2 := [seq:(nat->IR)]
                           (Ex [y:IR](Cauchy_lim_prop2 seq y)).
(* End_Tex_Verb *)


(* Begin_Tex_Verb *)
Definition Cauchy_lim_prop3 := [seq:(nat->IR)][y:IR]
                               (k:nat)
                               (Ex [N:nat](m:nat)((le N m) ->
                               (AbsSmall (One_div_succ k) ((seq m) [-] y)))).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Definition Cauchy_prop3 := [seq:(nat->IR)]
                           (Ex [y:IR](Cauchy_lim_prop3 seq y)).
(* End_Tex_Verb *)


(* Begin_Tex_Verb *)
Definition Cauchy_lim_prop4 := [seq:(nat->IR)][y:IR]
                         (((m:nat)(AbsSmall (One_div_succ m) ((seq m)[-]y)))).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Definition Cauchy_prop4 := [seq:(nat->IR)]
                           (Ex [y:IR](Cauchy_lim_prop4 seq y)).
(* End_Tex_Verb *)
End Cauchy_Defs.


Section Inequalities.
(* Tex_Prose
\subsection{Inequalities of limits}
*)

(* Tex_Prose
The next lemma is equal to lemma \verb!Lim_Cauchy!.
*)
(* Begin_Tex_Verb *)
Lemma Cauchy_complete : (seq:(CauchySeq IR))
                        (Cauchy_lim_prop2 seq (Lim seq)).
(* End_Tex_Verb *)
Exact Lim_Cauchy.
Qed.

(* Begin_Tex_Verb *)
Lemma less_Lim_so_less_seq : (seq:(CauchySeq IR))(y:IR)(y [:<] (Lim seq)) ->
             (Ex [N:nat](m:nat)(le N m)->(y [:<] (seq m))).
(* End_Tex_Verb *)
Intros.
Elim (Cauchy_complete seq ((Lim seq)[-]y)).
Intro N.
Intros.
Split with N.
Intros.
Generalize (H0 ? H1); Intro.
Unfold absSmall in H2.
Elim H2.
Intros.

Apply plus_cancel_less with [--](Lim seq).
Step_Rat_less_lft [--]((Lim seq)[-]y).
Step_Rat_less_rht (seq m) [-] (Lim seq).
Assumption.

Apply plus_cancel_less with y.
Step_Rat_less_lft y.
Step_Rat_less_rht (Lim seq).
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Lim_less_so_seq_less : (seq:(CauchySeq IR))(y:IR)((Lim seq) [:<] y) ->
                            (Ex [N:nat](m:nat)(le N m)->((seq m) [:<] y)).
(* End_Tex_Verb *)
Intros.
Elim (Cauchy_complete seq (y[-](Lim seq))).
Intro N.
Intros.
Split with N.
Intros.
Generalize (H0 ? H1); Intro.
Unfold absSmall in H2.
Elim H2.
Intros.

Apply plus_cancel_less with [--](Lim seq).
Exact H4.

Apply plus_cancel_less with (Lim seq).
Step_Rat_less_rht y.
Step_Rat_less_lft (Lim seq).
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Lim_less_Lim_so_seq_less_seq :
               (seq1,seq2:(CauchySeq IR))((Lim seq1) [:<] (Lim seq2)) ->
               (Ex [N:nat](m:nat)(le N m)->((seq1 m) [:<] (seq2 m))).
(* End_Tex_Verb *)
Intros.
Let Av := ((Lim seq1) [+] (Lim seq2)) [/] TwoNZ in Goal.
Cut (Lim seq1) [:<] Av; Try Intro.
Cut Av [:<] (Lim seq2); Try Intro.
Generalize (Lim_less_so_seq_less ?? H0); Intro.
Generalize (less_Lim_so_less_seq ?? H1); Intro.
Elim H2; Intro N1; Intros.
Elim H3; Intro N2; Intros.
Exists (max N1 N2); Intros.
Apply less_transitive_unfolded with Av.
Apply H4.
Apply le_trans with (max N1 N2).
Apply le_max1.
Assumption.
Apply H5.
Apply le_trans with (max N1 N2).
Apply le_max2.
Assumption.
Rewrite Heq.
Apply Average_less_Greatest.
Assumption.
Rewrite Heq.
Apply Smallest_less_Average.
Assumption.
Qed.


(* Tex_Prose
The next lemma
follows from \verb!less_Lim_so_less_seq! with $y := (y+(\verb!Lim!~seq))/2$.
*)
(* Begin_Tex_Verb *)
Lemma less_Lim_so : (seq:(CauchySeq IR))(y:IR)(y [:<] (Lim seq)) ->
             (Ex [eps:IR](Zero [:<] eps) /\
                (Ex [N:nat](m:nat)(le N m)->((y[+]eps) [:<] (seq m)))).
(* End_Tex_Verb *)
Intros.
Elim (less_Lim_so_less_seq seq ((y [+] (Lim seq)) [/] TwoNZ)); Intros.
Exists ((Lim seq) [-] y) [/] TwoNZ.
Split.
Apply pos_div_two.
Apply shift_zero_less_minus.
Assumption.
Exists x.
Intros.
Step_Rat_less_lft (y[+](Lim seq))[/]TwoNZ.
Apply H0.
Assumption.
Apply Average_less_Greatest.
Assumption.
Qed.




(* Begin_Tex_Verb *)
Lemma Lim_less_so : (seq:(CauchySeq IR))(y:IR)((Lim seq) [:<] y) ->
             (Ex [eps:IR](Zero [:<] eps) /\
               (Ex [N:nat](m:nat)(le N m)->(((seq m)[+]eps) [:<] y))).
(* End_Tex_Verb *)
Intros.
Elim (Lim_less_so_seq_less seq (((Lim seq) [+] y) [/] TwoNZ)); Intros.
Exists (y [-] (Lim seq)) [/] TwoNZ.
Split.
Apply pos_div_two.
Apply shift_zero_less_minus.
Assumption.
Exists x.
Intros.
Apply shift_plus_less.
Step_Rat_less_rht ((Lim seq)[+]y)[/]TwoNZ.
Apply H0.
Assumption.
Apply Smallest_less_Average.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma leEq_seq_so_leEq_lim : (seq:CauchySeqR)(y:IR)((i:nat)y[:<=](seq i)) ->
                                             (y[:<=](Lim seq)).
(* End_Tex_Verb *)
Intros.
Unfold leEq.
Intro.
Generalize (Lim_less_so_seq_less ?? H0); Intro.
Elim H1; Intros N H2.
Apply (H N).
Apply H2.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma Lim_leEq_Lim : (seq1,seq2:CauchySeqR)((i:nat)(seq1 i)[:<=](seq2 i)) ->
                                           ((Lim seq1)[:<=](Lim seq2)).
(* End_Tex_Verb *)
Intros.
Unfold leEq.
Intro.
Generalize (Lim_less_Lim_so_seq_less_seq ?? H0); Intro.
Elim H1; Intros N H2.
Apply (H N).
Apply H2.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma seq_leEq_so_lim_leEq : (seq:CauchySeqR)(y:IR)((i:nat)(seq i)[:<=]y) ->
                                    ((Lim seq)[:<=] y).
(* End_Tex_Verb *)
Intros.
Unfold leEq.
Intro.
Generalize (less_Lim_so_less_seq ?? H0); Intro.
Elim H1; Intros N H2.
Apply (H N).
Apply H2.
Auto with arith.
Qed.


(* Begin_Tex_Verb *)
Lemma limits_unique : (seq:(CauchySeq IR))(y:IR)
                      (Cauchy_lim_prop2 seq y) -> (y [=] (Lim seq)).
(* End_Tex_Verb *)
Intros.
Apply not_ap_imp_eq.
Unfold not; Intro.
Generalize (ap_imp_less ? ? ? H0); Intro.
Elim H1; Intros.
Elim (less_Lim_so ? ? H2); Intro eps; Intros.
Elim H3; Intros.
Elim H5; Intro N; Intros.
Unfold Cauchy_lim_prop2 in H.
Elim (H ? H4); Intro N'; Intros.
Generalize (le_max1 N N'); Intro.
Generalize (le_max2 N N'); Intro.
Generalize (H6 ? H8); Intros.
Generalize (H7 ? H9); Intros.
Elim H11; Intros.
Apply (less_antisymmetric_unfolded ? ? ? H10).
Apply plus_cancel_less with [--]y.
(* The following tactic gives a terrible error
   Step_Rat_less_lft ((Nring (max N N'))[-]y). *)
Step_Rat_less_rht eps.
Exact H13.

(* Second case similar to first case *)
Elim (Lim_less_so ? ? H2); Intro eps; Intros.
Elim H3; Intros.
Elim H5; Intro N; Intros.
Unfold Cauchy_lim_prop2 in H.
Elim (H ? H4); Intro N'; Intros.
Generalize (le_max1 N N'); Intro.
Generalize (le_max2 N N'); Intro.
Generalize (H6 ? H8); Intros.
Generalize (H7 ? H9); Intros.
Elim H11; Intros.
Apply (less_antisymmetric_unfolded ? ? ? H10).
Apply plus_cancel_less with (([--]y)[-]eps).
Step_Rat_less_lft [--]eps.
Step_Rat_less_rht (seq (max N N'))[-]y.
Assumption.
Qed.

End Inequalities.

Section Equiv_Cauchy.
(* Tex_Prose
\subsection{Equivalence of formulations of Cauchy}
*)

(* Begin_Tex_Verb *)
Lemma Cauchy_prop1_prop : (seq:(nat->IR))
                          (Cauchy_prop1 seq) -> (Cauchy_prop seq).
(* End_Tex_Verb *)
Intros.
Unfold Cauchy_prop1 in H.
Unfold Cauchy_prop.
Intros.
Cut e[#]Zero.
Intro eNZ.
Elim (Archimedes (One [/] (e[//]eNZ))).
Intros.
Elim (H x).
Intros.
Split with x0.
Intros.
Generalize (H2 ? H3).
Intro.
Apply AbsSmall_trans with (one_div_succ IR x).

Unfold one_div_succ.
Unfold Snring.
Apply shift_div_less'.
Change Zero [:<] (nring (IR) (S x)).
Apply nring_pos.
Auto with arith.

Step_less_rht (e[*](nring IR (S x))).
Apply less_transitive_unfolded with e[*](nring IR x).
Apply shift_less_mult' with eNZ.
Assumption.

Assumption.

Apply mult_resp_less_lft.
Apply nring_less.
Auto.

Assumption.

Assumption.
Apply pos_ap_zero.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_prop2_prop : (seq:(nat->IR))
                          (Cauchy_prop2 seq) -> (Cauchy_prop seq).
(* End_Tex_Verb *)
Intros.
Unfold Cauchy_prop.
Intros.
Unfold Cauchy_prop2 in H.
Elim H.
Intro y; Intros.
Unfold Cauchy_lim_prop2 in H1.
Elim (H1 (e[/]TwoNZ)).
Intro N.
Intros.
Exists N.
Intros.
Generalize (H2 ? H3); Intro.
Generalize (le_n N); Intro.
Generalize (H2 ? H5); Intro.
Generalize (AbsSmall_minus ? ? ? ? H6); Intro.
Generalize (AbsSmall_plus ? ? ? ? ? H4 H7); Intro.
Step_Rat_AbsSmall_lft ((e[/]TwoNZ) [+] (e[/]TwoNZ)).
Step_Rat_AbsSmall_rht ((seq m)[-]y)[+](y[-](seq N)).
Assumption.
Apply pos_div_two.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_lim_prop3_prop2 : (seq:(nat->IR))(y:IR)
                         (Cauchy_lim_prop3 seq y) -> (Cauchy_lim_prop2 seq y).
(* End_Tex_Verb *)
Intros.
Unfold Cauchy_lim_prop2.
Intros.
Unfold Cauchy_lim_prop3 in H.
Generalize (pos_ap_zero ? ? H0); Intro Heps.
Elim (Archimedes (One[/]eps[//]Heps)).
Intro K; Intros.
Elim (H K).
Intro N; Intros.
Exists N.
Intros.
Generalize (H2 ? H3); Intro.
Apply AbsSmall_trans with (one_div_succ (IR) K); Try Assumption.
Unfold one_div_succ.
Unfold Snring.
Apply shift_div_less'.
Apply nring_pos.
Auto with arith.
Apply less_transitive_unfolded with ((nring IR K) [*] eps).
Generalize (shift_less_mult' ???? Heps H0 H1); Intro.
Step_less_rht eps[*](nring IR K).
Assumption.

Apply mult_resp_less; Try Assumption.
Apply nring_less.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_prop3_prop2 : (seq:(nat->IR))
                          (Cauchy_prop3 seq) -> (Cauchy_prop2 seq).
(* End_Tex_Verb *)
Unfold Cauchy_prop2.
Unfold Cauchy_prop3.
Intros.
Elim H; Intros.
Exists x.
Apply Cauchy_lim_prop3_prop2.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_prop3_prop : (seq:(nat->IR))
                          (Cauchy_prop3 seq) -> (Cauchy_prop seq).
(* End_Tex_Verb *)
Intros.
Apply Cauchy_prop2_prop.
Apply Cauchy_prop3_prop2.
Assumption.
Qed.



(* Begin_Tex_Verb *)
Definition Build_CauchySeq1 : (seq:(nat->IR))
                         (Cauchy_prop1 seq) -> CauchySeqR.
(* End_Tex_Verb *)
Intros.
Unfold CauchySeqR.
Apply Build_CauchySeq with seq.
Apply Cauchy_prop1_prop.
Assumption.
Qed.


(* Begin_Tex_Verb *)
Lemma Cauchy_lim_prop4_prop3 : (seq:(nat->IR))(y:IR)
                        (Cauchy_lim_prop4 seq y) -> (Cauchy_lim_prop3 seq y).
(* End_Tex_Verb *)
Intros.
Unfold Cauchy_lim_prop4 in H.
Unfold Cauchy_lim_prop3.
Intros.
Exists k.
Intros.
Apply AbsSmall_leEq_trans with (one_div_succ IR m).
2: Apply H.
Apply one_div_succ_resp_leEq.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_lim_prop4_prop2 : (seq:(nat->IR))(y:IR)
                        (Cauchy_lim_prop4 seq y) -> (Cauchy_lim_prop2 seq y).
(* End_Tex_Verb *)
Intros.
Apply Cauchy_lim_prop3_prop2.
Apply Cauchy_lim_prop4_prop3.
Assumption.
Qed.


(* Begin_Tex_Verb *)
Lemma Cauchy_prop4_prop3 : (seq:(nat->IR))
                        (Cauchy_prop4 seq) -> (Cauchy_prop3 seq).
(* End_Tex_Verb *)
Unfold Cauchy_prop4.
Unfold Cauchy_prop3.
Intros.
Elim H; Intros.
Exists x.
Apply Cauchy_lim_prop4_prop3.
Assumption.
Qed.


(* Begin_Tex_Verb *)
Lemma Cauchy_prop4_prop : (seq:(nat->IR))
                             (Cauchy_prop4 seq) -> (Cauchy_prop seq).
(* End_Tex_Verb *)
Intros.
Apply Cauchy_prop3_prop.
Apply Cauchy_prop4_prop3.
Assumption.
Qed.


(* Begin_Tex_Verb *)
Definition Build_CauchySeq4 : (seq:(nat->IR))
                         (Cauchy_prop4 seq) -> CauchySeqR.
(* End_Tex_Verb *)
Intros.
Unfold CauchySeqR.
Apply Build_CauchySeq with seq.
Apply Cauchy_prop4_prop.
Assumption.
Defined.

(* Begin_Tex_Verb *)
Definition Build_CauchySeq4_y : (seq:(nat->IR))(y:IR)
                           (Cauchy_lim_prop4 seq y) -> CauchySeqR.
(* End_Tex_Verb *)
Intros.
Apply Build_CauchySeq4 with seq.
Unfold Cauchy_prop4.
Exists y.
Assumption.
Defined.

(* Begin_Tex_Verb *)
Lemma Lim_CauchySeq4 : (seq:(nat->IR))(y:IR)
                       (H:(Cauchy_lim_prop4 seq y))
                       ((Lim (Build_CauchySeq4_y seq y H)) [=] y).
(* End_Tex_Verb *)
Intros.
Apply eq_symmetric_unfolded.
Apply limits_unique.
Apply Cauchy_lim_prop3_prop2.
Apply Cauchy_lim_prop4_prop3.
Unfold Build_CauchySeq4_y.
Unfold Build_CauchySeq4.
Unfold CS_seq.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Definition Build_CauchySeq2 : (seq:(nat->IR))
                         (Cauchy_prop2 seq) -> CauchySeqR.
(* End_Tex_Verb *)
Intros.
Unfold CauchySeqR.
Apply Build_CauchySeq with seq.
Apply Cauchy_prop2_prop.
Assumption.
Defined.

(* Begin_Tex_Verb *)
Definition Build_CauchySeq2_y : (seq:(nat->IR))(y:IR)
                           (Cauchy_lim_prop2 seq y) -> CauchySeqR.
(* End_Tex_Verb *)
Intros.
Apply Build_CauchySeq2 with seq.
Unfold Cauchy_prop2.
Exists y.
Assumption.
Defined.


(* Begin_Tex_Verb *)
Lemma Lim_CauchySeq2 : (seq:(nat->IR))(y:IR)
                       (H:(Cauchy_lim_prop2 seq y))
                       ((Lim (Build_CauchySeq2_y seq y H)) [=] y).
(* End_Tex_Verb *)
Intros.
Apply eq_symmetric_unfolded.
Apply limits_unique.
Unfold Build_CauchySeq2_y.
Unfold Build_CauchySeq2.
Unfold CS_seq.
Assumption.
Qed.


End Equiv_Cauchy.


Section Cauchy_props.
(* Tex_Prose
\subsection{Properties of Cauchy sequences}
*)

(* Begin_Tex_Verb *)
Lemma Cauchy_lim_sum : (seq1,seq2:(nat->IR))(y1,y2:IR)
                (Cauchy_lim_prop2 seq1 y1) -> (Cauchy_lim_prop2 seq2 y2) ->
                (Cauchy_lim_prop2 ([n:nat]((seq1 n) [+] (seq2 n))) (y1[+]y2)).
(* End_Tex_Verb *)
Intros.
Unfold Cauchy_lim_prop2.
Intros.
Cut (Zero [:<] eps [/] TwoNZ).
Intro.
Elim (H ? H2); Intros.
Elim (H0 ? H2); Intros.
Exists (max x x0).
Intros.
Step_Rat_AbsSmall_rht ((seq1 m) [-] y1)[+] ((seq2 m) [-] y2).
Apply AbsSmall_eps_div_two.
Apply H3.
Apply le_trans with (max x x0).
Apply le_max1.
Assumption.

Apply H4.
Apply le_trans with (max x x0).
Apply le_max2.
Assumption.

Apply pos_div_two.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_sum : (seq1,seq2:CauchySeqR)
                   (Cauchy_prop ([n:nat]((seq1 n) [+] (seq2 n)))).
(* End_Tex_Verb *)
Intros.
Apply Cauchy_prop2_prop.
Unfold Cauchy_prop2.
Exists (Lim seq1) [+] (Lim seq2).
Apply Cauchy_lim_sum.
Apply Cauchy_complete.
Apply Cauchy_complete.
Qed.

(* Begin_Tex_Verb *)
Lemma Lim_sum : (seq1,seq2:CauchySeqR)
(Lim (Build_CauchySeq IR ([n:nat]((seq1 n) [+] (seq2 n)))
                         (Cauchy_sum seq1 seq2)))
[=] ((Lim seq1) [+] (Lim seq2)).
(* End_Tex_Verb *)
Intros.
Apply eq_symmetric_unfolded.
Apply limits_unique.
Simpl.
Apply Cauchy_lim_sum.
Apply Cauchy_complete.
Apply Cauchy_complete.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_lim_minus : (seq:(nat->IR))(y:IR)
                (Cauchy_lim_prop2 seq y) ->
                (Cauchy_lim_prop2 ([n:nat]([--](seq n))) ([--]y)).
(* End_Tex_Verb *)
Intros.
Unfold Cauchy_lim_prop2.
Intros.
Elim (H ? H0); Intros.
Exists x.
Intros.
Step_Rat_AbsSmall_rht [--]((seq m)[-] y).
Apply min_resp_AbsSmall.
Apply H1.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_minus : (seq:CauchySeqR)
                     (Cauchy_prop ([n:nat]([--](seq n)))).
(* End_Tex_Verb *)
Intros.
Apply Cauchy_prop2_prop.
Unfold Cauchy_prop2.
Exists [--](Lim seq).
Apply Cauchy_lim_minus.
Apply Cauchy_complete.
Qed.

(* Begin_Tex_Verb *)
Lemma Lim_minus : (seq:CauchySeqR)
(Lim (Build_CauchySeq IR ([n:nat]([--] (seq n)))
                         (Cauchy_minus seq)))
[=] ([--](Lim seq)).
(* End_Tex_Verb *)
Intros.
Apply eq_symmetric_unfolded.
Apply limits_unique.
Simpl.
Apply Cauchy_lim_minus.
Apply Cauchy_complete.
Qed.


(* Begin_Tex_Verb *)
Lemma Cauchy_lim_min : (seq1,seq2:(nat->IR))(y1,y2:IR)
                (Cauchy_lim_prop2 seq1 y1) -> (Cauchy_lim_prop2 seq2 y2) ->
                (Cauchy_lim_prop2 ([n:nat]((seq1 n) [-] (seq2 n))) (y1[-]y2)).
(* End_Tex_Verb *)
Intros.
Unfold cg_minus.
Change (Cauchy_lim_prop2 ([n:nat](seq1 n)[+]([m:nat][--](seq2 m) n)) (y1[+][--]y2)).
Apply Cauchy_lim_sum.
Assumption.
Apply Cauchy_lim_minus.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_min : (seq1,seq2:CauchySeqR)
                   (Cauchy_prop ([n:nat]((seq1 n) [-] (seq2 n)))).
(* End_Tex_Verb *)
Intros.
Apply Cauchy_prop2_prop.
Unfold Cauchy_prop2.
Exists (Lim seq1) [-] (Lim seq2).
Apply Cauchy_lim_min.
Apply Cauchy_complete.
Apply Cauchy_complete.
Qed.

(* Begin_Tex_Verb *)
Lemma Lim_min : (seq1,seq2:CauchySeqR)
(Lim (Build_CauchySeq IR ([n:nat]((seq1 n) [-] (seq2 n)))
                         (Cauchy_min seq1 seq2)))
[=] ((Lim seq1) [-] (Lim seq2)).
(* End_Tex_Verb *)
Intros.
Apply eq_symmetric_unfolded.
Apply limits_unique.
Simpl.
Apply Cauchy_lim_min.
Apply Cauchy_complete.
Apply Cauchy_complete.
Qed.


(* Begin_Tex_Verb *)
Lemma Cauchy_lim_mult : (seq1,seq2:(nat->IR))(y1,y2:IR)
                (Cauchy_lim_prop2 seq1 y1) -> (Cauchy_lim_prop2 seq2 y2) ->
                (Cauchy_lim_prop2 ([n:nat]((seq1 n) [*] (seq2 n))) (y1[*]y2)).
(* End_Tex_Verb *)
Unfold Cauchy_lim_prop2. Intros.
Elim (mult_contin ? y1 y2 eps H1). Intro c. Intros.
Elim H2. Clear H2. Intros.
Elim H3. Clear H3. Intro d. Intros.
Elim H3. Clear H3. Intros.
Elim (H c H2). Clear H. Intro N1. Intros.
Elim (H0 d H3). Clear H0. Intro N2. Intros.
Cut (EX N | (le N1 N) /\ (le N2 N)). Intro.
Elim H5. Clear H5. Intro N. Intros. Elim H5. Clear H5. Intros.
Exists N. Intros.
Apply AbsSmall_wd_rht_unfolded with [--](y1[*]y2[-](seq1 m)[*](seq2 m)).
Apply min_resp_AbsSmall.
Apply H4; Clear H4; Intros.
Apply AbsSmall_wd_rht_unfolded with [--]((seq1 m)[-]y1).
Apply min_resp_AbsSmall.
Apply H. Omega.
Rational.
Apply AbsSmall_wd_rht_unfolded with [--]((seq2 m)[-]y2).
Apply min_resp_AbsSmall.
Apply H0. Omega.
Rational.
Rational.
Elim (le_lt_dec N1 N2); Intros.
Exists N2. Auto.
Exists N1. Split. Auto. Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_mult : (seq1,seq2:CauchySeqR)
                   (Cauchy_prop ([n:nat]((seq1 n) [*] (seq2 n)))).
(* End_Tex_Verb *)
Intros.
Apply Cauchy_prop2_prop.
Unfold Cauchy_prop2.
Exists (Lim seq1) [*] (Lim seq2).
Apply Cauchy_lim_mult.
Apply Cauchy_complete.
Apply Cauchy_complete.
Qed.

(* Begin_Tex_Verb *)
Lemma Lim_mult : (seq1,seq2:CauchySeqR)
(Lim (Build_CauchySeq IR ([n:nat]((seq1 n) [*] (seq2 n)))
                         (Cauchy_mult seq1 seq2)))
[=] ((Lim seq1) [*] (Lim seq2)).
(* End_Tex_Verb *)
Intros.
Apply eq_symmetric_unfolded.
Apply limits_unique.
Simpl.
Apply Cauchy_lim_mult.
Apply Cauchy_complete.
Apply Cauchy_complete.
Qed.


End Cauchy_props.


Section Maximum.
(* Tex_Prose
\subsection{Maximum}
Let us first consider the informal definition of maximum.

\begin{definition}\label{defmax}
Given $x,y\in\RR$, we define the maximum of $x$ and $y$. First
construct a sequence $(y'_i)_{i\in\NN}$ such that
$$\forall i\in \NN[-\frac{1}{i}< y-y'_i <\frac{1}{i} \wedge y'_i \noto
x].$$ This is is possible (Lemma \verb!exis_AFS! below). Note that
$(y'_i)_{i\in\NN}$ is a Cauchy sequence and $y=\lim_{i\rightarrow \infty}
y'_i$. Now define the sequence $(s_i)_{i\in\NN}$ by
$$s_i :=
\left\{ \begin{array}{rcl}
        x &\mbox{if}& x>y'_i,\\
        y'_i &\mbox{if}& x<y'_i,\\
       \end{array}\right.$$
Now $(s_i)_{i\in\NN}$ is a Cauchy sequence and we define
$$\maxx (x ,y) := \lim_{i\rightarrow \infty} s_i.$$
\end{definition}

First we will consider the ``apart from'' sequence $y'_i$, then we define
the maximum function, and then prove its properties.
*)

Section ApartFrom.
(* Tex_Prose
\subsubsection{The ``apart from'' sequence}
Given an $x$ and $y$, the ``apart from''
sequence is a Cauchy sequence $y'_i$ with limit $y$
and with $y'_i$ apart from $x$ for all $i$.
Below, this ``apart from sequence'' $y'$ is called \verb!AFS!.
\begin{convention}
Let \verb!x! and \verb!y! be reals.
\end{convention}
*)

Variable x,y:IR.

(* Begin_Tex_Verb *)
Lemma Inform_cotrans_less_unfolded
     : (R:COrdField; a,b:R)
        (a [:<] b)->(c:R){a [:<] c}+{c [:<] b}.
(* End_Tex_Verb *)
Intros.
Apply or_informative.
Apply cotrans_less_unfolded.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma exis_AFS : (eps:IR)(Zero [:<] eps) ->
                    (sig IR [y':IR]((AbsSmall eps (y' [-] y)) /\ (y' [#] x))).
(* End_Tex_Verb *)
Intros.
Cut ({(y[-](eps[/]TwoNZ))[:<]x} + {x[:<](y[+](eps[/]TwoNZ))}).
Intro.
Elim H0.

Intro.
Exists y[-]eps[/]TwoNZ.
Split.
Step_Rat_AbsSmall_rht [--](eps[/]TwoNZ).
Apply min_resp_AbsSmall.
Apply AbsSmall_eps_div2.
Assumption.
Apply less_imp_ap.
Assumption.

Intro.
Exists y[+]eps[/]TwoNZ.
Split.
Step_Rat_AbsSmall_rht eps[/]TwoNZ.
Apply AbsSmall_eps_div2.
Assumption.
Apply ap_symmetric_unfolded.
Apply less_imp_ap.
Assumption.

Apply Inform_cotrans_less_unfolded.
Unfold cg_minus.
Apply plus_resp_less_lft.

Cut (Zero [:<] eps[/] TwoNZ).
Intro.
Apply less_transitive_unfolded with ZeroR.
Step_less_rht [--]ZeroR.
Apply min_resp_less.
Assumption.

Assumption.

Apply pos_div_two.
Assumption.
Qed.

(* Tex_Prose
Now we construct the sequence $y'_i$, with name \verb!AFS!.
*)
(* Begin_Tex_Verb *)
Definition AFS := [i:nat](proj1_sig ? ? (exis_AFS (One_div_succ i)
                         (one_div_succ_pos ? i)))
               :  nat->IR.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma AFS_prop :
     (i:nat)((AbsSmall (One_div_succ i) ((AFS i)[-]y)) /\ ((AFS i) [#] x)).
(* End_Tex_Verb *)
Intros.
Exact (proj2_sig ? ? (exis_AFS (One_div_succ i) (one_div_succ_pos ? i))).
Qed.

(* Begin_Tex_Verb *)
Lemma AFS_ap : (i:nat)((AFS i) [#] x).
(* End_Tex_Verb *)
Intros.
Elim (AFS_prop i).
Auto.
Qed.

(* Tex_Prose
\verb!AFS x y! is a Cauchy-sequence, and has limit \verb!y!.
*)
(* Begin_Tex_Verb *)
Lemma AFS_Cauchy_lim : (Cauchy_lim_prop4 AFS y).
(* End_Tex_Verb *)
Intros.
Unfold Cauchy_lim_prop4.
Intros.
Elim (AFS_prop m); Intros.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Cauchy_prop_AFS : (Cauchy_prop AFS).
(* End_Tex_Verb *)
Intros.
Apply Cauchy_prop4_prop.
Unfold Cauchy_prop4.
Exists y.
Exact AFS_Cauchy_lim.
Qed.

(* Tex_Prose
Now we make \verb!AFCS! which is a {\em Cauchy} sequence.
*)
(* Begin_Tex_Verb *)
Definition AFCS : (CauchySeq IR).
(* End_Tex_Verb *)
Intros.
Unfold CauchySeqR.
Apply Build_CauchySeq4_y with AFS y.
Exact AFS_Cauchy_lim.
Defined.

(* Begin_Tex_Verb *)
Lemma Lim_AFCS : (Lim AFCS) [=] y.
(* End_Tex_Verb *)
Intros.
Unfold AFCS.
Apply Lim_CauchySeq4.
Qed.

(* Begin_Tex_Verb *)
Lemma AFCS_ap : (i:nat)((AFCS i) [#] x).
(* End_Tex_Verb *)
Intros.
Unfold AFCS.
Simpl.
Apply AFS_ap.
Qed.

End ApartFrom.

Section Max_function.
(* Tex_Prose
\subsubsection{The actual max function}

\begin{convention}
Let \verb!x! and \verb!y! be reals
(we will define the maximum of \verb!x! and \verb!y!).
\end{convention}
*)

Variable x,y:IR.

(* Begin_Tex_Verb *)
Lemma Inform_ap_imp_less : (a,b:IR)((a [#] b) -> {a[:<]b} + {b[:<]a}).
(* End_Tex_Verb *)
Intros.
Apply or_informative.
Apply ap_imp_less.
Assumption.
Qed.

(* Tex_Prose
\verb!Max_seq i! corresponds with $s_i$ in informal Definition~\ref{defmax}.
*)
(* Begin_Tex_Verb *)
Definition Max_seq : nat->IR.
(* End_Tex_Verb *)
Intro i.
Generalize (AFS_ap x y i); Intro.
(* Make case distinction *)
Elim (Inform_ap_imp_less ?? H); Intro.
(* x > y'_i, so use x *)
Exact x.

(* x < y'_i, so use y'_i, i.e. AFS x y H *)
Exact (AFS x y i).
Defined.

(* Begin_Tex_Verb *)
Lemma Max_is_x : (i:nat)((AFS x y i) [:<]x) -> (Max_seq i) = x.
(* End_Tex_Verb *)
Intros.
Unfold Max_seq.
Rewrite not_r_sumbool_rec.
Reflexivity.
Apply less_antisymmetric_unfolded.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Max_is_AFS_i : (i:nat)(x[:<](AFS x y i)) -> (Max_seq i) = (AFS x y i).
(* End_Tex_Verb *)
Intros.
Unfold Max_seq.
Rewrite not_l_sumbool_rec.
Reflexivity.
Intro.
Apply (less_antisymmetric_unfolded ??? H0 H).
Qed.


(* Begin_Tex_Verb *)
Lemma Cauchy_Max_seq : (Cauchy_prop Max_seq).
(* End_Tex_Verb *)
Intros.
Unfold Cauchy_prop.
Intros.
Elim (Cauchy_prop_AFS x y e).
Intro N; Intros.
Exists N.
Intros.
Generalize (H0 ? H1); Intro.
Generalize (AFS_ap x y m); Intro.
Generalize (AFS_ap x y N); Intro.
Elim (ap_imp_less ? ? ? H3); Intro.
Rewrite Max_is_x; Try Assumption.
Elim (ap_imp_less ? ? ? H4); Intro.
Rewrite Max_is_x; Try Assumption.
Step_Rat_AbsSmall_rht (Zero::IR).
Apply less_imp_AbsSmall; Try Assumption.
Apply leEq_reflexive.
Rewrite Max_is_AFS_i; Try Assumption.
Apply AbsSmall_minus.
Apply AbsSmall_intermediate with (AFS x y m).
Assumption.
Assumption.
Apply AbsSmall_minus.
Assumption.
Rewrite Max_is_AFS_i; Try Assumption.
Elim (ap_imp_less ? ? ? H4); Intro.
Rewrite Max_is_x; Try Assumption.
Apply AbsSmall_intermediate with (AFS x y N); Try Assumption.
Rewrite Max_is_AFS_i; Try Assumption.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Definition Max_CauchySeq : CauchySeqR.
(* End_Tex_Verb *)
Unfold CauchySeqR.
Apply Build_CauchySeq with Max_seq.
Exact Cauchy_Max_seq.
Defined.

(* Begin_Tex_Verb *)
Definition MAX : IR.
(* End_Tex_Verb *)
Apply lim.
Exact Max_CauchySeq.
Defined.

(* Tex_Prose
Constructively, the elementary properties of the maximum function are:
\begin{itemize}
\item $x\leq \maxx (x,y)$,
\item $x\leq \maxx (x,y)$,
\item $z<\maxx(x,y) \Rightarrow z<x \vee z<y$.
\end{itemize}
(This can be more concisely expressed as
 $z<\maxx(x,y) \Leftrightarrow z<x \vee z<y$).
From these elementary properties we can prove all other properties, including
strong extensionality.
With strong extensionality, we can make the binary {\em operation} \verb!Max!.
(So \verb!Max! is \verb!MAX! coupled with some proofs.)
*)



(* Begin_Tex_Verb *)
Lemma lft_leEq_MAX : x[:<=]MAX.
(* End_Tex_Verb *)
Intros.
Unfold MAX.
Apply leEq_seq_so_leEq_lim.
Intro.
Generalize (AFS_ap x y i); Intro.
Elim (ap_imp_less ??? H); Intro.
Generalize (Max_is_x ? H0); Intro.
Unfold Max_CauchySeq.
Simpl.
Rewrite H1.
Apply leEq_reflexive.
Generalize (Max_is_AFS_i ? H0); Intro.
Unfold Max_CauchySeq.
Simpl.
Rewrite H1.
Apply less_leEq.
Assumption.
Qed.



(* Begin_Tex_Verb *)
Lemma rht_leEq_MAX : y[:<=]MAX.
(* End_Tex_Verb *)
Intros.
Unfold MAX.
Apply leEq_wdl with (Lim (AFCS x y)).
2: Apply Lim_AFCS.
Apply Lim_leEq_Lim.
Intro.
Generalize (AFS_ap x y i); Intro.
Simpl.
Elim (ap_imp_less ??? H); Intro.
Generalize (Max_is_x ? H0); Intro.
Rewrite H1.
Apply less_leEq.
Assumption.
Generalize (Max_is_AFS_i ? H0); Intro.
Rewrite H1.
Apply leEq_reflexive.
Qed.

(* Begin_Tex_Verb *)
Lemma less_MAX_imp : (z:IR)(z[:<]MAX) -> (z[:<]x) \/ (z[:<]y).
(* End_Tex_Verb *)
Intros.
Unfold MAX in H.
Elim (less_Lim_so ?? H).
Intro eps; Intros.
Elim H0; Intros.
Elim H2; Intro N; Intros.
Generalize (AFS_Cauchy_lim x y); Intro.
Generalize (Cauchy_lim_prop4_prop2 ?? H4); Intro.
Unfold Cauchy_lim_prop2 in H5.
Elim (H5 eps H1); Intro N'; Intros.
Generalize (H6 (max N N')); Intros.
Cut (le N' (max N N')).
Intro.
Generalize (H7 H8); Intros.
Cut (le N (max N N')).
Intro.
Generalize (H3 ? H10); Intro.
(* Case distinction *)
Generalize (AFS_ap x y (max N N')); Intro.
Elim (ap_imp_less ??? H12); Intro.
Generalize (Max_is_x ? H13); Intro.
Unfold Max_CauchySeq in H11.
Simpl in H11.
Rewrite H14 in H11.
Left.
Apply less_transitive_unfolded with z[+]eps.
Step_Rat_less_lft z[+]Zero.
Apply plus_resp_less_lft.
Assumption.
Assumption.
Generalize (Max_is_AFS_i ? H13); Intro.
Simpl in H11.
Rewrite H14 in H11.
Unfold absSmall in H9.
Elim H9; Intros.
Right.
Generalize (shift_less_minus ???? H11); Intro.
Apply less_transitive_unfolded with (AFS x y (max N N'))[-]eps.
Assumption.
Apply shift_minus_less'.
Step_Rat_less_rht y[+]eps.
Apply shift_less_plus'.
Assumption.
Apply le_max1.
Apply le_max2.
Qed.

End Max_function.

(* Begin_Tex_Verb *)
Lemma MAX_strong_ext : (bin_op_strong_ext ? MAX).
(* End_Tex_Verb *)
Unfold bin_op_strong_ext.
Unfold bin_fun_strong_ext.
Intros.
Generalize (ap_imp_less ??? H); Intro.
Elim H0; Intro.
Generalize (less_MAX_imp ??? H1); Intro.
Elim H2; Intro.
Left.
Apply less_imp_ap.
Apply leEq_less_trans with (MAX x1 y1).
Apply lft_leEq_MAX.
Assumption.
Right.
Apply less_imp_ap.
Apply leEq_less_trans with (MAX x1 y1).
Apply rht_leEq_MAX.
Assumption.

Generalize (less_MAX_imp ??? H1); Intro.
Elim H2; Intro.
Left.
Apply Greater_imp_ap.
Apply leEq_less_trans with (MAX x2 y2).
Apply lft_leEq_MAX.
Assumption.
Right.
Apply Greater_imp_ap.
Apply leEq_less_trans with (MAX x2 y2).
Apply rht_leEq_MAX.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma MAX_well_def : (bin_op_well_def IR MAX).
(* End_Tex_Verb *)
Unfold bin_op_well_def.
Apply  bin_fun_strong_ext_imp_well_def.
Exact MAX_strong_ext.
Qed.

Section properties_of_Max.

(* Tex_Prose
\subsubsection{Properties of Max}
*)

(* Begin_Tex_Verb *)
Definition Max := (Build_CSetoid_bin_op ? MAX MAX_well_def MAX_strong_ext).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma lft_leEq_Max : (x,y:IR)x [:<=] (Max x y).
(* End_Tex_Verb *)
Unfold Max.
Simpl.
Exact lft_leEq_MAX.
Qed.

(* Begin_Tex_Verb *)
Lemma rht_leEq_Max : (x,y:IR)y [:<=] (Max x y).
(* End_Tex_Verb *)
Unfold Max.
Simpl.
Exact rht_leEq_MAX.
Qed.

(* Begin_Tex_Verb *)
Lemma less_Max_imp : (x,y,z:IR)(z[:<](Max x y)) -> (z[:<]x) \/ (z[:<]y).
(* End_Tex_Verb *)
Unfold Max.
Simpl.
Exact less_MAX_imp.
Qed.

(* Begin_Tex_Verb *)
Lemma Max_leEq : (x,y,z:IR)(x[:<=]z) -> (y[:<=]z) -> (Max x y)[:<=]z.
(* End_Tex_Verb *)
Unfold Max.
Simpl.
Intros.
Unfold leEq.
Intro.
Generalize (less_MAX_imp ??? H1); Intro.
Elim H2; Intros.
Elim H.
Assumption.
Elim H0.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma Max_less : (x,y,z:IR)(x [:<] z) -> (y [:<] z) -> (Max x y) [:<] z.
(* End_Tex_Verb *)
Intros.
Elim (smaller ? z[-]x z[-]y). Intro e. Intros.
Elim H1. Clear H1. Intros. Elim H2. Clear H2. Intros.
Cut z[-]e [:<] z. Intro.
Elim (cotrans_less_unfolded ? z[-]e z H4 (Max x y)); Intros.
Elim (less_Max_imp ??? H5); Intros.
Cut ~(e [:<] z[-]x). Intro. Elim (H7 H2).
Apply less_antisymmetric_unfolded.
Apply shift_minus_less. Apply shift_less_plus'. Auto.
Cut ~(e [:<] z[-]y). Intro. Elim (H7 H3).
Apply less_antisymmetric_unfolded.
Apply shift_minus_less. Apply shift_less_plus'. Auto.
Auto.
Apply shift_minus_less. Step_less_lft z[+]Zero.
Apply plus_resp_less_lft. Auto.
Apply shift_less_minus. Step_less_lft x. Auto.
Apply shift_less_minus. Step_less_lft y. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma equiv_imp_eq_max : (x,x',m:IR)
  ((y:IR)(x [:<] y) -> (x' [:<] y) -> (m [:<] y)) ->
  ((y:IR)(m [:<] y) -> (x [:<] y)) ->
  ((y:IR)(m [:<] y) -> (x' [:<] y)) ->
    (Max x x') [=] m.
(* End_Tex_Verb *)
Intros.
Apply lt_equiv_imp_eq; Intros.
Apply H.
Apply leEq_less_trans with (Max x x').
Apply lft_leEq_Max. Auto.
Apply leEq_less_trans with (Max x x').
Apply rht_leEq_Max. Auto.
Apply Max_less; Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma Max_id : (x:IR)(Max x x) [=] x.
(* End_Tex_Verb *)
Intros.
Apply equiv_imp_eq_max; Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma Max_comm : (x,y:IR)(Max x y)[=](Max y x).
(* End_Tex_Verb *)
Cut (x,y:IR)(Max x y)[:<=](Max y x).
Intros.
Apply leEq_imp_eq.
Apply H.
Apply H.
Intros.
Apply Max_leEq.
Apply rht_leEq_Max.
Apply lft_leEq_Max.
Qed.

(* Tex_Prose
\begin{lemma} \label{lemmaxgeq}
$\forall x,y\in\RR[ x\leq y \leftrightarrow \maxx(x,y) = y]$.
\end{lemma}
*)

(* Begin_Tex_Verb *)
Lemma leEq_imp_Max_is_rht : (x,y:IR)(x [:<=] y) -> (Max x y) [=] y.
(* End_Tex_Verb *)
Intros.
Apply leEq_imp_eq.
Apply Max_leEq.
Assumption.
Apply leEq_reflexive.
Apply rht_leEq_Max.
Qed.

(* Begin_Tex_Verb *)
Lemma Max_is_rht_imp_leEq : (x,y:IR)((Max x y) [=] y) -> (x [:<=] y).
(* End_Tex_Verb *)
Intros.
Unfold leEq.
Intro.
Generalize (less_leEq ??? H0); Intro.
Generalize (leEq_imp_Max_is_rht ?? H1); Intro.
Cut y[=]x.
Intro.
Apply (less_irreflexive_unfolded ? x).
Step_less_lft y.
Assumption.
Step (Max x y).
Stepr (Max y x).
Apply Max_comm.
Qed.

End properties_of_Max.

End Maximum.

Hints Resolve Max_id : algebra.


(**********************************************************************)
Section Absolute.
(**********************************************************************)

(* Tex_Prose
\subsection{Absolute value}
*)

(* Begin_Tex_Verb *)
Definition ABSIR := [x:IR](Max x ([--]x))
                 :  IR -> IR.
(* End_Tex_Verb *)


(* Begin_Tex_Verb *)
Lemma ABSIR_strong_ext : (un_op_strong_ext ? ABSIR).
(* End_Tex_Verb *)
Unfold un_op_strong_ext.
Unfold fun_strong_ext.
Unfold ABSIR.
Intros.
Generalize (csbf_strext ??? Max); Intro.
Unfold bin_fun_strong_ext in H0.
Generalize (H0 ???? H); Intro.
Elim H1.
Intro.
Assumption.
Intro.
Apply zero_minus_apart.
Generalize (minus_ap_zero ??? H2); Intro.
Generalize (min_resp_ap_zero ?? H3); Intro.
Cut x[-]y [=] [--]([--]x[-][--]y).
Intro.
Step_ap_lft [--]([--]x[-][--]y).
Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma ABSIR_well_def : (un_op_well_def ? ABSIR).
(* End_Tex_Verb *)
Unfold un_op_well_def.
Apply fun_strong_ext_imp_well_def.
Exact ABSIR_strong_ext.
Qed.

(* Begin_Tex_Verb *)
Definition AbsIR := (Build_CSetoid_un_op ? ABSIR ABSIR_well_def ABSIR_strong_ext)
                 :  (CSetoid_un_op IR).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma abs_wdIR: (x,y:IR) (x[=]y)->(AbsIR x) [=] (AbsIR y).
(* End_Tex_Verb *)
Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma Abs_wd_lft_unfolded : (x,y,e:IR)(x[=]y) -> ((AbsIR x)[:<]e) ->
((AbsIR y)[:<]e).
(* End_Tex_Verb *)
Proof.
Intros.
Apply less_wdl with (AbsIR x).
Assumption.
Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma Abs_wd_rht_unfolded : (x,y,e:IR)(x[=]y) -> (e[:<](AbsIR x)) ->
(e[:<](AbsIR y)).
(* End_Tex_Verb *)
Proof.
Intros.
Apply less_wdr with (AbsIR x).
Assumption.
Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma AbsIRz_isz :(AbsIR Zero)[=]Zero.
(* End_Tex_Verb *)
Intros. Unfold AbsIR. Simpl. Unfold ABSIR.
Step_final (Max Zero Zero).
Qed.

End Absolute.

Hints Resolve AbsIRz_isz : algebra.

Tactic Definition Step_Abs_less_rht [$y] :=
  [<:tactic:<Apply Abs_wd_rht_unfolded with $y;
    [Idtac | Algebra] >>].
Tactic Definition Step_Abs_less_lft [$y] :=
  [<:tactic:<Apply Abs_wd_lft_unfolded with $y;
    [Idtac | Algebra] >>].

Tactic Definition Step_Rat_Abs_less_rht [$y] :=
  [<:tactic:<Apply Abs_wd_rht_unfolded with $y;
    [Idtac | Rational] >>].
Tactic Definition Step_Rat_Abs_less_lft [$y] :=
  [<:tactic:<Apply Abs_wd_lft_unfolded with $y;
    [Idtac | Rational] >>].

(* Begin_Tex_Verb *)
Lemma abs_eq_abssmall :(x,e:IR)([--]e [:<] x) -> (x [:<] e) ->
	(AbsSmall e x).
(* End_Tex_Verb *)
Intros.
Unfold absSmall.
Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma abs_eq_abssmall2 :(x,e:IR)(Zero[:<]e) -> ((AbsIR x) [:<] e) ->
	(AbsSmall e x).
(* End_Tex_Verb *)
Intros.
Unfold absSmall.
Simpl in H0.
Unfold ABSIR in H0.
Simpl in H0.
Split.
Generalize (rht_leEq_Max x [--]x).
Intro H1.
Generalize (leEq_less_trans ?? (MAX x [--]x) ? H1 H0).
Intro H2.
Step_Rat_less_rht [--][--]x.
Apply min_resp_less.
Assumption.
Generalize (lft_leEq_Max x [--]x).
Intro H1.
Generalize (leEq_less_trans ?? (MAX x [--]x) ? H1 H0).
Auto.
Qed.


