(* $Id: NRootIR.v,v 1.6 2000/11/07 16:04:08 janz Exp $ *)

Require Export OddPolyRootIR.

(* Tex_Prose
\section{Roots of Real Numbers}
*)

(* Tex_Prose
\subsection{roots exist}
*)

Section NRoot.

Variable n : nat.
Hypothesis n_pos : (lt (0) n).
Variable c : IR.
Hypothesis c_nonneg : Zero [:<=] c.

Local p := _X_[^]n[-](_C_ c).

(* Begin_Tex_Verb *)
Lemma nrootIR : (EX x | (Zero [:<=] x) /\ (x[^]n [=] c)).
(* End_Tex_Verb *)
Intros.
Cut (Monic n p). Intro.
Elim (cpoly_pos' ? p Zero n); Auto.
Intro X. Intros. Elim H0. Clear H0. Intros.
Cut (EX x | (Zero [:<=] x) /\ (x [:<=] X) /\ (p!x [=] Zero)). Intro.
Elim H2. Clear H2. Intros.
Elim H2. Clear H2. Intros. Elim H3. Clear H3. Intros.
Exists x. Split. Auto.
Apply cg_inv_unique_2.
Step (_X_!x)[^]n[-](_C_ c)!x.
Step (_X_[^]n)!x[-](_C_ c)!x.
Step_final (_X_[^]n[-](_C_ c))!x.
Apply ivt_poly; Auto.
Apply monic_apzero with n; Auto.
Unfold p.
Step_leEq_lft (_X_[^]n)!Zero[-](_C_ c)!Zero.
Step_leEq_lft (_X_!Zero)[^]n[-]c.
Step_leEq_lft Zero[^]n[-]c.
Step_leEq_lft Zero[-]c.
Step_leEq_lft [--]c.
Step_leEq_rht [--]Zero::IR. Apply min_resp_leEq. Auto.
Apply less_leEq. Auto.
Unfold p.
Apply Monic_minus with (0).
Apply Degree_le_c_.
Pattern 1 n. Replace n with (mult (1) n).
Apply Monic_nexp.
Apply Monic_x_.
Auto with arith.
Auto.
Qed.

End NRoot.


(**********************************************************************)
Section rootsExist.
(**********************************************************************)

(* Begin_Tex_Verb *)
(* nth roots exist *)
Lemma nroot': (x:IR)(k:nat)(Zero [:<=] x)->(lt O k)->
  (sig IR [y:IR]((Zero [:<=] y) /\ (y[^]k [=] x))).
(* End_Tex_Verb *)
Intros.
Apply ex_informative with P := [y:IR]((Zero [:<=] y) /\ (y[^]k [=] x)).
Elim (nrootIR k H0 x H). Intro y. Intros.
Exists y. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma nroot: (x:IR)(k:nat)(Zero [:<] x)->(lt O k)->
  (sig IR [y:IR]((Zero [:<=] y) /\ (y[^]k [=] x))).
(* End_Tex_Verb *)
Intros.
Apply nroot'; Auto.
Apply less_leEq. Auto.
Qed.

(* Begin_Tex_Verb *)
Definition nroot_fun [x:IR; k:nat; posx:(Zero [:<] x); posk:(lt O k)] : IR :=
  (proj1_sig ?? (nroot x k posx posk)).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nroot_power : (x:IR; k:nat; posx:(Zero [:<] x); posk:(lt O k))
  (nroot_fun x k posx posk)[^]k [=] x.
(* End_Tex_Verb *)
Intros.
Elim (proj2_sig ?? (nroot x k posx posk)).
Auto.
Qed.

Hints Resolve nroot_power : algebra.

(* Begin_Tex_Verb *)
Lemma nroot_pos : (x:IR; k:nat; posx:(Zero [:<] x); posk:(lt O k))
  Zero [:<] (nroot_fun x k posx posk).
(* End_Tex_Verb *)
Intros.
Cut Zero [:<=] (nroot_fun x k posx posk). Intro.
Cut ((nroot_fun x k posx posk) [:<] Zero) \/
  (Zero [:<] (nroot_fun x k posx posk)). Intro.
Elim H0; Clear H0; Intros. Elim (H H0). Auto.
Apply ap_imp_less.
Apply un_op_strext_unfolded with (nexp_op IR k).
Step_ap_lft x.
Step_ap_rht Zero::IR.
Apply Greater_imp_ap. Auto.
Elim (proj2_sig ?? (nroot x k posx posk)).
Intros.
Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma nroot_power' : (x:IR; k:nat; posxk:(Zero [:<] x[^]k); posk:(lt O k))
  (Zero [:<=] x) -> (nroot_fun (x[^]k) k posxk posk) [=] x.
(* End_Tex_Verb *)
Intros.
Apply root_unique with k.
Apply less_leEq. Apply nroot_pos.
Auto. Auto.
Apply nroot_power.
Qed.

(* Begin_Tex_Verb *)
Lemma nroot_pres_lt :
	(x,y:IR;k:nat;zltx:(Zero[:<]x);zlty:(Zero[:<]y);lt0k:(lt (0) k))
	(x[:<]y)->((nroot_fun x k zltx lt0k) [:<] (nroot_fun y k zlty lt0k)).
(* End_Tex_Verb *)
Intros.
Apply power_cancel_less with k.
Apply less_leEq. Apply nroot_pos.
Step_less_lft x. Step_less_rht y. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma nroot_pres_lt1 : (x:IR;k:nat;zltx:(Zero[:<]x);lt0k:(lt (0) k))
	(x[:<]One)->((nroot_fun x k zltx lt0k) [:<] One).
(* End_Tex_Verb *)
Intros.
Apply power_cancel_less with k.
Apply less_leEq. Apply pos_one.
Step_less_lft x. Step_less_rht One::IR. Auto.
Qed.

End rootsExist.

(**********************************************************************)
Section Square_root.
(**********************************************************************)

(* Tex_Prose
\subsection{square root}
*)

(* Begin_Tex_Verb *)
Definition sqrt [x:IR; xpos:(Zero [:<=] x)] : IR :=
  (proj1_sig ?? (nroot' x (2) xpos (lt_O_Sn (1)))).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma sqrt_sqr : (x:IR)(xpos:(Zero [:<=] x))((sqrt x xpos)[^](2) [=] x).
(* End_Tex_Verb *)
Intros.
Elim (proj2_sig ?? (nroot' x (2) xpos (lt_O_Sn (1)))).
Auto.
Qed.

Hints Resolve sqrt_sqr : algebra.

(* Begin_Tex_Verb *)
Lemma sqrt_nonneg : (x:IR)(xpos:(Zero [:<=] x))(Zero [:<=] (sqrt x xpos)).
(* End_Tex_Verb *)
Intros.
Elim (proj2_sig ?? (nroot' x (2) xpos (lt_O_Sn (1)))).
Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma sqrt_wd : (x,y:IR)(xpos:(Zero [:<=] x))(ypos:(Zero [:<=] y))
  (x [=] y)->((sqrt x xpos) [=] (sqrt y ypos)).
(* End_Tex_Verb *)
Intros.
Apply root_unique with (2).
Apply sqrt_nonneg. Apply sqrt_nonneg.
Auto.
Step x. Step_final y.
Qed.

Hints Resolve sqrt_wd : algebra_c.

(* Begin_Tex_Verb *)
Lemma sqrt_to_nonneg : (x:IR)(Zero [:<=] x)->(x2pos:(Zero [:<=] x[^](2)))
  ((sqrt x[^](2) x2pos) [=] x).
(* End_Tex_Verb *)
Intros.
Apply root_unique with (2).
Apply sqrt_nonneg. Auto. Auto.
Step_final x[^](2).
Qed.

(* Begin_Tex_Verb *)
Lemma sqrt_to_nonpos : (x:IR)(x [:<=] Zero)->(x2pos:(Zero [:<=] x[^](2)))
  ((sqrt x[^](2) x2pos) [=] [--]x).
(* End_Tex_Verb *)
Intros.
Apply root_unique with (2).
Apply sqrt_nonneg.
Step_leEq_lft [--]Zero::IR. Apply min_resp_leEq. Auto.
Auto.
Step x[^](2). Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma sqrt_mult : (x,y:IR)
  (xpos:(Zero [:<=] x))(ypos:(Zero [:<=] y))(xypos:(Zero [:<=] x[*]y))
    ((sqrt x[*]y xypos) [=] (sqrt x xpos)[*](sqrt y ypos)).
(* End_Tex_Verb *)
Intros.
Apply root_unique with (2).
Apply sqrt_nonneg.
Apply mult_resp_nonneg; Apply sqrt_nonneg.
Auto.
Step x[*]y.
Step (sqrt x xpos)[^](2)[*](sqrt y ypos)[^](2).
Rational.
Qed.

Hints Resolve sqrt_mult : algebra.

(* Begin_Tex_Verb *)
Lemma sqrt_mult_wd :
  (x,y,z:IR)(xpos:(Zero [:<=] x))(ypos:(Zero [:<=] y))(zpos:(Zero [:<=] z))
    (z [=] x[*]y) -> (sqrt z zpos) [=] (sqrt x xpos)[*](sqrt y ypos).
(* End_Tex_Verb *)
Intros.
Cut Zero [:<=] x[*]y. Intro.
Step_final (sqrt x[*]y H0).
Apply mult_resp_nonneg; Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma sqrt_less : (x,y:IR)(ypos:(Zero [:<=] y))
  (x[^](2) [:<] y)->(x [:<] (sqrt y ypos)).
(* End_Tex_Verb *)
Intros.
Apply power_cancel_less with (2).
Apply sqrt_nonneg.
Step_less_rht y. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma sqrt_less' : (x,y:IR)(ypos:(Zero [:<=] y))
  (x[^](2) [:<] y)->([--]x [:<] (sqrt y ypos)).
(* End_Tex_Verb *)
Intros.
Apply power_cancel_less with (2).
Apply sqrt_nonneg.
Step_Rat_less_lft x[^](2). Step_less_rht y. Auto.
Qed.

End Square_root.

Hints Resolve sqrt_wd : algebra_c.
Hints Resolve nroot_power nroot_power' : algebra.
Hints Resolve sqrt_sqr sqrt_mult : algebra.


Section Absolute_Props.

(* Properties of absolute values in IR *)

(* Begin_Tex_Verb *)
Lemma AbsIR_sqrt_sqr : (x:IR; xxpos:(Zero [:<=] x[^](2)))
  (AbsIR x) [=] (sqrt x[^](2) xxpos).
(* End_Tex_Verb *)
Intros. Unfold AbsIR. Simpl. Unfold ABSIR.
Apply equiv_imp_eq_max; Intros.
Apply power_cancel_less with (2).
Apply less_leEq.
Apply mult_cancel_less with Two::IR. Apply pos_two.
Step_Rat_less_lft x[+][--]x.
Step_Rat_less_rht y[+]y.
Apply plus_resp_less_both; Auto.
Step_less_lft One[*]x[*]x.
Step_Rat_less_lft x[^](2)[+]Zero.
Apply shift_plus_less'.
Step_Rat_less_rht (y[-]x)[*](y[-][--]x).
Apply mult_resp_pos.
Apply shift_zero_less_minus. Auto.
Apply shift_zero_less_minus. Auto.
Apply leEq_less_trans with (sqrt x[^](2) xxpos).
Apply power_cancel_leEq with (2). Auto.
Apply sqrt_nonneg.
Step_leEq_rht x[^](2).
Apply leEq_reflexive.
Auto.
Apply leEq_less_trans with (sqrt x[^](2) xxpos).
Apply power_cancel_leEq with (2). Auto.
Apply sqrt_nonneg.
Step_leEq_rht x[^](2).
Step_Rat_leEq_lft x[^](2).
Apply leEq_reflexive.
Auto.
Qed.

Hints Resolve AbsIR_sqrt_sqr : algebra.

(* Begin_Tex_Verb *)
Lemma abs_pres_multIR : (x,y:IR) (AbsIR (x[*]y)) [=] ((AbsIR x)[*](AbsIR y)).
(* End_Tex_Verb *)
Intros.
Step (sqrt (x[*]y)[^](2) (sqr_nonneg ? x[*]y)).
Cut Zero [:<=] x[^](2)[*]y[^](2). Intro.
Step (sqrt x[^](2)[*]y[^](2) H).
Step_final (sqrt x[^](2) (sqr_nonneg ? x))[*](sqrt y[^](2) (sqr_nonneg ? y)).
Apply mult_resp_nonneg; Apply sqr_nonneg.
Qed.

(* Begin_Tex_Verb *)
(* Cauchy-Schwartz for IR *)
Lemma triangle_IR: (x,y:IR) (AbsIR (x[+]y)) [:<=] ((AbsIR x)[+](AbsIR y)).
(* End_Tex_Verb *)
Intros.
Step_leEq_lft (sqrt (x[+]y)[^](2) (sqr_nonneg ? x[+]y)).
Step_leEq_rht (sqrt x[^](2) (sqr_nonneg ? x))[+](sqrt y[^](2) (sqr_nonneg ? y)).
Apply power_cancel_leEq with (2). Auto.
Step_leEq_lft Zero[+]Zero::IR. Apply plus_resp_leEq_both; Apply sqrt_nonneg.
Step_leEq_lft (x[+]y)[^](2).
Step_Rat_leEq_lft x[^](2)[+]y[^](2)[+]Two[*](x[*]y).
Step_Rat_leEq_rht (sqrt x[^](2) (sqr_nonneg (IR) x))[^](2)[+]
  (sqrt y[^](2) (sqr_nonneg (IR) y))[^](2)[+]
    Two[*]((sqrt x[^](2) (sqr_nonneg (IR) x))[*](sqrt y[^](2) (sqr_nonneg (IR) y))).
Apply plus_resp_leEq_both.
Step_leEq_rht x[^](2)[+]y[^](2). Apply leEq_reflexive.
Apply mult_resp_leEq_lft.
Apply power_cancel_leEq with (2). Auto.
Apply mult_resp_nonneg; Apply sqrt_nonneg.
Step_Rat_leEq_rht (sqrt x[^](2) (sqr_nonneg ? x))[^](2)[*]
  (sqrt y[^](2) (sqr_nonneg ? y))[^](2).
Step_leEq_rht x[^](2)[*]y[^](2).
Step_leEq_lft x[^](2)[*]y[^](2).
Apply leEq_reflexive.
Apply less_leEq. Apply pos_two.
Qed.

(* Begin_Tex_Verb *)
Lemma triangle_sumIR : (k,l:nat)(s:nat->IR)(le k (S l)) ->
  (AbsIR (Sum k l s)) [:<=] (Sum k l [i:nat](AbsIR (s i))).
(* End_Tex_Verb *)
Intros. Induction l; Intros.
Inversion H.
Unfold sum. Unfold sum1. Simpl.
Step_Rat_leEq_rht Zero::IR.
Step_leEq_rht (AbsIR Zero).
Apply eq_imp_leEq. Apply abs_wdIR. Rational.
Inversion H1.
Unfold sum. Unfold sum1. Simpl.
Step_Rat_leEq_rht (ABSIR (s (0))).
Apply eq_imp_leEq. Apply abs_wdIR. Rational.
Elim (le_lt_eq_dec k (S (S l))); Intros.
Apply leEq_wdl with (AbsIR (Sum k l s)[+](s (S l))).
Apply leEq_wdr with (Sum k l [i:nat](AbsIR (s i)))[+](AbsIR (s (S l))).
Apply leEq_transitive with (AbsIR (Sum k l s))[+](AbsIR (s (S l))).
Apply triangle_IR.
Apply plus_resp_leEq. Apply Hrecl. Auto with arith.
Apply eq_symmetric_unfolded.
Apply sum_last with f := [i:nat](AbsIR (s i)).
Apply abs_wdIR.
Apply eq_symmetric_unfolded. Apply sum_last.
Rewrite y.
Unfold sum. Unfold sum1. Simpl.
Step_Rat_leEq_rht Zero::IR.
Step_leEq_rht (AbsIR Zero).
Apply eq_imp_leEq. Apply abs_wdIR. Rational.
Auto.
Qed.

End Absolute_Props.


