(* $Id: R_CReals.v,v 1.8 2000/11/10 11:27:37 freek Exp $ *)

Require Export R_COrdField.
Require Export CReals.

(* Summary:
      1- R is archemaedian.
      2- Definition of limit of Cauchy sequences of R using modulus of 
	 convergence diagonalization.
      3- R is complete.
      4- R is a model of CReals.
*)


Section R_CReals.

Variable a_COrdField : COrdField.

Syntactic Definition R_as_COrdField' := (R_as_COrdField a_COrdField).
Syntactic Definition CS_seq_ONER' := (CS_seq_ONER a_COrdField).
Syntactic Definition CS_seq_ZEROR' := (CS_seq_ZEROR a_COrdField).

(*
Syntactic Definition R_as_CSetoid' := (R_as_CSetoid a_COrdField).
Syntactic Definition Rlt' := (Rlt a_COrdField).
Syntactic Definition Rlt_is_strictorder' :=  (Rlt_is_strictorder a_COrdField).

Syntactic Definition R_as_CField' := (R_as_CField a_COrdField).
Syntactic Definition Rplus_is_bin_fun' := (Rplus_is_bin_fun a_COrdField).
Syntactic Definition Rmult_is_bin_fun' := (Rmult_is_bin_fun a_COrdField).

Syntactic Definition ZEROR' := (ZEROR a_COrdField).
Syntactic Definition ONER' := (ONER a_COrdField).

Syntactic Definition R' := (R a_COrdField).
Syntactic Definition R_mul_as_CSemi_grp' := (R_mul_as_CSemi_grp a_COrdField).
Syntactic Definition Rmult_is_assoc' := (Rmult_is_assoc a_COrdField).
*)


 


Lemma CS_seq_identity:(x:a_COrdField)(Cauchy_prop [m:nat]x).
 Intro.
 Unfold Cauchy_prop.
 Intros.
 Exists O.
 Intros.
 Step_Rat_AbsSmall_rht Zero::a_COrdField.
 Split.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Assumption.
Qed.


Definition inject_Q:=[x:a_COrdField](Build_CauchySeq a_COrdField 
			  [m:nat]x (CS_seq_identity x))
                    : a_COrdField->(R_as_COrdField').


Lemma ing_eq:(x,y:a_COrdField)(x[=]y)->((inject_Q x)[=](inject_Q y)).
 Intros.
 Unfold inject_Q.
 Change (~((Build_CauchySeq a_COrdField [_:nat]x 
        (CS_seq_identity x))::R_as_COrdField'
      [#] (Build_CauchySeq a_COrdField [_:nat]y (CS_seq_identity y)))).
 Simpl.
 Apply Eq_alt_2_2.
 Intros.
 Simpl.
 Exists O.
 Intros.
 Step_AbsLSmall_rht Zero::a_COrdField.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
 Apply cg_cancel_rht with G:=(a_COrdField :: CGroup) a:=y.
 Step y.
 Step_final x.
 Rational.
Qed.


Lemma ing_plus:(x,y:a_COrdField)(inject_Q (x[+]y))[=]
		((inject_Q x)[+](inject_Q y)).
 Intros.
 Unfold inject_Q. 
 Change (~( (Build_CauchySeq a_COrdField [_:nat]x[+]y 
     (CS_seq_identity x[+]y))::R_as_COrdField'
      [#] (Build_CauchySeq a_COrdField [_:nat]x 
                    (CS_seq_identity x))::R_as_COrdField'
            [+](Build_CauchySeq a_COrdField [_:nat]y
                 (CS_seq_identity y)))).
 Simpl.
 Apply Eq_alt_2_2.
 Intros.
 Simpl.
 Exists O.
 Intros.
 Step_AbsLSmall_rht Zero::a_COrdField.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption. 
Qed.

Lemma ing_min : (x,y:a_COrdField)(inject_Q [--]x)[=]
	([--](inject_Q x)).
 Intros.
 Change (~((inject_Q [--]x)[#]
	([--]((inject_Q x))))).
 Unfold inject_Q.
 Simpl. 
 Apply Eq_alt_2_2.
 Intros.
 Simpl.
 Exists O.
 Intros.
 Step_AbsLSmall_rht Zero::a_COrdField.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption. 
Qed.

Lemma ing_lt:(x,y:a_COrdField)( x[:<]y)->((inject_Q x)[:<](inject_Q y)).
 Intros.
 Simpl. 
 Unfold Rlt.
 Exists ((y[-]x)[/]TwoNZ).
 Split.
 Apply mult_cancel_less with R:=a_COrdField z:=Two::a_COrdField.
 Apply pos_two.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht y[-]x.
 Apply shift_zero_less_minus.
 Assumption.
 Exists O.
 Intros.
 Unfold inject_Q.
 Unfold CS_seq.
 Apply plus_cancel_less with R:=a_COrdField z:=x[-](y[/]TwoNZ).
 Apply mult_cancel_less with R:=a_COrdField z:=Two::a_COrdField. 
 Apply pos_two.
 Step_Rat_less_lft x. 
 Step_Rat_less_rht y.
 Assumption.
Qed.
 
Lemma AbsLSmall_approach_zero:(OF:COrdField; x:(OF))
 ((e:(OF))(Zero [:<] e)->(AbsLSmall e x))->(x[=]Zero).
 Intros.
 Apply not_ap_imp_eq.
 Intro. 
 Cut ((x[:<]Zero)\/(Zero[:<]x)).
 Intro.
 Case H1.
 Change (~(x [:<] Zero)).
 Cut (~(Zero[:<][--]x)).
 Intro.
 Intro.
 Apply H2.
 Apply min_cancel_less.
 Step_Rat_less_lft x.
 Step_Rat_less_rht Zero::OF.
 Assumption.
 Apply approach_zero_weak.
 Intros.
 Apply min_cancel_leEq.
 Step_Rat_leEq_rht x.
 Cut (absLSmall OF e x).
 Intro.
 Elim H3.
 Intros.
 Assumption.
 Apply H.
 Assumption.
 Change (~(Zero [:<] x)).
 Apply approach_zero_weak.
 Intros.
 Cut (absLSmall OF e x).
 Intro.
 Elim H3.
 Intros.
 Assumption.
 Apply H.
 Assumption. 
 Apply ap_imp_less.
 Assumption.
Qed.



Lemma ing_cancel_eq_:(x,y:a_COrdField)((inject_Q x)[=](inject_Q y))->
 			(x[=]y).
 Intros.
 Cut ((e:(a_COrdField))
           (Zero [:<] e)
           ->(EX N:nat |
                (m:nat)
                 (le N m)
                 ->(absLSmall a_COrdField e
                     (CS_seq a_COrdField (inject_Q x)  m)
                       [-](CS_seq a_COrdField (inject_Q y) m)))).
 Intro.

 Apply cg_inv_unique_2.
 Apply AbsLSmall_approach_zero.
 Intros.
 Cut (EX N:nat |
             (m:nat)(le N m)->(absLSmall a_COrdField e
                  (CS_seq a_COrdField (inject_Q x) m)
                    [-](CS_seq a_COrdField (inject_Q y) m))).
 Intro.
 Case H2.
 Intros N1 H3.
 Change (absLSmall a_COrdField e
                  (CS_seq a_COrdField (inject_Q x) N1)
                    [-](CS_seq a_COrdField (inject_Q y) N1)).
 Apply H3.
 Constructor.
 Apply H0.
 Assumption.
 Intros.
 Apply Eq_alt_2_1.
 Assumption.
 Assumption.
Qed. 

Lemma ing_cancel_less:(x,y:a_COrdField)((inject_Q x)[:<](inject_Q y))->
 			(x[:<]y). 
 Intros.
 Cut (EX e:(a_COrdField) |
     (Zero [:<] e)
     /\(EX N:nat |
         (m:nat)
          (le N m)
           ->e
               [:<] (CS_seq a_COrdField (inject_Q y) m)
                      [-](CS_seq a_COrdField (inject_Q x) m))).
 Intro.
 Case H0.
 Intros e H1.
 Elim H1.
 Intros.
 Case H3.
 Intros N H4.

 Apply plus_cancel_less with R:=a_COrdField z:=[--]x.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht y[-]x.
 Apply less_transitive_unfolded with F:=a_COrdField y:=e.
 Assumption.
 Change (e[:<] (CS_seq a_COrdField (inject_Q y) N)
                    [-](CS_seq a_COrdField (inject_Q x) N)).
 Apply H4.
 Constructor.
 Assumption.
Qed.





Theorem expand_Q_R:(x:R_as_COrdField')(e:a_COrdField)
  (Zero [:<] e)
  ->((N:nat)((m:nat)(le N m)->(AbsSmall e[/]FourNZ 
		(CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N)))->
     ((m:nat)(le N m)->(AbsSmall (inject_Q e) 
      (inject_Q (CS_seq a_COrdField x m))[-]x))).     

 Intros.

 Split.
 Simpl.
 Unfold Rlt.
 Exists e[/]TwoNZ.
 Split.
 Apply pos_div_two.
 Assumption.
 
 Exists N.
 Intros.
 Change  (e[/]TwoNZ [:<] (CS_seq a_COrdField
             (inject_Q (CS_seq a_COrdField x m))[-]x m0)
             [-]([--]e)).
 Apply plus_cancel_less with R:=a_COrdField z:=[--]e.
 Step_Rat_less_lft [--](e[/]TwoNZ).
 Step_Rat_less_rht  (CS_seq a_COrdField
             (inject_Q (CS_seq a_COrdField x m))[-]x m0).
 Cut (absSmall a_COrdField e[/]FourNZ
            (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N)). 
 Intro.
 Elim H3.
 Intros.
 Cut (absSmall a_COrdField e[/]FourNZ
            (CS_seq a_COrdField x m0)[-](CS_seq a_COrdField x N)).
 Intro.
 Elim H6.
 Intros.
 Change ([--](e[/]TwoNZ)[:<] (CS_seq a_COrdField x m)
				[-](CS_seq a_COrdField x m0)).
 Step_Rat_less_lft ([--](e[/]FourNZ))[+]([--](e[/]FourNZ)).
 Step_Rat_less_rht ((CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N))
          [+]((CS_seq a_COrdField x N)[-](CS_seq a_COrdField x m0)).
 Apply plus_resp_less_both.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft (CS_seq a_COrdField x m0)[-](CS_seq a_COrdField x N).
 Step_Rat_less_rht e[/]FourNZ.
 Assumption.
 
 Apply H0.
 Assumption.
 Apply H0.
 Assumption.

 Simpl.
 Unfold Rlt.
 Exists e[/]TwoNZ.
 Split.
 Apply pos_div_two.
 Assumption.
 
 Exists N.
 Intros.
 Change  (e[/]TwoNZ [:<] e[-](CS_seq a_COrdField
             (inject_Q (CS_seq a_COrdField x m))[-]x m0)).
 Apply plus_cancel_less with R:=a_COrdField z:=[--]e.
 Step_Rat_less_lft [--](e[/]TwoNZ).
 Step_Rat_less_rht [--](CS_seq a_COrdField
             (inject_Q (CS_seq a_COrdField x m))[-]x m0).
 Apply min_resp_less.
 Cut (absSmall a_COrdField e[/]FourNZ
            (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N)). 
 Intro.
 Elim H3.
 Intros.
 Cut (absSmall a_COrdField e[/]FourNZ
            (CS_seq a_COrdField x m0)[-](CS_seq a_COrdField x N)).
 Intro.
 Elim H6.
 Intros.
 Change ((CS_seq a_COrdField x m)[-](CS_seq a_COrdField x m0)
		[:<]e[/]TwoNZ).
 Step_Rat_less_rht (e[/]FourNZ)[+](e[/]FourNZ).
 Step_Rat_less_lft ((CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N))
          [+]((CS_seq a_COrdField x N)[-](CS_seq a_COrdField x m0)).
 Apply plus_resp_less_both.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_rht (CS_seq a_COrdField x m0)[-](CS_seq a_COrdField x N).
 Assumption.
 
 Apply H0.
 Assumption.
 Apply H0.
 Assumption.
Qed.
 
Lemma conv_modulus:(x:R_as_COrdField';M:nat){N:nat|(m:nat)(le N m)
    	->(absSmall a_COrdField
        (One_div_succ M)
   	(CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N))}.
 Intros.
 Apply ex_informative with A:=nat 
		P:=[N:nat](m:nat)(le N m)->
	(absSmall a_COrdField
        (One_div_succ M)
   	(CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N)).
 Case x.
 Intros x_ px.
 Unfold Cauchy_prop in px.
 Cut (EX N:nat |
             (m:nat)
              (le N m)->(absSmall a_COrdField 
             	(One_div_succ M)
                 (x_ m)[-](x_ N))).
 Intro.
 Case H.
 Intros N H1.
 Exists N.
 Intros.
 Apply H1.
 Assumption.
 Apply px.
 Apply one_div_succ_pos.
Qed.


Lemma conv_modulus_1:(x:R_as_COrdField';M:nat;H:~(M=O))
	{N:nat|(m:nat)(le N m)
    	->(absSmall a_COrdField
        (One[/](Nring M)[//](nring_apart a_COrdField M O H))
   	(CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N))}.
 Intros.
 Apply ex_informative with A:=nat 
		P:=[N:nat](m:nat)(le N m)->
	(absSmall a_COrdField
   (One[/](Nring M)[//](nring_apart a_COrdField M O H))
   	(CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N)).
 Case x.
 Intros x_ px.
 Unfold Cauchy_prop in px.
 Cut (EX N:nat |
             (m:nat)
              (le N m)->(absSmall a_COrdField 
		 (One[/](Nring M)[//](nring_apart a_COrdField M O H))
                 (x_ m)[-](x_ N))).
 Intro.
 Case H0.
 Intros N H1.
 Exists N.
 Intros.
 Apply H1.
 Assumption.
 Apply px.
 Apply mult_cancel_less with R:=a_COrdField z:=(nring a_COrdField M).
 Apply nring_pos.
 Apply neq_O_lt.
 Intro.
 Apply H.
 Apply sym_eq.
 Assumption.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht One::a_COrdField.
 Apply pos_one.
Qed.

Definition T:=[x:R_as_COrdField'; m:nat](let (N,_)=(conv_modulus x m) in N).
Definition T_1:=[x:R_as_COrdField'; m:nat;H:~(m=O)]
                            (let (N,_)=(conv_modulus_1 x m H) in N).




Lemma ing_cancel_AbsSmall:(e,x,y:a_COrdField)(AbsSmall (inject_Q e)
	(inject_Q x)[-](inject_Q y))->(AbsSmall e x[-]y). 
 Intros.
 Elim H.
 Intros.
 Split.
 Apply ing_cancel_less.
 Step_less_lft [--](inject_Q e).
 Step_less_rht (inject_Q x)[-](inject_Q y).
 Assumption.
 Step (inject_Q x)[+]([--](inject_Q y)).
 Step (inject_Q x)[+](inject_Q [--]y).
 Apply plus_resp_eq.
 Apply eq_symmetric_unfolded.
 Apply ing_min.
 Exact e.
 Step_final (inject_Q (x[+]([--]y))).
 Apply eq_symmetric_unfolded.
 Apply ing_plus.
 Apply eq_symmetric_unfolded.
 Apply ing_min.
 Exact e.
 
 Apply ing_cancel_less.
 Step_less_lft (inject_Q x)[-](inject_Q y).
 Assumption.
 Step (inject_Q x)[+]([--](inject_Q y)).
 Step (inject_Q x)[+](inject_Q [--]y).
 Apply plus_resp_eq.
 Apply eq_symmetric_unfolded.
 Apply ing_min.
 Exact e.
 Step_final (inject_Q (x[+]([--]y))).
 Apply eq_symmetric_unfolded.
 Apply ing_plus.
Qed.

Lemma ing_One:(inject_Q One::a_COrdField)[=]One.
  Apply eq_symmetric_unfolded.
  Change ((Build_CauchySeq a_COrdField [_:nat]One CS_seq_ONER')
                   ::R_as_COrdField'[=]
     (Build_CauchySeq a_COrdField [_:nat]One (CS_seq_identity One))).
  Apply not_ap_imp_eq. 
  Simpl.
  Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Change  (absLSmall a_COrdField e One[-]One).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed.
 

Lemma ing_Nring:(n:nat)(nring R_as_COrdField' n)[=](inject_Q 
			(nring a_COrdField n)).
 Intros.
 Induction n.
 Simpl.
 Change (Zero[=](inject_Q Zero::a_COrdField)).
 Unfold inject_Q.
 Change ((Build_CauchySeq a_COrdField [_:nat]Zero CS_seq_ZEROR')
                   ::R_as_COrdField'[=]
     (Build_CauchySeq a_COrdField [_:nat]Zero (CS_seq_identity Zero))).
 Apply not_ap_imp_eq.
 Simpl.
 Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Change  (absLSmall a_COrdField e Zero[-]Zero).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
 
 Change ((nring R_as_COrdField' n)[+]One[=]
		(inject_Q (nring a_COrdField n)[+]One)).
 Step_final  (inject_Q (nring (a_COrdField) n))[+]One.
 Step  (inject_Q (nring (a_COrdField) n))[+](inject_Q One::a_COrdField).
 Apply plus_resp_eq.
 Apply eq_symmetric_unfolded.
 Exact ing_One.
 
 Apply eq_symmetric_unfolded.
 Apply ing_plus.
Qed.
 
 
Hypothesis a_COrdField_is_archemaedian:
           (x:a_COrdField)(Ex [n:nat](x[:<](Nring n))).

Theorem R_is_archemaedian:(x:R_as_COrdField')(Ex [n:nat](x [:<] (Nring n))).
 Intros.
 Case x.
 Intros x_ px.
 
 Cut  (Ex [K:a_COrdField]((K [#] Zero)/\
      (Ex [N:nat](m:nat)(le N m)->(AbsSmall K (x_ m))))).
 Intro.
 Case H.
 Intros K H0.
 Elim H0.
 Intros.
 Cut (Ex [n:nat](K[+]K[:<](Nring n))).   (* using that Q is Archemaedian *)
 Intro.
 Case H3.
 Intros n H4.
 Exists n.
 Apply less_transitive_unfolded with F:=R_as_COrdField' y:=(inject_Q K[+]K).
 Case H2.
 Intros N H5.
 Simpl.
 Unfold Rlt.
 Exists K.
 Split.
 Apply AbsSmall_pos with x:=(x_ N).
 Apply H5.
 Constructor.
 Exists N.
 Intros.
 Change (K [:<] (K[+]K)[-](x_ m)).
 Apply plus_cancel_less with R:=a_COrdField z:=[--]K[+](x_ m).
 Step_Rat_less_lft (x_ m).
 Step_Rat_less_rht K.
 Cut (absSmall a_COrdField K (x_ m)).
 Intro.
 Elim H7.
 Intros.
 Assumption.
 Apply H5.
 Assumption.
 Step_less_rht  (inject_Q (nring (a_COrdField) n)).
 Apply ing_lt.
 Assumption.
 Apply eq_symmetric_unfolded.
 Apply ing_Nring.

 (* Here we use Q_is_Archemaedian *)
 Apply a_COrdField_is_archemaedian.
 Apply CS_seq_bounded.
 Exact px.
Qed.

Definition PT:=[x:R_as_COrdField';M:nat](projP2 nat 
    [N:nat]((m:nat)
      (le N m)
      ->(absSmall a_COrdField (one_div_succ a_COrdField M)
          (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N)))
         (conv_modulus x M)).

Lemma modulus_property:(x:R_as_COrdField';M:nat) ((m0,m1:nat)
      (le (T x M)  m0)->(le (T x M) m1) 
      ->(absSmall a_COrdField Two[*](one_div_succ a_COrdField M)
          (CS_seq a_COrdField x m0)[-](CS_seq a_COrdField x m1))).
 Intros.
 Step_Rat_AbsSmall_lft
	(one_div_succ a_COrdField M)[+](one_div_succ a_COrdField M).
 Step_Rat_AbsSmall_rht 
	  ((CS_seq a_COrdField x m0)[-](CS_seq a_COrdField x (T x M)))
	[+]((CS_seq a_COrdField x (T x M))[-](CS_seq a_COrdField x m1)).
 Cut([N:nat]
   (m:nat)
    (le N m)
    ->(absSmall a_COrdField (one_div_succ a_COrdField M)
        (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N))
   (projP1 nat
     [N:nat]
      (m:nat)
       (le N m)
       ->(absSmall a_COrdField (one_div_succ a_COrdField M)
           (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N))
     (conv_modulus x M))). 
 Intro.
 Apply AbsSmall_plus.

 Apply H1.
 Assumption.
 
 Apply AbsSmall_minus.
 Apply H1.
 Assumption.
 Exact (PT x M).
Qed.




Lemma ing_mult:(x,y:a_COrdField)(inject_Q x[*]y)[=]
		(inject_Q x)[*](inject_Q y).
 Intros.
 Unfold inject_Q. 
 Apply not_ap_imp_eq.
 Simpl.
 Apply Eq_alt_2_2.
 Intros.
 Simpl.
 Exists O.
 Intros.
 Step_AbsLSmall_rht Zero::a_COrdField.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption. 
Qed.

Opaque R_as_COrdField.

Lemma ing_three:(x:a_COrdField)(inject_Q x)[/]ThreeNZ[=]
				(inject_Q x[/]ThreeNZ).
 Intros.
 Apply mult_cancel_lft with z:=Three::R_as_COrdField'.
 Apply Greater_imp_ap.
 Apply nring_pos.
 Apply lt_O_Sn.
 Step (inject_Q x).
 (* JZ: Removed Rational. *)
 Apply eq_symmetric_unfolded.
 Apply eq_transitive_unfolded with 
	y:=(inject_Q Three::a_COrdField)[*](inject_Q x[/]ThreeNZ).
 Apply mult_wd.
 Apply ing_Nring.
 Apply eq_reflexive_unfolded.
 Apply eq_transitive_unfolded with 
        y:=(inject_Q  Three[*](x[/]ThreeNZ)).
 Apply eq_symmetric_unfolded.
 Apply ing_mult.
 Apply ing_eq.
 Rational.
Qed.

Transparent R_as_COrdField.

Lemma modulus_property_2:(x:(R_as_COrdField'); M,m:nat)
  (le (T x M) m)->
  (absSmall a_COrdField (one_div_succ a_COrdField M)
     (CS_seq a_COrdField x m)
       [-](CS_seq a_COrdField x (T x M))).
 Intros.
 Cut([N:nat]
   (m:nat)
    (le N m)
    ->(absSmall a_COrdField (one_div_succ a_COrdField M)
        (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N))
   (projP1 nat
     [N:nat]
      (m:nat)
       (le N m)
       ->(absSmall a_COrdField (one_div_succ a_COrdField M)
           (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N))
     (conv_modulus x M))). 
 Intros.
 Apply H0.
 Assumption.
 Exact (PT x M). 
Qed.
 
 
Lemma expand_Q_R_2:(x:(R_as_COrdField'); e:(a_COrdField); N:nat)
 (Zero [:<] e)->
    ((m:nat)
      (le N m)
      ->(absSmall a_COrdField e[/]FourNZ
          (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x N)))
    ->(absSmall R_as_COrdField' (inject_Q e)
           (inject_Q (CS_seq a_COrdField x N))[-]x).
 Intros.
 Apply expand_Q_R with x:=x e:=e N:=N.
 Assumption.
 Intros.
 Apply H0.
 Assumption.
 Constructor.
Qed.



Lemma CS_seq_diagonal:(a: (CauchySeq R_as_COrdField'))(Cauchy_prop 
	[m:nat](CS_seq a_COrdField 
         (CS_seq R_as_COrdField' a m) (T (CS_seq R_as_COrdField' a m)  m))).
 Intros.
 Unfold Cauchy_prop.
 Case a.
 Intros a_ pa.
 Intros.
 Simpl.
 Unfold Cauchy_prop in pa.
 Cut (e[#]Zero).
 Intro.
 Cut (EX n:nat | (Twelve[/]e[//]H0)[-]One[:<] (nring (a_COrdField) n)).
 Intro.
 Case H1.
 Intros M H2.
 Cut (EX N:nat |
             (m:nat)
             (le N m)->(absSmall R_as_COrdField' (inject_Q e)[/]SixNZ 
              (a_ m)[-](a_ N))).
 Intro.
 Case H3.
 Intros N H4.
 
 Exists (plus N M). 
 Intros.

 Apply ing_cancel_AbsSmall.
 Step_Rat_AbsSmall_lft (((inject_Q e)[/]ThreeNZ)[+]((inject_Q e)[/]ThreeNZ))
			[+]((inject_Q e)[/]ThreeNZ).
 Step_Rat_AbsSmall_rht 
     ((inject_Q (CS_seq a_COrdField (a_ m) (T (a_ m) m)))[-](a_ m))
  [+]((a_ (plus N M))[-]
  (inject_Q (CS_seq a_COrdField (a_ (plus N M)) (T (a_ (plus N M)) 
   	(plus N M)))))[+]
  ((a_ m)[-](a_ (plus N M))).  
 Apply AbsSmall_plus.
 Apply AbsSmall_plus.
 
 Step_AbsSmall_lft (inject_Q e[/]ThreeNZ).
 Apply AbsSmall_trans with 
		 R:=R_as_COrdField' 
		 e1:=(inject_Q Four[*](one_div_succ a_COrdField m)). 
 Apply ing_lt.
 Apply leEq_less_trans with 
			R:=a_COrdField
			y:= Four[*](one_div_succ a_COrdField M).
 
 Apply mult_resp_leEq_lft.
 Apply One_div_succ_resp_leEq.
 Apply le_trans with m:=(plus N M).
 Rewrite plus_sym.
 Apply le_plus_l.
 Assumption. 
 Apply less_leEq.
 Apply nring_pos.
 Apply lt_O_Sn.

 Apply mult_cancel_less with R:=a_COrdField
			     z:=((Nring M)[+]One)[*]Three::a_COrdField. 
 Apply mult_resp_pos.
 Apply less_transitive_unfolded with F:=a_COrdField
			     y:=Twelve[/]e[//]H0.

 Apply mult_cancel_less with R:=a_COrdField z:=e.
 Assumption.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht Twelve::a_COrdField.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply plus_cancel_less with R:=a_COrdField z:=[--]One::a_COrdField.
 Step_Rat_less_lft  Twelve[/]e[//]H0[-]One.
 Step_Rat_less_rht (nring (a_COrdField) M).
 Exact H2.
 Apply nring_pos.
 Apply lt_O_Sn.

 Unfold one_div_succ.
 Unfold Snring.
 Change ((Four[*]  
       (One[/]((nring (a_COrdField) M)[+]One)
          [//](nring_ap_zero a_COrdField (S M)
                (sym_not_eq nat (0) (S M) (O_S M)))))
     [*](((nring (a_COrdField) M)[+]One)
           [*]Three)
      [:<] (e[/]ThreeNZ)
             [*](((nring (a_COrdField) M)[+]One)
                   [*]Three)).
 Step_Rat_less_lft Twelve::a_COrdField. 
 Step_Rat_less_rht e[*]((nring (a_COrdField) M)[+]One).
 Apply mult_cancel_less with R:=a_COrdField
			     z:=(One[/]e[//]H0).
 Apply recip_resp_pos. 
 Assumption.
 Step_Rat_less_rht ((nring (a_COrdField) M)[+]One). 
 Apply plus_cancel_less with R:=a_COrdField z:=[--]One::a_COrdField.
 Step_Rat_less_lft Twelve[/]e[//]H0[-]One.
 Step_Rat_less_rht  (nring (a_COrdField) M).
 Exact H2.

 Apply expand_Q_R_2 with x:=(a_ m) 
                   e:=Four[*](one_div_succ a_COrdField m) 
                   N:=(T (a_ m) m).
 
 Apply mult_resp_pos.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply one_div_succ_pos.
 
 Intros.
 Step_Rat_AbsSmall_lft (one_div_succ a_COrdField m).
 Apply modulus_property_2.
 Assumption.

 Apply eq_symmetric_unfolded.
 Apply ing_three.

 Step_AbsSmall_lft (inject_Q e[/]ThreeNZ).
 Apply AbsSmall_trans with 
		 R:=R_as_COrdField' 
		 e1:=(inject_Q Four[*](one_div_succ a_COrdField M)). 
 Apply ing_lt.

 Apply mult_cancel_less with R:=a_COrdField
			     z:=((Nring M)[+]One)[*]Three::a_COrdField. 
 Apply mult_resp_pos.
 Apply less_transitive_unfolded with F:=a_COrdField
			     y:=Twelve[/]e[//]H0.

 Apply mult_cancel_less with R:=a_COrdField z:=e.
 Assumption.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht Twelve::a_COrdField.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply plus_cancel_less with R:=a_COrdField z:=[--]One::a_COrdField.
 Step_Rat_less_lft  Twelve[/]e[//]H0[-]One.
 Step_Rat_less_rht (nring (a_COrdField) M).
 Exact H2.
 Apply nring_pos.
 Apply lt_O_Sn.

 Unfold one_div_succ.
 Unfold Snring.
 Change ((Four[*]  
       (One[/]((nring (a_COrdField) M)[+]One)
          [//](nring_ap_zero a_COrdField (S M)
                (sym_not_eq nat (0) (S M) (O_S M)))))
     [*](((nring (a_COrdField) M)[+]One)
           [*]Three)
      [:<] (e[/]ThreeNZ)
             [*](((nring (a_COrdField) M)[+]One)
                   [*]Three)).
 Step_Rat_less_lft Twelve::a_COrdField. 
 Step_Rat_less_rht e[*]((nring (a_COrdField) M)[+]One).
 Apply mult_cancel_less with R:=a_COrdField
			     z:=(One[/]e[//]H0).
 Apply recip_resp_pos. 
 Assumption.
 Step_Rat_less_rht ((nring (a_COrdField) M)[+]One). 
 Apply plus_cancel_less with R:=a_COrdField z:=[--]One::a_COrdField.
 Step_Rat_less_lft Twelve[/]e[//]H0[-]One.
 Step_Rat_less_rht  (nring (a_COrdField) M).
 Exact H2.

 Apply AbsSmall_minus.
 Apply expand_Q_R_2 with x:=(a_ (plus N M)) 
                   e:=Four[*](one_div_succ a_COrdField M) 
                   N:=(T (a_ (plus N M)) (plus N M)).
 
 Apply mult_resp_pos.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply one_div_succ_pos.
 
 Intros.
 Step_Rat_AbsSmall_lft (one_div_succ a_COrdField M).
 Apply AbsSmall_leEq_trans with 
			R:=a_COrdField
			e1:=(one_div_succ a_COrdField (plus N M)).
 Apply One_div_succ_resp_leEq.
 Rewrite plus_sym.
 Apply le_plus_l.
 Apply modulus_property_2.
 Assumption.

 Apply eq_symmetric_unfolded.
 Apply ing_three.

 Step_Rat_AbsSmall_lft  ((inject_Q e)[/]SixNZ)[+]((inject_Q e)[/]SixNZ).
 Step_Rat_AbsSmall_rht ((a_ m)[-](a_ N))[+]((a_ N)[-](a_ (plus N M))).
 Apply AbsSmall_plus.
 Apply H4.
 Apply le_trans with m:=(plus N M).
 Apply le_plus_l.
 Assumption.
 Apply AbsSmall_minus.
 Apply H4.
 Apply le_trans with m:=(plus N M).
 Apply le_plus_l.
 Constructor.
 
 Apply pa.
 
 Apply mult_cancel_less with R:=R_as_COrdField' z:=Six::R_as_COrdField'.
 Apply nring_pos.
 Apply lt_O_Sn.
 Step_Rat_less_lft Zero::R_as_COrdField'.
 Step_Rat_less_rht (inject_Q e).
 Change (inject_Q Zero::a_COrdField)[:<](inject_Q e).
 Apply ing_lt.
 Assumption.
 
 Apply a_COrdField_is_archemaedian.
 Apply Greater_imp_ap.
 Assumption.
Qed.

Definition LimR_CauchySeq:=[a:(CauchySeq R_as_COrdField')]
		(Build_CauchySeq a_COrdField
     [m:nat](CS_seq a_COrdField (CS_seq R_as_COrdField' a m)
      (T (CS_seq R_as_COrdField' a m) m)) (CS_seq_diagonal a)).


(*
Definition R_as_CReals_sig:=(!Build_CReals_sig R_as_COrdField' LimR_CauchySeq).
 *)

Opaque R_as_COrdField.

Lemma ing_n:(x:a_COrdField;n:nat;H1:(nring (a_COrdField) n)[#]Zero;
			H2:(nring R_as_COrdField' n)[#]Zero)
          (inject_Q x)[/](nring R_as_COrdField' n)[//]H2[=]
	  (inject_Q x[/](nring a_COrdField n)[//]H1).
 Intros.
 Apply mult_cancel_lft with z:=(inject_Q (nring a_COrdField n)). 
 Apply Greater_imp_ap.
 Step_less_rht (nring (R_as_COrdField') n).
 
 Apply nring_pos.
 Apply neq_O_lt.
 Apply nring_ap_zero_imp with a_COrdField.
 Assumption.
 
 Apply ing_Nring.

 Step (inject_Q x).
 Step  (nring (R_as_COrdField') n)[*]
		((inject_Q x)[/](nring (R_as_COrdField') n)[//]H2).
 Apply mult_wd.
 Apply eq_symmetric_unfolded.
 Apply ing_Nring.
 Apply eq_reflexive_unfolded.
 Rational.
 Apply eq_symmetric_unfolded.
 Apply eq_transitive_unfolded with 
        y:=(inject_Q  (nring a_COrdField n)[*]
		(x[/](nring (a_COrdField) n)[//]H1)).
 Apply eq_symmetric_unfolded.
 Apply ing_mult.
 Apply ing_eq.
 Rational.
Qed.

Transparent R_as_COrdField.



Lemma Q_dense_in_R : (x:R_as_COrdField')(Zero[:<]x)->
		(Ex [q:a_COrdField]((Zero[:<]q)/\((inject_Q q)[:<]x))).
 Intros.
 Cut (x[#]Zero).
 Intro.
 Cut (EX n:nat | (One[/]x[//]H0) [:<] (nring (R_as_COrdField') n)). 
 Intro.
 Case H1.
 Intros n H2.
 Cut ((nring a_COrdField n)[#]Zero).
 Intro.
 Exists (One[/](nring a_COrdField n)[//]H3).
 Split.
 Apply recip_resp_pos.
 Apply ing_cancel_less.
 Change (Zero[:<] (inject_Q (nring (a_COrdField) n))).
 Apply less_transitive_unfolded with 
			F:=R_as_COrdField'
			y:=(One[/]x[//]H0).
 Apply recip_resp_pos.
 Assumption.
 Step_less_rht (nring R_as_COrdField' n).
 Assumption.
 Apply ing_Nring.

 Cut ( (nring (R_as_COrdField') n) [#] Zero).
 Intro.
 Step_less_lft  (inject_Q One::a_COrdField)[/]
		(nring (R_as_COrdField') n)[//]H4.
 Apply mult_cancel_less with R:=R_as_COrdField' z:=(nring R_as_COrdField' n).
 Apply nring_pos.
 Apply neq_O_lt.
 Apply nring_ap_zero_imp with a_COrdField.
 Assumption.
 Step_Rat_less_lft (inject_Q One::a_COrdField).
 Step_less_lft One::R_as_COrdField'.
 Apply mult_cancel_less with R:=R_as_COrdField' z:=(One[/]x[//]H0).
 Apply recip_resp_pos.
 Assumption.
 Step_Rat_less_lft One[/]x[//]H0.
 Step_Rat_less_rht  (nring (R_as_COrdField') n).
 Assumption.
 Apply eq_symmetric_unfolded.
 Exact ing_One.
 Apply ing_n.
 
 Apply Greater_imp_ap.
 Apply less_transitive_unfolded with F:=R_as_COrdField'
				y:= One[/]x[//]H0.
 Apply recip_resp_pos.
 Assumption.
 Assumption.
 Apply Greater_imp_ap.
 Apply ing_cancel_less.
 Step_less_rht (nring (R_as_COrdField') n).
 Change (Zero[:<] (nring (R_as_COrdField') n)).
 Apply less_transitive_unfolded with F:=R_as_COrdField'
				y:= One[/]x[//]H0.
 Apply recip_resp_pos.
 Assumption.
 Assumption.
 
 Apply ing_Nring.
 Apply R_is_archemaedian.
 Apply Greater_imp_ap.
 Assumption.
Qed.
 
		

Theorem R_is_complete:(a:(CauchySeq R_as_COrdField'))
		(seqLimit R_as_COrdField' a (LimR_CauchySeq a)). 
 Intros.
 Simpl.
 Red.
 Case a.
 Intros a_ pa.
 Intros.
 Simpl.
 Cut (e[#]Zero).
 Intro.
 Cut (EX q:(a_COrdField) | (Zero [:<] q)/\((inject_Q q) [:<] e[/]ThreeNZ)). 
 Intro.
 Case H1.
 Intros q H2.
 Elim H2.
 Intros.
 Cut (q[#]Zero).
 Intro.

 Cut (EX n:nat | (Four[/]q[//]H5)[-]One [:<] (nring (a_COrdField) n)).
 Intro.
 Case H6.
 Intros M H7. 
 Unfold Cauchy_prop in pa.
 Cut (EX N:nat |
             (m:nat)
             (le N m)->(absSmall R_as_COrdField' e[/]SixNZ 
              (a_ m)[-](a_ N))).
 Intro.
 Case H8.
 Intros N2 H9.
 
 Cut (Cauchy_prop (LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa))). 
 Intro.
 Unfold Cauchy_prop in H10.
 
 Cut (EX N:nat |
             (m:nat)
              (le N m)
              ->(absSmall a_COrdField (q[/]EightNZ)
                  (CS_seq a_COrdField
                    (LimR_CauchySeq
                      (Build_CauchySeq R_as_COrdField' a_ pa)) m)
                    [-](CS_seq a_COrdField
                         (LimR_CauchySeq
                           (Build_CauchySeq R_as_COrdField' a_ pa)) N))).
 Intro.
 Case H11.
 Intros N1 H12.

 Exists (plus M (plus N1 N2)).
 Intros.
 
 Step_Rat_AbsSmall_lft (e[/]ThreeNZ)[+](e[/]ThreeNZ)[+](e[/]ThreeNZ).
 Step_Rat_AbsSmall_rht ((a_ m)[-](a_ (plus M (plus N1 N2))))[+]
        ((a_ (plus M (plus N1 N2)))[-]
   (inject_Q (CS_seq a_COrdField 
       (LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa)) 
             (plus M (plus N1 N2)))))[+]
   ((inject_Q (CS_seq a_COrdField 
       (LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa)) 
             (plus M (plus N1 N2))))[-]
     (LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa))).
 Apply AbsSmall_plus.
 Apply AbsSmall_plus.
 
 Step_Rat_AbsSmall_lft (e[/]SixNZ)[+](e[/]SixNZ).
 Step_Rat_AbsSmall_rht ((a_ m)[-](a_ N2))[+]((a_ N2)[-]
			(a_ (plus M (plus N1 N2)))).
 Apply AbsSmall_plus.
 Apply H9.
 Apply le_trans with m:=(plus M (plus N1 N2)).
 Rewrite plus_sym with m:=N2.
 Rewrite plus_permute with m:=N2.
 Apply le_plus_l.
 Assumption.
 
 Apply AbsSmall_minus.
 Apply H9.
 Apply le_trans with m:=(plus M (plus N1 N2)).
 Rewrite plus_sym with m:=N2.
 Rewrite plus_permute with m:=N2.
 Apply le_plus_l.
 Constructor.
 
 Apply AbsSmall_trans with R:=R_as_COrdField'
			   e1:=(inject_Q q).
 Assumption.
 Apply AbsSmall_minus.
 Simpl.

 Apply AbsSmall_trans  with R:=R_as_COrdField'
	e1:=Four[*](One_div_succ (plus M (plus N1 N2)))::R_as_COrdField'.

 Apply leEq_less_trans with 
			R:=R_as_COrdField'
			y:= Four[*](one_div_succ R_as_COrdField' M).
 
 Apply mult_resp_leEq_lft.
 Apply One_div_succ_resp_leEq.
 Apply le_plus_l.
 Apply less_leEq.
 Apply nring_pos.
 Apply lt_O_Sn.

 Apply mult_cancel_less with R:=R_as_COrdField'
			     z:=((Nring M)[+]One)::R_as_COrdField'. 

 Apply less_transitive_unfolded with F:=R_as_COrdField'
			     y:=(inject_Q Four[/]q[//]H5).
 Change ((inject_Q Zero::a_COrdField)[:<] (inject_Q Four[/]q[//]H5)).
 Apply ing_lt.

 Apply mult_cancel_less with R:=a_COrdField z:=q.
 Assumption.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht Four::a_COrdField.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply plus_cancel_less with R:=R_as_COrdField' z:=[--]One::R_as_COrdField'.
 Step_Rat_less_rht (nring (R_as_COrdField') M).
 Step_less_lft  (inject_Q Four[/]q[//]H5)[+]
		(inject_Q ([--](One))::a_COrdField).
 Step_less_lft (inject_Q  (Four[/]q[//]H5)[+]([--]One)).
 Step_less_rht (inject_Q  (nring (a_COrdField) M)).
 Apply ing_lt.
 Step_Rat_less_lft  (Four[/]q[//]H5)[-]One.
 Exact H7.
 Apply eq_symmetric_unfolded.
 Apply ing_Nring.
 Apply ing_plus.
 Apply plus_resp_eq.
 Step [--](inject_Q One::a_COrdField).
 Apply ing_min.
 Exact q.
 Step (Zero[-](inject_Q One::a_COrdField)).
 Step_final (Zero[-]One::R_as_COrdField').
 Apply cg_minus_wd.
 Apply eq_reflexive_unfolded.
 Exact ing_One.

 Unfold one_div_succ.
 Unfold Snring.
 Change ((Four[*]  
       (One[/]((nring (R_as_COrdField') M)[+]One)
          [//](nring_ap_zero R_as_COrdField' (S M)
                (sym_not_eq nat (0) (S M) (O_S M)))))
     [*]((nring (R_as_COrdField') M)[+]One)
      [:<] (inject_Q q)
             [*]((nring (R_as_COrdField') M)[+]One)).
                 
 Step_Rat_less_lft Four::R_as_COrdField'. 

 Step_less_rht (inject_Q q)[*](inject_Q ((nring (a_COrdField) M)[+]One)).
 Step_less_lft (inject_Q Four::a_COrdField).
 Step_less_rht (inject_Q q[*]((nring (a_COrdField) M)[+]One)).
 Apply ing_lt.
 Apply mult_cancel_less with R:=a_COrdField
			z:=(One[/]q[//]H5).
 Apply recip_resp_pos.
 Assumption.
 Step_Rat_less_lft  Four[/]q[//]H5.
 Step_Rat_less_rht ((nring (a_COrdField) M)[+]One).
 Apply plus_cancel_less with R:=a_COrdField z:=[--]One::a_COrdField.
 Step_Rat_less_lft (Four[/]q[//]H5)[-]One.
 Step_Rat_less_rht  (nring (a_COrdField) M).
 Exact H7.
 Apply ing_mult.
 Apply eq_symmetric_unfolded.
 Apply ing_Nring.
 Apply mult_wd.
 Apply ing_eq.
 Apply eq_reflexive_unfolded.
 Step (inject_Q (nring a_COrdField M))[+](inject_Q One::a_COrdField).
 Apply ing_plus.
 Step  (inject_Q (nring (a_COrdField) M))[+]One.
 Apply plus_resp_eq.
 Exact ing_One.
 Step One[+](inject_Q (nring (a_COrdField) M)).
 Step_final One[+] (nring (R_as_COrdField') M).
 Apply plus_resp_eq.
 Apply eq_symmetric_unfolded.
 Apply ing_Nring.

 Step_AbsSmall_lft (inject_Q  
		Four[*](one_div_succ a_COrdField (plus M (plus N1 N2)))).
 Apply expand_Q_R_2 with x:=(a_ (plus M (plus N1 N2)))
                 e:=Four[*](one_div_succ a_COrdField (plus M (plus N1 N2)))
                       N:=(T (a_ (plus M (plus N1 N2))) (plus M (plus N1 N2))).

 Apply mult_resp_pos.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply one_div_succ_pos.
 Intros.
 Step_Rat_AbsSmall_lft (one_div_succ a_COrdField (plus M (plus N1 N2))).
 Apply modulus_property_2.
 Assumption.
 Step (inject_Q Four::a_COrdField)[*]
   (inject_Q (one_div_succ a_COrdField (plus M (plus N1 N2)))). 
 Apply ing_mult.
 Step Four[*](inject_Q (one_div_succ a_COrdField (plus M (plus N1 N2)))).
 Apply mult_wd.
 Apply eq_symmetric_unfolded.
 Apply ing_Nring.
 Apply eq_reflexive_unfolded.
 Apply mult_wd.
 Apply eq_reflexive_unfolded.
 Unfold one_div_succ.
 Unfold Snring.
 Cut ((nring a_COrdField (S (plus M (plus N1 N2))))[#]Zero).
 Intro.
 Cut ((nring R_as_COrdField' (S (plus M (plus N1 N2))))[#]Zero). 
 Intro.
 Step   (inject_Q 
    (One[/](nring (a_COrdField) (S (plus M (plus N1 N2))))[//]H14)).
 
 Step_final  (One[/](nring (R_as_COrdField') (S (plus M (plus N1 N2))))[//]H15).
 Step (inject_Q One::a_COrdField)[/]
       (nring (R_as_COrdField') (S (plus M (plus N1 N2))))[//]H15.
 Apply eq_symmetric_unfolded.
 Apply ing_n.
 Apply div_wd.
 Exact ing_One.
 Apply eq_reflexive_unfolded.
Change (inject_Q One)[/](nring (R_as_COrdField') (S (plus M (plus N1 N2))))[//]H15
      [=] (inject_Q
            One
              [/](nring (a_COrdField) (S (plus M (plus N1 N2))))[//]H14).
Apply ing_n.
Change

   (inject_Q
     One[/](nring (a_COrdField) (S (plus M (plus N1 N2))))[//]H14)
      [=] (inject_Q One)
            [/](nring (R_as_COrdField') (S (plus M (plus N1 N2))))
                 [//](nring_ap_zero R_as_COrdField'
                       (S (plus M (plus N1 N2)))
                       (sym_not_eq nat (0) (S (plus M (plus N1 N2)))
                         (O_S (plus M (plus N1 N2))))).
Apply eq_symmetric_unfolded.
Apply ing_n.
(*
 Exact (nring_ap_zero R_as_COrdField' (S (plus M (plus N1 N2)))
                  (sym_not_eq nat (0) (S (plus M (plus N1 N2)))
                    (O_S (plus M (plus N1 N2))))).
 Exact (nring_ap_zero a_COrdField (S (plus M (plus N1 N2)))
                  (sym_not_eq nat (0) (S (plus M (plus N1 N2)))
                    (O_S (plus M (plus N1 N2))))). 
*)
Apply nring_ap_zero.
Auto with arith.
Apply nring_ap_zero.
Auto with arith.

Apply AbsSmall_trans with R:=R_as_COrdField'
 			e1:=(inject_Q q). 
 Assumption.
 Apply expand_Q_R_2 with 
		x:=(LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa))
                e:=q
                N:=(plus M (plus N1 N2)).
 Assumption.
 Intros.
 Step_Rat_AbsSmall_lft (q[/]EightNZ)[+](q[/]EightNZ).
 Step_Rat_AbsSmall_rht ( (CS_seq a_COrdField
   (LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa)) m0)[-]
     (CS_seq a_COrdField
   (LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa)) N1))[+]
  ((CS_seq a_COrdField
 (LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa)) N1)[-]
   (CS_seq a_COrdField
 (LimR_CauchySeq (Build_CauchySeq R_as_COrdField' a_ pa)) 
         (plus M (plus N1 N2)))).
 Apply AbsSmall_plus.
 Apply H12.
 Apply le_trans with m:= (plus M (plus N1 N2)).
 Rewrite plus_permute.
 Apply le_plus_l.
 Assumption.
 Apply AbsSmall_minus.
 Apply H12.
 Apply le_trans with m:= (plus M (plus N1 N2)).
 Rewrite plus_permute.
 Apply le_plus_l. 
 Constructor.
 
 Apply H10.
 Apply mult_cancel_less with R:=a_COrdField z:=Eight::a_COrdField.
 Apply nring_pos.
 Apply lt_O_Sn.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht q.
 Assumption.

 Apply CS_seq_diagonal with a:= (Build_CauchySeq R_as_COrdField' a_ pa).
 
 Apply pa.
 Apply mult_cancel_less with R:=R_as_COrdField' z:=Six::R_as_COrdField'.
 Apply nring_pos.
 Apply lt_O_Sn.
 Step_Rat_less_lft Zero::R_as_COrdField'.
 Step_Rat_less_rht e.
 Assumption. 
 
 Apply a_COrdField_is_archemaedian.
 
 Apply Greater_imp_ap.
 Assumption.
 Apply Q_dense_in_R.
 Apply mult_cancel_less with R:=R_as_COrdField' z:=Three::R_as_COrdField'.
 Apply nring_pos.
 Apply lt_O_Sn.
 Step_Rat_less_lft Zero::R_as_COrdField'.
 Step_Rat_less_rht e.
 Assumption. 
 
 Apply Greater_imp_ap.
 Assumption.
Qed.

Definition R_is_CReals:=(!Build_is_CReals R_as_COrdField' LimR_CauchySeq 
 		 R_is_complete R_is_archemaedian).

Definition R_as_CReals:=(!Build_CReals R_as_COrdField' LimR_CauchySeq 
	R_is_CReals).

End R_CReals.

Require Export Q_COrdField.

Definition Concrete_R := (R_as_CReals Q_as_COrdField Q_is_archemaedian) : CReals.
 
 
 
