(* $Id: R_CSemi_grp.v,v 1.8 2000/11/01 15:54:56 milad Exp $ *)

Require Export COrdFields. 
Load Transparent_algebra.

(* Summary:
      1- Some additoional operations on COrdField.
      2- Definition of R -set of reals- as the set of Cauchy sequences of Q.
         (based on the definitoin of CauchySeq in COrdFields.v)
      3- Definition of Order on R.
      4- Definitoin of Apartness in terms of Order.
      5- R is CSetoid.
      6- Giving alternative equivalent definitions for EqR (equality on R).
      7- Definition of pointwise addition of Cauchy sequences: Rplus.
      8- <R, Rplus, ZEROR> is CSemi-grp.
*)

Syntactic Definition Six :=(Nring (S (S (S (S (S (S O))))))).
Remark nonzero_Six:(R:COrdField) Six [#] Zero::R. 
Intro.
Apply pos_ap_zero.
Apply nring_pos.
Apply lt_O_Sn.
Qed.

Syntactic Definition SixNZ := Six [//] (nonzero_Six ?).


Syntactic Definition Eight:=
 (Nring (S (S (S (S (S (S (S (S O))))))))).

Remark nonzero_Eight:(R:COrdField) Eight [#] Zero::R. 
Intro.
Apply pos_ap_zero.
Apply nring_pos.
Apply lt_O_Sn.
Qed.

Syntactic Definition EightNZ := Eight [//] (nonzero_Eight ?).


Syntactic Definition Twelve :=
 (Nring (S (S (S (S (S (S (S (S (S (S (S (S O))))))))))))).

Remark nonzero_Twelve :(R:COrdField) Twelve [#] Zero::R. 
Intro.
Apply pos_ap_zero.
Apply nring_pos.
Apply lt_O_Sn.
Qed.

Syntactic Definition TwelveNZ := Twelve [//] (nonzero_Twelve ?).



Syntactic Definition Sixteen :=
 (Nring (S (S (S (S (S (S (S (S (S (S (S (S (S (S (S (S O))))))))))))))))).

Remark nonzero_Sixteen :(R:COrdField) Sixteen [#] Zero::R. 
Intro.
Apply pos_ap_zero.
Apply nring_pos.
Apply lt_O_Sn.
Qed.

Syntactic Definition SixteenNZ := Sixteen [//] (nonzero_Sixteen ?).


Definition absBig [R:COrdField;e,x:R]:Prop:= (Zero::R[:<]e)/\
			((e [:<] x)\/ (x [:<] [--]e)).

Syntactic Definition AbsBig := (absBig ?).


Lemma AbsBigSmall_minus: (R:COrdField;e1,e2,x1,x2:R)(e2 [:<] e1)->
		(AbsBig e1 x1)->(AbsSmall e2 x2)->(AbsBig (e1[-]e2) (x1[-]x2)).
 Intros.
 Unfold absBig.
 Split.

 Apply plus_cancel_less with z:=e2.
 Step_Rat_less_lft e2. 
 Step_Rat_less_rht e1.
 Assumption.

 Unfold absBig in H0.
 Elim H0.
 Intros.
 Case H3.
 
 Intro.
 Left.
 Unfold absSmall in H1.
 Elim H1.
 Intros.
 Step_Rat_less_lft e1[+]([--]e2).
 Step_Rat_less_rht x1[+]([--]x2).
 Apply plus_resp_less_both.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft x2.
 Step_Rat_less_rht e2.
 Assumption.

 Intro.
 Right.
 Unfold absSmall in H1.
 Elim H1.
 Intros.
 Step_Rat_less_rht [--]e1[+]e2.
 Step_Rat_less_lft x1[+]([--]x2).
 Apply plus_resp_less_both.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_rht x2.
 Step_Rat_less_lft [--]e2.
 Assumption.
Qed.
 
 
 (********************************************************************************)
Section absBig_wd_properties.
 (********************************************************************************)
Variable R:COrdField.
 
Lemma AbsBig_wd_rht:(rel_well_def_rht R AbsBig).
 Red.
 Intros.
 Unfold absBig.
 Unfold absBig in H.
 Elim H. 
 Intros.
 Split.
  
  Assumption.

  Case H2.
  
   Intro.
   Left.
   Apply less_wdr with F:=R y:=y.
   Assumption.
   Assumption.
   
   Intro.
   Right.
   Apply less_wdl with x:=y.
   Assumption.
   Assumption.
Qed.

Lemma AbsBig_wd_lft: (rel_well_def_lft R AbsBig).
 Red.
 Unfold absBig.
 Intros.
 Elim H.
 Intros.
 Split.
 
  Step_less_rht x.
  Assumption.

  Case H2.

   Intro.
   Left.
   Step_less_lft x.
   Assumption.
   
   Intro.
   Right.
   Step_less_rht [--]x.
   Assumption.
Qed.

Lemma AbsBig_wd_rht_unfolded:(x,y,z:R)(AbsBig x y)->(y[=]z)->(AbsBig x z).
 Proof AbsBig_wd_rht.

Lemma AbsBig_wd_lft_unfolded:(x,y,z:R)(AbsBig x y)->(x[=]z)->(AbsBig z y).
 Proof AbsBig_wd_lft.

End absBig_wd_properties. 

Tactic Definition Step_AbsBig_rht [$y] :=
  [<:tactic:<Apply AbsBig_wd_rht_unfolded with $y;
  [Idtac | Algebra] >>]. 


Tactic Definition Step_AbsBig_lft [$y] :=
  [<:tactic:<Apply AbsBig_wd_lft_unfolded with $y;
  [Idtac | Algebra] >>]. 


Tactic Definition Step_Rat_AbsBig_rht [$y] :=
  [<:tactic:<Apply AbsBig_wd_rht_unfolded with $y;
  [Idtac | Rational] >>]. 


Tactic Definition Step_Rat_AbsBig_lft [$y] :=
  [<:tactic:<Apply AbsBig_wd_lft_unfolded with $y;
  [Idtac | Rational] >>]. 


Definition absLSmall [R:COrdField;e,x:R]:Prop := ([--]e [:<=] x)/\(x [:<=] e). 

Syntactic Definition AbsLSmall :=(absLSmall ?).

Lemma AbsLSmall_plus :(R:COrdField; e1,e2,x1,x2:R)(AbsLSmall e1 x1)->
 	(AbsLSmall e2 x2)->(AbsLSmall (e1[+]e2) (x1[+]x2)).
 Intros R e1 e2 x1 x2.
 Unfold absLSmall.
 Intros.
 Split.
 Elim H.
 Intros.
 Elim H0.
 Intros.
 Step_Rat_leEq_lft ([--]e1)[+]([--]e2).
 Apply plus_resp_leEq_both.
 Assumption.
 Assumption.
 Elim H.
 Intros.
 Elim H0.
 Intros.
 Apply plus_resp_leEq_both.
 Assumption.
 Assumption.
Qed.

(*************************************************************)
Section absLSmall_wd_properties.
(*************************************************************)
Variable R:COrdField.    
 
Lemma AbsLSmall_wd_rht :(rel_well_def_rht R AbsLSmall).
 Red. 
 Intros.
 Unfold absLSmall.
 Unfold absLSmall in H.
 Split.
 Apply leEq_wdr with y:=y.
 Elim H.
 Intros.
 Assumption.
 Assumption.
 
 Apply leEq_wdl with x:=y.
 Elim H.
 Intros.
 Assumption.
 Assumption.
Qed.
 
Lemma AbsLSmall_wd_rht_unfolded :(x,y,z:R)(AbsLSmall x y)->(y[=]z)->
		(AbsLSmall x z).
Proof AbsLSmall_wd_rht.

Lemma AbsLSmall_wd_lft:(rel_well_def_lft R AbsLSmall).
 Red.
 Unfold absLSmall.
 Intros.
 Split.
 Apply leEq_wdl with x:=[--]x.
 Elim H.
 Intros.
 Assumption.
 Step Zero[-]x.
 Stepr Zero[-]z.
 Apply cg_minus_wd.
 Algebra.
 Assumption.
 
 Apply leEq_wdr with y:=x.
 Elim H.
 Intros.
 Assumption.
 Assumption.
Qed.

Lemma AbsLSmall_wd_lft_unfolded:(x,y,z:R)(AbsLSmall x y)->(x[=]z)->
	(AbsLSmall z y).
Proof AbsLSmall_wd_lft.

End absLSmall_wd_properties.



Tactic Definition Step_AbsLSmall_rht [$y] :=
  [<:tactic:<Apply AbsLSmall_wd_rht_unfolded with $y;
  [Idtac | Algebra] >>]. 


Tactic Definition Step_AbsLSmall_lft [$y] :=
  [<:tactic:<Apply AbsLSmall_wd_lft_unfolded with $y;
  [Idtac | Algebra] >>]. 


Tactic Definition Step_Rat_AbsLSmall_rht [$y] :=
  [<:tactic:<Apply AbsLSmall_wd_rht_unfolded with $y;
  [Idtac | Rational] >>]. 


Tactic Definition Step_Rat_AbsLSmall_lft [$y] :=
  [<:tactic:<Apply AbsLSmall_wd_lft_unfolded with $y;
  [Idtac | Rational] >>]. 

Section R_CSemi_grp.
Variable a_COrdField : COrdField.

Definition R:= (CauchySeq a_COrdField).


Definition Rlt:=[x,y:R](Ex [e:a_COrdField](Zero [:<] e)/\(Ex [N:nat](m:nat)
 (le N m) -> 
 (e [:<] (CS_seq a_COrdField y m) [-] (CS_seq a_COrdField x m)))).


Lemma Rlt_is_transitive:(transitive R Rlt).
Red.
Intros.
Red.
Red in H.
Red in H0.
Case H.
Intros e1 H1.
(*Case H1.
Intros N1 H2.*)
Case H0.
Intros e2 H3.
(*Case H3.
Intros N2 H4.*)
Exists (e1 [+] e2).
Split.
Step_less_lft (Zero::a_COrdField)[+](Zero::a_COrdField).
Apply plus_resp_less_both.
Elim H1.
Intros.
Assumption.
Elim H3.
Intros.
Assumption.
Cut ((EX N:nat |
            (m:nat)
             (le N m)
             ->e2
                  [:<] (CS_seq a_COrdField z m)
                         [-](CS_seq a_COrdField y m))).
Intros.
Case H2.
Intros N2 H3.
Cut ((EX N:nat |
            (m:nat)
             (le N m)
             ->e1
                  [:<] (CS_seq a_COrdField y m)
                         [-](CS_seq a_COrdField x m))).
Intros.
Case H5.
Intros N1 H6.
Exists (plus N1 N2).
Intros.
Cut (e2 [:<] (CS_seq a_COrdField z m) [-] (CS_seq a_COrdField y m)).
Intro.
Cut (e1 [:<] (CS_seq a_COrdField y m) [-] (CS_seq a_COrdField x m)).
Intro.
Step_Rat_less_rht 
 (((CS_seq a_COrdField y m) [-] (CS_seq a_COrdField x m))
      [+] ((CS_seq a_COrdField z m) [-] (CS_seq a_COrdField y m))).
Apply plus_resp_less_both.
Assumption.
Assumption.

Apply H6.
Apply le_trans with m:=(plus N1 N2).
Apply le_plus_l.
Assumption.

Apply H4.
Apply le_trans with m:=(plus N1 N2).
Apply le_plus_r.
Assumption.

Elim H1.
Intros.
Assumption.

Elim H3.
Intros.
Assumption.
Qed.

Lemma Rlt_is_irreflexive:(irreflexive Rlt).
Red.
Intro.
Unfold Rlt.
Intro.
Case H.
Intros e H0.
Cut (e [:<] Zero).
Change (~(e [:<] Zero)).
Apply less_antisymmetric_unfolded.
Elim H0.
Intros.
Assumption.
Elim H0.
Intros.
Case H2.
Intros N H3.
Cut ((m:nat)(le N m)->(e[:<]Zero)).
Intro.
Apply H4 with m:=N.
Trivial.
Intros.
Step_Rat_less_rht  (CS_seq a_COrdField x m)[-](CS_seq a_COrdField x m).
Apply H3.
Assumption.
Qed.

Lemma Rlt_is_antisymmetric:(antisymmetric Rlt).
Red.
Intros.
Intro.
Cut (Rlt x x).
Apply Rlt_is_irreflexive with x:=x.
Apply Rlt_is_transitive with x:=x y:=y z:=x.
Assumption.
Assumption.
Qed.

Definition Rlt_is_strictorder:=(!Build_strictorder R Rlt Rlt_is_transitive 
Rlt_is_antisymmetric).

Definition ap_R := [x,y:R](Rlt x y)\/(Rlt y x).

(* Now we define Equality on R in terms of apartness, weird? *)

Definition EqR :=[x,y:R]~(ap_R x y).

Lemma ap_R1:(!irreflexive R ap_R).
Red.
Intros.
Unfold ap_R.
Red.
Intros.
Elim H.
Change (~(Rlt x x)).
Apply Rlt_is_irreflexive.
Change (~(Rlt x x)).
Apply Rlt_is_irreflexive.
Qed.

Lemma ap_R2:(!symmetric R ap_R).
Red.
Intros x y.
Unfold ap_R.
Tauto.
Qed.

Theorem dec_Rlt:(x,y,z:R)(Rlt x z)->((Rlt x y)\/(Rlt y z)).
Intro x.
Case x.
Intros x_ px.
Intro y.
Case y.
Intros y_ py.
Intro z.
Case z.
Intros z_ pz.
Intro.
Unfold Rlt in H.
Unfold CS_seq in H.
Case H.
Intros e H.
Elim H0.
Intros.
Case H2.
Intros N H3.
Unfold Cauchy_prop in px.
Unfold Cauchy_prop in py.
Unfold Cauchy_prop in pz.
Cut ((EX N:nat |
             (m:nat)
              (le N m)->(absSmall a_COrdField e[/](TwelveNZ) 
                                  (x_ m)[-](x_ N)))).
Intro.
Cut ((EX N:nat |
             (m:nat)
              (le N m)->(absSmall a_COrdField e[/](TwelveNZ) 
  				  (y_ m)[-](y_ N)))).
Intro.
Cut ((EX N:nat |
             (m:nat)
              (le N m)->(absSmall a_COrdField e[/]TwelveNZ
 				  (z_ m)[-](z_ N)))).
Intro.
Case H4.
Intros N1 H41.
Case H5.
Intros N2 H51.
Case H6.
Intros N3 H61.
Cut (
((y_ (plus N (plus N1 (plus N2 N3)))) [:<] 
(z_  (plus N (plus N1 (plus N2 N3))) )[-] e[/]TwoNZ) \/
((x_  (plus N (plus N1 (plus N2 N3))) )[+] e[/]TwoNZ [:<]
(y_ (plus N (plus N1 (plus N2 N3)))))).
Intro.
Case H7.
Intro.
Right.
Unfold Rlt.
Exists e[/]SixNZ.
Split.

Apply mult_cancel_less with 
		R:=a_COrdField
		z:=Six::a_COrdField.
Apply nring_pos.
Apply lt_O_Sn.

Step_less_lft Zero::a_COrdField.
Step_Rat_less_rht e.
Assumption.

Exists (plus N (plus N1 (plus N2 N3))).

Cut ( (m:nat)
         (le(plus N (plus N1 (plus N2 N3)))  m)
         ->(absSmall a_COrdField
            e[/](nring (a_COrdField) (6))[//](nonzero_Six a_COrdField) 
	(y_ m)[-](y_ (plus N (plus N1 (plus N2 N3))) ))).
Intro H52.
Cut ( (m:nat)
         (le (plus N (plus N1 (plus N2 N3))) m)
         ->(absSmall a_COrdField
             e[/](nring (a_COrdField) (6))[//](nonzero_Six a_COrdField) 
	(z_ m)[-](z_ (plus N (plus N1 (plus N2 N3))) ))).
Intro H62.
Intro.
Intro.
Cut ((absSmall a_COrdField
             e
               [/](nring (a_COrdField) (6))
                    [//](nonzero_Six a_COrdField)
             (y_ m)[-](y_ (plus N (plus N1 (plus N2 N3)))))).
Intro H53.
Cut ((absSmall a_COrdField
             e
               [/](nring (a_COrdField) (6))
                    [//](nonzero_Six a_COrdField)
             (z_ m)[-](z_ (plus N (plus N1 (plus N2 N3)))))).
Intro H63.
Unfold CS_seq.
Apply min_cancel_less.
Step_Rat_less_lft ((y_ m)[-](z_ m)).
Apply plus_cancel_less with 
		R:=a_COrdField
		z:=e[/]TwoNZ.
Step_Rat_less_rht (e[/]SixNZ [+] e[/]SixNZ).
Apply less_transitive_unfolded with
                F:=a_COrdField
		y:=(((y_ m)[-](z_ m)) [+] 
                 ((z_ (plus N (plus N1 (plus N2 N3)))) 
                  [-] (y_ (plus N (plus N1 (plus N2 N3)))))).  

Apply plus_resp_less_lft.
Apply plus_cancel_less with 
		R:=a_COrdField
		z:=(y_ (plus N (plus N1 (plus N2 N3)))).
Apply plus_cancel_less with 
		R:=a_COrdField
		z:=[--]e[/]TwoNZ.
Step_Rat_less_lft (y_ (plus N (plus N1 (plus N2 N3)))).
Step_Rat_less_rht (z_ (plus N (plus N1 (plus N2 N3))))[-]e[/]TwoNZ.
Assumption.

Step_Rat_less_lft ( ((y_ m) [-] (y_ (plus N (plus N1 (plus N2 N3))))) [+]
                    ((z_ (plus N (plus N1 (plus N2 N3)))) [-] (z_ m)) ).
Apply plus_resp_less_both. 
Unfold absSmall in H53.
Elim H53.
Intros H54 H55.
Assumption.

Unfold absSmall in H63.
Elim H63.
Intros H64 H65.
Apply min_cancel_less.
Step_Rat_less_rht  (z_ m)[-](z_ (plus N (plus N1 (plus N2 N3)))).
Assumption.

Apply H62.
Assumption.
Apply H52.
Assumption.

Intros.

Apply AbsSmall_minus.
Step_Rat_AbsSmall_rht ( ((z_ (plus N (plus N1 (plus N2 N3)))) [-] (z_ N3))[+]
                      ((z_ N3) [-] (z_ m) )). 
Step_Rat_AbsSmall_lft ((e[/]TwelveNZ)[+](e[/]TwelveNZ)).
Apply AbsSmall_plus.
Apply H61.
Rewrite plus_sym with m:=N3.
Rewrite plus_permute with m:=N3.
Rewrite plus_permute with m:=N3.
Apply le_plus_trans.
Trivial.

Apply AbsSmall_minus.
Apply H61.
Apply le_trans with m:=(plus N (plus N1 (plus N2 N3))).
Rewrite plus_sym with m:=N3.
Rewrite plus_permute with m:=N3.
Rewrite plus_permute with m:=N3.
Apply le_plus_trans.
Trivial.

Assumption.


Intros.

Apply AbsSmall_minus.
Step_Rat_AbsSmall_rht ( ((y_ (plus N (plus N1 (plus N2 N3)))) [-] (y_ N2))[+]
                      ((y_ N2) [-] (y_ m) )). 
Step_Rat_AbsSmall_lft ((e[/]TwelveNZ)[+](e[/]TwelveNZ)).
Apply AbsSmall_plus.
Apply H51.
Rewrite plus_permute with m:=N2.
Rewrite plus_permute with m:=N2.
Apply le_plus_trans.
Trivial.

Apply AbsSmall_minus.
Apply H51.
Apply le_trans with m:=(plus N (plus N1 (plus N2 N3))).
Rewrite plus_permute with m:=N2.
Rewrite plus_permute with m:=N2.
Apply le_plus_trans.
Trivial.

Assumption.

Intro.
Left.
Unfold Rlt.
Exists e[/]SixNZ.
Split.

Apply mult_cancel_less with 
		R:=a_COrdField
		z:=Six::a_COrdField.
Apply nring_pos.
Apply lt_O_Sn.

Step_less_lft Zero::a_COrdField.
Step_Rat_less_rht e.
Assumption.

Exists (plus N (plus N1 (plus N2 N3))).

Cut ( (m:nat)
         (le(plus N (plus N1 (plus N2 N3)))  m)
         ->(absSmall a_COrdField
            e[/](nring (a_COrdField) (6))[//](nonzero_Six a_COrdField) 
	(y_ m)[-](y_ (plus N (plus N1 (plus N2 N3))) ))).
Intro H52.
Cut ( (m:nat)
         (le (plus N (plus N1 (plus N2 N3))) m)
         ->(absSmall a_COrdField
             e[/](nring (a_COrdField) (6))[//](nonzero_Six a_COrdField) 
	(x_ m)[-](x_ (plus N (plus N1 (plus N2 N3))) ))).
Intro H62.
Intro.
Intro.
Cut ((absSmall a_COrdField
             e
               [/](nring (a_COrdField) (6))
                    [//](nonzero_Six a_COrdField)
             (y_ m)[-](y_ (plus N (plus N1 (plus N2 N3)))))).
Intro H53.
Cut ((absSmall a_COrdField
             e
               [/](nring (a_COrdField) (6))
                    [//](nonzero_Six a_COrdField)
             (x_ m)[-](x_ (plus N (plus N1 (plus N2 N3)))))).
Intro H63.
Unfold CS_seq.
Apply min_cancel_less.
Step_Rat_less_lft ((x_ m)[-](y_ m)).
Apply plus_cancel_less with 
		R:=a_COrdField
		z:=e[/]TwoNZ.
Step_Rat_less_rht (e[/]SixNZ [+] e[/]SixNZ).
Apply less_transitive_unfolded with
                F:=a_COrdField
		y:=(((x_ m)[-](y_ m)) [+] 
                 ((y_ (plus N (plus N1 (plus N2 N3)))) 
                  [-] (x_ (plus N (plus N1 (plus N2 N3)))))).  

Apply plus_resp_less_lft.
Apply plus_cancel_less with 
		R:=a_COrdField
		z:=(x_ (plus N (plus N1 (plus N2 N3)))).
Step_Rat_less_rht  (y_ (plus N (plus N1 (plus N2 N3)))).
Step_Rat_less_lft  (x_ (plus N (plus N1 (plus N2 N3))))[+]e[/]TwoNZ.
Assumption.

Step_Rat_less_lft (x_ m)[-](x_ (plus N (plus N1 (plus N2 N3))))[+]
 		((y_ (plus N (plus N1 (plus N2 N3))))[-](y_ m)). 
Apply plus_resp_less_both.

Unfold absSmall in H63.
Elim H63.
Intros H64 H65.
Assumption.

Unfold absSmall in H53.
Elim H53.
Intros H54 H55.
Apply min_cancel_less.
Step_Rat_less_rht  (y_ m)[-](y_ (plus N (plus N1 (plus N2 N3)))).
Assumption.

Apply H62.
Assumption.
Apply H52.
Assumption.

Intros.

Apply AbsSmall_minus.
Step_Rat_AbsSmall_rht ( ((x_ (plus N (plus N1 (plus N2 N3)))) [-] (x_ N1))[+]
                      ((x_ N1) [-] (x_ m) )). 
Step_Rat_AbsSmall_lft ((e[/]TwelveNZ)[+](e[/]TwelveNZ)).
Apply AbsSmall_plus.
Apply H41.
Rewrite plus_permute with m:=N1.
Apply le_plus_trans.
Trivial.

Apply AbsSmall_minus.
Apply H41.
Apply le_trans with m:=(plus N (plus N1 (plus N2 N3))).
Rewrite plus_permute with m:=N1.
Apply le_plus_trans.
Trivial.

Assumption.


Intros.

Apply AbsSmall_minus.
Step_Rat_AbsSmall_rht ( ((y_ (plus N (plus N1 (plus N2 N3)))) [-] (y_ N2))[+]
                      ((y_ N2) [-] (y_ m) )). 
Step_Rat_AbsSmall_lft ((e[/]TwelveNZ)[+](e[/]TwelveNZ)).
Apply AbsSmall_plus.
Apply H51.
Rewrite plus_permute with m:=N2.
Rewrite plus_permute with m:=N2.
Apply le_plus_trans.
Trivial.

Apply AbsSmall_minus.
Apply H51.
Apply le_trans with m:=(plus N (plus N1 (plus N2 N3))).
Rewrite plus_permute with m:=N2.
Rewrite plus_permute with m:=N2.
Apply le_plus_trans.
Trivial.

Assumption.

Cut (((x_ (plus N (plus N1 (plus N2 N3))))[+]e[/]TwoNZ
         [:<] (y_ (plus N (plus N1 (plus N2 N3))))) \/
  ((y_ (plus N (plus N1 (plus N2 N3))))
       [:<] (z_ (plus N (plus N1 (plus N2 N3))))[-]e[/]TwoNZ)).
Intro.
Tauto.

Apply cotrans_less_unfolded.
Apply plus_cancel_less with
		R:=a_COrdField
		z:=e[/]TwoNZ.
Apply plus_cancel_less with
		R:=a_COrdField
		z:=[--](x_ (plus N (plus N1 (plus N2 N3)))).
Step_Rat_less_lft e.
Step_Rat_less_rht (z_ (plus N (plus N1 (plus N2 N3))))[-]
                  (x_ (plus N (plus N1 (plus N2 N3)))).
Apply H3.

Apply le_plus_trans.
Trivial.

Apply pz.


Apply mult_cancel_less with 
		R:=a_COrdField
		z:=Twelve::a_COrdField.
Apply nring_pos.
Apply lt_O_Sn.

Step_Rat_less_lft Zero::a_COrdField.
Step_Rat_less_rht e.
Assumption.


Apply py.


Apply mult_cancel_less with 
		R:=a_COrdField
		z:=Twelve::a_COrdField.
Apply nring_pos.
Apply lt_O_Sn.

Step_Rat_less_lft Zero::a_COrdField.
Step_Rat_less_rht e.
Assumption.

Apply px.


Apply mult_cancel_less with 
		R:=a_COrdField
		z:=Twelve::a_COrdField.
Apply nring_pos.
Apply lt_O_Sn.

Step_Rat_less_lft Zero::a_COrdField.
Step_Rat_less_rht e.
Assumption.

Qed.


Lemma ap_R3:(!cotransitive R ap_R).
Red.
Unfold ap_R.
Intros.
Case H.

Intro.
Case (dec_Rlt x z y H0). 
Intro.
Left.
Left.
Assumption.

Intro.
Right.
Left.
Assumption.

Intro.
Case (dec_Rlt y z x H0).
Intro.
Right.
Right.
Assumption.

Intro.
Left.
Right.
Assumption.

Qed.

Lemma ap_R4 :(!tight_apart R EqR ap_R).
 Red.
 Intros.
 Unfold EqR.
 Red.
 Split.
 Trivial.
 Trivial.
Qed.

(* 
(* properties of Equality *)
Theorem refl_equalR:(x:R)(EqR x x).
 Intro.
 Unfold EqR.
 Apply ap_R1.
Qed.

Theorem sym_equalR:(x,y:R)(EqR x y)->(EqR y x).
 Unfold EqR.
 Intros.
 Intro.
 Apply H.
 Apply ap_R2.
 Assumption.
Qed.

Theorem trans_equalR:(x,y,z:R)(EqR x y)->(EqR y z)->(EqR x z). 
 Intros.
 Intro.
 Cut ((ap_R x y)\/(ap_R y z)). 
 Intro.
 Case H2.
 Assumption.
 Assumption.
 Apply ap_R3.
 Assumption.
Qed.
*)


Definition ap_R_is_apartness := (!Build_is_CSetoid R EqR ap_R ap_R1 ap_R2 
 ap_R3 ap_R4).

Definition R_as_CSetoid := (!Build_CSetoid R EqR ap_R ap_R_is_apartness).

 

(* Here is slight alternation in definition of order on R - very slight! *)

Lemma Rlt_alt_1:(x,y: R)
(Ex [e:a_COrdField](Zero [:<] e)/\(Ex [N:nat](m:nat)
 (le N m) -> 
 (e [:<=] (CS_seq a_COrdField y m) [-] (CS_seq a_COrdField x m))))->
 (Rlt x y).
Intros.
Case H.
Intro e1.
Intros.
Elim H0.
Intros.
Case H2.
Intro N1.
Intros.
Unfold Rlt.
Exists (e1[/]TwoNZ).
Split.
Apply pos_div_two.
Assumption.
Exists N1.
Intros.
Apply less_leEq_trans with
		R:=a_COrdField
		y:=e1.
Apply mult_cancel_less with
		R:=a_COrdField
		z:=Two::a_COrdField.
Apply pos_two.

Step_Rat_less_lft e1[+]Zero::a_COrdField.
Step_Rat_less_rht e1[+]e1.
Apply plus_resp_less_lft.
Assumption.
Apply H3.
Assumption.
Qed.

Lemma Rlt_alt_2:(x,y:R)(Rlt x y)->
	(Ex [e:a_COrdField](Zero [:<] e)/\(Ex [N:nat](m:nat)(le N m) -> 
       (e [:<=] (CS_seq a_COrdField y m) [-] (CS_seq a_COrdField x m)))).
 Intros.
Unfold Rlt in H.
Case H.
Intro e.
Intros.
Elim H0.
Intros.
Case H2.
Intro N.
Intros.
Exists e.
Split.
Assumption.
Exists N.
Intros.
Change (~((CS_seq a_COrdField y m)[-](CS_seq a_COrdField x m)[:<]e)).
Apply less_antisymmetric_unfolded.
Apply H3.
Assumption.
Qed.


Lemma ap_R_alt_1: (x,y:R)(ap_R x y)->(Ex [e:a_COrdField](Zero[:<]e)/\
        (Ex [N:nat](m:nat)(le N m)->
	((CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m)[:<][--]e)\/
        (e[:<](CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m)))).
 Intros.
 Unfold ap_R in H.
 Case H.
 Intros.
 Unfold Rlt in H0.
 Case H0.
 Intro e1.
 Intros.
 Elim H1.
 Intros.
 Case H3.
 Intros N1 H31.
 Exists e1.
 Intros.
 Split.
 Assumption.
 Exists N1.
 Intros.
 Left.
 Apply min_cancel_less.
 Step_Rat_less_lft e1.
 Step_Rat_less_rht ((CS_seq a_COrdField y m)[-](CS_seq a_COrdField x m)).
 Apply H31.
 Assumption.
 Intros.
 Unfold Rlt in H0.
 Case H0.
 Intro e1.
 Intros.
 Elim H1.
 Intros.
 Case H3.
 Intros N1 H31.
 Exists e1.
 Intros.
 Split.
 Assumption.
 Exists N1.
 Intros.
 Right.
 Apply H31.
 Assumption. 
Qed.
 

Definition Rplus:=[x,y:R](!Build_CauchySeq a_COrdField 
	[m:nat]((CS_seq a_COrdField x m)[+](CS_seq a_COrdField y m))
        (CS_seq_plus a_COrdField 
		(CS_seq a_COrdField x) (CS_seq a_COrdField y)
		(CS_proof a_COrdField x) (CS_proof a_COrdField y)))
  :R->R->R. 
(*
Lemma ap_R_alt_2:(x,y:R)(Ex [e:a_COrdField](Zero[:<]e)/\
        (Ex [N:nat](m:nat)(le N m)->
	((CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m)[:<][--]e)\/
        (e[:<](CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m))))
	->(ap_R x y). 
*)




Lemma Eq_alt_1:(x,y:R;e:a_COrdField)(Zero [:<] e)->
~(Ex [N:nat](m:nat)(le N m)->(AbsBig e[/]FourNZ 
 (CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m)))->
 (Ex [N:nat](m:nat)(le N m)->(absLSmall a_COrdField e 
 (CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m))).

 Intros x y e H.
 Case x.
 Intros x_ px.
 Case y.
 Intros y_ py.
 Unfold CS_seq.
 Intro.
 Unfold Cauchy_prop in px.
 Unfold Cauchy_prop in py.
 Cut ((EX N:nat |
             (m:nat)
             (le N m)->(absSmall a_COrdField e[/]EightNZ (x_ m)[-](x_ N)))).
 Intros px1.
 Cut ((EX N:nat |
             (m:nat)
             (le N m)->(absSmall a_COrdField e[/]EightNZ (y_ m)[-](y_ N)))).
 Intro py1.
 Case px1.
 Intros N1 px2.
 Case py1.
 Intros N2 py2.
 Exists (plus N1 N2).
 Cut ( (m:nat)
	~((le (plus N1 N2) m)/\
	( (e[:<](x_ m)[-](y_ m))\/((x_ m)[-](y_ m)[:<][--]e)))).
 Intro.
 Intros.
 Cut (~((e [:<] (x_ m)[-](y_ m))\/((x_ m)[-](y_ m) [:<] [--]e))).
 Intro.
 Unfold absLSmall.
 Cut (~(e [:<] (x_ m)[-](y_ m))/\~((x_ m)[-](y_ m) [:<] [--]e)).
 Intro.
 Cut (~((x_ m)[-](y_ m) [:<] [--]e)/\ ~(e [:<] (x_ m)[-](y_ m))).
 Tauto.
 Tauto.
 Tauto.
 Intro.
 Cut (~((le (plus N1 N2) m)
        /\((e [:<] (x_ m)[-](y_ m))\/((x_ m)[-](y_ m) [:<] [--]e)))).
 Intros.
 Elim H4.
 Intros.
 Split.
 Assumption.
 Assumption.
 Apply H1.
 
 Intro.
 Intro.

 Apply deMorgan_ex_all with A:=nat a:=m X:=False
      	P:= [m:nat](le (plus N1 N2) m)/\
       ((e [:<] (x_ m)[-](y_ m))\/((x_ m)[-](y_ m) [:<] [--]e)).
 Intro.
 Cut ((m:nat)(le (plus N1 N2) m)->(absBig a_COrdField e[/]FourNZ
	 (x_ m)[-](y_ m))).
 Intro.
 Apply H0.
 Exists (plus N1 N2).
 Assumption.
 Intros.
 Unfold absBig.
 Split.

 (* TO prove that 0 < e/4 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Four::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)
 
 Cut (AbsBig e[/]TwoNZ (x_ m0)[-](y_ m0)). 
 Intros.
 Unfold absBig in H4.
 Elim H4.
 Intros.
 Case H6.
 Intros.
 Left.
 Apply less_transitive_unfolded with
	F:=a_COrdField
	y:=(e[/]TwoNZ).
  
  Apply mult_cancel_less with 
	  R:=a_COrdField
	  z:=Four::a_COrdField.
  Apply nring_pos.
  Apply lt_O_Sn.
  Step_Rat_less_lft e[+]Zero.
  Step_Rat_less_rht e[+]e.
  Apply plus_resp_less_lft.
  Assumption.
 
  Assumption.

 Intros.
 Right.
 Apply less_transitive_unfolded with
	F:=a_COrdField
	y:=[--](e[/]TwoNZ).
  Assumption.
  
  Apply mult_cancel_less with 
	  R:=a_COrdField
	  z:=Four::a_COrdField.
  Apply nring_pos.
  Apply lt_O_Sn.
  Step_Rat_less_rht [--](e[+]Zero).
  Step_Rat_less_lft [--](e[+]e).
  Apply min_cancel_less.
  Step_Rat_less_lft e[+]Zero.
  Step_Rat_less_rht e[+]e.
  Apply plus_resp_less_lft.
  Assumption.
 
 Step_Rat_AbsBig_lft (e[-](e[/]FourNZ))[-](e[/]FourNZ).
 Step_Rat_AbsBig_rht 
           (((x_ m)[-](y_ m))[-]((x_ m)[-](x_ m0)))[-]((y_ m0)[-](y_ m)).
 Apply AbsBigSmall_minus with R:=a_COrdField.
 Apply plus_cancel_less with 
	R:=a_COrdField
	z:=e[/]FourNZ.
 Step_Rat_less_lft e[/]TwoNZ.
 Step_Rat_less_rht e.
 Apply mult_cancel_less with
		R:=a_COrdField 
		z:=Two::a_COrdField.
 Apply pos_two.
 Step_Rat_less_lft e[+]Zero::a_COrdField.
 Step_Rat_less_rht e[+]e.
 Apply plus_resp_less_lft.
 Assumption.

 Apply AbsBigSmall_minus with R:=a_COrdField.
 Apply less_transitive_unfolded with
                F:=a_COrdField
                y:=e[/]TwoNZ.  
 Apply mult_cancel_less with
		R:=a_COrdField 
		z:=Two::a_COrdField.
 Apply pos_two.
 Step_Rat_less_lft e[/]TwoNZ.
 Step_Rat_less_rht e.
 Apply mult_cancel_less with
		R:=a_COrdField 
		z:=Two::a_COrdField.
 Apply pos_two.
 Step_Rat_less_lft e[+]Zero::a_COrdField.
 Step_Rat_less_rht e[+]e.
 Apply plus_resp_less_lft.
 Assumption.
 Apply mult_cancel_less with
		R:=a_COrdField 
		z:=Two::a_COrdField.
 Apply pos_two.
 Step_Rat_less_lft e[+]Zero::a_COrdField.
 Step_Rat_less_rht e[+]e.
 Apply plus_resp_less_lft.
 Assumption.

 Unfold absBig.
 Split.
 Assumption.
 Elim H1.
 Intros.
 Assumption.
 
 Step_Rat_AbsSmall_lft (e[/]EightNZ)[+](e[/]EightNZ).
 Step_Rat_AbsSmall_rht ((x_ m)[-](x_ N1))[+]((x_ N1)[-](x_ m0)).
 Apply AbsSmall_plus.
 Apply px2.
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_l.
 Elim H1.
 Intros.
 Assumption.

 Apply AbsSmall_minus.
 Apply px2.
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_l.
 Assumption.

  
 Step_Rat_AbsSmall_lft (e[/]EightNZ)[+](e[/]EightNZ).
 Step_Rat_AbsSmall_rht ((y_ m0)[-](y_ N2))[+]((y_ N2)[-](y_ m)).
 Apply AbsSmall_plus.
 Apply py2.
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_r.
 Assumption.

 Apply AbsSmall_minus.
 Apply py2.
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_r.
 Elim H1.
 Intros.
 Assumption.

 Assumption.

 Apply py.
 
 (* TO prove that 0 < e/8 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Eight::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)

 Apply px.
 
 (* TO prove that 0 < e/8 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Eight::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)
Qed.




Lemma ap_R_alt_2:(x,y:R)(Ex [e:a_COrdField](Zero[:<]e)/\
        (Ex [N:nat](m:nat)(le N m)->
	((CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m)[:<][--]e)\/
        (e[:<](CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m))))
        ->(ap_R x y).
 Intros x y.
 Case x.
 Intros x_ px.
 Case y.
 Intros y_ py.
 Unfold CS_seq.
 Unfold Cauchy_prop in px.
 Unfold Cauchy_prop in py.
 Intro.
 Case H.
 Intros e H1.
 Elim H1.
 Intros.
 Cut ((EX N:nat |
             (m:nat)
             (le N m)->(absSmall a_COrdField e[/]SixNZ (x_ m)[-](x_ N)))).
 Intro.
 Cut ((EX N:nat |
             (m:nat)
             (le N m)->(absSmall a_COrdField e[/]SixNZ (y_ m)[-](y_ N)))).
 Intro.
 Case H3.
 Intros N1 H31.
 Case H4.
 Intros N2 H41.
 Case H2.
 Intros N H21.
 Cut( ((x_ (plus N (plus N1 N2))) [-](y_  (plus N (plus N1 N2))) [:<] [--]e)
    \/(e [:<] (x_ (plus N (plus N1 N2)) )[-](y_ (plus N (plus N1 N2))))).
 Intro.
 Case H5.
 Intro.
 Unfold ap_R.


 Left.
 Unfold Rlt.
 Unfold CS_seq.
 Exists e[/]ThreeNZ.
 Split.
  
 (* TO prove that 0 < e/3 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Three::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)
 
 Exists (plus N (plus N1 N2)).
 Intros.
 Step_Rat_less_lft ([--]e[/]ThreeNZ)[+]e[+]([--]e[/]ThreeNZ).
 Step_Rat_less_rht ((y_ m)[-](y_ (plus N (plus N1 N2))))[+]
          ((y_ (plus N (plus N1 N2)))[-](x_ (plus N (plus N1 N2))))[+]
                   ((x_ (plus N (plus N1 N2)))[-](x_ m)).         
 Apply plus_resp_less_both.
 Apply plus_resp_less_both.
 
 Step_Rat_less_lft ([--]e[/]SixNZ)[+]([--]e[/]SixNZ).
 Step_Rat_less_rht ((y_ m)[-](y_ N2))[+]((y_ N2)[-](y_ (plus N (plus N1 N2)))).
 Apply plus_resp_less_both.
 Cut ((absSmall a_COrdField e[/](nring (a_COrdField) (6))
        [//](nonzero_Six a_COrdField) (y_ m)[-](y_ N2))).
 Intro.
 Unfold absSmall in H8.
 Elim H8.
 Intros.
 Step_Rat_less_lft [--](e[/]SixNZ).
 Assumption.
 
 Apply H41.
 Apply le_trans with  m:=(plus N (plus N1 N2)).
 Rewrite plus_sym with n:=N1.
 Rewrite plus_permute with m:=N2.
 Apply le_plus_l.
 Assumption.

 Cut((absSmall a_COrdField e[/]SixNZ (y_ N2)[-](y_ (plus N (plus N1 N2))))). Intro.
 Unfold absSmall in H8.
 Elim H8.
 Intros.
 Step_Rat_less_lft [--](e[/]SixNZ).
 Assumption.

 Apply AbsSmall_minus.
 Apply H41.
 Rewrite plus_sym with n:=N1.
 Rewrite plus_permute with m:=N2.
 Apply le_plus_l.

 (* e *)
 Apply min_cancel_less.
 Step_Rat_less_lft ((x_ (plus N (plus N1 N2)))[-](y_ (plus N (plus N1 N2)))).
 Assumption.
 (* e *)
 
 Step_Rat_less_lft ([--]e[/]SixNZ)[+]([--]e[/]SixNZ).
 Step_Rat_less_rht ((x_ (plus N (plus N1 N2)))[-](x_ N1))[+]((x_ N1)[-](x_ m)).
 Apply plus_resp_less_both.
 Cut((absSmall a_COrdField e[/]SixNZ (x_ (plus N (plus N1 N2)))[-](x_ N1))). 
 Intro.
 Unfold absSmall in H8.
 Elim H8.
 Intros.
 Step_Rat_less_lft [--](e[/]SixNZ).
 Assumption.

 Apply H31.
 Rewrite plus_permute with m:=N1.
 Apply le_plus_l.


 Cut ((absSmall a_COrdField e[/](nring (a_COrdField) (6))
        [//](nonzero_Six a_COrdField) (x_ N1)[-](x_ m))).
 Intro.
 Unfold absSmall in H8.
 Elim H8.
 Intros.
 Step_Rat_less_lft [--](e[/]SixNZ).
 Assumption.
 
 Apply AbsSmall_minus.
 Apply H31.
 Apply le_trans with  m:=(plus N (plus N1 N2)).
 Rewrite plus_permute with m:=N1.
 Apply le_plus_l.
 Assumption.

 Intro.
 Unfold ap_R.


 Right.
 Unfold Rlt.
 Unfold CS_seq.
 Exists e[/]ThreeNZ.
 Split.
  
 (* TO prove that 0 < e/3 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Three::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)
 
 Exists (plus N (plus N1 N2)).
 Intros.
 Step_Rat_less_lft ([--]e[/]ThreeNZ)[+]e[+]([--]e[/]ThreeNZ).
 Step_Rat_less_rht ((x_ m)[-](x_ (plus N (plus N1 N2))))[+]
          ((x_ (plus N (plus N1 N2)))[-](y_ (plus N (plus N1 N2))))[+]
                   ((y_ (plus N (plus N1 N2)))[-](y_ m)).         
 Apply plus_resp_less_both.
 Apply plus_resp_less_both.
 
 Step_Rat_less_lft ([--]e[/]SixNZ)[+]([--]e[/]SixNZ).
 Step_Rat_less_rht ((x_ m)[-](x_ N1))[+]((x_ N1)[-](x_ (plus N (plus N1 N2)))).
 Apply plus_resp_less_both.
 Cut ((absSmall a_COrdField e[/](nring (a_COrdField) (6))
        [//](nonzero_Six a_COrdField) (x_ m)[-](x_ N1))).
 Intro.
 Unfold absSmall in H8.
 Elim H8.
 Intros.
 Step_Rat_less_lft [--](e[/]SixNZ).
 Assumption.
 
 Apply H31.
 Apply le_trans with  m:=(plus N (plus N1 N2)).
 Rewrite plus_permute with m:=N1.
 Apply le_plus_l.
 Assumption.

 Cut((absSmall a_COrdField e[/]SixNZ (x_ N1)[-](x_ (plus N (plus N1 N2))))). 
 Intro.
 Unfold absSmall in H8.
 Elim H8.
 Intros.
 Step_Rat_less_lft [--](e[/]SixNZ).
 Assumption.

 Apply AbsSmall_minus.
 Apply H31.
 Rewrite plus_permute with m:=N1.
 Apply le_plus_l.

 (* e *)
 Assumption.
 (* e *)
 
 Step_Rat_less_lft ([--]e[/]SixNZ)[+]([--]e[/]SixNZ).
 Step_Rat_less_rht ((y_ (plus N (plus N1 N2)))[-](y_ N2))[+]((y_ N2)[-](y_ m)).
 Apply plus_resp_less_both.
 Cut((absSmall a_COrdField e[/]SixNZ (y_ (plus N (plus N1 N2)))[-](y_ N2))). 
 Intro.
 Unfold absSmall in H8.
 Elim H8.
 Intros.
 Step_Rat_less_lft [--](e[/]SixNZ).
 Assumption.

 Apply H41.
 Rewrite plus_sym with n:=N1.
 Rewrite plus_permute with m:=N2.
 Apply le_plus_l.


 Cut ((absSmall a_COrdField e[/](nring (a_COrdField) (6))
        [//](nonzero_Six a_COrdField) (y_ N2)[-](y_ m))).
 Intro.
 Unfold absSmall in H8.
 Elim H8.
 Intros.
 Step_Rat_less_lft [--](e[/]SixNZ).
 Assumption.
 
 Apply AbsSmall_minus.
 Apply H41.
 Apply le_trans with  m:=(plus N (plus N1 N2)).
 Rewrite plus_sym with n:=N1.
 Rewrite plus_permute with m:=N2.
 Apply le_plus_l.
 Assumption.
 
 
 Apply H21.
 Apply le_plus_l.

 Apply py.
   
 (* TO prove that 0 < e/6 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Six::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)

 Apply px.
 
  
 (* TO prove that 0 < e/3 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Six::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)
Qed.  


 
Lemma Eq_alt_2_1:(x,y:R)~(ap_R x y)->((e:a_COrdField)
		(Zero [:<] e)->(Ex [N:nat](m:nat)(le N m)->
		(absLSmall a_COrdField e 
	(CS_seq a_COrdField x m) [-](CS_seq a_COrdField y m)))).
 Intros.
 Apply Eq_alt_1.
 Assumption.

 Intro.
 Apply H.
 Apply ap_R_alt_2.
 Exists e[/]FourNZ.
 Split.
(* TO prove that 0 < e/4 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Four::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *) 
 Case H1.
 Intros N H2.
 Exists N.
 Intros.
 Cut ((absBig a_COrdField e[/]FourNZ
            (CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m))).
 Intro.
 Unfold absBig in H4.
 Elim H4.
 Intros.
 Tauto.
 
 Apply H2.
 Assumption.
Qed.

Lemma Eq_alt_2_2:(x,y:R)((e:a_COrdField)
		(Zero [:<] e)->(Ex [N:nat](m:nat)(le N m)->
		(absLSmall a_COrdField e 
	(CS_seq a_COrdField x m) [-](CS_seq a_COrdField y m))))
        ->~(ap_R x y).

 Intros.
 Intro.
 Cut ((EX e:(a_COrdField) |
      (Zero [:<] e)
      /\(EX N:nat |(m:nat)(le N m)
            ->((CS_seq a_COrdField x m)
                 [-](CS_seq a_COrdField y m) [:<] [--]e)
              \/(e [:<] 
	      (CS_seq a_COrdField x m)[-](CS_seq a_COrdField y m))))).
 Intro.
 Case H1.
 Intros e H2.
 Elim H2.
 Intros.
 Cut ((EX N:nat |
            (m:nat)
             (le N m)
             ->(absLSmall a_COrdField e
                 (CS_seq a_COrdField x m)
                   [-](CS_seq a_COrdField y m)))).
 Intro.
 Case H4.
 Intros N1 H41.
 Case H5.
 Intros N2 H51.
 Cut (((CS_seq a_COrdField x (plus N1 N2))
    [-](CS_seq a_COrdField y (plus N1 N2))
               [:<] [--]e)
           \/(e
                 [:<] (CS_seq a_COrdField x (plus N1 N2))
                        [-](CS_seq a_COrdField y (plus N1 N2)))).
 Intro.
 Cut ((absLSmall a_COrdField e
	    (CS_seq a_COrdField x (plus N1 N2))[-]
            (CS_seq a_COrdField y (plus N1 N2)))).
 Intro.
 Unfold absLSmall in H7.
 Change (~( (CS_seq a_COrdField x (plus N1 N2))
                   [-](CS_seq a_COrdField y (plus N1 N2))[:<][--]e)/\
         ~(e[:<] (CS_seq a_COrdField x (plus N1 N2))
                   [-](CS_seq a_COrdField y (plus N1 N2)))) in H7.
 Cut(~( ((CS_seq a_COrdField x (plus N1 N2))
          [-](CS_seq a_COrdField y (plus N1 N2)) [:<] [--]e)
       \/(e
             [:<] (CS_seq a_COrdField x (plus N1 N2))
                    [-](CS_seq a_COrdField y (plus N1 N2))))).
 Intro.
 Apply H8.
 Assumption.
 Tauto.
 
 Apply H51.
 Apply le_plus_r.
 
 Apply H41.
 Apply le_plus_l.
 
 Apply H.
 Assumption.
 
 Apply ap_R_alt_1.
 Assumption.
Qed.
 
 




Theorem Rplus_is_well_defined : (bin_fun_well_def R_as_CSetoid R_as_CSetoid 
 R_as_CSetoid Rplus).
 
 Red.
 Intros.
 Simpl.
Red.

 Apply Eq_alt_2_2.
 Intros.
 Simpl.
 Change ( (EX N:nat |
      (m:nat)
       (le N m)
       ->(absLSmall a_COrdField e
           ((CS_seq a_COrdField x1 m)[+]
             (CS_seq a_COrdField y1 m))
             [-]((CS_seq a_COrdField x2 m)[+]
                  (CS_seq a_COrdField y2 m))))).
 Cut ((EX N:nat |
         (m:nat)
          (le N m)
          ->(absLSmall a_COrdField e[/]TwoNZ
              (CS_seq a_COrdField x1 m)[-](CS_seq a_COrdField x2 m)))).
 Intro.
 Cut ((EX N:nat |
         (m:nat)
          (le N m)
          ->(absLSmall a_COrdField e[/]TwoNZ
              (CS_seq a_COrdField y1 m)[-](CS_seq a_COrdField y2 m)))).
 Intro.
 Case H2.
 Intros N1 H21.
 Case H3.
 Intros N2 H31.
 Exists (plus N1 N2).
 Intros.
 Cut ((absLSmall a_COrdField e[/]TwoNZ
             (CS_seq a_COrdField x1 m)[-](CS_seq a_COrdField x2 m))).
 Intro.
 Cut ((absLSmall a_COrdField e[/]TwoNZ
             (CS_seq a_COrdField y1 m)[-](CS_seq a_COrdField y2 m))).
 Intro.
 Step_Rat_AbsLSmall_lft (e[/]TwoNZ)[+](e[/]TwoNZ).
 Step_Rat_AbsLSmall_rht  
 ((CS_seq a_COrdField x1 m)[-](CS_seq a_COrdField x2 m))[+]
 ((CS_seq a_COrdField y1 m)[-](CS_seq a_COrdField y2 m)).
 Apply AbsLSmall_plus.
 Assumption.
 Assumption.
 Apply H31.
 
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_r.
 Assumption.

 Apply H21.
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_l.
 Assumption.
 
 Apply Eq_alt_2_1.
 Assumption.
 Apply pos_div_two.
 Assumption.
 Apply Eq_alt_2_1.
 Assumption.
 Apply pos_div_two.
 Assumption.
Qed.





Theorem Rplus_is_extensional:(bin_fun_strong_ext R_as_CSetoid R_as_CSetoid 
	R_as_CSetoid Rplus).
 Red.
 Intros x1 x2 y1 y2.
 Case x1.
 Intros x1_ px1.
 Case x2.
 Intros x2_ px2.
 Case y1.
 Intros y1_ py1.
 Case y2.
 Intros y2_ py2.
 Unfold Cauchy_prop in px1.
 Unfold Cauchy_prop in px2.
 Unfold Cauchy_prop in py1.
 Unfold Cauchy_prop in py2.
 
 Intro.
 Cut ((EX e:(a_COrdField) |
    (Zero [:<] e)
    /\(EX N:nat |
         (m:nat)
          (le N m)
          ->((((x1_ m)[+](y1_ m))[-]((x2_ m)[+](y2_ m))[:<] [--]e)
            \/(e[:<]((x1_ m)[+](y1_ m))[-]((x2_ m)[+](y2_ m))))))).
 Intro.
 Case H0.
 
 Intros e H1.
 Elim H1.
 Intros.

 Cut((EX N:nat |
              (m:nat)
               (le N m)->(absSmall a_COrdField e[/]SixteenNZ 
		(x1_ m)[-](x1_ N)))).
 Intros px11.
 Cut((EX N:nat |
              (m:nat)
               (le N m)->(absSmall a_COrdField e[/]SixteenNZ 
		(x2_ m)[-](x2_ N)))).
 Intros px21.
 Cut((EX N:nat |
              (m:nat)
               (le N m)->(absSmall a_COrdField e[/]SixteenNZ 
		(y1_ m)[-](y1_ N)))).
 Intro py11.
 Cut((EX N:nat |
              (m:nat)
               (le N m)->(absSmall a_COrdField e[/]SixteenNZ 
		(y2_ m)[-](y2_ N)))).
 Intro py21.
 Case px11.
 Intros N1 qx1.
 Case px21.
 Intros N2 qx2.
 Case py11.
 Intros M1 qy1.
 Case py21.
 Intros M2 qy2.
 Case H3.
 Intros N H31.

 Cut (((m:nat)(le (plus N (plus N1 (plus N2 (plus M1 M2)))) m)->
(((x1_ m)[-](x2_ m)[:<][--](e[/]FourNZ))\/((e[/]FourNZ)[:<](x1_ m)[-](x2_ m))))
 \/((m:nat)(le (plus N (plus N1 (plus N2 (plus M1 M2)))) m)->
(((y1_ m)[-](y2_ m)[:<][--](e[/]FourNZ))\/((e[/]FourNZ)[:<](y1_ m)[-](y2_ m))))
 ).
 Intro.
 Case H4.
 Intro.
 
 Left.
 Simpl.
 Apply ap_R_alt_2.
 Unfold CS_seq.
 Exists e[/]FourNZ.
 Split.
 (* TO prove that 0 < e/4 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Four::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)  
 
 Exists (plus N (plus N1 (plus N2 (plus M1 M2)))). 
 Assumption.
 
 Intro.
 Right.
 Simpl.
 Apply ap_R_alt_2.
 Unfold CS_seq.
 Exists e[/]FourNZ.
 Split.
 (* TO prove that 0 < e/4 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Four::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)  
 
 Exists (plus N (plus N1 (plus N2 (plus M1 M2)))). 
 Assumption.

 Cut ((((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
     [-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2))))) [:<] [--](e[/]TwoNZ))
       \/(e[/]TwoNZ [:<] (x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
	[-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))))
     \/
      (((y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))[-]
        (y2_ (plus N (plus N1 (plus N2 (plus M1 M2))))) [:<] [--](e[/]TwoNZ))
       \/(e[/]TwoNZ [:<] (y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
	[-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))))).
 Intro.
 Case H4. 
 
 Intro.
 Left.
 Intros.
 Cut (AbsBig e[/]FourNZ (x1_ m)[-](x2_ m)).
 Unfold absBig.
 Intros.
 Elim H7.
 Intros.
 Case H9.
 Intro.
 Right.
 Assumption.
 Intro.
 Left.
 Assumption.

 Step_Rat_AbsBig_lft ((e[/]TwoNZ)[-](e[/]EightNZ))[-](e[/]EightNZ).
 Step_Rat_AbsBig_rht  ((
 	 (x1_  (plus N (plus N1 (plus N2 (plus M1 M2)))))[-]
	 (x2_  (plus N (plus N1 (plus N2 (plus M1 M2))))))[-]
	((x1_  (plus N (plus N1 (plus N2 (plus M1 M2)))))[-](x1_ m)))[-]
	 ((x2_ m)[-](x2_  (plus N (plus N1 (plus N2 (plus M1 M2)))))).
 Apply AbsBigSmall_minus with R:=a_COrdField.
 
  Apply mult_cancel_less with R:=a_COrdField z:=Eight::a_COrdField.
  Apply nring_pos.
  Apply lt_O_Sn.
  Step_Rat_less_lft e[+]Zero[+]Zero::a_COrdField.
  Step_Rat_less_rht e[+]e[+]e.
  Apply plus_resp_less_both.
  Apply plus_resp_less_lft.
  Assumption.
  Assumption.
  
  Apply AbsBigSmall_minus.
   
   Apply mult_cancel_less with R:=a_COrdField z:=Eight::a_COrdField.
   Apply nring_pos.
   Apply lt_O_Sn.
   Step_Rat_less_lft e[+]Zero[+]Zero[+]Zero::a_COrdField.
   Step_Rat_less_rht e[+]e[+]e[+]e.
   Apply plus_resp_less_both.
   Apply plus_resp_less_both.
   Apply plus_resp_less_lft.
   Assumption.
   Assumption.
   Assumption.

   Unfold absBig.
   Split.
   Apply pos_div_two.
   Assumption.
   Case H5.
   Intro.
   Right.
   Assumption.
   Intro.
   Left.
   Assumption.
   
  Step_Rat_AbsSmall_lft (e[/]SixteenNZ)[+](e[/]SixteenNZ).
  Step_Rat_AbsSmall_rht 
  	((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))[-](x1_ N1))[+]
        ((x1_ N1)[-](x1_ m)).
  Apply AbsSmall_plus.
  Apply qx1.
  (* To prove that N + N1 + N2 + M1 + M2 >  N1 *)
  (* Start *)
    Rewrite plus_permute with m:=N1. 
    Apply le_plus_l.
  (* Finish *)
  Apply AbsSmall_minus.
  Apply qx1.
  (* To prove that N1 > m *)
  (* Start *)
    Apply le_trans with m:= (plus N (plus N1 (plus N2 (plus M1 M2)))).
    Rewrite plus_permute with m:=N1. 
    Apply le_plus_l.
    Assumption.
  (* Finish *)
     
  Step_Rat_AbsSmall_lft (e[/]SixteenNZ)[+](e[/]SixteenNZ).
  Step_Rat_AbsSmall_rht ((x2_ m)[-](x2_ N2))[+]	
		((x2_ N2)[-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))).
  Apply AbsSmall_plus.
  Apply qx2.
  (* To prove that N2 > m *)
  (* Start *)
    Apply le_trans with m:= (plus N (plus N1 (plus N2 (plus M1 M2)))).
    Rewrite plus_permute with m:=N2. 
    Rewrite plus_permute with m:=N2.
    Apply le_plus_l.
    Assumption.
  (* Finish *)
  Apply AbsSmall_minus. 
  Apply qx2.
  (* To prove that N + N1 + N2 + M1 + M2 >  N2 *)
  (* Start *)
    Rewrite plus_permute with m:=N2. 
    Rewrite plus_permute with m:=N2.
    Apply le_plus_l.
  (* Finish *)
  
 Intro.
 Right.
 Intros.
 Cut (AbsBig e[/]FourNZ (y1_ m)[-](y2_ m)).
 Unfold absBig.
 Intros.
 Elim H7.
 Intros.
 Case H9.
 Intro.
 Right.
 Assumption.
 Intro.
 Left.
 Assumption.

 Step_Rat_AbsBig_lft ((e[/]TwoNZ)[-](e[/]EightNZ))[-](e[/]EightNZ).
 Step_Rat_AbsBig_rht  ((
 	 (y1_  (plus N (plus N1 (plus N2 (plus M1 M2)))))[-]
	 (y2_  (plus N (plus N1 (plus N2 (plus M1 M2))))))[-]
	((y1_  (plus N (plus N1 (plus N2 (plus M1 M2)))))[-](y1_ m)))[-]
	 ((y2_ m)[-](y2_  (plus N (plus N1 (plus N2 (plus M1 M2)))))).
 Apply AbsBigSmall_minus with R:=a_COrdField.
 
  Apply mult_cancel_less with R:=a_COrdField z:=Eight::a_COrdField.
  Apply nring_pos.
  Apply lt_O_Sn.
  Step_Rat_less_lft e[+]Zero[+]Zero::a_COrdField.
  Step_Rat_less_rht e[+]e[+]e.
  Apply plus_resp_less_both.
  Apply plus_resp_less_lft.
  Assumption.
  Assumption.
  
  Apply AbsBigSmall_minus.
   
   Apply mult_cancel_less with R:=a_COrdField z:=Eight::a_COrdField.
   Apply nring_pos.
   Apply lt_O_Sn.
   Step_Rat_less_lft e[+]Zero[+]Zero[+]Zero::a_COrdField.
   Step_Rat_less_rht e[+]e[+]e[+]e.
   Apply plus_resp_less_both.
   Apply plus_resp_less_both.
   Apply plus_resp_less_lft.
   Assumption.
   Assumption.
   Assumption.

   Unfold absBig.
   Split.
   Apply pos_div_two.
   Assumption.
   Case H5.
   Intro.
   Right.
   Assumption.
   Intro.
   Left.
   Assumption.
   
  Step_Rat_AbsSmall_lft (e[/]SixteenNZ)[+](e[/]SixteenNZ).
  Step_Rat_AbsSmall_rht 
  	((y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))[-](y1_ M1))[+]
        ((y1_ M1)[-](y1_ m)).
  Apply AbsSmall_plus.
  Apply qy1.
  (* To prove that N + N1 + N2 + M1 + M2 >  M1 *)
  (* Start *)
    Rewrite plus_permute with m:=M1. 
    Rewrite plus_permute with m:=M1. 
    Rewrite plus_permute with m:=M1.  
    Apply le_plus_l.
  (* Finish *)
  Apply AbsSmall_minus.
  Apply qy1.
  (* To prove that M1 > m *)
  (* Start *)
    Apply le_trans with m:= (plus N (plus N1 (plus N2 (plus M1 M2)))).
    Rewrite plus_permute with m:=M1. 
    Rewrite plus_permute with m:=M1. 
    Rewrite plus_permute with m:=M1.
    Apply le_plus_l.
    Assumption.
  (* Finish *)
     
  Step_Rat_AbsSmall_lft (e[/]SixteenNZ)[+](e[/]SixteenNZ).
  Step_Rat_AbsSmall_rht ((y2_ m)[-](y2_ M2))[+]	
		((y2_ M2)[-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))).
  Apply AbsSmall_plus.
  Apply qy2.
  (* To prove that M2 > m *)
  (* Start *)
    Apply le_trans with m:= (plus N (plus N1 (plus N2 (plus M1 M2)))).
    Rewrite plus_sym with m:=M2.
    Rewrite plus_permute with m:=M2. 
    Rewrite plus_permute with m:=M2.
    Rewrite plus_permute with m:=M2.
    Apply le_plus_l.
    Assumption.
  (* Finish *)
  Apply AbsSmall_minus. 
  Apply qy2.
  (* To prove that N + N1 + N2 + M1 + M2 >  M2 *)
  (* Start *)
    Rewrite plus_sym with m:=M2.
    Rewrite plus_permute with m:=M2.
    Rewrite plus_permute with m:=M2. 
    Rewrite plus_permute with m:=M2.
    Apply le_plus_l.
  (* Finish *)
 
  (* CORE OF THE PROOF *)
 Cut((((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
       [-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
        [:<] [--](e[/]TwoNZ))\/
        ((y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
        [-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
         [:<] [--](e[/]TwoNZ)))
        \/
	(((e[/]TwoNZ) [:<] (x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                 [-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2))))))\/
         ((e[/]TwoNZ) [:<] (y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                 [-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))))). 
  Intro.
  Case H4.
  Intro. 
  Case H5.
  Intro. 
  Left.
  Left.
  Assumption.
  Intro.
  Right.
  Left.
  Assumption.
  Intro.
  Case H5.
  Intro.
  Left.
  Right.
  Assumption.
  Intro.
  Right.
  Right.
  Assumption.

 Cut((  ((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))[+]
	(y1_ (plus N (plus N1 (plus N2 (plus M1 M2))))))[-]
	((x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))[+]
	(y2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))) [:<] [--]e)
      \/(e [:<] (((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))[+]	
	(y1_ (plus N (plus N1 (plus N2 (plus M1 M2))))))[-]	
	((x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))[+]	
	(y2_ (plus N (plus N1 (plus N2 (plus M1 M2))))))))).
 Intro.
 Case H4.

 Intro.
 Left.
 Cut (  (((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
      [-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2))))))
       [:<] [--](e[/]TwoNZ))\/
       ( [--](e[/]TwoNZ)[:<]([--]e [-] 
        ((y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
        [-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2))))))))).
 Intro.
 Case H6.
 Intro.
 Left.
 Assumption.
 Intro.
 Right.
 Apply plus_cancel_less with 
                  R:=a_COrdField
                  z:=  [--]((y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                       [-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))).
 Apply plus_cancel_less with
		R:=a_COrdField
		z:=[--](e[/]TwoNZ).
 Step_Rat_less_lft [--](e[/]TwoNZ).
 Step_Rat_less_rht  [--]e [-]((y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                           [-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))).
 Assumption.
 
 Apply cotrans_less_unfolded with R:=a_COrdField z:=[--](e[/]TwoNZ).
 Apply plus_cancel_less with 
		R:=a_COrdField
		z:=((y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                   [-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))).
 Step_Rat_less_lft  (((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
         [+](y1_ (plus N (plus N1 (plus N2 (plus M1 M2))))))
         [-]((x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
               [+](y2_ (plus N (plus N1 (plus N2 (plus M1 M2))))))).
 Step_Rat_less_rht [--]e.
 Assumption.

 
 Intro.
 Right.
 Cut ( (e[-](((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
      [-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))))
       [:<] (e[/]TwoNZ))\/
      (e[/]TwoNZ
         [:<] (y1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                [-](y2_ (plus N (plus N1 (plus N2 (plus M1 M2))))))).
 Intro.
 Case H6.
 Intro.
 Left.
 Apply plus_cancel_less with 
                  R:=a_COrdField
                  z:=  [--]((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                       [-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))).
 Apply plus_cancel_less with
		R:=a_COrdField
		z:=(e[/]TwoNZ).
 Step_Rat_less_rht (e[/]TwoNZ).
 Step_Rat_less_lft  e [-]((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                           [-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))).
 Assumption.
 Intro.
 Right.
 Assumption.
 
 Apply cotrans_less_unfolded with R:=a_COrdField z:=(e[/]TwoNZ).
 Apply plus_cancel_less with 
		R:=a_COrdField
		z:=((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
                   [-](x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))).
 Step_Rat_less_rht  (((x1_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
         [+](y1_ (plus N (plus N1 (plus N2 (plus M1 M2))))))
         [-]((x2_ (plus N (plus N1 (plus N2 (plus M1 M2)))))
               [+](y2_ (plus N (plus N1 (plus N2 (plus M1 M2))))))).
 Step_Rat_less_lft e.
 Assumption.
 (* END OF THE CORE OF THE PROOF *)
 
 Apply H31.
 Apply le_plus_l.
 
 Apply py2.
 
  (* TO prove that 0 < e/16 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Sixteen::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)  
 
 Apply py1.
  (* TO prove that 0 < e/16 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Sixteen::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *) 
 Apply px2. 
  (* TO prove that 0 < e/16 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Sixteen::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *) 
 Apply px1. 
  (* TO prove that 0 < e/16 *)
   (* Start *)
     Apply mult_cancel_less with
          R:=a_COrdField
          z:=Sixteen::a_COrdField.
     Apply nring_pos.
     Apply lt_O_Sn.
     Step_Rat_less_lft Zero::a_COrdField.
     Step_Rat_less_rht e.
     Assumption.
   (* Finish *)  
   Change ((EX e:(a_COrdField) |
      (Zero [:<] e)
      /\(EX N:nat |
           (m:nat)(le N m)-> 
 ((CS_seq a_COrdField (Rplus (Build_CauchySeq a_COrdField x1_ px1)
            (Build_CauchySeq a_COrdField y1_ py1)) m)[-]
  (CS_seq a_COrdField (Rplus (Build_CauchySeq a_COrdField x2_ px2)
            (Build_CauchySeq a_COrdField y2_ py2)) m)[:<][--]e)\/
 (e[:<](CS_seq a_COrdField (Rplus (Build_CauchySeq a_COrdField x1_ px1)
            (Build_CauchySeq a_COrdField y1_ py1)) m)[-]
  (CS_seq a_COrdField (Rplus (Build_CauchySeq a_COrdField x2_ px2)
            (Build_CauchySeq a_COrdField y2_ py2)) m))))).

   Apply ap_R_alt_1.
   Assumption.
Qed.

Definition Rplus_is_bin_fun:=(!Build_CSetoid_bin_fun R_as_CSetoid R_as_CSetoid
	R_as_CSetoid Rplus Rplus_is_well_defined Rplus_is_extensional).



Theorem Rplus_is_assoc:(associative R_as_CSetoid Rplus_is_bin_fun).
 Red.
 Simpl.
 Intros.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Unfold Rplus.
 Simpl.
 Change((absLSmall a_COrdField e
     ((CS_seq a_COrdField x m)[+]
       ((CS_seq a_COrdField y m)[+](CS_seq a_COrdField z m)))
       [-](((CS_seq a_COrdField x m)[+](CS_seq a_COrdField y m))[+]
     (CS_seq a_COrdField z m)))).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed.

Lemma CS_seq_ZEROR:(Cauchy_prop [m:nat]Zero::a_COrdField).
 Red.
 Intros.
 Exists O.
 Intros.
 Step_Rat_AbsSmall_rht Zero::a_COrdField.
 Unfold absSmall.
 Split.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Assumption.
Qed.

Definition ZEROR := (Build_CauchySeq a_COrdField [m:nat]Zero::a_COrdField
	CS_seq_ZEROR):R.

 
Definition R_as_CSemi_grp := (!Build_CSemi_grp R_as_CSetoid ZEROR 
 Rplus_is_bin_fun Rplus_is_assoc).

End R_CSemi_grp.
