(* $Id: FinDimVecSp.v,v 1.17 2000/03/21 13:57:16 janz Exp $ *)

(* Obsolete but maintained *)

(* Finite Dimensional Vector Spaces: n-tuples over a field *)

Require Export CVectorSpace.
Require Export TupleCGroups.

Transparent sym_eq.
Transparent f_equal.

Implicit Arguments On.

Section tupleVectorSpaces.
Variable F : CField.
Variable V : (VSpace F).
Variable n : nat.

Local crr : CGroup := (Build_TupleCGroup V n).
Local smult : (CSetoid_outer_op F crr) :=
   (Build_TupleCSetoid_scalar_op ?? (!vs_op F V) n).

Lemma smult_assoc: (a,b:F; v:crr)(smult a[*]b v) [=] (smult a (smult b v)).
Simpl; Unfold eqs mapf; Intros.
Apply vs_assoc.
Qed.

Lemma smult_unit: (v:crr)(smult One v) [=] v.
Simpl; Unfold eqs mapf; Intros.
Algebra.
Qed.

Lemma smult_distl:
  (a,b:F; v:crr) (smult a[+]b v) [=] (smult a v)[+](smult b v).
Simpl; Unfold eqs mapf map2f; Intros.
Apply vs_distl.
Qed.

Lemma smult_distr:
  (a:F; v,u:crr) (smult a v[+]u) [=] (smult a v)[+](smult a u).
Simpl; Unfold eqs mapf map2f; Intros.
Apply vs_distr.
Qed.

Definition Build_TupleVS: (VSpace F).
Apply (!Build_VSpace F crr smult).
Exact smult_assoc.
Exact smult_unit.
Exact smult_distl.
Exact smult_distr.
Defined.


Definition Vn : (VSpace F) := Build_TupleVS.

End tupleVectorSpaces.

Section Fields_as_VS.
Variable F : CField.
Variable n : nat.

(* A Field is a VS over itself *)
Definition Build_FVS: (VSpace F).
Apply (!Build_VSpace F F (cr_mult F)); Algebra.
Defined.

(* Tupling a Field as a VS over itself gives fin dim vector spaces *)
Definition Fn : (VSpace F) := (Vn Build_FVS n).

End Fields_as_VS.

(* m-by-n matrices over F are a VS over F *)
Section matrices_as_F_VS.
Variable F : CField.
Variables m,n : nat.

Definition Fmn : (VSpace F) := (Vn (Fn F n) m).

End matrices_as_F_VS.

Implicit Arguments Off.


