(* $Id: NRootCC.v,v 1.61 2000/11/07 16:04:08 janz Exp $ *)

Require Export CComplex.
Require Export Wf_nat.
Require Export ArithRing.

(* Tex_Prose
\section{Roots of Complex Numbers}
*)

(* Tex_Prose
\subsection{CC ap Zero}
*)

Section CC_ap_zero.

(* Begin_Tex_Verb *)
Lemma cc_ap_zero : (P:CC->Prop)
  ((a,b:IR)(a [#] Zero)->(P a[+I*]b))->
  ((a,b:IR)(b [#] Zero)->(P a[+I*]b))->
    (c:CC)(c [#] Zero)->(P c).
(* End_Tex_Verb *)
Intro. Intro. Intro. Intro.
Elim c. Intros a b. Intro.
Elim H1; Intros.
Apply H.
(** Algebra. *)
  Exact H2.
Apply H0.
(** Algebra. *)
  Exact H2.
Qed.

End CC_ap_zero.

(* Tex_Prose
\subsection{Imag to Real}
*)

Section Imag_to_Real.

(* Begin_Tex_Verb *)
Lemma imag_to_real : (a,b,a',b':IR)(a'[+I*]b' [=] (a[+I*]b)[*]I)->
  (a [#] Zero)->(b' [#] Zero).
(* End_Tex_Verb *)
Intros.
Cut b' [=] a; Intros.
(** Step_ap_lft a. *)
  Apply ap_well_def_lft_unfolded with a.
  Exact H0.
  Apply eq_symmetric_unfolded. Exact H1.
(** Step (Im a'[+I*]b'). *)
  Apply eq_transitive_unfolded with (Im a'[+I*]b').
  Apply eq_reflexive_unfolded.
(** Step (Im a[+I*]b[*]I). *)
  Apply eq_transitive_unfolded with (Im a[+I*]b[*]I).
  Apply Im_wd. Exact H.
(** Step_final (Im ([--]b)[+I*]a). *)
  Apply eq_transitive_unfolded with (Im ([--]b)[+I*]a).
  Apply Im_wd. Apply mult_I.
  Apply eq_reflexive_unfolded.
Qed.

End Imag_to_Real.

(* Tex_Prose
\subsection{NRoot I}
*)

Section NRootI.

(* Begin_Tex_Verb *)
Definition sqrt_Half := (sqrt Half (less_leEq ??? (pos_half IR))).
Definition sqrt_I := sqrt_Half[+I*]sqrt_Half.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma sqrt_I_nexp : (sqrt_I[^](2) [=] I).
(* End_Tex_Verb *)
(** Step sqrt_I[*]sqrt_I. *)
  Apply eq_transitive_unfolded with sqrt_I[*]sqrt_I.
  Apply nexp_two.
Unfold sqrt_I.
(** Step (sqrt_Half[*]sqrt_Half[-]sqrt_Half[*]sqrt_Half)[+I*]
    (sqrt_Half[*]sqrt_Half[+]sqrt_Half[*]sqrt_Half). *)
  Apply eq_transitive_unfolded with (sqrt_Half[*]sqrt_Half[-]sqrt_Half[*]
    sqrt_Half)[+I*](sqrt_Half[*]sqrt_Half[+]sqrt_Half[*]sqrt_Half).
  Apply eq_reflexive_unfolded.
Cut sqrt_Half[*]sqrt_Half [=] Half; Intros.
(** Step Zero[+I*](Half[+]Half). *)
  Apply eq_transitive_unfolded with Zero[+I*](Half[+]Half).
  Apply I_wd. Apply cg_minus_correct. Apply bin_op_wd_unfolded. Exact H.
    Exact H.
(** Step_final Zero[+I*]One. *)
  Apply eq_transitive_unfolded with Zero[+I*]One.
  Apply I_wd. Apply eq_reflexive_unfolded. Apply half_2.
  Apply eq_reflexive_unfolded.
(** Step sqrt_Half[^](2). *)
  Apply eq_transitive_unfolded with sqrt_Half[^](2).
  Apply eq_symmetric_unfolded. Apply nexp_two.
Unfold sqrt_Half.
(** Algebra. *)
  Apply sqrt_sqr.
Qed.

(* Begin_Tex_Verb *)
Lemma nroot_I_nexp_aux : (n:nat)(on:(odd n))
  (Ex [m:nat] (mult n n) = (plus (mult (4) m) (1))).
(* End_Tex_Verb *)
Intros.
Elim (odd_S2n n); Try Assumption.
Intros n' H.
Rewrite H.
Exists (plus (mult n' n') n').
Unfold double.
Rewrite S_to_plus_one.
Ring.
Qed.

(* Begin_Tex_Verb *)
Definition nroot_I [n:nat; on:(odd n)] : CC := I[^]n.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nroot_I_nexp : (n:nat; on:(odd n))((nroot_I ? on)[^]n [=] I).
(* End_Tex_Verb *)
Intros.
Unfold nroot_I.
(** Step I[^](mult n n). *)
  Apply eq_transitive_unfolded with I[^](mult n n).
  Apply nexp_mult.
Elim (nroot_I_nexp_aux n); Try Assumption.
Intros m H.
Rewrite H.
(** Step I[^](mult (4) m)[*]I[^](1). *)
  Apply eq_transitive_unfolded with I[^](mult (4) m)[*]I[^](1).
  Apply eq_symmetric_unfolded. Apply nexp_plus.
(** Step (I[^](4))[^]m[*]I. *)
  Apply eq_transitive_unfolded with (I[^](4))[^]m[*]I.
  Apply bin_op_wd_unfolded. Apply eq_symmetric_unfolded. Apply nexp_mult.
    Apply nexp_one.
Cut I[^](4) [=] One; Intros.
(** Step One[^]m[*]I. *)
  Apply eq_transitive_unfolded with One[^]m[*]I.
  Apply bin_op_wd_unfolded. Apply un_op_wd_unfolded. Exact H0.
    Apply eq_reflexive_unfolded.
(** Step_final One[*]I. *)
  Apply eq_transitive_unfolded with One[*]I.
  Apply bin_op_wd_unfolded. Apply one_nexp. Apply eq_reflexive_unfolded.
  Apply one_mult.
Replace (4) with (mult (2) (2)).
(** Step (I[^](2))[^](2). *)
  Apply eq_transitive_unfolded with (I[^](2))[^](2).
  Apply eq_symmetric_unfolded. Apply nexp_mult.
(** Step ([--](One::CC))[^](2). *)
  Apply eq_transitive_unfolded with ([--](One::CC))[^](2).
  Apply un_op_wd_unfolded. Exact I_square'.
(** Step_final (One::CC)[^](2). *)
  Apply eq_transitive_unfolded with (One::CC)[^](2).
  Apply min_nexp_two.
  Apply one_nexp.
Auto with arith.
Qed.
Hints Resolve nroot_I_nexp : algebra.

(* Begin_Tex_Verb *)
Definition nroot_minus_I [n:nat; on:(odd n)] : CC := [--](nroot_I n on).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nroot_minus_I_nexp : (n:nat)(on:(odd n))
  ((nroot_minus_I n on)[^]n [=] [--]I).
(* End_Tex_Verb *)
Intros.
Unfold nroot_minus_I.
(** Step_final [--]((nroot_I n on)[^]n). *)
  Apply eq_transitive_unfolded with [--]((nroot_I n on)[^]n).
  Apply min_nexp_odd. Exact on.
  Apply un_op_wd_unfolded. Apply nroot_I_nexp.
Qed.

End NRootI.

(* Tex_Prose
\subsection{NRootCC 1}
*)

Section NRootCC_1.

(* Tex_Prose
\subsubsection{NRootCC 1 ap real}
*)

Section NRootCC_1_ap_real.

(* Tex_Prose
\begin{convention}
Let \verb!a, b : IR! and \verb!bnz : b [#] Zero!.
\end{convention}
*)
Variables a, b : IR.
Hypothesis bnz : b [#] Zero.

(* Begin_Tex_Verb *)
Local c2 := a[^](2)[+]b[^](2).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC1_c2pos : (Zero [:<] c2).
(* End_Tex_Verb *)
Unfold c2.
Apply plus_resp_nonneg_pos.
Apply sqr_nonneg.
Apply pos_square.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Local c := (sqrt c2 (less_leEq ??? nrCC1_c2pos)).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Local a'2 := (c[+]a)[*]Half.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC1_a'2pos : (Zero [:<] a'2).
(* End_Tex_Verb *)
Unfold a'2.
Apply (mult_resp_pos IR).
Step_Rat_less_rht c[-][--]a.
Apply shift_zero_less_minus.
Unfold c.
Apply sqrt_less'.
Unfold c2.
Apply (csr_wdl ? (cof_less IR) a[^](2)[+]Zero a[^](2)[+]b[^](2)).
Apply plus_resp_less_lft.
Change (Zero [:<] b[^](2)).
Apply pos_square. Assumption.
(** Algebra. *)
  Apply cm_rht_unit_unfolded.
Apply pos_half.
Qed.

(* Begin_Tex_Verb *)
Local a' := (sqrt a'2 (less_leEq ??? nrCC1_a'2pos)).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Local b'2 := (c[-]a)[*]Half.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC1_b'2pos : (Zero [:<] b'2).
(* End_Tex_Verb *)
Unfold b'2.
Apply (mult_resp_pos IR).
Change (Zero [:<] c[-]a).
Apply shift_zero_less_minus.
Unfold c.
Apply sqrt_less.
Unfold c2.
Step_Rat_less_lft a[^](2)[+]Zero.
Apply plus_resp_less_lft.
Change (Zero [:<] b[^](2)).
Apply pos_square. Assumption.
Apply pos_half.
Qed.
(* Begin_Tex_Verb *)
Local b' := (sqrt b'2 (less_leEq ??? nrCC1_b'2pos)).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC1_a3 : a'[^](2)[-]b'[^](2) [=] a.
(* End_Tex_Verb *)
Unfold a' b'.
(** Step a'2[-]b'2. *)
  Apply eq_transitive_unfolded with a'2[-]b'2.
  Apply cg_minus_wd. Apply sqrt_sqr. Apply sqrt_sqr.
Unfold a'2 b'2.
Unfold half.
Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC1_a4 : (c[+]a)[*](c[-]a) [=] b[^](2).
(* End_Tex_Verb *)
(** Step c[^](2)[-]a[^](2). *)
  Apply eq_transitive_unfolded with c[^](2)[-]a[^](2).
  Apply nexp_funny.
Unfold c.
(** Step c2[-]a[^](2). *)
  Apply eq_transitive_unfolded with c2[-]a[^](2).
  Apply cg_minus_wd. Apply sqrt_sqr. Apply eq_reflexive_unfolded.
Unfold c2.
(** Step (a[^](2)[+]b[^](2))[+][--](a[^](2)). *)
  Apply eq_transitive_unfolded with (a[^](2)[+]b[^](2))[+][--](a[^](2)).
  Apply eq_reflexive_unfolded.
(** Step (b[^](2)[+]a[^](2))[+][--](a[^](2)). *)
  Apply eq_transitive_unfolded with (b[^](2)[+]a[^](2))[+][--](a[^](2)).
  Apply bin_op_wd_unfolded. Apply cm_commutes_unfolded.
    Apply eq_reflexive_unfolded.
(** Step b[^](2)[+](a[^](2)[+][--](a[^](2))). *)
  Apply eq_transitive_unfolded with b[^](2)[+](a[^](2)[+][--](a[^](2))).
  Apply eq_symmetric_unfolded. Apply plus_assoc_unfolded.
(** Step_final b[^](2)[+]Zero. *)
  Apply eq_transitive_unfolded with b[^](2)[+]Zero.
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded.
    Apply cg_rht_inv_unfolded.
  Apply cm_rht_unit_unfolded.
Qed.
Hints Resolve nrCC1_a4 : algebra.

(* Begin_Tex_Verb *)
Lemma nrCC1_a5 : a'2[*]b'2 [=] (b[*]Half)[^](2).
(* End_Tex_Verb *)
Unfold a'2 b'2.
(** Step (c[+]a)[*](Half[*]((c[-]a)[*]Half)). *)
  Apply eq_transitive_unfolded with (c[+]a)[*](Half[*]((c[-]a)[*]Half)).
  Apply eq_symmetric_unfolded. Apply mult_assoc_unfolded.
(** Step (c[+]a)[*](((c[-]a)[*]Half)[*]Half). *)
  Apply eq_transitive_unfolded with (c[+]a)[*](((c[-]a)[*]Half)[*]Half).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Apply mult_commutes.
(** Step (c[+]a)[*]((c[-]a)[*](Half[*]Half)). *)
  Apply eq_transitive_unfolded with (c[+]a)[*]((c[-]a)[*](Half[*]Half)).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded.
    Apply eq_symmetric_unfolded. Apply mult_assoc_unfolded.
(** Step ((c[+]a)[*](c[-]a))[*](Half[*]Half). *)
  Apply eq_transitive_unfolded with ((c[+]a)[*](c[-]a))[*](Half[*]Half).
  Apply mult_assoc_unfolded.
(** Step b[^](2)[*](Half[*]Half). *)
  Apply eq_transitive_unfolded with b[^](2)[*](Half[*]Half).
  Apply bin_op_wd_unfolded. Exact nrCC1_a4. Apply eq_reflexive_unfolded.
(** Step (b[*]b)[*](Half[*]Half). *)
  Apply eq_transitive_unfolded with (b[*]b)[*](Half[*]Half).
  Apply bin_op_wd_unfolded. Apply nexp_two. Apply eq_reflexive_unfolded.
(** Step ((b[*]b)[*]Half)[*]Half. *)
  Apply eq_transitive_unfolded with ((b[*]b)[*]Half)[*]Half.
  Apply mult_assoc_unfolded.
(** Step (b[*](b[*]Half))[*]Half. *)
  Apply eq_transitive_unfolded with (b[*](b[*]Half))[*]Half.
  Apply bin_op_wd_unfolded. Apply eq_symmetric_unfolded.
    Apply mult_assoc_unfolded. Apply eq_reflexive_unfolded.
(** Step ((b[*]Half)[*]b)[*]Half. *)
  Apply eq_transitive_unfolded with ((b[*]Half)[*]b)[*]Half.
  Apply bin_op_wd_unfolded. Apply mult_commutes. Apply eq_reflexive_unfolded.
(** Step_final (b[*]Half)[*](b[*]Half). *)
  Apply eq_transitive_unfolded with (b[*]Half)[*](b[*]Half).
  Apply eq_symmetric_unfolded. Apply mult_assoc_unfolded.
  Apply eq_symmetric_unfolded. Apply nexp_two.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC1_a6 : (Zero [:<] a'2[*]b'2).
(* End_Tex_Verb *)
Apply (mult_resp_pos IR).
Apply nrCC1_a'2pos.
Apply nrCC1_b'2pos.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC1_a6' : (Zero [:<] (b[*]Half)[^](2)).
(* End_Tex_Verb *)
Apply pos_square.
(** Step_ap_rht Zero[*]Half. *)
  Apply ap_well_def_rht_unfolded with (Zero::IR)[*]Half.
  2: Apply cring_mult_zero_op.
Apply mult_rht_resp_ap; Try Assumption.
Apply pos_ap_zero.
Apply pos_half.
Qed.
Hints Resolve nrCC1_a5 : algebra.

(* Begin_Tex_Verb *)
Lemma nrCC1_a7_upper : (Zero [:<] b)->(a'[*]b' [=] b[*]Half).
(* End_Tex_Verb *)
Intros.
Unfold a' b'.
(** Step (sqrt a'2[*]b'2 (less_leEq ??? nrCC1_a6)). *)
  Apply eq_transitive_unfolded with (sqrt a'2[*]b'2 (less_leEq ??? nrCC1_a6)).
  Apply eq_symmetric_unfolded. Apply sqrt_mult.
(** Step (sqrt (b[*]Half)[^](2) nrCC1_a6'). *)
  Apply eq_transitive_unfolded with (sqrt (b[*]Half)[^](2) (less_leEq ??? nrCC1_a6')).
  Apply sqrt_wd. Exact nrCC1_a5.
Apply sqrt_to_nonneg.
Apply less_leEq.
Step_Rat_less_lft (Zero::IR)[*]Half.
Apply mult_resp_less. Assumption.
Apply pos_half.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC1_a7_lower : (b [:<] Zero)->(a'[*][--]b' [=] b[*]Half).
(* End_Tex_Verb *)
Intros.
(** Step [--](a'[*]b'). *)
  Apply eq_transitive_unfolded with [--](a'[*]b').
  Apply cring_minus_mult_lft.
Cut a'[*]b' [=] [--](b[*]Half); Intros.
(** Step_final [--][--](b[*]Half). *)
  Apply eq_transitive_unfolded with [--][--](b[*]Half).
  Apply un_op_wd_unfolded. Exact H0.
  Apply cg_inv_inv.
Unfold a' b'.
(** Step (sqrt a'2[*]b'2 (less_leEq ??? nrCC1_a6)). *)
  Apply eq_transitive_unfolded with (sqrt a'2[*]b'2 (less_leEq ??? nrCC1_a6)).
  Apply eq_symmetric_unfolded. Apply sqrt_mult.
(** Step (sqrt (b[*]Half)[^](2) (less_leEq ??? nrCC1_a6')). *)
  Apply eq_transitive_unfolded with (sqrt (b[*]Half)[^](2) (less_leEq ??? nrCC1_a6')).
  Apply sqrt_wd. Exact nrCC1_a5.
Apply sqrt_to_nonpos.
Apply less_leEq.
Step_Rat_less_rht (Zero::IR)[*]Half.
Apply mult_resp_less. Assumption.
Apply pos_half.
Qed.
Hints Resolve nrCC1_a3 nrCC1_a7_upper nrCC1_a7_lower : algebra.

(* Begin_Tex_Verb *)
Lemma nrootCC_1_upper : (Zero [:<] b)->((a'[+I*]b')[^](2) [=] a[+I*]b).
(* End_Tex_Verb *)
Intros.
(** Step (a'[^](2)[-]b'[^](2))[+I*]((a'[*]b')[*]Two). *)
  Apply eq_transitive_unfolded with (a'[^](2)[-]b'[^](2))[+I*]((a'[*]b')[*]Two).
  Apply cc_calculate_square.
Cut (a'[*]b')[*]Two [=] b; Intros.
(** Step_final a[+I*]b. *)
  Apply eq_transitive_unfolded with a[+I*]b.
  Apply I_wd. Exact nrCC1_a3. Exact H0.
  Apply eq_reflexive_unfolded.
(** Step (b[*]Half)[*]Two. *)
  Apply eq_transitive_unfolded with (b[*]Half)[*]Two.
  Apply bin_op_wd_unfolded. Apply nrCC1_a7_upper. Exact H.
    Apply eq_reflexive_unfolded.
(** Algebra. *)
  Apply half_1'.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_1_lower : (b [:<] Zero)->((a'[+I*][--]b')[^](2) [=] a[+I*]b).
(* End_Tex_Verb *)
Intros.
Cut a'[^](2)[-]([--]b')[^](2) [=] a; Intros.
Cut (a'[*][--]b')[*]Two [=] b; Intros.
(** Step_final (a'[^](2)[-]([--]b')[^](2))[+I*]((a'[*][--]b')[*]Two). *)
  Apply eq_transitive_unfolded with
    (a'[^](2)[-]([--]b')[^](2))[+I*]((a'[*][--]b')[*]Two).
  Apply cc_calculate_square.
  Apply I_wd. Exact H0. Exact H1.
(** Step (b[*]Half)[*]Two. *)
  Apply eq_transitive_unfolded with (b[*]Half)[*]Two.
  Apply bin_op_wd_unfolded. Apply nrCC1_a7_lower. Exact H.
    Apply eq_reflexive_unfolded.
(** Algebra. *)
  Apply half_1'.
(** Step_final a'[^](2)[-]b'[^](2). *)
  Apply eq_transitive_unfolded with a'[^](2)[-]b'[^](2).
  Apply cg_minus_wd. Apply eq_reflexive_unfolded. Apply min_nexp_two.
  Exact nrCC1_a3.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_1_ap_real : (Ex [z:CC](z[^](2) [=] a[+I*]b)).
(* End_Tex_Verb *)
Elim
  ((less_conf_ap IR)::(x,y:IR)(x [#] y)<->((x [:<] y)\/(y [:<] x))
    b Zero).
Intros.
Elim (H bnz); Intros.
Exists a'[+I*][--]b'. Apply nrootCC_1_lower. Assumption.
Exists a'[+I*]b'. Apply nrootCC_1_upper. Assumption.
Qed.

End NRootCC_1_ap_real.

(* Tex_Prose
\subsubsection{NRootCC 1 ap imag}
*)

Section NRootCC_1_ap_imag.

(* Tex_Prose
\begin{convention}
Let \verb!a, b : IR! and \verb!anz : a [#] Zero!.
\end{convention}
*)
Variables a, b : IR.
Hypothesis anz : a [#] Zero.

(* Begin_Tex_Verb *)
Local c' := (a[+I*]b)[*][--]I.
Local a' := (Re c').
Local b' := (Im c').
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrootCC_1_ap_imag : (Ex [z:CC](z[^](2) [=] a[+I*]b)).
(* End_Tex_Verb *)
Elim (nrootCC_1_ap_real a' b').
Intros.
Exists x[*]sqrt_I.
(** Step x[^](2)[*]sqrt_I[^](2). *)
  Apply eq_transitive_unfolded with x[^](2)[*]sqrt_I[^](2).
  Apply mult_nexp.
Hints Resolve sqrt_I_nexp : algebra.
(** Step (a'[+I*]b')[*]I. *)
  Apply eq_transitive_unfolded with (a'[+I*]b')[*]I.
  Apply bin_op_wd_unfolded. Exact H. Exact sqrt_I_nexp.
(** Step ((a[+I*]b)[*][--]I)[*]I. *)
  Apply eq_transitive_unfolded with ((a[+I*]b)[*][--]I)[*]I.
  Apply eq_reflexive_unfolded.
(** Step (a[+I*]b)[*]([--]I[*]I). *)
  Apply eq_transitive_unfolded with (a[+I*]b)[*]([--]I[*]I).
  Apply eq_symmetric_unfolded. Apply mult_assoc_unfolded.
(** Step_final (a[+I*]b)[*]One. *)
  Apply eq_transitive_unfolded with (a[+I*]b)[*]One.
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Exact I_inv_lft.
  Apply mult_one.
Cut b[+I*]([--]a) [=] c'; Intros.
(** Step_ap_lft (Im c'). *)
  Apply ap_well_def_lft_unfolded with (Im c').
  2: Apply eq_reflexive_unfolded.
(** Step_ap_lft (Im b[+I*][--]a). *)
  Apply ap_well_def_lft_unfolded with (Im b[+I*][--]a).
  2: Apply Im_wd. 2: Exact H.
(** Step_ap_lft [--]a. *)
  Apply ap_well_def_lft_unfolded with [--]a.
  Apply zero_minus_apart. Apply minus_ap_zero. Apply min_resp_ap_zero.
    Exact anz.
  Apply eq_reflexive_unfolded.
(** Step ([--][--]b)[+I*][--]a. *)
  Apply eq_transitive_unfolded with ([--][--]b)[+I*][--]a.
  Apply I_wd. Apply eq_symmetric_unfolded. Apply cg_inv_inv.
    Apply eq_reflexive_unfolded.
(** Step [--](([--]b)[+I*]a). *)
  Apply eq_transitive_unfolded with [--](([--]b)[+I*]a).
  Apply eq_reflexive_unfolded.
(** Step [--]((a[+I*]b)[*]I). *)
  Apply eq_transitive_unfolded with [--]((a[+I*]b)[*]I).
  Apply un_op_wd_unfolded. Apply eq_symmetric_unfolded. Apply mult_I.
(** Step_final (a[+I*]b)[*][--]I. *)
  Apply eq_transitive_unfolded with (a[+I*]b)[*][--]I.
  Apply eq_symmetric_unfolded. Apply cring_minus_mult_lft.
  Apply eq_reflexive_unfolded.
Qed.

End NRootCC_1_ap_imag.

(* Begin_Tex_Verb *)
Lemma nrootCC_1 : (c:CC)(c [#] Zero)->(Ex [z:CC](z[^](2) [=] c)).
(* End_Tex_Verb *)
Intros.
Pattern c.
Apply cc_ap_zero; Try Assumption; Intros.
Apply nrootCC_1_ap_imag. Assumption.
Apply nrootCC_1_ap_real. Assumption.
Qed.

End NRootCC_1.

(* Tex_Prose
\subsection{NRootCC 2}
*)

Section NRootCC_2.

(* Tex_Prose
\begin{convention}
Let \verb!n : nat! and \verb!c, z : CC! and \verb!cnz : c [#] Zero!.
\end{convention}
*)
Variable n : nat.
Variables c, z : CC.
Hypothesis cnz : c [#] Zero.

(* Begin_Tex_Verb *)
Lemma nrootCC_2' :
  ((z[*](conj z))[^]n [=] c[*](conj c))->
    (z[^]n[*](conj c)[-](conj z)[^]n[*]c [=] Zero)->
      ((z[^]n)[^](2) [=] c[^](2)).
(* End_Tex_Verb *)
Intros.
Cut z[^]n[*](conj c) [=] (conj z)[^]n[*]c; Intros.
Apply (mult_cancel_rht ? (z[^]n)[^](2) c[^](2) (conj c)).
Apply conj_4.
(** Step_ap_lft c. *)
  Apply ap_well_def_lft_unfolded with c.
  2: Apply eq_symmetric_unfolded. 2: Apply conj_5.
(** Step_ap_rht Zero::CC. *)
  Apply ap_well_def_rht_unfolded with Zero::CC.
  Exact cnz.
  Apply eq_symmetric_unfolded. Exact conj_6.
(** Step (z[^]n[*]z[^]n)[*](conj c). *)
  Apply eq_transitive_unfolded with (z[^]n[*]z[^]n)[*](conj c).
  Apply bin_op_wd_unfolded. Apply nexp_two. Apply eq_reflexive_unfolded.
(** Step z[^]n[*](z[^]n[*](conj c)). *)
  Apply eq_transitive_unfolded with z[^]n[*](z[^]n[*](conj c)).
  Apply eq_symmetric_unfolded. Apply mult_assoc_unfolded.
(** Step z[^]n[*]((conj z)[^]n[*]c). *)
  Apply eq_transitive_unfolded with z[^]n[*]((conj z)[^]n[*]c).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Exact H1.
(** Step (z[^]n[*](conj z)[^]n)[*]c. *)
  Apply eq_transitive_unfolded with (z[^]n[*](conj z)[^]n)[*]c.
  Apply mult_assoc_unfolded.
(** Step ((z[*](conj z))[^]n)[*]c. *)
  Apply eq_transitive_unfolded with ((z[*](conj z))[^]n)[*]c.
  Apply bin_op_wd_unfolded. Apply eq_symmetric_unfolded. Apply mult_nexp.
    Apply eq_reflexive_unfolded.
(** Step (c[*](conj c))[*]c. *)
  Apply eq_transitive_unfolded with (c[*](conj c))[*]c.
  Apply bin_op_wd_unfolded. Exact H. Apply eq_reflexive_unfolded.
(** Step c[*](c[*](conj c)). *)
  Apply eq_transitive_unfolded with c[*](c[*](conj c)).
  Apply mult_commutes.
(** Step_final (c[*]c)[*](conj c). *)
  Apply eq_transitive_unfolded with (c[*]c)[*](conj c).
  Apply mult_assoc_unfolded.
  Apply bin_op_wd_unfolded. Apply eq_symmetric_unfolded. Apply nexp_two.
    Apply eq_reflexive_unfolded.
Cut (G:CGroup)(x,y:G)(x[-]y [=] Zero)->(x [=] y); Intros.
Apply H1. Assumption.
(** Step x[+]Zero. *)
  Apply eq_transitive_unfolded with x[+]Zero.
  Apply eq_symmetric_unfolded. Apply cm_rht_unit_unfolded.
(** Step x[+]([--]y[+]y). *)
  Apply eq_transitive_unfolded with x[+]([--]y[+]y).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded.
    Apply eq_symmetric_unfolded. Apply cg_lft_inv_unfolded.
(** Step (x[+][--]y)[+]y. *)
  Apply eq_transitive_unfolded with (x[+][--]y)[+]y.
  Apply plus_assoc_unfolded.
(** Step_final Zero[+]y. *)
  Apply eq_transitive_unfolded with Zero[+]y.
  Apply bin_op_wd_unfolded. Exact H1. Apply eq_reflexive_unfolded.
  Apply cm_lft_unit_unfolded.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_2 :
  ((z[*](conj z))[^]n [=] c[*](conj c))->
    (z[^]n[*](conj c)[-](conj z)[^]n[*]c [=] Zero)->
      ((z[^]n [=] c) \/ (z[^]n [=] [--]c)).
(* End_Tex_Verb *)
Intros.
Apply conditional_square_eq; Try Assumption.
Exact TwoCC_ap_zero.
Apply nrootCC_2'; Assumption.
Qed.

End NRootCC_2.

(* Tex_Prose
\subsection{NRootCC 3}
*)

Section NRootCC_3.

(* Begin_Tex_Verb *)
Fixpoint Im_poly [p:(cpoly CC)] : (cpoly IR) :=
  Cases p of
    cpoly_zero => (cpoly_zero IR)
  | (cpoly_linear c p1) => (cpoly_linear IR (Im c) (Im_poly p1))
  end.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC3_a1 : (p:(cpoly CC))(r:IR)((Im_poly p)!r [=] (Im p!(cc_IR r))).
(* End_Tex_Verb *)
Intros.
Elim p; Intros.
Unfold Im_poly.
(** Step Zero::IR. *)
  Apply eq_transitive_unfolded with Zero::IR.
  Apply eq_reflexive_unfolded.
(** Step_final (Im Zero::CC). *)
  Apply eq_transitive_unfolded with (Im Zero::CC); Apply eq_reflexive_unfolded.
(** Step (cpoly_linear ? (Im s) (Im_poly c))!r. *)
  Apply eq_transitive_unfolded with (cpoly_linear ? (Im s) (Im_poly c))!r.
  Apply eq_reflexive_unfolded.
(** Step (Im s)[+]r[*]((Im_poly c)!r). *)
  Apply eq_transitive_unfolded with (Im s)[+]r[*]((Im_poly c)!r).
  Apply eq_reflexive_unfolded.
(** Step (Im s)[+]r[*](Im (c!(cc_IR r))). *)
  Apply eq_transitive_unfolded with (Im s)[+]r[*](Im (c!(cc_IR r))).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Apply bin_op_wd_unfolded.
    Apply eq_reflexive_unfolded. Exact H.
Cut (r:IR)(c:CC)(r[*](Im c) [=] (Im (cc_IR r)[*]c)); Intros.
(** Step (Im s)[+](Im (cc_IR r)[*](c!(cc_IR r))). *)
  Apply eq_transitive_unfolded with (Im s)[+](Im (cc_IR r)[*](c!(cc_IR r))).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Apply H0.
(** Step_final (Im s[+](cc_IR r)[*](c!(cc_IR r))). *)
  Apply eq_transitive_unfolded with (Im s[+](cc_IR r)[*](c!(cc_IR r))).
  Apply eq_reflexive_unfolded.
  Apply eq_reflexive_unfolded.
(** Step r0[*](Im c0)[+]Zero. *)
  Apply eq_transitive_unfolded with r0[*](Im c0)[+]Zero.
  Apply eq_symmetric_unfolded. Apply cm_rht_unit_unfolded.
(** Step r0[*](Im c0)[+]Zero[*](Re c0). *)
  Apply eq_transitive_unfolded with r0[*](Im c0)[+]Zero[*](Re c0).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded.
    Apply eq_symmetric_unfolded. Apply cring_mult_zero_op.
(** Step (Im (r0[+I*]Zero)[*]((Re c0)[+I*](Im c0))). *)
  Apply eq_transitive_unfolded with (Im (r0[+I*]Zero)[*]((Re c0)[+I*](Im c0))).
  Apply eq_reflexive_unfolded.
(** Step_final (Im (cc_IR r0)[*]((Re c0)[+I*](Im c0))). *)
  Apply eq_transitive_unfolded with (Im (cc_IR r0)[*]((Re c0)[+I*](Im c0))).
  Apply eq_reflexive_unfolded.
  Apply eq_reflexive_unfolded.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC3_a2 : (p:(cpoly CC))(n:nat)
  ((Nth_coeff n (Im_poly p)) [=] (Im (Nth_coeff n p))).
(* End_Tex_Verb *)
Intro.
Elim p; Intros.
Unfold Im_poly.
(** Step Zero::IR. *)
  Apply eq_transitive_unfolded with Zero::IR.
  Apply eq_reflexive_unfolded.
(** Step_final (Im Zero::CC). *)
  Apply eq_transitive_unfolded with (Im Zero::CC).
  Apply eq_reflexive_unfolded.
  Apply eq_reflexive_unfolded.
Elim n; Intros.
(** Step_final (Im s). *)
  Apply eq_transitive_unfolded with (Im s).
  Apply eq_reflexive_unfolded.
  Apply eq_reflexive_unfolded.
(** Step (nth_coeff ? n0 (Im_poly c)). *)
  Apply eq_transitive_unfolded with (nth_coeff ? n0 (Im_poly c)).
  Apply eq_reflexive_unfolded.
(** Step_final (Im (nth_coeff CC n0 c)). *)
  Apply eq_transitive_unfolded with (Im (nth_coeff CC n0 c)).
  Apply H.
  Apply eq_reflexive_unfolded.
Qed.

(* Tex_Prose
\begin{convention}
Let \verb!a, b : IR! and \verb!bnz : b [#] Zero! and \verb!n : nat!.
\end{convention}
*)
Variable a, b : IR.
Hypothesis bnz : b [#] Zero.
Variable n : nat.

(* Begin_Tex_Verb *)
Definition nrCC3_poly'' := (_X_[+](_C_ I))[^]n.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC3_a3 : (r:IR)((nrCC3_poly''!(cc_IR r)) [=] (r[+I*]One)[^]n).
(* End_Tex_Verb *)
Intros.
Unfold nrCC3_poly''.
(** Step ((_X_[+](_C_ I))!(cc_IR r))[^]n. *)
  Apply eq_transitive_unfolded with ((_X_[+](_C_ I))!(cc_IR r))[^]n.
  Apply nexp_apply.
(** Step ((_X_!(cc_IR r))[+]((_C_) I)!(cc_IR r))[^]n. *)
  Apply eq_transitive_unfolded with ((_X_!(cc_IR r))[+]((_C_) I)!(cc_IR r))[^]n.
  Apply un_op_wd_unfolded. Apply plus_apply.
Cut (c,x:CC)((_X_!x)[+]((_C_ c)!x) [=] x[+]c); Intros.
(** Step ((cc_IR r)[+]I)[^]n. *)
  Apply eq_transitive_unfolded with ((cc_IR r)[+]I)[^]n.
  Apply un_op_wd_unfolded. Apply H.
(** Step ((r[+I*]Zero)[+](Zero[+I*]One))[^]n. *)
  Apply eq_transitive_unfolded with ((r[+I*]Zero)[+](Zero[+I*]One))[^]n.
  Apply eq_reflexive_unfolded.
(** Step_final ((r[+]Zero)[+I*](Zero[+]One))[^]n. *)
  Apply eq_transitive_unfolded with ((r[+]Zero)[+I*](Zero[+]One))[^]n.
  Apply eq_reflexive_unfolded.
  Apply un_op_wd_unfolded. Apply I_wd. Apply cm_rht_unit_unfolded.
    Apply cm_lft_unit_unfolded.
(** Algebra. *)
  Apply bin_op_wd_unfolded. Apply _x_apply. Apply _c_apply.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC3_a4 : (Degree_le (1) _X_[+](_C_ I)).
(* End_Tex_Verb *)
Apply Degree_imp_Degree_le.
Cut (Degree (1) (_C_ I)[+]_X_); Intros.
Apply (Degree_wd ? (_C_ I)[+]_X_).
(** Algebra. *)
  Apply cm_commutes_unfolded.
(** Algebra. *)
  Exact H.
Apply (Degree_plus_rht ? (_C_ I) _X_ O (1)).
Apply Degree_le_c_.
Apply Degree_x_.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC3_a5 : (Degree_le n nrCC3_poly'').
(* End_Tex_Verb *)
Replace n with (mult (1) n).
Unfold nrCC3_poly''.
Apply Degree_le_nexp.
Exact nrCC3_a4.
Unfold mult.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC3_a6 : (Nth_coeff n nrCC3_poly'') [=] One.
(* End_Tex_Verb *)
Cut (Monic n nrCC3_poly''); Intros.
Unfold monic in H.
Elim H; Intros; Assumption.
Replace n with (mult (1) n).
Unfold nrCC3_poly''.
Apply Monic_nexp.
Unfold monic; Split.
(** Algebra. *)
  Apply eq_reflexive_unfolded.
Exact nrCC3_a4.
Unfold mult.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Definition nrCC3_poly' := nrCC3_poly''[*](_C_ a[+I*][--]b).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC3_a7 : (r:IR)
  ((nrCC3_poly'!(cc_IR r)) [=] (r[+I*]One)[^]n[*](a[+I*][--]b)).
(* End_Tex_Verb *)
Intros.
Unfold nrCC3_poly'.
(** Step (nrCC3_poly''!(cc_IR r))[*]((_C_ a[+I*][--]b)!(cc_IR r)). *)
  Apply eq_transitive_unfolded with
    (nrCC3_poly''!(cc_IR r))[*]((_C_ a[+I*][--]b)!(cc_IR r)).
  Apply mult_apply.
Hints Resolve nrCC3_a3 : algebra.
(** Step_final (nrCC3_poly''!(cc_IR r))[*](a[+I*][--]b). *)
  Apply eq_transitive_unfolded with (nrCC3_poly''!(cc_IR r))[*](a[+I*][--]b).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Apply _c_apply.
  Apply bin_op_wd_unfolded. Apply nrCC3_a3. Apply eq_reflexive_unfolded.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC3_a8 : (Degree_le n nrCC3_poly').
(* End_Tex_Verb *)
Replace n with (plus n O).
Unfold nrCC3_poly'.
Apply Degree_le_mult.
Exact nrCC3_a5.
Apply Degree_le_c_.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC3_a9 : (Nth_coeff n nrCC3_poly') [=] a[+I*][--]b.
(* End_Tex_Verb *)
Unfold nrCC3_poly'.
Hints Resolve Nth_coeff_p_mult_c_ : algebra.
(** Step (Nth_coeff n nrCC3_poly'')[*](a[+I*][--]b). *)
  Apply eq_transitive_unfolded with (Nth_coeff n nrCC3_poly'')[*](a[+I*][--]b).
  Apply Nth_coeff_p_mult_c_.
Hints Resolve nrCC3_a6 : algebra.
(** Step_final One[*](a[+I*][--]b). *)
  Apply eq_transitive_unfolded with One[*](a[+I*][--]b).
  Apply bin_op_wd_unfolded. Exact nrCC3_a6. Apply eq_reflexive_unfolded.
  Apply one_mult.
Qed.

(* Begin_Tex_Verb *)
Definition nrootCC_3_poly := (Im_poly nrCC3_poly').
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrootCC_3_ : (r:IR)
  ((nrootCC_3_poly!r) [=] (Im (r[+I*]One)[^]n[*](a[+I*][--]b))).
(* End_Tex_Verb *)
Intros.
Unfold nrootCC_3_poly.
Hints Resolve nrCC3_a1 nrCC3_a7 : algebra.
(** Step_final (Im (nrCC3_poly'!(cc_IR r))). *)
  Apply eq_transitive_unfolded with (Im (nrCC3_poly'!(cc_IR r))).
  Apply nrCC3_a1.
  Apply Im_wd. Apply nrCC3_a7.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_3 : (r:IR)
  ((cc_IR (nrootCC_3_poly!r))[*](Two[*]I) [=]
    ((r[+I*]One)[^]n[*](a[+I*][--]b)[-](r[+I*][--]One)[^]n[*](a[+I*]b))).
(* End_Tex_Verb *)
Intros.
Cut (conj (r[+I*]One)[^]n[*](a[+I*][--]b)) [=] (r[+I*][--]One)[^]n[*](a[+I*]b);
  Intros.
Hints Resolve nrootCC_3_ : algebra.
(** Step (cc_IR (Im (r[+I*]One)[^]n[*](a[+I*][--]b)))[*](Two[*]I). *)
  Apply eq_transitive_unfolded with
    (cc_IR (Im (r[+I*]One)[^]n[*](a[+I*][--]b)))[*](Two[*]I).
  Apply bin_op_wd_unfolded. Apply cc_IR_1. Apply nrootCC_3_.
    Apply eq_reflexive_unfolded.
Hints Resolve calculate_Im : algebra.
(** Step_final
    (r[+I*]One)[^]n[*](a[+I*][--]b)[-](conj (r[+I*]One)[^]n[*](a[+I*][--]b)).
    *)
  Apply eq_transitive_unfolded with
    (r[+I*]One)[^]n[*](a[+I*][--]b)[-](conj (r[+I*]One)[^]n[*](a[+I*][--]b)).
  Apply calculate_Im.
  Apply cg_minus_wd. Apply eq_reflexive_unfolded. Exact H.
(** Step (conj (r[+I*]One)[^]n)[*](conj a[+I*][--]b). *)
  Apply eq_transitive_unfolded with (conj (r[+I*]One)[^]n)[*](conj a[+I*][--]b).
  Apply conj_2.
(** Step_final (conj r[+I*]One)[^]n[*]a[+I*][--][--]b. *)
  Apply eq_transitive_unfolded with (conj r[+I*]One)[^]n[*]a[+I*][--][--]b.
  Apply bin_op_wd_unfolded. Apply conj_3. Apply eq_reflexive_unfolded.
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Apply I_wd.
    Apply eq_reflexive_unfolded. Apply cg_inv_inv.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_3_degree : (Degree n nrootCC_3_poly).
(* End_Tex_Verb *)
Unfold degree.
Split.
Cut (Nth_coeff n nrootCC_3_poly) [=] [--]b; Intros.
(** Step_ap_lft [--]b. *)
  Apply ap_well_def_lft_unfolded with [--]b.
  Apply zero_minus_apart. Apply minus_ap_zero. Apply min_resp_ap_zero.
    Exact bnz.
  Apply eq_symmetric_unfolded. Exact H.
Unfold nrootCC_3_poly.
Hints Resolve nrCC3_a2 : algebra.
(** Step (Im (Nth_coeff n nrCC3_poly')). *)
  Apply eq_transitive_unfolded with (Im (Nth_coeff n nrCC3_poly')).
  Apply nrCC3_a2.
Hints Resolve nrCC3_a9 : algebra.
(** Step_final (Im a[+I*][--]b). *)
  Apply eq_transitive_unfolded with (Im a[+I*][--]b).
  Apply Im_wd. Exact nrCC3_a9.
  Apply eq_reflexive_unfolded.
Cut (p:(cpoly CC))(n:nat)(Degree_le n p)->(Degree_le n (Im_poly p)); Intros.
Unfold nrootCC_3_poly.
Apply H.
Exact nrCC3_a8.
Unfold degree_le.
Unfold degree_le in H.
Intros.
(** Step (Im (Nth_coeff m p)). *)
  Apply eq_transitive_unfolded with (Im (Nth_coeff m p)).
  Apply nrCC3_a2.
(** Step_final (Im Zero::CC). *)
  Apply eq_transitive_unfolded with (Im Zero::CC).
  Apply Im_wd. Apply H. Exact H0.
  Apply eq_reflexive_unfolded.
Qed.

End NRootCC_3.

(* Tex_Prose
\subsection{NRootCC 3'}
*)

Section NRootCC_3'.

(* Tex_Prose
\begin{convention}
Let \verb!c : IR! and \verb!n : nat! and \verb!nnz : (lt O n)!.
\end{convention}
*)
Variable c : IR.
Variable n : nat.
Hypothesis nnz: (lt O n).

(* Begin_Tex_Verb *)
Definition nrootCC_3'_poly := _X_[^]n[-](_C_ c).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrootCC_3' : (x:IR)(nrootCC_3'_poly!x [=] x[^]n[-]c).
(* End_Tex_Verb *)
Intros.
Unfold nrootCC_3'_poly.
Cut (_X_[^]n)!x [=] x[^]n. Intros.
(** Step_final (_X_[^]n)!x[-](_C_ c)!x. *)
  Apply eq_transitive_unfolded with (_X_[^]n)!x[-](_C_ c)!x.
  Apply minus_apply.
  Apply cg_minus_wd. Exact H. Apply _c_apply.
(** Step_final (_X_!x)[^]n. *)
  Apply eq_transitive_unfolded with (_X_!x)[^]n.
  Apply nexp_apply.
  Apply un_op_wd_unfolded. Apply _x_apply.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_3'_degree : (Degree n nrootCC_3'_poly).
(* End_Tex_Verb *)
Unfold nrootCC_3'_poly.
Apply (Degree_minus_lft ? (_C_ c) _X_[^]n O n).
Apply Degree_le_c_.
Replace (degree IR n) with (degree IR (mult (1) n)).
Apply Degree_nexp.
Apply Degree_x_.
Replace (mult (1) n) with n; Auto.
Unfold mult.
Auto with arith.
Assumption.
Qed.

End NRootCC_3'.

(* Tex_Prose
\subsection{NRootCC 4}
*)

Section NRootCC_4.

(* Tex_Prose
\subsubsection{NRootCC 4 ap real}
*)

Section NRootCC_4_ap_real.

(* Tex_Prose
\begin{convention}
Let \verb!a, b : IR! and \verb!bnz : b [#] Zero! and \verb!n:nat! and
\verb!on : (odd n)!.
\end{convention}
*)
Variable a, b : IR.
Hypothesis bnz : b [#] Zero.
Variable n : nat.
Hypothesis on : (odd n).

(* Begin_Tex_Verb *)
Local c := a[+I*]b.
(* End_Tex_Verb *)

Section NRootCC_4_solutions.

(* Begin_Tex_Verb *)
Lemma nrCC4_a1 :
  (Ex [r:IR]((r[+I*]One)[^]n[*](conj c)[-](r[+I*][--]One)[^]n[*]c [=] Zero)).
(* End_Tex_Verb *)
Elim (realpolyn_oddhaszero (nrootCC_3_poly a b n)).
Intro r. Intros.
Exists r.
(** Step (r[+I*]One)[^]n[*](a[+I*][--]b)[-](r[+I*][--]One)[^]n[*](a[+I*]b). *)
  Apply eq_transitive_unfolded with
    (r[+I*]One)[^]n[*](a[+I*][--]b)[-](r[+I*][--]One)[^]n[*](a[+I*]b).
  Apply eq_reflexive_unfolded.
Hints Resolve nrootCC_3 : algebra.
(** Step (cc_IR ((nrootCC_3_poly a b n)!r))[*](Two[*]I). *)
  Apply eq_transitive_unfolded with
    (cc_IR ((nrootCC_3_poly a b n)!r))[*](Two[*]I).
  Apply eq_symmetric_unfolded. Apply nrootCC_3.
(** Step (cc_IR Zero)[*](Two[*]I). *)
  Apply eq_transitive_unfolded with (cc_IR Zero)[*](Two[*]I).
  Apply bin_op_wd_unfolded. Apply cc_IR_1. Exact H. Apply eq_reflexive_unfolded.
(** Step_final Zero[*](Two[*]I). *)
  Apply eq_transitive_unfolded with Zero[*](Two[*]I).
  Apply eq_reflexive_unfolded.
  Apply cring_mult_zero_op.
Unfold odd_cpoly.
Exists n.
Split; Try Assumption.
Apply (nrootCC_3_degree a b bnz n).
Qed.

(* Tex_Prose
\begin{convention}
Let \verb!r2', c2 : IR! and \verb!r2'nz : r2' [#] Zero!.
\end{convention}
*)
Variable r2', c2 : IR.
Hypothesis r2'nz : r2' [#] Zero.

(* Begin_Tex_Verb *)
Lemma nrCC4_a1' : (Ex [y2:IR]((y2[*]r2')[^]n [=] c2)).
(* End_Tex_Verb *)
Elim (realpolyn_oddhaszero (nrootCC_3'_poly c2 n)).
Intro y2r2'. Intros.
Exists y2r2'[/](r2'[//]r2'nz).
(** Step y2r2'[^]n. *)
  Apply eq_transitive_unfolded with y2r2'[^]n.
  Apply un_op_wd_unfolded. Apply div_1.
(** Step y2r2'[^]n[+]Zero. *)
  Apply eq_transitive_unfolded with y2r2'[^]n[+]Zero.
  Apply eq_symmetric_unfolded. Apply cm_rht_unit_unfolded.
(** Step y2r2'[^]n[+]([--]c2[+]c2). *)
  Apply eq_transitive_unfolded with y2r2'[^]n[+]([--]c2[+]c2).
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded.
    Apply eq_symmetric_unfolded. Apply cg_lft_inv_unfolded.
(** Step (y2r2'[^]n[+][--]c2)[+]c2. *)
  Apply eq_transitive_unfolded with (y2r2'[^]n[+][--]c2)[+]c2.
  Apply plus_assoc_unfolded.
(** Step (y2r2'[^]n[-]c2)[+]c2. *)
  Apply eq_transitive_unfolded with (y2r2'[^]n[-]c2)[+]c2.
  Apply eq_reflexive_unfolded.
Hints Resolve nrootCC_3' : algebra.
(** Step (nrootCC_3'_poly c2 n)!y2r2'[+]c2. *)
  Apply eq_transitive_unfolded with (nrootCC_3'_poly c2 n)!y2r2'[+]c2.
  Apply bin_op_wd_unfolded. Apply eq_symmetric_unfolded. Apply nrootCC_3'.
    Apply eq_reflexive_unfolded.
(** Step_final Zero[+]c2. *)
  Apply eq_transitive_unfolded with Zero[+]c2.
  Apply bin_op_wd_unfolded. Exact H. Apply eq_reflexive_unfolded.
  Apply cm_lft_unit_unfolded.
Unfold odd_cpoly.
Exists n.
Split; Try Assumption.
Apply nrootCC_3'_degree.
Rewrite (odd_double n). Auto with arith.
Assumption.
Qed.

End NRootCC_4_solutions.

Section NRootCC_4_equations.

(* Tex_Prose
\begin{convention}
Let \verb!r,y2 : IR! with
\verb!(r[+I*]One)[^]n[*](conj c)[-](r[+I*][--]One)[^]n[*]c [=] Zero!
and
\verb!(y2[*](r[^](2)[+]One))[^]n [=] a[^](2)[+]b[^](2)!.
\end{convention}
*)
Variable r : IR.
Hypothesis r_property :
  (r[+I*]One)[^]n[*](conj c)[-](r[+I*][--]One)[^]n[*]c [=] Zero.
Variable y2 : IR.
Hypothesis y2_property :
  (y2[*](r[^](2)[+]One))[^]n [=] a[^](2)[+]b[^](2).

(* Begin_Tex_Verb *)
Lemma nrCC4_a2 : (Zero [:<] a[^](2)[+]b[^](2)).
(* End_Tex_Verb *)
Apply plus_resp_nonneg_pos.
Apply sqr_nonneg.
Apply pos_square.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC4_a3 : (Zero [:<] r[^](2)[+]One).
(* End_Tex_Verb *)
Apply plus_resp_nonneg_pos.
Apply sqr_nonneg.
Apply pos_one.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC4_a4 : (Zero [:<] y2).
(* End_Tex_Verb *)
Apply mult_cancel_pos_lft with r[^](2)[+]One.
Apply odd_power_cancel_pos with n.
Assumption.
Apply (pos_wd ??? y2_property).
Apply nrCC4_a2.
Apply nrCC4_a3.
Qed.

(* Begin_Tex_Verb *)
Definition nrCC4_y := (sqrt y2 (less_leEq ??? nrCC4_a4)).
Local y := nrCC4_y.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Definition nrCC4_x := y[*]r.
Local x := nrCC4_x.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC4_a5 : x [=] y[*]r.
(* End_Tex_Verb *)
Unfold x. Unfold nrCC4_x.
(** Algebra. *)
  Apply eq_reflexive_unfolded.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC4_a6 : (x[^](2)[+]y[^](2))[^]n [=] a[^](2)[+]b[^](2).
(* End_Tex_Verb *)
Unfold x. Unfold nrCC4_x.
Cut (y[*]r)[^](2)[+]y[^](2) [=] y[^](2)[*](r[^](2)[+]One). Intro.
(** Step (y[^](2)[*](r[^](2)[+]One))[^]n. *)
  Apply eq_transitive_unfolded with (y[^](2)[*](r[^](2)[+]One))[^]n.
  Apply un_op_wd_unfolded. Exact H.
Cut y[^](2) [=] y2. Intro.
(** Step_final (y2[*](r[^](2)[+]One))[^]n. *)
  Apply eq_transitive_unfolded with (y2[*](r[^](2)[+]One))[^]n.
  Apply un_op_wd_unfolded. Apply bin_op_wd_unfolded. Exact H0.
    Apply eq_reflexive_unfolded.
  Exact y2_property.
Unfold y. Unfold nrCC4_y.
Apply sqrt_sqr.
(** Step_final y[^](2)[*]r[^](2)[+]y[^](2)[*]One. *)
  Apply eq_transitive_unfolded with y[^](2)[*]r[^](2)[+]y[^](2)[*]One.
  Apply bin_op_wd_unfolded. Apply mult_nexp. Apply eq_symmetric_unfolded.
    Apply mult_one.
  Apply eq_symmetric_unfolded. Apply ring_dist_unfolded.
Qed.

(* Begin_Tex_Verb *)
Definition nrCC4_z := x[+I*]y.
Local z := nrCC4_z.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrCC4_a7 : (z[^]n[*](conj c)[-](conj z)[^]n[*]c) [=] Zero.
(* End_Tex_Verb *)
Unfold z. Unfold nrCC4_z.
(** Step (x[+I*]y)[^]n[*](conj c)[-](x[+I*][--]y)[^]n[*]c. *)
  Apply eq_transitive_unfolded with
    (x[+I*]y)[^]n[*](conj c)[-](x[+I*][--]y)[^]n[*]c.
  Apply eq_reflexive_unfolded.
Unfold x. Unfold nrCC4_x.
Cut ((y[*]r)[+I*]y)[^]n[*](conj c) [=]
  (cc_IR y)[^]n[*]((r[+I*]One)[^]n[*](conj c)). Intro.
Cut ((y[*]r)[+I*][--]y)[^]n[*]c [=]
  (cc_IR y)[^]n[*]((r[+I*][--]One)[^]n[*]c). Intro.
(** Step (cc_IR y)[^]n[*]((r[+I*]One)[^]n[*](conj c))[-]
    (cc_IR y)[^]n[*]((r[+I*][--]One)[^]n[*]c). *)
  Apply eq_transitive_unfolded with
    (cc_IR y)[^]n[*]((r[+I*]One)[^]n[*](conj c))[-]
    (cc_IR y)[^]n[*]((r[+I*][--]One)[^]n[*]c).
  Apply cg_minus_wd. Exact H. Exact H0.
(** Step (cc_IR y)[^]n[*]
    (((r[+I*]One)[^]n[*](conj c))[-]((r[+I*][--]One)[^]n[*]c)). *)
  Apply eq_transitive_unfolded with (cc_IR y)[^]n[*]
    (((r[+I*]One)[^]n[*](conj c))[-]((r[+I*][--]One)[^]n[*]c)).
  Apply eq_symmetric_unfolded. Apply dist_2a.
(** Step_final (cc_IR y)[^]n[*]Zero. *)
  Apply eq_transitive_unfolded with (cc_IR y)[^]n[*]Zero.
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Exact r_property.
  Apply cring_mult_zero.
Cut ((y[*]r)[+I*][--]y)[^]n [=] (cc_IR y)[^]n[*](r[+I*][--]One)[^]n. Intro.
(** Step_final ((cc_IR y)[^]n[*](r[+I*][--]One)[^]n)[*]c. *)
  Apply eq_transitive_unfolded with ((cc_IR y)[^]n[*](r[+I*][--]One)[^]n)[*]c.
  Apply bin_op_wd_unfolded. Exact H0. Apply eq_reflexive_unfolded.
  Apply eq_symmetric_unfolded. Apply mult_assoc_unfolded.
Cut (y[*]r)[+I*][--]y [=] (cc_IR y)[*](r[+I*][--]One). Intro.
(** Step_final ((cc_IR y)[*](r[+I*][--]One))[^]n. *)
  Apply eq_transitive_unfolded with ((cc_IR y)[*](r[+I*][--]One))[^]n.
  Apply un_op_wd_unfolded. Exact H0.
  Apply mult_nexp.
Cut [--]y [=] y[*][--]One. Intro.
(** Step_final (y[*]r)[+I*](y[*][--]One). *)
  Apply eq_transitive_unfolded with (y[*]r)[+I*](y[*][--]One).
  Apply I_wd. Apply eq_reflexive_unfolded. Exact H0.
  Apply eq_symmetric_unfolded. Apply cc_IR_4b.
(** Step_final [--](y[*]One). *)
  Apply eq_transitive_unfolded with [--](y[*]One).
  Apply un_op_wd_unfolded. Apply eq_symmetric_unfolded. Apply mult_one.
  Apply eq_symmetric_unfolded. Apply cring_minus_mult_lft.
Cut ((y[*]r)[+I*]y)[^]n [=] (cc_IR y)[^]n[*](r[+I*]One)[^]n. Intro.
(** Step_final ((cc_IR y)[^]n[*](r[+I*]One)[^]n)[*](conj c). *)
  Apply eq_transitive_unfolded with
    ((cc_IR y)[^]n[*](r[+I*]One)[^]n)[*](conj c).
  Apply bin_op_wd_unfolded. Exact H. Apply eq_reflexive_unfolded.
  Apply eq_symmetric_unfolded. Apply mult_assoc_unfolded.
Cut (y[*]r)[+I*]y [=] (cc_IR y)[*](r[+I*]One). Intro.
(** Step_final ((cc_IR y)[*](r[+I*]One))[^]n. *)
  Apply eq_transitive_unfolded with ((cc_IR y)[*](r[+I*]One))[^]n.
  Apply un_op_wd_unfolded. Exact H.
  Apply mult_nexp.
(** Step_final (y[*]r)[+I*](y[*]One). *)
  Apply eq_transitive_unfolded with (y[*]r)[+I*](y[*]One).
  Apply I_wd. Apply eq_reflexive_unfolded. Apply eq_symmetric_unfolded.
    Apply mult_one.
  Apply eq_symmetric_unfolded. Apply cc_IR_4b.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC4_a8 : (z[*](conj z))[^]n [=] c[*](conj c).
(* End_Tex_Verb *)
Unfold z.
Unfold nrCC4_z.
Unfold c.
(** Step (cc_IR x[^](2)[+]y[^](2))[^]n. *)
  Apply eq_transitive_unfolded with (cc_IR x[^](2)[+]y[^](2))[^]n.
  Apply un_op_wd_unfolded. Apply calculate_norm.
(** Step (cc_IR (x[^](2)[+]y[^](2))[^]n). *)
  Apply eq_transitive_unfolded with (cc_IR (x[^](2)[+]y[^](2))[^]n).
  Apply cc_IR_3.
Hints Resolve nrCC4_a6 : algebra.
(** Step_final (cc_IR (a[^](2)[+]b[^](2))). *)
  Apply eq_transitive_unfolded with (cc_IR (a[^](2)[+]b[^](2))).
  Apply cc_IR_1. Exact nrCC4_a6.
  Apply eq_symmetric_unfolded. Apply calculate_norm.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC4_a9 : (z[^]n [=] c) \/ (z[^]n [=] [--]c).
(* End_Tex_Verb *)
Apply nrootCC_2.
Right.
(** Step_ap_lft b. *)
  Apply ap_well_def_lft_unfolded with b.
  Exact bnz.
  Apply eq_reflexive_unfolded.
Apply nrCC4_a8.
Apply nrCC4_a7.
Qed.

End NRootCC_4_equations.

(* Begin_Tex_Verb *)
Lemma nrCC4_a10 : (c:CC)
  (Ex [z:CC]((z[^]n [=] c) \/ (z[^]n [=] [--]c)))->
    (Ex [z:CC](z[^]n [=] c)).
(* End_Tex_Verb *)
Intros.
Elim H. Intros.
Elim H0; Intros.
Exists x. Assumption.
Exists [--]x.
(** Step [--](x[^]n). *)
  Apply eq_transitive_unfolded with [--](x[^]n).
  Apply min_nexp_odd. Exact on.
(** Step_final [--][--]c0. *)
  Apply eq_transitive_unfolded with [--][--]c0.
  Apply un_op_wd_unfolded. Exact H1.
  Apply cg_inv_inv.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_4_ap_real : (Ex [z:CC](z[^]n [=] c)).
(* End_Tex_Verb *)
Apply nrCC4_a10.
Elim nrCC4_a1. Intro r. Intros.
Elim (nrCC4_a1' r[^](2)[+]One a[^](2)[+]b[^](2)). Intro y2. Intros.
Exists (nrCC4_z r y2 H0).
Apply nrCC4_a9. Assumption.
Change ((r[^](2))[+]One [#] Zero).
Apply pos_ap_zero.
Apply nrCC4_a3.
Qed.

End NRootCC_4_ap_real.

(* Tex_Prose
\subsubsection{NRootCC 4 ap imag}
*)

Section NRootCC_4_ap_imag.

(* Tex_Prose
\begin{convention}
Let \verb!a, b : IR! and \verb!n : nat!
with
\verb!a [#] Zero! and \verb!(odd n)!.
\end{convention}
*)
Variable a, b : IR.
Hypothesis anz : a [#] Zero.
Variable n : nat.
Hypothesis on : (odd n).

(* Begin_Tex_Verb *)
Local c' := (a[+I*]b)[*]I.
Local a' := (Re c').
Local b' := (Im c').
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma nrootCC_4_ap_real' : (Ex [z':CC](z'[^]n [=] a'[+I*]b')).
(* End_Tex_Verb *)
Apply nrootCC_4_ap_real; Try Assumption.
Apply (imag_to_real a b a' b').
(** Algebra. *)
  Apply eq_reflexive_unfolded.
(** Algebra. *)
  Exact anz.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_4_ap_imag : (Ex [z:CC](z[^]n [=] a[+I*]b)).
(* End_Tex_Verb *)
Elim nrootCC_4_ap_real'.
Intro z'.
Intro.
Exists z'[*](nroot_minus_I n on).
(** Step z'[^]n[*](nroot_minus_I n on)[^]n. *)
  Apply eq_transitive_unfolded with z'[^]n[*](nroot_minus_I n on)[^]n.
  Apply mult_nexp.
Hints Resolve nroot_minus_I_nexp : algebra.
(** Step (a'[+I*]b')[*][--]I. *)
  Apply eq_transitive_unfolded with (a'[+I*]b')[*][--]I.
  Apply bin_op_wd_unfolded. Exact H. Apply nroot_minus_I_nexp.
(** Step ((a[+I*]b)[*]I)[*][--]I. *)
  Apply eq_transitive_unfolded with ((a[+I*]b)[*]I)[*][--]I.
  Apply eq_reflexive_unfolded.
(** Step (a[+I*]b)[*](I[*][--]I). *)
  Apply eq_transitive_unfolded with (a[+I*]b)[*](I[*][--]I).
  Apply eq_symmetric_unfolded. Apply mult_assoc_unfolded.
(** Step_final (a[+I*]b)[*]One. *)
  Apply eq_transitive_unfolded with (a[+I*]b)[*]One.
  Apply bin_op_wd_unfolded. Apply eq_reflexive_unfolded. Exact I_inv_rht.
  Apply mult_one.
Qed.

End NRootCC_4_ap_imag.

(* Begin_Tex_Verb *)
Lemma nrootCC_4 : (c:CC)(c [#] Zero)->(n:nat)(odd n)->
  (Ex [z:CC](z[^]n [=] c)).
(* End_Tex_Verb *)
Intros.
Pattern c.
Apply cc_ap_zero; Try Assumption; Intros.
Apply nrootCC_4_ap_imag; Try Assumption.
Apply nrootCC_4_ap_real; Try Assumption.
Qed.

End NRootCC_4.


(* Tex_Prose
\subsection{NRootCC}
*)


Section NRootCC_5.

(* Begin_Tex_Verb *)
Lemma nrCC_5a1 :
  (P:nat->Prop)
  ((n:nat)(odd n)->(P n))-> ((n:nat)(lt O n)->(P n)->(P (double n)))->
    (n:nat)(lt O n)->(P n).
(* End_Tex_Verb *)

Cut (n:nat)(lt O (double n))->(lt O n). Intro.

Intro. Intro. Intro. Intro.
Pattern n.
Apply lt_wf_ind. Intros.
Generalize (even_or_odd n0). Intro. Elim H4.

Intro.
Rewrite (even_double n0).
Apply H1.
Apply H.
Rewrite <- (even_double n0). Assumption.
Assumption.
Apply H2.
Apply lt_div2. Assumption.
Rewrite (even_double n0) in H3.
Apply H. Assumption.
Assumption.
Assumption.

Exact (H0 n0).

Unfold double. Intros.
Case (zerop n). Intro.
Absurd (lt O (plus n n)).
Rewrite e. Auto with arith.
Assumption.
Intro. Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC_5a2 : (n:nat)(double n) = (mult (2) n).
(* End_Tex_Verb *)
Intros.
Unfold double.
Unfold mult.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma nrCC_5a3 : (n:nat)(z:CC)((z[^](2))[^]n [=] z[^](double n)).
(* End_Tex_Verb *)
Intros.
(** Step z[^](mult (2) n). *)
  Apply eq_transitive_unfolded with z[^](mult (2) n).
  Apply nexp_mult.
Rewrite <- nrCC_5a2.
(** Algebra. *)
  Apply eq_reflexive_unfolded.
Qed.
Hints Resolve nrCC_5a3 : algebra.

(* Tex_Prose
\begin{convention}
Let \verb!c : CC!
with
\verb!c [#] Zero!.
\end{convention}
*)
Variable c : CC.
Hypothesis cnz : c [#] Zero.

(* Begin_Tex_Verb *)
Lemma nrCC_5a4 : (n:nat)(lt O n)->
  (Ex [z:CC](z[^]n [=] c))->(Ex [z:CC](z[^](double n) [=] c)).
(* End_Tex_Verb *)
Intros.
Elim H0. Intros.
Elim (nrootCC_1 x). Intros.
Exists x0.
(** Step (x0[^](2))[^]n. *)
  Apply eq_transitive_unfolded with (x0[^](2))[^]n.
  Apply eq_symmetric_unfolded. Apply nrCC_5a3.
(** Step_final x[^]n. *)
  Apply eq_transitive_unfolded with x[^]n.
  Apply un_op_wd_unfolded. Exact H2.
  Exact H1.
Apply (un_op_strext ? (nexp_op CC n)).
(** Step_ap_lft c. *)
  Apply ap_well_def_lft_unfolded with c.
  2: Apply eq_symmetric_unfolded. 2: Exact H1.
(** Step_ap_rht Zero::CC. *)
  Apply ap_well_def_rht_unfolded with Zero::CC.
  Exact cnz.
  Apply eq_symmetric_unfolded. Apply zero_nexp. Exact x. Exact H.
Qed.

(* Begin_Tex_Verb *)
Lemma nrootCC_5 : (n:nat)(lt O n)->(Ex [z:CC](z[^]n [=] c)).
(* End_Tex_Verb *)
Intros.
Pattern n.
Apply nrCC_5a1.
Exact (nrootCC_4 c cnz).
Exact nrCC_5a4.
Assumption.
Qed.

End NRootCC_5.

(* Tex_Prose
\subsection{Final def}
*)

(* Begin_Tex_Verb *)
Definition nrootCC :
  (c:CC)(c [#] Zero)->(n:nat)(lt O n)->(Ex [z:CC](z[^]n [=] c))
    := nrootCC_5.
(* End_Tex_Verb *)


