(* $Id: Triangle.v,v 1.11 2000/11/10 11:27:35 freek Exp $ *)

Require Export CComplex.
	
(* Begin_Tex_Verb *)
Lemma triangle : (x,y:CC)(AbsCC (x[+]y)) [:<=] (AbsCC x)[+](AbsCC y).
(* End_Tex_Verb *)
Intros.
Elim x. Intros x1 x2.
Elim y. Intros y1 y2.
Unfold AbsCC. Simpl.
Apply power_cancel_leEq with (2). Auto.
Step_leEq_lft Zero[+]Zero::IR.
Apply plus_resp_leEq_both; Apply sqrt_nonneg.
Step_leEq_lft One[*](x1[+]y1)[*](x1[+]y1)[+]One[*](x2[+]y2)[*](x2[+]y2).
Step_Rat_leEq_rht
  (sqrt One[*]x1[*]x1[+]One[*]x2[*]x2 (cc_abs_aid ? x1 x2))[^](2)[+]
  (sqrt One[*]y1[*]y1[+]One[*]y2[*]y2 (cc_abs_aid ? y1 y2))[^](2)[+]
  Two[*](sqrt One[*]x1[*]x1[+]One[*]x2[*]x2 (cc_abs_aid ? x1 x2))[*]
    (sqrt One[*]y1[*]y1[+]One[*]y2[*]y2 (cc_abs_aid ? y1 y2)).
Step_leEq_rht
  (One[*]x1[*]x1[+]One[*]x2[*]x2)[+]
  (One[*]y1[*]y1[+]One[*]y2[*]y2)[+]
  Two[*](sqrt One[*]x1[*]x1[+]One[*]x2[*]x2 (cc_abs_aid ? x1 x2))[*]
    (sqrt One[*]y1[*]y1[+]One[*]y2[*]y2 (cc_abs_aid ? y1 y2)).
Apply shift_leEq_rht.
Step_Rat_leEq_rht
  Two[*]((sqrt One[*]x1[*]x1[+]One[*]x2[*]x2 (cc_abs_aid ? x1 x2))[*]
      (sqrt One[*]y1[*]y1[+]One[*]y2[*]y2 (cc_abs_aid ? y1 y2))[-]
    (x1[*]y1[+]x2[*]y2)).
Apply mult_resp_nonneg. Apply less_leEq. Apply pos_two.
Apply shift_leEq_lft.
Apply power_cancel_leEq with (2). Auto.
Apply mult_resp_nonneg; Apply sqrt_nonneg.
Step_leEq_rht
  (sqrt One[*]x1[*]x1[+]One[*]x2[*]x2 (cc_abs_aid ? x1 x2))[^](2)[*]
  (sqrt One[*]y1[*]y1[+]One[*]y2[*]y2 (cc_abs_aid ? y1 y2))[^](2).
Step_leEq_rht (One[*]x1[*]x1[+]One[*]x2[*]x2)[*]
  (One[*]y1[*]y1[+]One[*]y2[*]y2).
Apply shift_leEq_rht.
Step_Rat_leEq_rht (x1[*]y2[-]x2[*]y1)[^](2).
Apply sqr_nonneg.
Qed.

(* Begin_Tex_Verb *)
Lemma triangle_sum : (m,n:nat)(z:nat->CC)(le m (S n)) ->
  (AbsCC (Sum m n z)) [:<=] (Sum m n [i:nat](AbsCC (z i))).
(* End_Tex_Verb *)
Intros. Induction n; Intros.
Inversion H.
Unfold sum. Unfold sum1.
Step_leEq_lft (AbsCC Zero).
Step_leEq_rht Zero::IR.
Step_leEq_rht (AbsCC Zero).
Apply leEq_reflexive.
Elim (le_n_O_eq ? H1); Intros.
Unfold sum. Unfold sum1. Simpl.
Cut (AbsCC (Zero[+](z (0)))[-]Zero) [:<=] (Zero[+](AbsCC (z(0))))[-]Zero.
Auto.
Apply eq_imp_leEq.
Step_Rat_rht (AbsCC (z (0))).
Apply AbsCC_wd.
Rational.
Elim (le_lt_eq_dec ?? H); Intros.
Step_leEq_lft (AbsCC (Sum m n z)[+](z (S n))).
Apply leEq_wdr with (Sum m n [i:nat](AbsCC (z i)))[+](AbsCC (z (S n))).
Apply leEq_transitive with (AbsCC (Sum m n z))[+](AbsCC (z (S n))).
Apply triangle.
Apply plus_resp_leEq.
Apply Hrecn. Auto with arith.
Apply eq_symmetric_unfolded. Apply sum_last with f := [i:nat](AbsCC (z i)).
Rewrite y. Unfold sum. Unfold sum1.
Step_leEq_lft (AbsCC Zero).
Step_leEq_rht Zero::IR.
Step_leEq_rht (AbsCC Zero).
Apply leEq_reflexive.
Qed.

(*
Definition AbsCC_fun :=
	(Build_CSetoid_fun CC IR AbsCC AbsCC_wd AbsCC_strext).
Definition CC_is_CMetricField :=
(Build_is_CMetricField CC AbsCC_fun AbsCC_nonneg AbsCC_resp_mult triangle).

Definition CC_MF := (Build_CMetricField CC AbsCC_fun CC_is_CMetricField).

Definition CC_Cauchy_real := [s:nat->CC_MF][n:nat](Re (s n)).
Definition CC_Cauchy_imag := [s:nat->CC_MF][n:nat](Im (s n)).


Ax_iom is_Cauchy_real :
	(s : (MCauchySeq CC_MF)) (Cauchy_prop (CC_Cauchy_real s)).

Ax_iom is_Cauchy_imag :
	(s : (MCauchySeq CC_MF)) (Cauchy_prop (CC_Cauchy_imag s)).

Definition MCauchy2Cauchy1 := [s : (MCauchySeq CC_MF)]
	(Build_CauchySeq IR (CC_Cauchy_real s)(is_Cauchy_real s)).

Definition MCauchy2Cauchy2 := [s : (MCauchySeq CC_MF)]
	(Build_CauchySeq IR (CC_Cauchy_imag s)(is_Cauchy_imag s)).

Definition MakeMCauchy := [s_r : (CauchySeq IR); s_i : (CauchySeq IR)]
	[n:nat](Build_CC_set (s_r n)(s_i n)).

Ax_iom is_MCauchy :
	(s_r : (CauchySeq IR); s_i : (CauchySeq IR))
	 (MCauchy_prop CC_MF (MakeMCauchy s_r s_i)).

Definition Cauchy2MCauchy := [s_r : (CauchySeq IR); s_i : (CauchySeq IR)]
	(Build_MCauchySeq CC_MF (MakeMCauchy s_r s_i)
		(is_MCauchy s_r s_i)).

Definition LimCC := [s:(MCauchySeq CC_MF)]
	(Build_CC_set (Lim (MCauchy2Cauchy1 s))(Lim (MCauchy2Cauchy2 s))).
*)


