(* $Id: R_CField.v,v 1.6 2000/10/13 12:32:17 freek Exp $ *)

Require Export R_mul_CSemi_grp.

(* Summary 
      1- <R, Rplus, ZEROR, Ropp, Rmult, ONER> is CRing.
      2- Definitoin of Rinv on nonzero Cauchy sequences. 
      3- < ..., Rinv> is CField.
*) 

Section R_CField.

Variable a_COrdField : COrdField.

Syntactic Definition R_as_CSetoid' := (R_as_CSetoid a_COrdField).

Syntactic Definition Rplus_is_bin_fun' := (Rplus_is_bin_fun a_COrdField).
Syntactic Definition Rmult_is_bin_fun' := (Rmult_is_bin_fun a_COrdField).

Syntactic Definition ZEROR' := (ZEROR a_COrdField).
Syntactic Definition ONER' := (ONER a_COrdField).

Syntactic Definition R' := (R a_COrdField).
Syntactic Definition R_mul_as_CSemi_grp' := (R_mul_as_CSemi_grp a_COrdField).
Syntactic Definition R_as_CGroup' := (R_as_CGroup a_COrdField).
Syntactic Definition Rmult_is_assoc' := (Rmult_is_assoc a_COrdField).


Theorem ONER_as_rht_unit:(!is_rht_unit R_as_CSetoid' Rmult_is_bin_fun' ONER').
 Red.
 Simpl.
 Intro.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Unfold ONER.
 Unfold Rplus.
 Simpl.
 Change ( (absLSmall a_COrdField e
     ((CS_seq a_COrdField x m)[*]One::a_COrdField)
       [-](CS_seq a_COrdField x m))).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed. 


Lemma Rmult_is_commut :(commutes R_as_CSetoid' Rmult_is_bin_fun').
 Red.
 Simpl.
 Intros.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Unfold Rmult.
 Simpl.
 Change ( (absLSmall a_COrdField e
     ((CS_seq a_COrdField x m)[*](CS_seq a_COrdField y m))
    [-]((CS_seq a_COrdField y m)[*](CS_seq a_COrdField x m)))).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed. 

Definition R_mul_is_CMonoid :=(!Build_is_CMonoid R_mul_as_CSemi_grp' 
 ONER_as_rht_unit Rmult_is_commut).

Definition R_mul_as_CMonoid :=(!Build_CMonoid R_mul_as_CSemi_grp' 
		R_mul_is_CMonoid).

Lemma R_mult_plus_is_dist:(Distributive Rmult_is_bin_fun' Rplus_is_bin_fun').
 Red.
 Simpl.
 Intros.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Unfold Rplus.
 Unfold Rmult.
 Change (absLSmall a_COrdField e
     ((CS_seq a_COrdField x m)[*]
       ((CS_seq a_COrdField y m)[+](CS_seq a_COrdField z m)))
       [-](((CS_seq a_COrdField x m)[*](CS_seq a_COrdField y m))[+]
     ((CS_seq a_COrdField x m)[*](CS_seq a_COrdField z m)))).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed. 

Lemma ONER_neq_ZEROR:(ONER'::R_as_CSetoid'[#]ZEROR'::R_as_CSetoid').
Simpl.
 Apply ap_R_alt_2.
 Exists (One[/]TwoNZ)::a_COrdField.
 Split.
 Apply mult_cancel_less with 
		R:=a_COrdField
		z:=Two::a_COrdField.
 Apply pos_two.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht One::a_COrdField.
 Apply pos_one.
 Exists O.
 Intros.
 Right.
 Change (One[/]TwoNZ [:<] One::a_COrdField [-] Zero::a_COrdField).
 Apply mult_cancel_less with 
		R:=a_COrdField
		z:=Two::a_COrdField.
 Apply pos_two.
 Step_Rat_less_lft One::a_COrdField.
 Step_Rat_less_rht (One[+]One)::a_COrdField.
 Apply less_plusOne.
Qed.

Definition R_is_CRing:=(!Build_is_CRing R_as_CGroup' ONER' Rmult_is_bin_fun'
	Rmult_is_assoc' R_mul_is_CMonoid R_mult_plus_is_dist ONER_neq_ZEROR).

Definition R_as_CRing :=(!Build_CRing R_as_CGroup' ONER' Rmult_is_bin_fun'
		R_is_CRing).

Definition R_star:=(NonZeros R_as_CRing).

Lemma ap_from_zero:(x:R')(x::R_as_CSetoid'[#]ZEROR'::R_as_CSetoid')->
   (Ex [N:nat](Ex [e:a_COrdField]
    ((Zero[:<]e)/\((m:nat)(le N m)->(AbsBig e (CS_seq a_COrdField x m)))))).
 Intros.
 Cut(Ex [e:a_COrdField](Zero[:<]e)/\(Ex [N:nat](m:nat)(le N m)->
    ((CS_seq a_COrdField x m)
                        [-](CS_seq a_COrdField ZEROR' m) [:<] [--]e)
                     \/(e
                           [:<] (CS_seq a_COrdField x m)
                                  [-](CS_seq a_COrdField ZEROR' m)))).
 Intro.
 Case H0.
 Intros e H1.
 Elim H1.
 Intros.
 Case H3.
 Intros N H4.
 Exists N.
 Exists e.
 Split.
 Assumption.
 Intros.
 Step_Rat_AbsBig_rht  (CS_seq a_COrdField x m)[-]Zero.
 Change (absBig a_COrdField e 
	(CS_seq a_COrdField x m)[-](CS_seq a_COrdField ZEROR' m)).
 Split.
 Assumption.
 Cut (((CS_seq a_COrdField x m)[-](CS_seq a_COrdField ZEROR' m)
         [:<] [--]e)\/ (e
       [:<] (CS_seq a_COrdField x m)[-](CS_seq a_COrdField ZEROR' m))).
 Intro.
 Case H6.
 Intro.
 Right.
 Assumption.
 Intro.
 Left.
 Assumption.
 Apply H4.
 Assumption.
 Apply ap_R_alt_1.
 Assumption.
Qed.


Lemma ap_from_zero_2:(x:R_star)(EX N:nat |
      (EX e:(a_COrdField) |
         (Zero [:<] e)
         /\((m:nat)
             (le N m)
           ->(absBig a_COrdField e (CS_seq a_COrdField (NZinj x) m))))).
 Intros.
 Case x.
 Intros xR pxR.
 Simpl.
 Apply ap_from_zero.
 Apply pxR.
Qed.

Theorem ap_from_zero_local_1:(x:R_star) (Ex [N:nat](EX e:(a_COrdField) |
       (Zero [:<] e)
       /\((m:nat)
           (le N m)
           ->(absBig a_COrdField e
               (CS_seq a_COrdField (nzinj R_as_CRing x) m))
       /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero)))).
 Intros.
 Cut (EX N:nat |
    (EX e:(a_COrdField) |
       (Zero [:<] e)
       /\((m:nat)
           (le N m)
           ->(absBig a_COrdField e
               (CS_seq a_COrdField (nzinj R_as_CRing x) m))))).   
 Intro. 
 Case H.
 Intros N H0.
 Exists N.
 Case H0.
 Intros e H1.
 Exists e.
 Elim H1.
 Intros.
 Split.
 Assumption.
 Intros.
 Split.
 Apply H3.
 Assumption.
 Cut(absBig a_COrdField e
            (CS_seq a_COrdField (nzinj R_as_CRing x) m)).
 Intro.
 Elim H5.
 Intros.
 Case H7.
 Intro.
 Apply Greater_imp_ap.
 Apply less_transitive_unfolded with F:=a_COrdField y:=e.
 Assumption.
 Assumption.
 Intro.
 Apply less_imp_ap.
 Apply less_transitive_unfolded with F:=a_COrdField y:=[--]e.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply H3.
 Assumption.
 Apply ap_from_zero_2.
Qed.


Lemma ap_from_zero_3_1:(x:(R_star))
 {N:nat | (EX e:(a_COrdField) |
       (Zero [:<] e)
       /\((m:nat)
           (le N m)
           ->(absBig a_COrdField e
               (CS_seq a_COrdField (nzinj R_as_CRing x) m))
       /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero)))}.
 Intro.
 Apply ex_informative with A:=nat
		P:=[N:nat](EX e:(a_COrdField) |
       (Zero [:<] e)
       /\((m:nat)
           (le N m)
           ->(absBig a_COrdField e
               (CS_seq a_COrdField (nzinj R_as_CRing x) m))
       /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero))).
 Apply ap_from_zero_local_1.
Qed.


(**************************** SECTION PROJECTION *****************************)
Section projection. 
 Variable A:Set.
 Variable P:A->Prop.
 
 Definition projP1:=[H:(sig A P)] let (x,h) = H in x.
 Definition projP2:=[H:(sig A P)]<[H:(sig A P)](P (projP1 H))>
			let (x,h) = H in h.
End projection.
(********************************* END ***************************************)



Definition F_1:R_star->nat :=[x:R_star](let (N,_)=(ap_from_zero_3_1 x) in N).  

Definition PF_1:=[x:R_star](projP2 nat   
 [N:nat](EX e:(a_COrdField) |
       (Zero [:<] e)
       /\((m:nat)
           (le N m)
           ->(absBig a_COrdField e
               (CS_seq a_COrdField (nzinj R_as_CRing x) m))
       /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero)))
   (ap_from_zero_3_1 x)).

Lemma property1:(x:R_star)(EX e:(a_COrdField) |
       (Zero [:<] e)
       /\((m:nat)
           (le (F_1 x) m)
           ->(absBig a_COrdField e
               (CS_seq a_COrdField (nzinj R_as_CRing x) m))
       /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero))).
 Intros.
 Cut([N:nat](EX e:(a_COrdField) |
       (Zero [:<] e)
       /\((m:nat)
           (le N m)
           ->(absBig a_COrdField e
               (CS_seq a_COrdField (nzinj R_as_CRing x) m))
       /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero)))
     (projP1 nat
	[N:nat](EX e:(a_COrdField) |
       (Zero [:<] e)
       /\((m:nat)
           (le N m)
           ->(absBig a_COrdField e
               (CS_seq a_COrdField (nzinj R_as_CRing x) m))
       /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero)))
 (ap_from_zero_3_1 x))). 
 Intro.
 Apply H.
 Exact (PF_1 x).
Qed.

Lemma property1_1:(x:R_star)(EX e:(a_COrdField) |
    (Zero [:<] e)
    /\((m:nat)
        (le (F_1 x) m)
        ->(absBig a_COrdField e
            (CS_seq a_COrdField (nzinj R_as_CRing x) m)))).
 Intro.
 Cut (EX e:(a_COrdField) |
    (Zero [:<] e)
    /\((m:nat)
        (le (F_1 x) m)
        ->(absBig a_COrdField e
            (CS_seq a_COrdField (nzinj R_as_CRing x) m))
          /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero))). 
 Intro.
 Case H.
 Intros e H0.
 Exists e.
 Elim H0.
 Intros.
 Split.
 Assumption.
 Intros.
 Cut ((absBig a_COrdField e
            (CS_seq a_COrdField (nzinj R_as_CRing x) m))
          /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero)).
 Intro.
 Elim H4.
 Intros.
 Assumption.
 Apply H2.
 Assumption.
 Apply property1.
Qed.

Lemma property1_2 : (x:R_star)(m:nat)(le (F_1 x) m) -> 
       (CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero.
 Intros.
 Cut (EX e:(a_COrdField) |
    (Zero [:<] e)
    /\((m:nat)
        (le (F_1 x) m)
        ->(absBig a_COrdField e
            (CS_seq a_COrdField (nzinj R_as_CRing x) m))
          /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero))). 
 Intro.
 Case H0.
 Intros e H1.
 Elim H1.
 Intros.
 Cut ((absBig a_COrdField e
            (CS_seq a_COrdField (nzinj R_as_CRing x) m))
          /\((CS_seq a_COrdField (nzinj R_as_CRing x) m) [#] Zero)). 
 Intro.
 Elim H4.
 Intros.
 Assumption.
 Apply H3.
 Assumption.
 Apply property1.
Qed.


Lemma lt_le_dec:(n,m:nat){lt n m}+{le m n}.
 Intros.
 Case (lt_eq_lt_dec n m).
 Intro.
 Case s.
 Intro.
 Left.
 Assumption.
 Intro.
 Right.
 Rewrite e.
 Constructor.
 Intro.
 Right.
 Apply lt_le_weak.
 Assumption.
Qed.

Definition inv_seq : (R_star -> (nat-> a_COrdField)).
Intro x.
Intro m.
Elim (lt_le_dec m (F_1 x)).
Intro.
Exact Zero.
Intro.
Generalize (property1_2 x m y).
Intro.
Exact (One[/](CS_seq a_COrdField (nzinj R_as_CRing x) m)[//]H).
Defined.

Lemma ElimR :( P:((c:(CauchySeq a_COrdField))
           (c::R_as_CSetoid'[#]Zero::R_as_CGroup')->Prop))
        ((c_:(nat->(a_COrdField)); pc:(Cauchy_prop c_);
   d:((Build_CauchySeq a_COrdField c_ pc)::R_as_CGroup'[#]Zero::R_as_CGroup'))
          (P (Build_CauchySeq a_COrdField c_ pc) d))
       ->(c:(CauchySeq a_COrdField);d:(c::R_as_CSetoid'[#]Zero::R_as_CGroup'))
 		(P c d).

 Intros.
 Induction c.
 Apply H.
Qed.



Lemma AbsBigSmall_inv:(OF:COrdField;x,e:OF)(AbsBig e x)->
   (H:x[#]Zero;J:e[#]Zero)(AbsSmall One[/]e[//]J One[/]x[//]H).
 Intros.
 Elim H.
 Intros.
 Split.
 Case H2.
 Intro.
 Apply less_transitive_unfolded with y:=Zero::OF.
 Apply min_cancel_less.
 Apply mult_cancel_less with z:=e.
 Assumption.
 Step_Rat_less_lft Zero::OF.
 Step_Rat_less_rht One::OF.
 Apply pos_one.
 Apply mult_cancel_less with z:=x.
 Apply less_transitive_unfolded with y:=e.
 Assumption.
 Assumption.
 Step_Rat_less_lft Zero::OF.
 Step_Rat_less_rht One::OF.
 Apply pos_one.
 Intro.
 Apply mult_cancel_less with z:=e[*]([--]x).
 Apply mult_resp_pos.
 Assumption.
 Apply less_transitive_unfolded with y:=e.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft x.
 Assumption.
 Step_Rat_less_lft x.
 Step_Rat_less_rht [--]e.
 Assumption.
 
 Case H2.
 Intros.
 Apply mult_cancel_less with z:=e[*]x.
 Apply mult_resp_pos.
 Assumption.
 Apply less_transitive_unfolded with y:=e.
 Assumption.
 Assumption.
 Step_Rat_less_lft e.
 Step_Rat_less_rht x.
 Assumption. 
 Intro.
 Apply less_transitive_unfolded with y:=Zero::OF.
 Apply mult_cancel_less with z:=[--]x.
 Apply less_transitive_unfolded with y:=e.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft x.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::OF.
 Step_Rat_less_rht One::OF.
 Apply pos_one. 
 Apply mult_cancel_less with z:=e.
 Assumption.
 Step_Rat_less_lft Zero::OF.
 Step_Rat_less_rht One::OF.
 Apply pos_one.
Qed.



Theorem CS_seq_inv :(x:R_star)(Cauchy_prop (inv_seq x)).
 Intros.
 Elim x.
 Intros xR pxR.
 Change  (Cauchy_prop (inv_seq (nzpro R_as_CRing xR pxR))).
 Apply ElimR with P:=[c:R';pc:c::R_as_CSetoid'[#]Zero::R_as_CGroup']
	(Cauchy_prop (inv_seq (nzpro R_as_CRing c pc))).
 Intros x_ px.    (* equiv. Induction xR *)
 Intro.
 Unfold Cauchy_prop.
 Unfold Cauchy_prop in px.
 
 Intros.
 Cut  (EX e:(a_COrdField) |
    (Zero [:<] e)
    /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m)
        ->(absBig a_COrdField e (x_ m)))).
 Intro.
 Case H0.
 Intros e0 H1.
 Elim H1.
 Intros.
 Cut (e0[#]Zero).
 Intro.
 Cut (EX N:nat | (m:nat)
           (le N m)->(absSmall a_COrdField (e[*]e0[*]e0)[/]EighteenNZ 
     (x_ m)[-](x_ N))).
 Intro px1.
 Case px1.
 Intros N H5.

 Exists 
    (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N).

 Intros.
  
 Cut (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m).
 Intros.
 Cut (~(lt m (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
   )).
 Intro nH7.

 Cut (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
  (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N)).
 Intro.

 Cut (~(lt  
    (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N)
    (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)))).
 Intro nH8.
 Cut ((x_ m)[#]Zero).
 Intro.
 Cut ((x_ (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) 
                 d)) N))[#]Zero).
 Intro.

 Step_AbsSmall_rht ((One[/](x_ m)[//] (property1_2 
          (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d) m H7))[-]
        (One[/](x_  (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N))[//] (property1_2 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)
                 (plus
           (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N)
                 H8))).

 Step_Rat_AbsSmall_lft Three[*]((One[/]e0[//]H4)[*]
		(Three[*]((One[/]e0[//]H4)[*]((e[*]e0[*]e0)[/]NineNZ)))).


 Step_Rat_AbsSmall_rht ((One[/](x_ m)[//]H9)[*] 
            ((One[/](x_  
   (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N))
  [//]H10)[*]
   ((x_ 
   (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N))
   [-](x_ m)))).


 Apply AbsSmall_mult.
 Apply AbsBigSmall_inv.
 Apply H3.
 Assumption.
 
 Apply AbsSmall_mult.
 Apply AbsBigSmall_inv.
 Apply H3.
 Assumption.

 Step_Rat_AbsSmall_rht 
 ((x_ 
   (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N))
   [-](x_ N))[+]((x_ N)[-](x_ m)).
 Step_Rat_AbsSmall_lft ((e[*]e0[*]e0)[/]EighteenNZ)[+] 
		       ((e[*]e0[*]e0)[/]EighteenNZ).
 Apply AbsSmall_plus.
 Apply H5.
 Apply le_plus_r.
 Apply AbsSmall_minus.
 Apply H5.
 Apply le_trans with 
 		m:= (plus (F_1 (nzpro R_as_CRing 
                     (Build_CauchySeq a_COrdField x_ px) d)) N).
 Apply le_plus_r.
 Assumption.

 Unfold inv_seq.
 Unfold sumbool_rec.
 Apply cg_minus_wd.
 Case (lt_le_dec m 
	(F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))). 
 Intros.
 Apply False_ind.
 Apply nH7.
 Assumption.
 Intro.

 Algebra.

 Case (lt_le_dec  
   (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N)
    (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))).
   
 Intros.
 Apply False_ind.
 Apply nH8.
 Assumption.
 Intro.
 Algebra.
 
 Exact((property1_2 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)
       (plus
       (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N) 
        H8)).
 Exact( (property1_2 
          (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d) m H7)).
 
 Apply le_not_lt.
 Assumption.
 Apply le_plus_l.
 
 Apply le_not_lt.
 Assumption.
 Apply le_trans with m:= (plus 
  (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) N).
 Apply le_plus_l.
 Assumption.

 Apply px.
 Apply mult_cancel_less with R:=a_COrdField z:=Eighteen::a_COrdField.
 Apply nring_pos.
 Apply lt_O_Sn.
 
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e[*](e0[*]e0).
 Apply mult_resp_pos.
 Assumption.
 Apply mult_resp_pos.
 Assumption.
 Assumption.
 
 Apply Greater_imp_ap.
 Assumption.
 Change (EX e0:(a_COrdField) |
      (Zero [:<] e0)
      /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m)
          ->(absBig a_COrdField e0 
        (CS_seq a_COrdField (Build_CauchySeq a_COrdField x_ px) m)))). 
 Change (EX e0:(a_COrdField) |
      (Zero [:<] e0)
      /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m)
          ->(absBig a_COrdField e0 
        (CS_seq a_COrdField 
(nzinj R_as_CRing (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
 m)))).
Apply property1_1.
Qed.





Theorem  inv_seq_nonzero:(x:R_star)
 ((Build_CauchySeq a_COrdField (inv_seq x) (CS_seq_inv x))::R_as_CRing
					 [#]Zero::R_as_CRing).
 Intros.
 Elim x.
 Intros xR pxR.
 Change  ((Build_CauchySeq a_COrdField
     (inv_seq (nzpro R_as_CRing xR pxR))       
     (CS_seq_inv (nzpro R_as_CRing xR pxR)))::R_as_CSetoid' [#] 
	Zero::R_as_CRing).

 Apply ElimR with P:=[c:R';pc:c::R_as_CSetoid'[#]Zero::R_as_CGroup']
	((Build_CauchySeq a_COrdField
     	(inv_seq (nzpro R_as_CRing c pc ))       
     	(CS_seq_inv (nzpro R_as_CRing c pc)))::R_as_CSetoid' [#] 
	Zero::R_as_CRing).

 Intros x_ px.    (* equiv. Induction xR *)
 Intro.
 
 Change ((Build_CauchySeq a_COrdField
     (inv_seq (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
     (CS_seq_inv (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)))
       ::R_as_CRing
       [#] ZEROR'::R_as_CRing).
Simpl.
 Apply ap_R_alt_2.
 Unfold ZEROR.
 Unfold CS_seq.

 Cut (EX K:a_COrdField |
             (K [#] Zero)
             /\(EX N:nat | (m:nat)(le N m)->(AbsSmall K (x_ m)))).
 Intro inv_seq_bounded.
 Cut  (EX e:(a_COrdField) |
    (Zero [:<] e)
    /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m)
        ->(absBig a_COrdField e (x_ m)))). 
 Intro.
 Case inv_seq_bounded.
 Intros K I.
 Elim I.
 Intros KNZ I0.
 Elim I0.
 Intros N I1.
 
 Case H.
 Intros e H0.
 Elim H0.
 Intros.

 Exists (One[/]K[//]KNZ).
 Split.
 
 Apply mult_cancel_less with R:=a_COrdField z:=K.
 Apply AbsSmall_pos with x:=(x_ N).
 Apply I1.
 Constructor.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht One::a_COrdField.
 Apply pos_one.
 
 Exists (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)
              ) N).
 Intros.
   
 Cut (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m).
 Intros.
 Cut (~(lt m (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
   )).
 Intro nH4.
 Cut ((x_ m)[#]Zero).
 Intro.

 Cut (absBig a_COrdField e (x_ m)).
 Intro.
 Elim H6.
 Intros.
 
 Cut (absSmall a_COrdField K (x_ m)).
 Intro.
 Elim H9.
 Intros.
 
 Case H8.
 Intro.
 Right.
 Step_Rat_less_rht  ((inv_seq (nzpro R_as_CRing 
	(Build_CauchySeq a_COrdField x_ px) d)) m).
 Step_less_rht (One[/](x_ m)[//]H5).
 Apply mult_cancel_less with R:=a_COrdField z:=K[*](x_ m).
 Apply mult_resp_pos.
 Apply AbsSmall_pos with x:=(x_ N).
 Apply I1.
 Constructor.
 Apply less_transitive_unfolded with F:=a_COrdField y:=e.
 Assumption.
 Assumption.
 Step_Rat_less_lft (x_ m).
 Step_Rat_less_rht K.
 Assumption.
 
 Unfold inv_seq.
 Unfold sumbool_rec.
 Case (lt_le_dec m 
	(F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))). 
 Intros.
 Apply False_ind.
 Apply nH4.
 Assumption.
 Intro.

 Algebra.

 Intro.
 Left.
 Step_Rat_less_lft  ((inv_seq (nzpro R_as_CRing 
	(Build_CauchySeq a_COrdField x_ px) d)) m).
 Step_less_lft (One[/](x_ m)[//]H5).
 Apply mult_cancel_less with R:=a_COrdField z:=K[*]([--](x_ m)).
 Apply mult_resp_pos.
 Apply AbsSmall_pos with x:=(x_ N).
 Apply I1.
 Constructor.
 Apply less_transitive_unfolded with F:=a_COrdField y:=e.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft (x_ m).
 Assumption.
 Step_Rat_less_rht (x_ m).
 Step_Rat_less_lft [--]K.
 Assumption.
 
 Unfold inv_seq.
 Unfold sumbool_rec.
 Case (lt_le_dec m 
	(F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))). 
 Intros.
 Apply False_ind.
 Apply nH4.
 Assumption.
 Intro.

 Algebra.

 Apply I1.
 Apply le_trans with m:=(plus (F_1 (nzpro R_as_CRing 
	(Build_CauchySeq a_COrdField x_ px) d)) N).
 Apply le_plus_r.
 Assumption.
 
 Apply H2.
 Apply le_trans with m:=(plus (F_1 (nzpro R_as_CRing 
	(Build_CauchySeq a_COrdField x_ px) d)) N).
 Apply le_plus_l.
 Assumption.
 
 Exact( (property1_2 
          (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d) m H4)).
 Apply le_not_lt.
 Assumption.
 Apply le_trans with m:=(plus (F_1 (nzpro R_as_CRing 
	(Build_CauchySeq a_COrdField x_ px) d)) N).
 Apply le_plus_l.
 Assumption.
 Change (EX e0:(a_COrdField) |
      (Zero [:<] e0)
      /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m)
          ->(absBig a_COrdField e0 
        (CS_seq a_COrdField 
 (nzinj R_as_CRing (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
 m)))).
 Apply property1_1.
 Apply CS_seq_bounded.
 Exact px.
Qed.
 
 

Definition Rinv:R_star->R_star:=[x:R_star]
(nzpro R_as_CRing (Build_CauchySeq a_COrdField (inv_seq x) (CS_seq_inv x)) 
  (inv_seq_nonzero x)).


Lemma AbsBig_mult: (OF:COrdField; e1,e2,x1,x2:(OF))
        (absBig OF e1 x1)
        ->(absBig OF e2 x2)
        ->(absBig OF (e1[*]e2) x1[*]x2).
 Intros.
 Elim H.
 Intros.
 Elim H0.
 Intros.
 Cut (Zero[:<]e1[*]e2).
 Intro.
 Split.
 Assumption.
 
 Case H2.
 Intro.
 Case H4.
 Intro.
 Left.
 Apply less_transitive_unfolded with F:=OF y:=e1[*]x2.
 Apply mult_resp_less_lft.
 Assumption.
 Assumption.
 Apply mult_resp_less.
 Assumption.
 Apply less_transitive_unfolded with F:=OF y:=e2.
 Assumption.
 Assumption.

 Intro.
 Right.
 Apply less_transitive_unfolded with F:=OF y:=e1[*]x2.
 Apply min_cancel_less.
 Step_Rat_less_lft ([--]x2)[*]e1.
 Step_Rat_less_rht ([--]x2)[*]x1.
 Apply mult_resp_less_lft.
 Assumption.
 Apply less_transitive_unfolded with y:=e2.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft x2.
 Assumption.
 Step_Rat_less_rht e1[*]([--]e2).
 Apply mult_resp_less_lft.
 Assumption.
 Assumption.
 
 Intro.
 Case H4.
 Intro.
 Right.
 Apply less_transitive_unfolded with F:=OF y:=([--]e1)[*]x2.
 Apply mult_resp_less.
 Assumption.
 Apply less_transitive_unfolded with y:=e2.
 Assumption.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft e1[*]e2.
 Step_Rat_less_rht e1[*]x2.
 Apply mult_resp_less_lft.
 Assumption.
 Assumption.

 Intro.
 Left.
 Apply less_transitive_unfolded with e1[*]([--]x2).  
 Apply mult_resp_less_lft.
 Apply min_cancel_less.
 Step_Rat_less_lft x2.
 Assumption.
 Assumption.
 Step_Rat_less_rht ([--]x1)[*]([--]x2).
 Apply mult_resp_less.
 Apply min_cancel_less.
 Step_Rat_less_lft x1.
 Assumption.
 Apply less_transitive_unfolded with y:=e2.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft x2.
 Assumption.
 Apply mult_resp_pos.
 Assumption.
 Assumption.
Qed. 

Lemma AbsBig_minus:(OF:COrdField; e,x1,x2:(OF))
        (absBig OF e x1[-]x2)->(absBig OF e x2[-]x1).
 Intros.
 Elim H.
 Intros.
 Split.
 Assumption.
 Case H1.
 Intro.
 Right.
 Apply min_cancel_less.
 Step_Rat_less_lft e.
 Step_Rat_less_rht x1[-]x2.
 Assumption.
 Intro.
 Left.
 Apply min_cancel_less.
 Step_Rat_less_lft x1[-]x2.
 Assumption.
Qed.



Theorem Rinv_is_extensional:(!fun_strong_ext R_star R_star Rinv).  
 Red.
 Intros x y.
 
 Elim x.
 Intros xR pxR.
 Elim y.
 Intros yR pyR.
 Change (((Rinv (nzpro R_as_CRing xR pxR))[#](Rinv (nzpro R_as_CRing yR pyR)))
           ->(xR[#]yR)).  
 Apply ElimR with P:=[c:R';pc:c::R_as_CSetoid'[#]Zero::R_as_CGroup']
	((Rinv (nzpro R_as_CRing c pc))[#](Rinv (nzpro R_as_CRing yR pyR)))
           ->(c::R_as_CRing[#]yR).	
 
 Intros x_ px.
 Intro.
 Apply ElimR with P:=[c:R';pc:c::R_as_CSetoid'[#]Zero::R_as_CGroup']
	((Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
         [#](Rinv (nzpro R_as_CRing c pc)))
        ->((Build_CauchySeq a_COrdField x_ px)::R_as_CRing[#]c::R_as_CRing).
 Intros y_ py.
 Intro b.
 Intro.  
Simpl.
 Apply ap_R_alt_2.
 Cut (EX e:(a_COrdField) |
      (Zero [:<] e)
      /\(EX N:nat |
           (m:nat)
            (le N m)
            ->((CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))) m)
                 [-](CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))) m)
                  [:<] [--]e)
              \/(e
                    [:<] (CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))) m)
                           [-](CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b)))
                                m)))). 
 
 Intro.
 Case H0.
 Intros e H01.
 Elim H01.
 Intros H02 H03.
 Case H03.
 Intros N H04.
 Cut  (EX e:(a_COrdField) |
    (Zero [:<] e)
    /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m)
        ->(absBig a_COrdField e (x_ m)))).
 Intro.  
 Case H1.
 Intros e1 H11.
 Elim H11.
 Intros H12 H13.
 Cut  (EX e:(a_COrdField) |
    (Zero [:<] e)
    /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b)) m)
        ->(absBig a_COrdField e (y_ m)))). 
 Intro.
 Case H2.
 Intros e2 H21.
 Elim H21.
 Intros H22 H23.
 Exists (e1[*]e2)[*]e.
 
 Split.
 Apply mult_resp_pos.
 Apply mult_resp_pos.
 Assumption.
 Assumption.
 Assumption.
 
 Exists (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
        (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
              N)).
 Intros.
 Cut (AbsBig (e1[*]e2)[*]e
      (CS_seq a_COrdField (Build_CauchySeq a_COrdField x_ px) m)
      [-](CS_seq a_COrdField (Build_CauchySeq a_COrdField y_ py) m)). 
 Intro.
 Elim H4.
 Intros.
 Case H6.
 Intro.
 Right.
 Assumption.
 Intro.
 Left.
 Assumption.
 
 Unfold CS_seq.
 Cut ((x_ m)[#]Zero).
 Intro.
 Cut ((y_ m)[#]Zero).
 Intro.
 Step_Rat_AbsBig_rht ((x_ m)[*](y_ m))[*]
		     ((One[/](y_ m)[//]H5)[-](One[/](x_ m)[//]H4)).
 Apply AbsBig_mult.
 Apply AbsBig_mult.
 
 Apply H13.
 Apply le_trans with 
   m:=(plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
        (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
              N)).
 Rewrite plus_permute with 
  m:=(F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)).
 Apply le_plus_l.
 Assumption.

 Apply H23.
 Apply le_trans with 
   m:=(plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
        (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
              N)). 
 Apply le_plus_l.
 Assumption.

 Apply AbsBig_minus.
 Step_AbsBig_rht 
  (CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))) m)
                 [-](CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))) m).     
 Cut (((CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))) m)
                 [-](CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))) m)
                  [:<] [--]e)
              \/(e
                    [:<] (CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))) m)
                           [-](CS_seq a_COrdField
  (NZinj (Rinv (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b)))
                                m))). 
 Intro.
 Split.
 Assumption.
 Case H6.
 Intro.
 Right.
 Assumption.
 Intro.
 Left.
 Assumption.
 Apply H04.
 Apply le_trans with 
   m:=(plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
        (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
              N)). 
 Rewrite plus_sym with m:=N.
 Rewrite plus_permute with m:=N.
 Apply le_plus_l.
 Assumption.
    
 Cut (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m).
 Intros.
 Cut (~(lt m (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
   )).
 Intro nH6.
   
 Cut (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b)) m).
 Intros.
 Cut (~(lt m (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
   )).
 Intro nH7.
 Apply cg_minus_wd.
 
 Unfold Rinv.
 Change ( 
 ((inv_seq (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m)
 	[=](One[/](x_ m)[//]H4)).
 
 Unfold inv_seq.
 Unfold sumbool_rec.
 Case (lt_le_dec m 
	(F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))). 
 Intros.
 Apply False_ind.
 Apply nH6.
 Assumption.
 Intro.

 Algebra.

 Unfold Rinv.
 Change ( 
 ((inv_seq (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b)) m)
 	[=](One[/](y_ m)[//]H5)).
 
 Unfold inv_seq.
 Unfold sumbool_rec.
 Case (lt_le_dec m 
	(F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))). 
 Intros.
 Apply False_ind.
 Apply nH7.
 Assumption.
 Intro.

 Algebra.

 Apply le_not_lt.
 Assumption.
 Apply le_trans with 
   m:=(plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
        (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
              N)).
 Apply le_plus_l.
 Assumption.
 Apply le_not_lt.
 Assumption.
 Apply le_trans with 
   m:=(plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
        (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
              N)).
 Rewrite plus_permute with 
  m:=(F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)).
 Apply le_plus_l.
 Assumption.
 Cut (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b)) m).
 Intros. 
 Exact( (property1_2 
          (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b) m H5)).
 Apply le_trans with 
   m:=(plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
        (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
              N)).
 Apply le_plus_l.
 Assumption. 
  
 Cut (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m).
 Intros. 
 Exact( (property1_2 
          (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d) m H4)).
 Apply le_trans with 
   m:=(plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
        (plus (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
              N)).
 Rewrite plus_permute with 
  m:=(F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)).
 Apply le_plus_l.
 Assumption. 

 Change (EX e0:(a_COrdField) |
      (Zero [:<] e0)
      /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b)) m)
          ->(absBig a_COrdField e0 
        (CS_seq a_COrdField 
 (nzinj R_as_CRing (nzpro R_as_CRing (Build_CauchySeq a_COrdField y_ py) b))
 m)))).
 Apply property1_1.
 Change (EX e0:(a_COrdField) |
      (Zero [:<] e0)
      /\((m:nat)
       (le (F_1 (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d)) m)
          ->(absBig a_COrdField e0 
        (CS_seq a_COrdField 
 (nzinj R_as_CRing (nzpro R_as_CRing (Build_CauchySeq a_COrdField x_ px) d))
 m)))).
 Apply property1_1. 

 Apply ap_R_alt_1.
 Assumption.
Qed.


Lemma Rinv_is_well_defined:(!fun_well_def R_star R_star Rinv).
 Red.
 Intros.
 Apply not_ap_imp_eq.
 Intro.
 Cut (~(x[#]y)).
 Intro.
 Apply H1.
 Apply Rinv_is_extensional.
 Assumption.
 Apply eq_imp_not_ap.
 Assumption.
Qed.

Definition Rinv_is_fun := (!Build_CSetoid_fun R_star R_star Rinv
		Rinv_is_well_defined Rinv_is_extensional).


Theorem  R_is_CField:(is_CField R_as_CRing Rinv_is_fun).
 Red.
 Intros.
 Simpl.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Exists (F_1 x).
 Intros.
 Change (absLSmall a_COrdField e
 (CS_seq a_COrdField
       ((nzinj R_as_CRing x)[*]
         (Build_CauchySeq a_COrdField (inv_seq x) (CS_seq_inv x))) m)
       [-]One).
 Step_AbsLSmall_rht Zero::a_COrdField.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption. 
 
 Change (Zero[=]
  ((CS_seq a_COrdField (nzinj R_as_CRing x) m)[*](inv_seq x m))[-]One).
 Apply cg_cancel_rht with G:=(a_COrdField :: CGroup) a:=One::a_COrdField.
 Step One::a_COrdField.
 Step_final ((CS_seq a_COrdField (nzinj R_as_CRing x) m)[*](inv_seq x m)).
 Cut ((CS_seq a_COrdField (nzinj R_as_CRing x) m)[#]Zero).
 Intro.
 Unfold inv_seq.
 Unfold sumbool_rec.
 Case (lt_le_dec m (F_1 x)). 
 Intro.
 Apply False_ind.
 Cut (~(lt m (F_1 x))).
 Intro.
 Apply H2.
 Assumption.
 Apply le_not_lt.
 Assumption.
 Intro.
 Rational.
 Exact (property1_2 x m H0). 
 Rational.
Qed.

Definition R_as_CField := (!Build_CField R_as_CRing Rinv_is_fun R_is_CField).

End R_CField.
