(* $Id: R_mul_CSemi_grp.v,v 1.9 2000/11/10 11:27:37 freek Exp $ *)

Require Export R_CSemi_grp.

(* Summary:
     1- <R, Rplus, ZEROR, Ropp> is CGroup.
     2- Definition of pointwise multiplication on Cauchy sequences, Rmult.
     3- <R, Rmult, ONER> is CSemi_grp.
*) 


Syntactic Definition Nine :=(Nring (9)).
Remark nonzero_Nine:(R:COrdField) Nine [#] Zero::R.
Intro.
Apply pos_ap_zero.
Apply nring_pos.
Apply lt_O_Sn.
Qed.

Syntactic Definition NineNZ := Nine [//] (nonzero_Nine ?).
Syntax constr level 1:
  nineNZ_constant [<<(nzpro $_ $_ (nonzero_Nine $_))>>] -> ["NineNZ"].
Syntax constr level 1:
  cr_nine_constant [<<(nring $_ (9))>>] -> ["Nine"].

Syntactic Definition Eighteen :=(Nring (18)).
Remark nonzero_Eighteen:(R:COrdField) Eighteen [#] Zero::R.
Intro.
Apply pos_ap_zero.
Apply nring_pos.
Apply lt_O_Sn.
Qed.

Syntactic Definition EighteenNZ := Eighteen [//] (nonzero_Eighteen ?).
Syntax constr level 1:
  eighteenNZ_constant [<<(nzpro $_ $_ (nonzero_Eighteen $_))>>] 
  -> ["EighteenNZ"].
Syntax constr level 1:
  cr_eighteen_constant [<<(nring $_ (18))>>] -> ["Eighteen"].




Syntactic Definition TwentyFour :=(Nring (24)).

Remark nonzero_TwentyFour:(OF:COrdField) TwentyFour [#] Zero::OF. 
Intro.
Apply pos_ap_zero.
Apply nring_pos.
Apply lt_O_Sn.
Qed.

Syntactic Definition TwentyFourNZ := TwentyFour [//] (nonzero_TwentyFour ?).
Syntax constr level 1:
  twentyfourNZ_constant [<<(nzpro $_ $_ (nonzero_TwentyFour $_))>>] -> 
  ["TwentyFourNZ"].
Syntax constr level 1:
  cr_twentyfour_constant [<<(nring $_ (24))>>] -> ["TwentyFour"].


Syntactic Definition FortyEight :=(Nring (48)).

Remark nonzero_FortyEight:(OF:COrdField) FortyEight [#] Zero::OF. 
Intro.
Apply pos_ap_zero.
Apply nring_pos.
Apply lt_O_Sn.
Qed.

Syntactic Definition FortyEightNZ := FortyEight [//] (nonzero_FortyEight ?).

Section R_mul_CSemi_grp.

Variable a_COrdField : COrdField.

Syntactic Definition R_as_CSetoid' := (R_as_CSetoid a_COrdField).

Syntactic Definition Rplus_is_bin_fun' := (Rplus_is_bin_fun a_COrdField).

Syntactic Definition ZEROR' := (ZEROR a_COrdField).

Syntactic Definition R_as_CSemi_grp' := (R_as_CSemi_grp a_COrdField).

Syntactic Definition R' := (R a_COrdField).

Theorem ZEROR_as_rht_unit:(!is_rht_unit R_as_CSetoid' Rplus_is_bin_fun' ZEROR').
 Red.
 Simpl.
 Intro.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Unfold ZEROR.
 Unfold Rplus.
 Simpl.
 Change ( (absLSmall a_COrdField e
     ((CS_seq a_COrdField x m)[+]Zero::a_COrdField)
       [-](CS_seq a_COrdField x m))).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed. 

Lemma Rplus_is_commut :(commutes R_as_CSetoid' Rplus_is_bin_fun').
 Red.
 Simpl.
 Intros.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Unfold Rplus.
 Simpl.
 Change ( (absLSmall a_COrdField e
     ((CS_seq a_COrdField x m)[+](CS_seq a_COrdField y m))
    [-]((CS_seq a_COrdField y m)[+](CS_seq a_COrdField x m)))).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed. 

Definition R_is_CMonoid :=(!Build_is_CMonoid R_as_CSemi_grp' ZEROR_as_rht_unit
  Rplus_is_commut).

Definition R_as_CMonoid :=(!Build_CMonoid R_as_CSemi_grp' R_is_CMonoid).

Lemma CS_seq_opp:(x:R')(Cauchy_prop [m:nat]([--](CS_seq a_COrdField x m))).
 Red.
 Intros.
 Case x.
 Intros x_ px.
 Unfold Cauchy_prop in px.
 Cut ((EX N:nat |
             (m:nat)
              (le N m)->(absSmall a_COrdField e (x_ m)[-](x_ N)))).
 Intro px1.
 Case px1.
 Intros N px2.
 Exists N.
 Intros.
 Unfold CS_seq.
 Apply AbsSmall_minus.
 Step_Rat_AbsSmall_rht (x_ m)[-](x_ N).
 Apply px2.
 Assumption.
 Apply px.
 Assumption.
Qed.


Definition Ropp :=[x:R'](Build_CauchySeq a_COrdField 
		[m:nat]([--](CS_seq a_COrdField x m)) (CS_seq_opp x)):R'->R'.

Theorem Ropp_is_extensional :(!fun_strong_ext R_as_CSetoid' R_as_CSetoid' Ropp).
 Red.
 Intros.
 Case H.
 Intro.
 Right.
 Unfold Rlt in H0.
 Unfold Ropp in H0.
 Simpl in H0.
 Change((EX e:a_COrdField |
          (Zero::a_COrdField[:<]e)
          /\(EX N:nat |
               (m:nat)
                (le N m)
                ->(e[:<]
                    ([--](CS_seq a_COrdField y m))
                      [-]([--](CS_seq a_COrdField x m)))))) in H0.
 Case H0.
 Intros e H1.
 Elim H1.
 Intros.
 Case H3.
 Intros N H31.
 Exists e.
 Split.
 Assumption.
 Exists N.
 Intros.
 Step_Rat_less_rht [--](CS_seq a_COrdField y m)
                   [-][--](CS_seq a_COrdField x m). 
 Apply H31.
 Assumption.
 Intro.
 Left.
 Unfold Rlt in H0.
 Unfold Ropp in H0.
 Simpl in H0.
 Change((EX e:a_COrdField |
          (Zero::a_COrdField[:<]e)
          /\(EX N:nat |
               (m:nat)
                (le N m)
                ->(e[:<]
                    ([--](CS_seq a_COrdField x m))
                      [-]([--](CS_seq a_COrdField y m)))))) in H0.
 Case H0.
 Intros e H1.
 Elim H1.
 Intros.
 Case H3.
 Intros N H31.
 Exists e.
 Split.
 Assumption.
 Exists N.
 Intros.
 Step_Rat_less_rht [--](CS_seq a_COrdField x m)
                   [-][--](CS_seq a_COrdField y m). 
 Apply H31.
 Assumption.
Qed.


Theorem Ropp_is_well_defined:(!fun_well_def R_as_CSetoid' R_as_CSetoid' Ropp).
 Red.
 Intros.
 Apply not_ap_imp_eq.
 Intro.
 Cut (~(x[#]y)).
 Intro.
 Apply H1.
 Apply Ropp_is_extensional.
 Assumption.
 Apply eq_imp_not_ap.
 Assumption.
Qed.

Definition Ropp_is_fun:=(!Build_CSetoid_fun R_as_CSetoid' R_as_CSetoid' Ropp
	Ropp_is_well_defined Ropp_is_extensional).

Theorem R_is_CGroup:(!is_CGroup R_as_CMonoid Ropp_is_fun).
 Red.
 Simpl.
 Intros.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Unfold Ropp.
 Unfold ZEROR.
 Simpl.
 Change ((EX N:nat |
      (m:nat)
       (le N m)
       ->(absLSmall a_COrdField e
           ((CS_seq a_COrdField x m)[+]
             ([--](CS_seq a_COrdField x m)))[-]Zero))).
 Exists O.
 Intros.
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed. 

Definition R_as_CGroup:=(!Build_CGroup R_as_CMonoid Ropp_is_fun R_is_CGroup).


(*

Theorem nonneg_square:(OF:COrdField;x:OF)Zero[:<=]x[*]x.
 Intros.
 Intro.
 Cut(x[#]Zero).
 Intro.
 Case(ap_imp_less OF x Zero H0).
 Intro.
 Cut (Zero[:<][--]x).
 Intro.
 Cut (Zero[:<]x[*]x).
 Change(~(Zero[:<]x[*]x)).
 Apply less_antisymmetric_unfolded.
 Assumption.
 Step_Rat_less_rht ([--]x)[*]([--]x).
 Apply mult_resp_pos.
 Assumption.
 Assumption.
 Apply min_cancel_less.
 Step_Rat_less_lft x.
 Step_Rat_less_rht Zero::OF.
 Assumption.
 Intro.
 Cut (Zero[:<]x[*]x).
 Change(~(Zero[:<]x[*]x)).
 Apply less_antisymmetric_unfolded.
 Assumption.
 Apply mult_resp_pos.
 Assumption.
 Assumption.
 Apply cring_mult_ap_zero with y:=x.
 Apply less_imp_ap.
 Assumption.
Qed.

*) 




Theorem CS_seq_bounded:(OF:COrdField; g:nat->OF)(Cauchy_prop g)->
  (Ex [K:OF]((K [#] Zero::OF)/\(Ex [N:nat](m:nat)(le N m)->(AbsSmall K (g m))))).

 Unfold Cauchy_prop.
 Intros.
 Cut ((EX N:nat | (m:nat)(le N m)->(absSmall OF One (g m)[-](g N)))).
 Intro.
 Case H0.
 Intros N H1.
 Exists (((g N)[^](2))[-](g N)[+]Two).
 Split.

 Apply Greater_imp_ap. 
 Apply leEq_less_trans with y:=((g N)[-](One[/]TwoNZ))[^](2).
 Apply sqr_nonneg.
 Step_less_lft  ((g N)[^](2))[-](g N)[+](One[/]FourNZ).
 Apply plus_resp_less_lft.
 Apply mult_cancel_less with z:=Four::OF.
 Apply nring_pos.
 Apply lt_O_Sn.
 Step_Rat_less_lft Zero[+](One[+]Zero)::OF.
 Step_Rat_less_rht Six[+](One[+]One)::OF.
 Apply plus_resp_less_both.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply plus_resp_less_lft.
 Apply pos_one.
 Stepr ((g N)[-]One[/]TwoNZ)[*]((g N)[-]One[/]TwoNZ).
 Step ((g N)[*](g N))[-](g N)[+]One[/]FourNZ.
 Rational.

 Exists N.
 Intros.
 Cut ((absSmall OF One (g m)[-](g N))).
 Unfold absSmall.
 Intro.
 Elim H3.
 Intros.
 Split.
 
 Apply plus_cancel_less with z:=[--](g N).
 Step_Rat_less_rht (g m)[-](g N).
 Step_Rat_less_lft [--](((g N)[^](2))[+]Two).
 Apply less_transitive_unfolded with y:=[--]One::OF.
 Apply min_cancel_less.
 Step_Rat_less_lft One::OF.
 Step_Rat_less_rht (g N)[^](2)[+]Two. 
 Apply plus_cancel_less with z:=[--]One::OF.
 Step_Rat_less_lft Zero::OF.
 Step_Rat_less_rht (g N)[^](2)[+]One.
 Apply leEq_less_trans with y:=(g N)[^](2).
 Apply sqr_nonneg.
 Apply less_plusOne.
 Assumption.
 
 Apply plus_cancel_less with z:=(g N)[-]Two.
 Step_Rat_less_rht (g N)[^](2).
 Step_less_rht (g N)[*](g N).
 Apply plus_cancel_less with z:=([--](Two [*](g N)))[+]Two.
 Step_Rat_less_lft (g m)[-](g N).
 Step_Rat_less_rht ((((g N)[*](g N))[+]One)[-](Two[*](g N)))[+]One.
 Apply less_leEq_trans with y:=One::OF.
 Assumption.
 Step_Rat_leEq_lft Zero[+]One::OF.
 Apply plus_resp_leEq with z:=One::OF.
 Step_Rat_leEq_rht ((g N)[-]One)[*]((g N)[-]One).
 Apply leEq_wdr with y:= ((g N)[-]One)[^](2).
 Apply sqr_nonneg.
 Algebra.
 
 Apply H1.
 Assumption.

 Apply H.
 Apply pos_one.
Qed.


Lemma CS_seq_mult:(x,y:R')(Cauchy_prop 
	   [m:nat](CS_seq a_COrdField x m)[*](CS_seq a_COrdField y m)).
 Red.
 Intros.
 Case x.
 Intros x_ px.
 Case y.
 Intros y_ py.
 Unfold Cauchy_prop in px.
 Unfold Cauchy_prop in py.
 Unfold CS_seq.
 Cut ((EX K:a_COrdField | (K [#] Zero)/\
             (EX N:nat | (m:nat)(le N m)->(AbsSmall K (x_ m)) ))).
 Intro.
 Case H0.
 Intros K1 H1.
 Elim H1.
 Intros J J1.
 Case J1.
 Intros M1 J11.
 Cut (Twelve[*]K1 [#] Zero).
 Intro K1NZ.
 Cut ((EX N:nat |
             (m:nat)
              (le N m)->(absSmall a_COrdField e[/](Twelve[*]K1)[//]K1NZ
	      (y_ m)[-](y_ N)))).
 Intro.
 Case H2.
 Intros N1 H21.
 Cut ((EX K:a_COrdField | (K [#] Zero)/\
             (EX N:nat | (m:nat)(le N m)->(AbsSmall K (y_ m)) ))).
 Intro.
 Case H3.
 Intros K2 H4.  
 Elim H4.
 Intros G G1.
 Case G1.
 Intros M2 G11.
 Cut  (Twelve[*]K2 [#] Zero).
 Intro K2NZ.
 Cut ((EX N:nat |
             (m:nat)
              (le N m)->(absSmall a_COrdField e[/](Twelve[*]K2)[//]K2NZ
	      (x_ m)[-](x_ N)))).
 Intro.
 Case H5.
 Intros N2 H51.
 
 Exists (plus M1 (plus N1 (plus M2 N2))).
 Intros.
 
 Step_Rat_AbsSmall_rht 
  ((x_ m)[*]((y_ m)[-](y_ (plus M1 (plus N1 (plus M2 N2))))))[+]
  ((y_ (plus M1 (plus N1 (plus M2 N2))))[*]
  ((x_ m)[-](x_ (plus M1 (plus N1 (plus M2 N2)))))).
 Step_Rat_AbsSmall_lft (e[/]TwoNZ)[+](e[/]TwoNZ).
 Apply AbsSmall_plus.
 
 Cut (Six[*]K1 [#]Zero).
 Intro K1NZ6.
 Step_Rat_AbsSmall_lft Three[*](K1[*](e[/](Six[*]K1)[//]K1NZ6)).
 Apply AbsSmall_mult.
 
 Apply J11.
 Apply le_trans with m:=(plus M1 (plus N1 (plus M2 N2))).
 Apply le_plus_l.
 Assumption.

 Step_Rat_AbsSmall_lft (e[/](Twelve[*]K1)[//]K1NZ)[+]
		       (e[/](Twelve[*]K1)[//]K1NZ).
 Step_Rat_AbsSmall_rht ((y_ m)[-](y_ N1))[+]
 		       ((y_ N1)[-](y_ (plus M1 (plus N1 (plus M2 N2))))).
 Apply AbsSmall_plus.
 Apply H21.
 Apply le_trans with m:=(plus M1 (plus N1 (plus M2 N2))).
 Rewrite plus_permute with m:=N1. 
 Apply le_plus_l.
 Assumption.
 Apply AbsSmall_minus.
 Apply H21.
 Rewrite plus_permute with m:=N1.
 Apply le_plus_l.
 Apply mult_resp_ap_zero.
 Apply nonzero_Six.
 Assumption.

 Cut (Six[*]K2 [#]Zero).
 Intro K2NZ6.
 Step_Rat_AbsSmall_lft Three[*](K2[*](e[/](Six[*]K2)[//]K2NZ6)).
 Apply AbsSmall_mult.
 
 Apply G11.
 Rewrite plus_permute with m:=M2.
 Rewrite plus_permute with m:=M2.
 Apply le_plus_l.

 Step_Rat_AbsSmall_lft (e[/](Twelve[*]K2)[//]K2NZ)[+]
		       (e[/](Twelve[*]K2)[//]K2NZ).
 Step_Rat_AbsSmall_rht ((x_ m)[-](x_ N2))[+]
 		       ((x_ N2)[-](x_ (plus M1 (plus N1 (plus M2 N2))))).
 Apply AbsSmall_plus.
 Apply H51.
 Apply le_trans with m:=(plus M1 (plus N1 (plus M2 N2))).
 Rewrite plus_sym with m:=N2.
 Rewrite plus_permute with m:=N2.
 Rewrite plus_permute with m:=N2.  
 Apply le_plus_l.
 Assumption.
 Apply AbsSmall_minus.
 Apply H51.
 Rewrite plus_sym with m:=N2.
 Rewrite plus_permute with m:=N2.
 Rewrite plus_permute with m:=N2.   
 Apply le_plus_l.
 Apply mult_resp_ap_zero.
 Apply nonzero_Six.
 Assumption.

 Apply px.
 
 (* To Prove that e/12K > 0 *)
 (* Start *)
 Apply mult_cancel_less with
		R:=a_COrdField
		z:=(Twelve[*]K2). 
 Apply mult_resp_pos.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply AbsSmall_pos with x:=(y_ M2).
 Apply G11.
 Constructor.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 (* Finish *)
 Apply mult_resp_ap_zero.
 Apply nonzero_Twelve.
 Assumption.
 
 Apply CS_seq_bounded.
 Assumption.


 Apply py.
 
 (* To Prove that e/12K > 0 *)
 (* Start *)
 Apply mult_cancel_less with
		R:=a_COrdField
		z:=(Twelve[*]K1). 
 Apply mult_resp_pos.
 Apply nring_pos.
 Apply lt_O_Sn.
 Apply AbsSmall_pos with x:=(x_ M1).
 Apply J11.
 Constructor.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 (* Finish *)
 Apply mult_resp_ap_zero.
 Apply nonzero_Twelve.
 Assumption.
 
 Apply CS_seq_bounded.
 Assumption.
Qed.
 

Definition Rmult :=[x,y:R'](Build_CauchySeq a_COrdField
  [m:nat](CS_seq a_COrdField x m)[*](CS_seq a_COrdField y m)
  (CS_seq_mult x y)):R'->R'->R'.


Lemma AbsBigSmall_trans:(OF:COrdField; e1,e2,x: OF)(AbsSmall e2 x)->
	(AbsBig e1 x)->(e1[:<]e2).
 Unfold absSmall.
 Unfold absBig.
 Intros.
 Elim H.
 Intros.
 Elim H0.
 Intros.
 Case H4. 
 Intro.
  Apply less_transitive_unfolded with y:=x.
  Assumption.
  Assumption.
 Intro.
  Apply min_cancel_less.
  Apply less_transitive_unfolded with y:=x. 
  Assumption. 
  Assumption.
Qed.

Lemma AbsBig_cancel_mult:(OF:COrdField; e,x,z:OF)(Zero[:<]z)->
		 (AbsBig e[*]z x[*]z)->(AbsBig e x). 
 Unfold absBig.
 Intros.
 Elim H0.
 Intros.
 Split.
 Apply mult_cancel_less with z:=z.
 Assumption.
 Step_less_lft Zero::OF.
 Assumption.
 Case H2.
 Intro.
 Left.
 Apply mult_cancel_less with z:=z.
 Assumption.
 Assumption.
 Intro.
 Right.
 Apply mult_cancel_less with z:=z.
 Assumption.
 Step_Rat_less_rht [--](e[*]z).
 Assumption.
Qed.
Lemma AbsBigSmall_trans2:(OF:COrdField; e1,e2,x: OF)(AbsSmall e2 x)->
	(AbsBig e1 x)->(AbsBig e1 e2).
 Intros.
 Red.
 Split.
 Elim H0.
 Intros.
 Assumption.
 Left.
 Apply AbsBigSmall_trans with x:=x.
 Assumption.
 Assumption.
Qed.

Lemma AbsLSmall_pos:(OF:COrdField; e,x:(OF))(absLSmall OF e x)->Zero [:<=] e.
 Unfold absLSmall.
 Intros.
 Elim H.
 Intros.
 Cut ([--]e [:<=] e).
 Intros.
 Apply mult_cancel_leEq with z:=Two::OF.
 Apply pos_two.
 Apply plus_cancel_leEq_rht with z:=[--]e.
 Step_Rat_leEq_lft [--]e.
 Step_Rat_leEq_rht e.
 Assumption.
 Apply leEq_transitive with y:=x.
 Assumption.
 Assumption.
Qed.
 


Lemma AbsLSmall_mult :(OF:COrdField; e1,e2,x1,x2:(OF))(absSmall OF e1 x1)
 	    ->(absLSmall OF e2 x2)->(absLSmall OF Three[*](e1[*]e2) x1[*]x2).
 Unfold absLSmall.
 Unfold absSmall.
 Intros.
 Elim H.
 Intros.
 Elim H0.
 Intros.
 Cut (Zero[:<]e1).
 Intro.
 Cut (Zero[:<=]e2).
 Intro.
 Split.

 Apply plus_cancel_leEq_rht with z:=(Three[*](e1[*]e2)).
 Step_Rat_leEq_lft Zero::OF.
 Step_Rat_leEq_rht x1[*]x2[+](e1[*]e2)[+](e1[*]e2)[+](e1[*]e2).
 Apply leEq_transitive with 
   	 y:= x1[*]x2[+](e1[*]e2)[+](x1[*]e2)[+](e1[*]x2).
 Step_Rat_leEq_rht (e2[+]x2)[*](e1[+]x1).
 Apply mult_resp_nonneg.

 Apply plus_cancel_leEq_rht with z:=[--]e2.
 Step_Rat_leEq_lft [--]e2.
 Step_Rat_leEq_rht x2.
 Assumption.
 
 Apply less_leEq.
 Apply plus_cancel_less with z:=[--]e1.
 Step_Rat_less_lft [--]e1.
 Step_Rat_less_rht x1.
 Assumption.

 Step_Rat_leEq_lft (x1[*]e2[+]e1[*]x2)[+](x1[*]x2[+]e1[*]e2).
 Step_Rat_leEq_rht (e1[*]e2[+]e1[*]e2)[+](x1[*]x2[+]e1[*]e2).
 Apply plus_resp_leEq.
 Apply plus_resp_leEq_both.
 Apply plus_cancel_leEq_rht with z:=[--](x1[*]e2).
 Step_Rat_leEq_lft Zero::OF.
 Step_Rat_leEq_rht e2[*](e1[-]x1).
 Apply mult_resp_nonneg.
 Assumption.
 Apply less_leEq.
 Apply plus_cancel_less with z:=x1.
 Step_Rat_less_lft x1.
 Step_Rat_less_rht e1.
 Assumption.
 Apply plus_cancel_leEq_rht with z:=[--](e1[*]x2).
 Step_Rat_leEq_lft Zero::OF.
 Step_Rat_leEq_rht (e2[-]x2)[*]e1.
 Apply mult_resp_nonneg.
 Apply plus_cancel_leEq_rht with z:=x2.
 Step_Rat_leEq_lft x2.
 Step_Rat_leEq_rht e2.
 Assumption.
 Apply less_leEq.
 Assumption.

 Apply plus_cancel_leEq_rht with z:=[--](x1[*]x2).
 Step_Rat_leEq_lft Zero::OF.
 Step_Rat_leEq_rht [--](x1[*]x2)[+](e1[*]e2)[+]((e1[*]e2)[+](e1[*]e2)).
 Apply leEq_transitive with 
   	 y:= [--](x1[*]x2)[+](e1[*]e2)[+]((x1[*]e2)[-](e1[*]x2)).
 Step_Rat_leEq_rht (e2[-]x2)[*](e1[+]x1).
 Apply mult_resp_nonneg.
 Apply plus_cancel_leEq_rht with z:=x2.
 Step_Rat_leEq_lft x2.
 Step_Rat_leEq_rht e2.
 Assumption.

 Apply less_leEq.
 Apply plus_cancel_less with z:=[--]e1.
 Step_Rat_less_lft [--]e1.
 Step_Rat_less_rht x1.
 Assumption.

 Step_Rat_leEq_lft (x1[*]e2[-]e1[*]x2)[+]([--](x1[*]x2)[+](e1[*]e2)).
 Step_Rat_leEq_rht (e1[*]e2[+]e1[*]e2)[+]([--](x1[*]x2)[+](e1[*]e2)).
 Apply plus_resp_leEq.
 Step_Rat_leEq_lft  x1[*]e2[+]([--]e1[*]x2).
 Apply plus_resp_leEq_both.

 Apply plus_cancel_leEq_rht with z:=[--](x1[*]e2).
 Step_Rat_leEq_lft Zero::OF.
 Step_Rat_leEq_rht e2[*](e1[-]x1).
 Apply mult_resp_nonneg.
 Assumption.
 Apply less_leEq.
 Apply plus_cancel_less with z:=x1.
 Step_Rat_less_lft x1.
 Step_Rat_less_rht e1.
 Assumption.
 Apply plus_cancel_leEq_rht with z:=(e1[*]x2).
 Step_Rat_leEq_lft Zero::OF.
 Step_Rat_leEq_rht (e2[+]x2)[*]e1.
 Apply mult_resp_nonneg.
 Apply plus_cancel_leEq_rht with z:=[--]e2.
 Step_Rat_leEq_lft [--]e2.
 Step_Rat_leEq_rht x2.
 Assumption.
 Apply less_leEq.
 Assumption.

 Apply AbsLSmall_pos with OF:=OF e:=e2 x:=x2.
 Assumption.
 Apply AbsSmall_pos with e:=e1 x:=x1.
 Assumption.
Qed.
 

Lemma AbsBigLSmall_trans3 : 
(OF:COrdField; e1,e2,x:(OF)) (AbsLSmall e2 x)->
		(AbsBig e1 x)->(AbsBig e1 e2).
 Unfold absBig.
 Unfold absLSmall.
 Intros.
 Elim H.
 Intros.
 Elim H0. 
 Intros.
 Split.
 Assumption.
 Case H4.
 Intro.
 Left.
 Apply less_leEq_trans with y:=x.
 Assumption.
 Assumption.
 Intro.
 Left.
 Apply min_cancel_less.
 Apply leEq_less_trans with y:=x.
 Assumption.
 Assumption.
Qed.

Definition absDouble[OF:COrdField;x,y:OF]:Prop:=
	((x[:<=]y)/\(Zero[:<=]y))\/((y[:<=]x)/\(y[:<=]Zero)).

Syntactic Definition AbsDouble :=(absDouble ?).



Lemma Rmult_is_extensional:(bin_fun_strong_ext R_as_CSetoid' R_as_CSetoid' 
 			     R_as_CSetoid' Rmult).
 Red.
 Intros x1 y1 x2 y2.
 Case x1.
 Intros x1_ px1.
 Case x2.
 Intros x2_ px2.
 Case y1.
 Intros y1_ py1.
 Case y2.
 Intros y2_ py2.
 Unfold Cauchy_prop in px1.
 Unfold Cauchy_prop in px2.
 Unfold Cauchy_prop in py1.
 Unfold Cauchy_prop in py2.
 
 Intro.
 Cut  (Ex [e:a_COrdField]((Zero [:<] e)/\(Ex [N:nat](m:nat)(le N m)->
   	((((x1_ m)[*](x2_ m)[-]((y1_ m)[*](y2_ m))[:<][--]e)\/
        (e[:<]((x1_ m)[*](x2_ m))[-]((y1_ m)[*](y2_ m)))))))).
 Intro.
 Case H0.
 Intros e H1.
 Elim H1.
 Intros.
 Cut (EX K:a_COrdField |
      (K [#] Zero)/\(EX N:nat | (m:nat)(le N m)->(AbsSmall K (x1_ m)))).
 Intro I1.
 Case I1.
 Intros K1 I2. 
 Elim I2.
 Intros J I3.
 Case I3.
 Intros B1 I4.
 Cut (EX K:a_COrdField |
      (K [#] Zero)/\(EX N:nat | (m:nat)(le N m)->(AbsSmall K (y2_ m)))).
 Intro L1.
 Case L1.
 Intros K2 L2. 
 Elim L2.
 Intros G L3.
 Case L3.
 Intros B2 L4.
 Cut (FortyEight[*]K2 [#] Zero).
 Intro K2NZ48.
 Cut (FortyEight[*]K1 [#] Zero).
 Intro K1NZ48.
 Cut (EX N:nat |
              (m:nat)
               (le N m)->(absSmall a_COrdField 
		e[/](FortyEight[*]K2)[//]K2NZ48 (x1_ m)[-](x1_ N))).
 Intro px11. 
 Cut (EX N:nat |
              (m:nat)
               (le N m)->(absSmall a_COrdField 
              	e[/](FortyEight[*]K1)[//]K1NZ48  (x2_ m)[-](x2_ N))).
 Intro px21.
 Cut (EX N:nat |
              (m:nat)
               (le N m)->(absSmall a_COrdField 
 		e[/](FortyEight[*]K2)[//]K2NZ48 (y1_ m)[-](y1_ N))). 
 Intro py11.
 Cut (EX N:nat |
              (m:nat)
               (le N m)->(absSmall a_COrdField 	
		e[/](FortyEight[*]K1)[//]K1NZ48 (y2_ m)[-](y2_ N))). 
 Intro py21.
 Case px11.
 Intros N1 qx1.
 Case px21.
 Intros N2 qx2.
 Case py11. 
 Intros M1 qy1.
 Case py21.
 Intros M2 qy2.
 Case H3.
 Intros N H31.
 Cut (Twelve[*]K2 [#] Zero).
 Intro K2NZ12.
 Cut (Twelve[*]K1 [#] Zero).
 Intro K1NZ12. 
 Cut (((m:nat)
     (le (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))) m)->
      (((x1_ m)[-](y1_ m)[:<][--](e[/](Twelve[*]K2)[//]K2NZ12))
     \/((e[/](Twelve[*]K2)[//]K2NZ12)[:<](x1_ m)[-](y1_ m))))
 \/
 ((m:nat)(le (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))) m)->
         (((x2_ m)[-](y2_ m)[:<][--](e[/](Twelve[*]K1)[//]K1NZ12))
       \/((e[/](Twelve[*]K1)[//]K1NZ12)[:<](x2_ m)[-](y2_ m))))
   ).
 Intro.
 Case H4.
 Intro.
 
 Left.
 
 Simpl.
 Apply ap_R_alt_2.
 Unfold CS_seq.
 Exists (e[/]((nring (a_COrdField) (12))[*]K2)[//]K2NZ12).
 Split.
 (* To Prove that e/12K > 0 *)
   (* Start *)
   Apply mult_cancel_less with
	          R:=a_COrdField
		  z:=(Twelve[*]K2). 
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(y2_ B2).
   Apply L4.
   Constructor.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e.
   Assumption.
   (* Finish *)
 
 Exists  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))).
 Assumption.
 
 Intro.
 Right.
 Simpl.
 Apply ap_R_alt_2.
 Unfold CS_seq.
 Exists (e[/]((nring (a_COrdField) (12))[*]K1)[//]K1NZ12).
 Split.
 (* To Prove that e/12K > 0 *)
   (* Start *)
   Apply mult_cancel_less with
	          R:=a_COrdField
		  z:=(Twelve[*]K1). 
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(x1_ B1).
   Apply I4.
   Constructor.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e.
   Assumption.
   (* Finish *)
 
 Exists  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))).
 Assumption.
 
 Cut (Six[*]K2 [#] Zero).
 Intro K2NZ6.
 Cut (Six[*]K1 [#] Zero).
 Intro K1NZ6.
 Cut ((((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
      [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
      [:<][--](e[/](Six[*]K2)[//]K2NZ6))
    \/((e[/](Six[*]K2)[//]K2NZ6)[:<]
      (x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
 \/
     (((x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [:<][--](e[/](Six[*]K1)[//]K1NZ6))
   \/((e[/](Six[*]K1)[//]K1NZ6)[:<]
     (x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
    [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
   ). 
 Intro.
 Case H4.
 Intro.
 
 Left.
 Intros.
 Cut (AbsBig e[/](Twelve[*]K2)[//]K2NZ12 (x1_ m)[-](y1_ m)).
 Unfold absBig.
 Intros.
 Elim H7.
 Intros.
 Case H9.
 Intro.
 Right.
 Assumption.
 Intro.
 Left.
 Assumption.
 
 Cut (TwentyFour[*]K2 [#] Zero).
 Intro K2NZ24.
 Step_Rat_AbsBig_lft ((e[/](Six[*]K2)[//]K2NZ6)[-]
 		      (e[/](TwentyFour[*]K2)[//]K2NZ24))[-]
              	      (e[/](TwentyFour[*]K2)[//]K2NZ24).
 Step_Rat_AbsBig_rht ((
     (x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
     (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))[-]
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
     (x1_ m)))[-]
     ((y1_ m)[-]
     (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
 Apply AbsBigSmall_minus with R:=a_COrdField.
  
  Apply mult_cancel_less with 
		R:=a_COrdField 
		z:=TwentyFour[*]K2::a_COrdField.
  Apply mult_resp_pos.
  Apply nring_pos.
  Apply lt_O_Sn.
  Apply AbsSmall_pos with x:=(y2_ B2).
  Apply L4.
  Constructor.
  
  Step_Rat_less_lft e[+]Zero[+]Zero::a_COrdField.
  Step_Rat_less_rht e[+]e[+]e.
  Apply plus_resp_less_both.
  Apply plus_resp_less_lft.
  Assumption.
  Assumption.
      
  Apply AbsBigSmall_minus.
  
   Apply mult_cancel_less with 
	         R:=a_COrdField 
		 z:=TwentyFour[*]K2::a_COrdField.
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(y2_ B2).
   Apply L4.
   Constructor.
   Step_Rat_less_lft e[+]Zero[+]Zero[+]Zero::a_COrdField.
   Step_Rat_less_rht e[+]e[+]e[+]e.
   Apply plus_resp_less_both.
   Apply plus_resp_less_both.
   Apply plus_resp_less_lft.
   Assumption.
   Assumption.
   Assumption.   
 
   Unfold absBig.
   Split.
   (* To Prove that e/6K > 0 *)
   (* Start *)
   Apply mult_cancel_less with
	          R:=a_COrdField
		  z:=(Six[*]K2). 
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(y2_ B2).
   Apply L4.
   Constructor.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e.
   Assumption.
   (* Finish *)
   Case H5.
   Intro.
   Right.
   Assumption.
   Intro.
   Left.
   Assumption.

  Step_Rat_AbsSmall_lft
 	(e[/](FortyEight[*]K2)[//]K2NZ48)[+](e[/](FortyEight[*]K2)[//]K2NZ48).
  Step_Rat_AbsSmall_rht
        ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
	[-](x1_ N1))[+]
        ((x1_ N1)[-](x1_ m)).
  Apply AbsSmall_plus.
  Apply qx1.
  (* To proev that N + N1 + N2 + M1 + M2 + B1 + B2 > N1 *)
  (* Start *)
    Rewrite plus_permute with m:=N1.
    Apply le_plus_l.
  (* Finish *)
  Apply AbsSmall_minus.
  Apply qx1.
  (* To prove that N1 > m *)
  (* Start *)
    Apply le_trans with 
	m:= (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))).
    Rewrite plus_permute with m:=N1.
    Apply le_plus_l.
    Assumption.
  (* Finish *)

  Step_Rat_AbsSmall_lft
 	(e[/](FortyEight[*]K2)[//]K2NZ48)[+](e[/](FortyEight[*]K2)[//]K2NZ48).
  Step_Rat_AbsSmall_rht
        ((y1_ m)[-](y1_ M1))[+]((y1_ M1)[-]
        (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
  Apply AbsSmall_plus.
  Apply qy1.
   (* To prove that M1 > m *)
  (* Start *)
    Apply le_trans with 
	m:= (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))).
    Rewrite plus_permute with m:=M1. 
    Rewrite plus_permute with m:=M1. 
    Rewrite plus_permute with m:=M1.
    Apply le_plus_l.
    Assumption.
  (* Finish *)
  Apply AbsSmall_minus.
  Apply qy1.
  (* To proev that N + N1 + N2 + M1 + M2 + B1 + B2 > M1 *)
  (* Start *)
    Rewrite plus_permute with m:=M1. 
    Rewrite plus_permute with m:=M1. 
    Rewrite plus_permute with m:=M1.
    Apply le_plus_l.
  (* Finish *)
  Apply mult_resp_ap_zero.  
  Apply nonzero_TwentyFour.
  Assumption.

 Intro.
 Right.
 Intros.
 Cut (AbsBig e[/](Twelve[*]K1)[//]K1NZ12 (x2_ m)[-](y2_ m)).
 Unfold absBig.
 Intros.
 Elim H7.
 Intros.
 Case H9.
 Intro.
 Right.
 Assumption.
 Intro.
 Left.
 Assumption.
 
 Cut (TwentyFour[*]K1 [#] Zero).
 Intro K1NZ24.
 Step_Rat_AbsBig_lft ((e[/](Six[*]K1)[//]K1NZ6)[-]
 		      (e[/](TwentyFour[*]K1)[//]K1NZ24))[-]
              	      (e[/](TwentyFour[*]K1)[//]K1NZ24).
 Step_Rat_AbsBig_rht ((
     (x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
     (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))[-]
     ((x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
     (x2_ m)))[-]
     ((y2_ m)[-]
     (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
 Apply AbsBigSmall_minus with R:=a_COrdField.
  
  Apply mult_cancel_less with 
		R:=a_COrdField 
		z:=TwentyFour[*]K1::a_COrdField.
  Apply mult_resp_pos.
  Apply nring_pos.
  Apply lt_O_Sn.
  Apply AbsSmall_pos with x:=(x1_ B1).
  Apply I4.
  Constructor.
  
  Step_Rat_less_lft e[+]Zero[+]Zero::a_COrdField.
  Step_Rat_less_rht e[+]e[+]e.
  Apply plus_resp_less_both.
  Apply plus_resp_less_lft.
  Assumption.
  Assumption.
      
  Apply AbsBigSmall_minus.
  
   Apply mult_cancel_less with 
	         R:=a_COrdField 
		 z:=TwentyFour[*]K1::a_COrdField.
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(x1_ B1).
   Apply I4.
   Constructor.
   Step_Rat_less_lft e[+]Zero[+]Zero[+]Zero::a_COrdField.
   Step_Rat_less_rht e[+]e[+]e[+]e.
   Apply plus_resp_less_both.
   Apply plus_resp_less_both.
   Apply plus_resp_less_lft.
   Assumption.
   Assumption.
   Assumption.   
 
   Unfold absBig.
   Split.
   (* To Prove that e/6K > 0 *)
   (* Start *)
   Apply mult_cancel_less with
	          R:=a_COrdField
		  z:=(Six[*]K1). 
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(x1_ B1).
   Apply I4.
   Constructor.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e.
   Assumption.
   (* Finish *)
   Case H5.
   Intro.
   Right.
   Assumption.
   Intro.
   Left.
   Assumption.

  Step_Rat_AbsSmall_lft
 	(e[/](FortyEight[*]K1)[//]K1NZ48)[+](e[/](FortyEight[*]K1)[//]K1NZ48).
  Step_Rat_AbsSmall_rht
        ((x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
	[-](x2_ N2))[+]
        ((x2_ N2)[-](x2_ m)).
  Apply AbsSmall_plus.
  Apply qx2.
  (* To proev that N + N1 + N2 + M1 + M2 + B1 + B2 > N2 *)
  (* Start *)
    Rewrite plus_permute with m:=N2. 
    Rewrite plus_permute with m:=N2.
    Apply le_plus_l.
  (* Finish *)
  Apply AbsSmall_minus.
  Apply qx2.
  (* To prove that N2 > m *)
  (* Start *)
    Apply le_trans with 
	m:= (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))).
    Rewrite plus_permute with m:=N2. 
    Rewrite plus_permute with m:=N2.
    Apply le_plus_l.
    Assumption.
  (* Finish *)

  Step_Rat_AbsSmall_lft
 	(e[/](FortyEight[*]K1)[//]K1NZ48)[+](e[/](FortyEight[*]K1)[//]K1NZ48).
  Step_Rat_AbsSmall_rht
        ((y2_ m)[-](y2_ M2))[+]((y2_ M2)[-]
        (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
  Apply AbsSmall_plus.
  Apply qy2.
   (* To prove that M2 > m *)
  (* Start *)
    Apply le_trans with 
	m:= (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))).
    Rewrite plus_permute with m:=M2. 
    Rewrite plus_permute with m:=M2. 
    Rewrite plus_permute with m:=M2.
    Rewrite plus_permute with m:=M2.
    Apply le_plus_l.
    Assumption.
  (* Finish *)
  Apply AbsSmall_minus.
  Apply qy2.
  (* To prove that N + N1 + N2 + M1 + M2 + B1 + B2 > M2 *)
  (* Start *)
    Rewrite plus_permute with m:=M2. 
    Rewrite plus_permute with m:=M2. 
    Rewrite plus_permute with m:=M2.
    Rewrite plus_permute with m:=M2.
    Apply le_plus_l.
  (* Finish *)
  Apply mult_resp_ap_zero.  
  Apply nonzero_TwentyFour.
  Assumption.

  (* CORE OF THE PROOF *)
  Cut ( (AbsBig e[/]TwoNZ
       ((y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
      ((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
       [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))
       ))   \/
      (AbsBig (e[/]TwoNZ) 
       (x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*] 
        ((x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
      [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
       ).
   Intro.
   Cut ( (AbsBig e[/](Six[*]K2)[//]K2NZ6
          ((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
      [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
       \/
      (AbsBig e[/](Six[*]K1)[//]K1NZ6
          ((x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
      [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
       ).
   Intro.
   Case H5. 
   
    Intro.
    Left.
    Unfold absBig in H6.
    Elim H6.
    Intros.
    Case H8.
    Intros.
    Right.
    Assumption.
    Intros.
    Left.
    Assumption.
    Intros.
    Elim H6.
    Intros.
    Right.
    Case H8.
    Intros.
    Right.
    Assumption.
    Intros.
    Left.
    Assumption.

 Case H4.
 
  Intro.
  Left.
  Unfold absBig in H5. 
  Elim H5.
  Intros.
  Cut ((y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
       [#]Zero).
  Intro IMP.
   Apply AbsBig_cancel_mult with OF:=a_COrdField z:=(Three[*]K2).
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(y2_ B2).
   Apply L4.
   Constructor.
  Step_Rat_AbsBig_lft e[/]TwoNZ.
  Case H7.
  
   Intro.
   Split.   
   Apply pos_div_two.
   Assumption.
   Case (ap_imp_less a_COrdField  
      (y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
             Zero::a_COrdField IMP).
    
    Intro. 
    Right.
    Apply less_transitive_unfolded with 
         F:=a_COrdField
         y:=([--](y2_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
         ((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft ([--](y2_
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))[*]
 	  ([--]((x1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Step_Rat_less_rht (Three[*]K2)[*] 
     ([--]((x1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply mult_resp_less. 
    Apply less_transitive_unfolded with 
		F:=a_COrdField
		y:=K2.
    Cut (AbsSmall K2 (y2_ 
  	(plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Intro.
    Elim H10.
    Intros.
    Apply min_cancel_less.
    Step_Rat_less_rht (y2_
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Assumption.
    Apply L4.
    (* TO Prove that N + N1 + N2 + M1 + M2 + B1 + B2 > B1 *)
    (* Start *)
    Rewrite plus_sym with m:=B2.
    Rewrite plus_permute with m:=B2. 
    Rewrite plus_permute with m:=B2.
    Rewrite plus_permute with m:=B2. 
    Rewrite plus_permute with m:=B2.
    Rewrite plus_permute with m:=B2.  
    Apply le_plus_l.
    (* Finish *)
    Step_Rat_less_lft One[*]K2.
    Apply mult_resp_less.
    Apply plus_cancel_less with 
			R:=a_COrdField
			z:=[--]One::a_COrdField.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht Two::a_COrdField.
    Apply pos_two.
    Apply AbsSmall_pos with x:=(y2_ B2).
    Apply L4.
    Constructor.
    
    Apply mult_cancel_less with
		R:=a_COrdField
		z:=[--] (y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft  (y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Step_Rat_less_rht Zero::a_COrdField.
    Assumption.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht (y2_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x1_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y1_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
    Apply pos_div_two.
    Assumption.
    Assumption.
    Step_Rat_less_lft [--]((y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [*]((x1_
           (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
           [-](y1_
                (plus N
                  (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply min_resp_less.
    Assumption.
    
    Intro.
    Left.
    Apply less_transitive_unfolded with 
         F:=a_COrdField
         y:=(y2_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
         ((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Assumption.
    Step_Rat_less_rht (Three[*]K2)[*] 
     ((x1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply mult_resp_less. 
    Apply less_transitive_unfolded with 
		F:=a_COrdField
		y:=K2.
    Cut (AbsSmall K2 (y2_ 
  	(plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Intro.
    Elim H10.
    Intros.
    Assumption.
    Apply L4.
    (* TO Prove that N + N1 + N2 + M1 + M2 + B1 + B2 > B2 *)
    (* Start *)
    Rewrite plus_sym with m:=B2.
    Rewrite plus_permute with m:=B2. 
    Rewrite plus_permute with m:=B2.
    Rewrite plus_permute with m:=B2. 
    Rewrite plus_permute with m:=B2.
    Rewrite plus_permute with m:=B2.  
    Apply le_plus_l.
    (* Finish *)
    Step_Rat_less_lft One[*]K2.
    Apply mult_resp_less.
    Apply plus_cancel_less with 
			R:=a_COrdField
			z:=[--]One::a_COrdField.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht Two::a_COrdField.
    Apply pos_two.
    Apply AbsSmall_pos with x:=(y2_ B2).
    Apply L4.
    Constructor.
    
    Apply mult_cancel_less with
		R:=a_COrdField
		z:=(y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Assumption.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht (y2_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x1_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y1_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
    Apply pos_div_two.
    Assumption.
    Assumption.

    
   Intro.
   Split.   
   Apply pos_div_two.
   Assumption.
   Case (ap_imp_less a_COrdField  
      (y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
             Zero::a_COrdField IMP).
    
    Intro. 
    Left.
    Apply less_transitive_unfolded with 
         F:=a_COrdField
         y:=([--](y2_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))[*]
         ((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft (y2_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [*]((x1_
                (plus N
                  (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                [-](y1_
                     (plus N
                       (plus N1
                         (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Assumption.
    Step_Rat_less_rht (Three[*]K2)[*] 
     ((x1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply mult_resp_less. 
    Apply less_transitive_unfolded with 
		F:=a_COrdField
		y:=K2.
    Cut (AbsSmall K2 (y2_ 
  	(plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Intro.
    Elim H10.
    Intros.
    Apply min_cancel_less.
    Step_Rat_less_rht (y2_
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Assumption.
    Apply L4.
    (* TO Prove that N + N1 + N2 + M1 + M2 + B1 + B2 > B1 *)
    (* Start *)
    Rewrite plus_sym with m:=B2.
    Rewrite plus_permute with m:=B2. 
    Rewrite plus_permute with m:=B2.
    Rewrite plus_permute with m:=B2. 
    Rewrite plus_permute with m:=B2.
    Rewrite plus_permute with m:=B2.  
    Apply le_plus_l.
    (* Finish *)
    Step_Rat_less_lft One[*]K2.
    Apply mult_resp_less.
    Apply plus_cancel_less with 
			R:=a_COrdField
			z:=[--]One::a_COrdField.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht Two::a_COrdField.
    Apply pos_two.
    Apply AbsSmall_pos with x:=(y2_ B2).
    Apply L4.
    Constructor.
    
    Apply mult_cancel_less with
		R:=a_COrdField
		z:=[--] (y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft  (y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Step_Rat_less_rht Zero::a_COrdField.
    Assumption.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht [--]((y2_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x1_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y1_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))))).
    
    Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
    Apply pos_div_two.
    Assumption.
    Apply min_cancel_less.
    Step_Rat_less_lft (y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [*]((x1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
               [-](y1_
                    (plus N
                      (plus N1
                        (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Assumption.

    Intro.
    Right.
    Apply less_transitive_unfolded with 
         F:=a_COrdField
         y:=(y2_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
    (((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
    [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft (y2_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
    ([--]((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
    [-](y1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Step_Rat_less_rht (Three[*]K2)[*] 
     ([--](((x1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))).
    Apply mult_resp_less. 
    Apply less_transitive_unfolded with 
		F:=a_COrdField
		y:=K2.
       
    Cut (AbsSmall K2 (y2_ 
  	(plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Intro.
    Elim H10.
    Intros.
    Assumption.
    Apply L4.
    (* TO Prove that N + N1 + N2 + M1 + M2 + B1 + B2 > B2 *)
    (* Start *)
    Rewrite plus_sym with m:=B2.
    Rewrite plus_permute with m:=B2. 
    Rewrite plus_permute with m:=B2.
    Rewrite plus_permute with m:=B2. 
    Rewrite plus_permute with m:=B2.
    Rewrite plus_permute with m:=B2.  
    Apply le_plus_l.
    (* Finish *)
    Step_Rat_less_lft One[*]K2.
    Apply mult_resp_less.
    Apply plus_cancel_less with 
			R:=a_COrdField
			z:=[--]One::a_COrdField.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht Two::a_COrdField.
    Apply pos_two.
    Apply AbsSmall_pos with x:=(y2_ B2).
    Apply L4.
    Constructor.
  
  
    Apply mult_cancel_less with
		R:=a_COrdField
		z:=(y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Assumption.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht [--]((y2_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x1_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y1_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
    Apply pos_div_two.
    Assumption.
    Apply min_cancel_less.
    Step_Rat_less_lft (y2_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [*]((x1_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
               [-](y1_
                    (plus N
                      (plus N1
                        (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Assumption.
    Assumption.


   Case H7.
   Intro.
   Apply cring_mult_ap_zero with 
		R:=(a_COrdField::CRing)
		y:= (x1_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y1_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))).
   Apply Greater_imp_ap with R:=a_COrdField.
   Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
   Apply pos_div_two with R:=a_COrdField. 
   Assumption.
   Assumption.
   Intro.
   Apply cring_mult_ap_zero with 
		R:=(a_COrdField::CRing)
		y:= (x1_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y1_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))).
   Apply less_imp_ap with R:=a_COrdField.
   Apply less_transitive_unfolded with F:=a_COrdField y:=[--](e[/]TwoNZ).
   Assumption.
   Apply min_cancel_less.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e[/]TwoNZ.
   Apply pos_div_two with R:=a_COrdField. 
   Assumption.

    
  Intro.
  Right.
  Unfold absBig in H5. 
  Elim H5.
  Intros.
  Cut ((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
       [#]Zero).
  Intro IMP.
   Apply AbsBig_cancel_mult with OF:=a_COrdField z:=(Three[*]K1).
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(x1_ B1).
   Apply I4.
   Constructor.
  Step_Rat_AbsBig_lft e[/]TwoNZ.
  Case H7.
  
   Intro.
   Split.   
   Apply pos_div_two.
   Assumption.
   Case (ap_imp_less a_COrdField  
      (x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
             Zero::a_COrdField IMP).
    
    Intro. 
    Right.
    Apply less_transitive_unfolded with 
         F:=a_COrdField
         y:=([--](x1_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
         ((x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft ([--](x1_
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))[*]
 	  ([--]((x2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Step_Rat_less_rht (Three[*]K1)[*] 
     ([--]((x2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply mult_resp_less. 
    Apply less_transitive_unfolded with 
		F:=a_COrdField
		y:=K1.
    Cut (AbsSmall K1 (x1_ 
  	(plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Intro.
    Elim H10.
    Intros.
    Apply min_cancel_less.
    Step_Rat_less_rht (x1_
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Assumption.
    Apply I4.
    (* TO Prove that N + N1 + N2 + M1 + M2 + B1 + B2 > B1 *)
    (* Start *)
     
    Rewrite plus_permute with m:=B1. 
    Rewrite plus_permute with m:=B1.
    Rewrite plus_permute with m:=B1. 
    Rewrite plus_permute with m:=B1.
    Rewrite plus_permute with m:=B1.  
    Apply le_plus_l.
    (* Finish *)
    Step_Rat_less_lft One[*]K1.
    Apply mult_resp_less.
    Apply plus_cancel_less with 
			R:=a_COrdField
			z:=[--]One::a_COrdField.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht Two::a_COrdField.
    Apply pos_two.
    Apply AbsSmall_pos with x:=(x1_ B1).
    Apply I4.
    Constructor.
    
    Apply mult_cancel_less with
		R:=a_COrdField
		z:=[--] (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft  (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Step_Rat_less_rht Zero::a_COrdField.
    Assumption.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht (x1_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x2_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y2_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
    Apply pos_div_two.
    Assumption.
    Assumption.
    Step_Rat_less_lft [--]((x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [*]((x2_
           (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
           [-](y2_
                (plus N
                  (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply min_resp_less.
    Assumption.
    
    Intro.
    Left.
    Apply less_transitive_unfolded with 
         F:=a_COrdField
         y:=(x1_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
         ((x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Assumption.
    Step_Rat_less_rht (Three[*]K1)[*] 
     ((x2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply mult_resp_less. 
    Apply less_transitive_unfolded with 
		F:=a_COrdField
		y:=K1.
    Cut (AbsSmall K1 (x1_ 
  	(plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Intro.
    Elim H10.
    Intros.
    Assumption.
    Apply I4.
    (* TO Prove that N + N1 + N2 + M1 + M2 + B1 + B2 > B2 *)
    (* Start *)
     
    Rewrite plus_permute with m:=B1. 
    Rewrite plus_permute with m:=B1.
    Rewrite plus_permute with m:=B1. 
    Rewrite plus_permute with m:=B1.
    Rewrite plus_permute with m:=B1.  
    Apply le_plus_l.
    (* Finish *)
    Step_Rat_less_lft One[*]K1.
    Apply mult_resp_less.
    Apply plus_cancel_less with 
			R:=a_COrdField
			z:=[--]One::a_COrdField.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht Two::a_COrdField.
    Apply pos_two.
    Apply AbsSmall_pos with x:=(x1_ B1).
    Apply I4.
    Constructor.
    
    Apply mult_cancel_less with
		R:=a_COrdField
		z:=(x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Assumption.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht (x1_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x2_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y2_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
    Apply pos_div_two.
    Assumption.
    Assumption.

    
   Intro.
   Split.   
   Apply pos_div_two.
   Assumption.
   Case (ap_imp_less a_COrdField  
      (x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
             Zero::a_COrdField IMP).
    
    Intro. 
    Left.
    Apply less_transitive_unfolded with 
         F:=a_COrdField
         y:=([--](x1_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))[*]
         ((x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
     [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft (x1_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [*]((x2_
                (plus N
                  (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                [-](y2_
                     (plus N
                       (plus N1
                         (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Assumption.
    Step_Rat_less_rht (Three[*]K1)[*] 
     ((x2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Apply mult_resp_less. 
    Apply less_transitive_unfolded with 
		F:=a_COrdField
		y:=K1.
    Cut (AbsSmall K1 (x1_ 
  	(plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Intro.
    Elim H10.
    Intros.
    Apply min_cancel_less.
    Step_Rat_less_rht (x1_
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Assumption.
    Apply I4.
    (* TO Prove that N + N1 + N2 + M1 + M2 + B1 + B2 > B1 *)
    (* Start *)
     
    Rewrite plus_permute with m:=B1. 
    Rewrite plus_permute with m:=B1.
    Rewrite plus_permute with m:=B1. 
    Rewrite plus_permute with m:=B1.
    Rewrite plus_permute with m:=B1.  
    Apply le_plus_l.
    (* Finish *)
    Step_Rat_less_lft One[*]K1.
    Apply mult_resp_less.
    Apply plus_cancel_less with 
			R:=a_COrdField
			z:=[--]One::a_COrdField.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht Two::a_COrdField.
    Apply pos_two.
    Apply AbsSmall_pos with x:=(x1_ B1).
    Apply I4.
    Constructor.
    
    Apply mult_cancel_less with
		R:=a_COrdField
		z:=[--] (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft  (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Step_Rat_less_rht Zero::a_COrdField.
    Assumption.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht [--]((x1_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x2_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y2_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))))).
    
    Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
    Apply pos_div_two.
    Assumption.
    Apply min_cancel_less.
    Step_Rat_less_lft (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [*]((x2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
               [-](y2_
                    (plus N
                      (plus N1
                        (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Assumption.

    Intro.
    Right.
    Apply less_transitive_unfolded with 
         F:=a_COrdField
         y:=(x1_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
    (((x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
    [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply min_cancel_less.
    Step_Rat_less_lft (x1_ 
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
    ([--]((x2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
    [-](y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
    Step_Rat_less_rht (Three[*]K1)[*] 
     ([--](((x2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [-](y2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))).
    Apply mult_resp_less. 
    Apply less_transitive_unfolded with 
		F:=a_COrdField
		y:=K1.
       
    Cut (AbsSmall K1 (x1_ 
  	(plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Intro.
    Elim H10.
    Intros.
    Assumption.
    Apply I4.
    (* TO Prove that N + N1 + N2 + M1 + M2 + B1 + B2 > B2 *)
    (* Start *)
     
    Rewrite plus_permute with m:=B1. 
    Rewrite plus_permute with m:=B1.
    Rewrite plus_permute with m:=B1. 
    Rewrite plus_permute with m:=B1.
    Rewrite plus_permute with m:=B1.  
    Apply le_plus_l.
    (* Finish *)
    Step_Rat_less_lft One[*]K1.
    Apply mult_resp_less.
    Apply plus_cancel_less with 
			R:=a_COrdField
			z:=[--]One::a_COrdField.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht Two::a_COrdField.
    Apply pos_two.
    Apply AbsSmall_pos with x:=(x1_ B1).
    Apply I4.
    Constructor.
  
  
    Apply mult_cancel_less with
		R:=a_COrdField
		z:=(x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
    Assumption.
    Step_Rat_less_lft Zero::a_COrdField.
    Step_Rat_less_rht [--]((x1_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x2_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y2_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))))).
    Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
    Apply pos_div_two.
    Assumption.
    Apply min_cancel_less.
    Step_Rat_less_lft (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [*]((x2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
               [-](y2_
                    (plus N
                      (plus N1
                        (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
    Assumption.
    Assumption.


   Case H7.
   Intro.
   Apply cring_mult_ap_zero with 
		R:=(a_COrdField::CRing)
		y:= (x2_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y2_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))).
   Apply Greater_imp_ap with R:=a_COrdField.
   Apply less_transitive_unfolded with F:=a_COrdField y:=e[/]TwoNZ.
   Apply pos_div_two with R:=a_COrdField. 
   Assumption.
   Assumption.
   Intro.
   Apply cring_mult_ap_zero with 
		R:=(a_COrdField::CRing)
		y:= (x2_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y2_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))).
   Apply less_imp_ap with R:=a_COrdField.
   Apply less_transitive_unfolded with F:=a_COrdField y:=[--](e[/]TwoNZ).
   Assumption.
   Apply min_cancel_less.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e[/]TwoNZ.
   Apply pos_div_two with R:=a_COrdField. 
   Assumption.
    
                 (* THE VERY CRUX OF THE PROOF *)
  Cut ( 
     (((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
      (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))
         [:<][--](e[/]TwoNZ))\/
      ((e[/]TwoNZ)[:<]
      (x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
    (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))))\/
     (((y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
     (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))
         [:<][--](e[/]TwoNZ))\/
      ((e[/]TwoNZ)[:<]
     (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
    (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))))).
  Intro.
  Case H4.
   Intro.
   Right.   
   Split.
   Apply pos_div_two.
   Assumption.
    Case H5.
    Intros.
    Right.
    Assumption.
    Intros.
    Left.
    Assumption.
   Intro.
   Left.
   Split.
   Apply pos_div_two.
   Assumption.
    Case H5.
    Intros.
    Right.
    Assumption.
    Intros.
    Left.
    Assumption.
  Cut ( 
     (((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
      (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))
         [:<][--](e[/]TwoNZ))\/
     ((y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
     (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))
         [:<][--](e[/]TwoNZ)))\/
     ( ((e[/]TwoNZ)[:<]
      (x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
    (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
      \/
      ((e[/]TwoNZ)[:<]
     (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
    (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))))).
  Intro. 
  Case H4.
  Intro.
  Case H5.
  Intro.
  Left.
  Left.
  Assumption.
  Intro.
  Right.
  Left.
  Assumption.
  Intro.
  Case H5.
  Intro.
  Left.
  Right.
  Assumption.
  Intro.
  Right.
  Right.
  Assumption.

  Cut ( 
     ((((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
      (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
       [+]
     ((y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
     (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
      [:<][--]e)\/
     (e[:<]
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
    (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
      [+]
    ((y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
    (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))))).
  Intro.
  Case H4.
  
  Intro.
  Left.
  Cut(  ((x1_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
      [*]((x2_
            (plus N
              (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
            [-](y2_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))
       [:<] [--](e[/]TwoNZ))
   \/([--](e[/]TwoNZ)[:<]([--]e)[-]
  ((y2_
        (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
        [*]((x1_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
              [-](y1_
                   (plus N
                     (plus N1
                       (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))
       )).
  Intro.
  Case H6.
  Intro.
  Left.
  Assumption.
  Intro.
  Right.
  Apply plus_cancel_less with 
		R:=a_COrdField
		z:=[--]((y2_ (plus N (plus N1 (plus N2 (plus M1 (plus M2 
			(plus B1 B2)))))))
     [*]((x1_
           (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
           [-](y1_
                (plus N
       (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))))[-](e[/]TwoNZ).
  Step_Rat_less_lft [--](e[/]TwoNZ).
  Step_Rat_less_rht  [--]e
                 [-](y2_
                      (plus N
                        (plus N1
                          (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                      [*]((x1_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2)))))))
                            [-](y1_
                                 (plus N
                                   (plus N1
                                     (plus N2
                                       (plus M1 (plus M2 (plus B1 B2)))))))).
  Assumption.
  Apply cotrans_less_unfolded with R:=a_COrdField z:=[--](e[/]TwoNZ).
  Apply plus_cancel_less with 
		R:=a_COrdField
		z:=(y2_
                  (plus N
                    (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                  [*]((x1_
                        (plus N
                          (plus N1
                            (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                        [-](y1_
                             (plus N
                               (plus N1
                                 (plus N2
                                   (plus M1 (plus M2 (plus B1 B2)))))))).
  Step_Rat_less_lft  (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [*]((x2_
               (plus N
                 (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
               [-](y2_
                    (plus N
                      (plus N1
                        (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))
         [+](y2_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
              [*]((x1_
                    (plus N
                      (plus N1
                        (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                    [-](y1_
                         (plus N
                           (plus N1
                             (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
   Step_Rat_less_rht [--]e.
   Assumption.
  
   Intro.
   Right.
   Cut(((e[-]   
           ((x1_ (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
              [*]((x2_
                    (plus N
                      (plus N1
                        (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                    [-](y2_
                         (plus N (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))))
      [:<](e[/]TwoNZ))\/
(e[/]TwoNZ
         [:<] (y2_
                (plus N
                  (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                [*]((x1_
                      (plus N
                        (plus N1
                          (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                      [-](y1_
                           (plus N
                             (plus N1
                               (plus N2
                                 (plus M1 (plus M2 (plus B1 B2)))))))))).
   Intro.
   Case H6.
   Intro.
   Left.
   Apply plus_cancel_less with 
		R:=a_COrdField
		z:=(e[/]TwoNZ)[-]((x1_
             (plus N
               (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
             [*]((x2_
                   (plus N
                     (plus N1
                       (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                   [-](y2_
                        (plus N
                          (plus N1
                            (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))).
   Step_Rat_less_lft  e
         [-](x1_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
              [*]((x2_
                    (plus N
                      (plus N1
                        (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                    [-](y2_
                         (plus N
                           (plus N1
                             (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
   Step_Rat_less_rht e[/]TwoNZ.
   Assumption.
   Intro.
   Right.
   Assumption.
   
  Apply cotrans_less_unfolded with R:=a_COrdField z:=e[/]TwoNZ.
  Apply plus_cancel_less with 
		R:=a_COrdField
		z:=(x1_
          (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
          [*]((x2_
                (plus N
                  (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                [-](y2_
                     (plus N
                       (plus N1
                         (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))).
  Step_Rat_less_lft e.
  Step_Rat_less_rht (x1_
                 (plus N
                   (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                 [*]((x2_
                       (plus N
                         (plus N1
                           (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                       [-](y2_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2))))))))
                 [+](y2_
                      (plus N
                        (plus N1
                          (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
                      [*]((x1_
                            (plus N
                              (plus N1
                                (plus N2
                                  (plus M1 (plus M2 (plus B1 B2)))))))
                            [-](y1_
                                 (plus N
                                   (plus N1
                                     (plus N2
                                       (plus M1 (plus M2 (plus B1 B2)))))))).
  Assumption.
  Cut(
     ((x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
      (x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
      (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
      (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))) 
      [:<] [--]e)
     \/(e [:<] 
      (x1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
      (x2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[-]
      (y1_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))[*]
      (y2_  (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2))))))))
      ).
  Intro.
  Case H4.
  Intro.
  Left.
  Step_Rat_less_lft (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [*](x2_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [-](y1_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
              [*](y2_
                   (plus N
                     (plus N1
                       (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
  Assumption.
  Intro.
  Right.
  Step_Rat_less_rht (x1_
         (plus N (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [*](x2_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
         [-](y1_
              (plus N
                (plus N1 (plus N2 (plus M1 (plus M2 (plus B1 B2)))))))
              [*](y2_
                   (plus N
                     (plus N1
                       (plus N2 (plus M1 (plus M2 (plus B1 B2))))))).
  Assumption.
  
             (* END OF THE VERY CRUX OF THE PROOF *)
  Apply H31.
  Apply le_plus_l.

 (* END OF THE CORE OF THE PROOF *)
 Apply mult_resp_ap_zero.
 Apply Greater_imp_ap.
 Apply nring_pos.
 Apply lt_O_Sn.
 Assumption.
 
 Apply mult_resp_ap_zero.
 Apply Greater_imp_ap.
 Apply nring_pos.
 Apply lt_O_Sn.
 Assumption.
     
 Apply mult_resp_ap_zero.
 Apply Greater_imp_ap.
 Apply nring_pos.
 Apply lt_O_Sn.
 Assumption.     

 Apply mult_resp_ap_zero.
 Apply Greater_imp_ap.
 Apply nring_pos.
 Apply lt_O_Sn.
 Assumption.   

 Apply py2.    
 (* To Prove that o < e/48K *)
 (* Start *)
   Apply mult_cancel_less with
	          R:=a_COrdField
		  z:=(FortyEight[*]K1). 
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(x1_ B1).
   Apply I4.
   Constructor.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e.
   Assumption.
 (* Finish *)  
 Apply py1.
  (* To Prove that o < e/48K *)
 (* Start *)
   Apply mult_cancel_less with
	          R:=a_COrdField
		  z:=(FortyEight[*]K2). 
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(y2_ B2).
   Apply L4.
   Constructor.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e.
   Assumption.
 (* Finish *) 
 Apply px2.    
 (* To Prove that o < e/48K *)
 (* Start *)
   Apply mult_cancel_less with
	          R:=a_COrdField
		  z:=(FortyEight[*]K1). 
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(x1_ B1).
   Apply I4.
   Constructor.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e.
   Assumption.
 (* Finish *)  
 Apply px1.
  (* To Prove that o < e/48K *)
 (* Start *)
   Apply mult_cancel_less with
	          R:=a_COrdField
		  z:=(FortyEight[*]K2). 
   Apply mult_resp_pos.
   Apply nring_pos.
   Apply lt_O_Sn.
   Apply AbsSmall_pos with x:=(y2_ B2).
   Apply L4.
   Constructor.
   Step_Rat_less_lft Zero::a_COrdField.
   Step_Rat_less_rht e.
   Assumption.
  (* Finish *)
     
 Apply mult_resp_ap_zero.
 Apply Greater_imp_ap.
 Apply nring_pos.
 Apply lt_O_Sn.
 Assumption.     

 Apply mult_resp_ap_zero.
 Apply Greater_imp_ap.
 Apply nring_pos.
 Apply lt_O_Sn.
 Assumption. 

 Apply CS_seq_bounded.
 Exact py2.
 Apply CS_seq_bounded.
 Exact px1.
 Change ((EX e:(a_COrdField) |
      (Zero [:<] e)
      /\(EX N:nat |
           (m:nat)(le N m)-> 
 ((CS_seq a_COrdField (Rmult (Build_CauchySeq a_COrdField x1_ px1)
            (Build_CauchySeq a_COrdField x2_ px2)) m)[-]
  (CS_seq a_COrdField (Rmult (Build_CauchySeq a_COrdField y1_ py1)
            (Build_CauchySeq a_COrdField y2_ py2)) m)[:<][--]e)\/
 (e[:<](CS_seq a_COrdField (Rmult (Build_CauchySeq a_COrdField x1_ px1)
            (Build_CauchySeq a_COrdField x2_ px2)) m)[-]
  (CS_seq a_COrdField (Rmult (Build_CauchySeq a_COrdField y1_ py1)
            (Build_CauchySeq a_COrdField y2_ py2)) m))))).
 Apply ap_R_alt_1.
 Assumption.
Qed.



Theorem Rmult_is_well_defined:(bin_fun_well_def R_as_CSetoid' R_as_CSetoid' 
		R_as_CSetoid' Rmult).
 Red.
 Intros.
 Apply not_ap_imp_eq.
 Intro.
 Cut (~(x1[#]x2)).
 Intro.
 Cut (~(y1[#]y2)).
 Intro.
 Cut (~((x1 [#] x2)\/(y1 [#] y2))).
 Intro.
 Apply H4.
 Apply Rmult_is_extensional.
 Assumption.
 Intro.
 Case H4.
 Assumption.
 Assumption.
 Apply eq_imp_not_ap.
 Assumption.
 Apply eq_imp_not_ap.
 Assumption.
Qed.

Definition Rmult_is_bin_fun:=(!Build_CSetoid_bin_fun R_as_CSetoid' R_as_CSetoid'
		R_as_CSetoid' Rmult Rmult_is_well_defined Rmult_is_extensional).

 
Theorem Rmult_is_assoc:(associative R_as_CSetoid' Rmult_is_bin_fun).
 Red. 
 Simpl.
 Intros.
 Unfold EqR.
 Apply Eq_alt_2_2.
 Intros.
 Exists O.
 Intros.
 Unfold Rmult.
 Simpl.
 Change((absLSmall a_COrdField e
     ((CS_seq a_COrdField x m)[*]
       ((CS_seq a_COrdField y m)[*](CS_seq a_COrdField z m)))
       [-](((CS_seq a_COrdField x m)[*](CS_seq a_COrdField y m))[*]
     (CS_seq a_COrdField z m)))).
 Step_Rat_AbsLSmall_rht Zero::a_COrdField.
 Unfold absLSmall.
 Split.
 Apply less_leEq.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Apply less_leEq.
 Assumption.
Qed.

Lemma CS_seq_ONER:(Cauchy_prop [m:nat]One::a_COrdField).
 Red.
 Intros.
 Exists O.
 Intros.
 Step_Rat_AbsSmall_rht Zero::a_COrdField.
 Unfold absSmall.
 Split.
 Apply min_cancel_less.
 Step_Rat_less_lft Zero::a_COrdField.
 Step_Rat_less_rht e.
 Assumption.
 Assumption.
Qed.

Definition ONER := (Build_CauchySeq a_COrdField [m:nat]One::a_COrdField
	CS_seq_ONER):R'.

Definition R_mul_as_CSemi_grp := (!Build_CSemi_grp R_as_CSetoid' ONER
 Rmult_is_bin_fun Rmult_is_assoc).

End R_mul_CSemi_grp.

