/*
 * Decompiled with CFR 0.152.
 */
package jason.client;

import jason.client.XORKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class XORCipher
extends CipherSpi {
    private byte[] key = new byte[8];
    private int keyIndex;
    private String mode;
    private String padding;
    public static final int BLOCKSIZE = 8;

    public int engineGetBlockSize() {
        return 8;
    }

    public int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof XORKey) {
            return ((XORKey)key).getEncoded().length;
        }
        throw new InvalidKeyException("XORKey expected");
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.mode = string;
    }

    public byte[] engineGetIV() {
        return null;
    }

    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    public int engineGetOutputSize(int n) {
        return n;
    }

    public byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(byArray, n, n2);
    }

    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    public void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        System.arraycopy(byArray, 0, this.key, 0, byArray.length);
        this.keyIndex = 0;
    }

    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray = key.getEncoded();
        System.arraycopy(byArray, 0, this.key, 0, byArray.length);
        this.keyIndex = 0;
    }

    public void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray = key.getEncoded();
        System.arraycopy(byArray, 0, this.key, 0, byArray.length);
        this.keyIndex = 0;
    }

    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = n;
        while (n4 < n + n2) {
            byArray2[n3++] = (byte)(byArray[n4] ^ this.key[this.keyIndex]);
            this.keyIndex = (this.keyIndex + 1) % this.key.length;
            ++n4;
        }
        return n2;
    }

    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
        try {
            n3 = this.engineUpdate(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            n3 = 0;
        }
        if (byArray2.length == n3) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        this.padding = string;
    }
}

