/*
 * Decompiled with CFR 0.152.
 */
package jason.client;

import jason.client.XORPrivateKey;
import jason.client.XORPublicKey;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.util.Arrays;

public class XORSignature
extends SignatureSpi {
    private XORPrivateKey privateKey;
    private XORPublicKey publicKey;
    private static final int SIGNATURE_LENGTH = 8;
    private int offset = 0;
    private byte[] buffer = new byte[8];

    public boolean engineVerify(byte[] byArray) throws SignatureException {
        return Arrays.equals(byArray, this.buffer);
    }

    public Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    public void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = (XORPrivateKey)privateKey;
        this.publicKey = new XORPublicKey(this.privateKey);
        int n = 0;
        while (n < 8) {
            this.buffer[n] = 0;
            ++n;
        }
        this.offset = 0;
        byte[] byArray = this.publicKey.getEncoded();
        try {
            this.engineUpdate(byArray, 0, byArray.length);
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
    }

    public byte[] engineSign() throws SignatureException {
        return this.buffer;
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.privateKey = null;
        this.publicKey = (XORPublicKey)publicKey;
        int n = 0;
        while (n < 8) {
            this.buffer[n] = 0;
            ++n;
        }
        this.offset = 0;
        byte[] byArray = publicKey.getEncoded();
        try {
            this.engineUpdate(byArray, 0, byArray.length);
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
    }

    public void engineUpdate(byte by) throws SignatureException {
        int n = this.offset;
        this.buffer[n] = (byte)(this.buffer[n] ^ by);
        this.offset = (this.offset + 1) % 8;
    }

    public void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        int n3 = n;
        while (n3 < n + n2) {
            this.engineUpdate(byArray[n3]);
            ++n3;
        }
    }
}

