package jason.client;

import java.security.*;
import java.security.spec.*;

public class MySignature {
	private XORSignature sigSpi;

	public MySignature(SignatureSpi signaturespi) {
		sigSpi = (XORSignature) signaturespi;
	}

	public void initVerify(PublicKey publickey)	throws InvalidKeyException {
		sigSpi.engineInitVerify(publickey);
	}

	public void initSign(PrivateKey privatekey)	throws InvalidKeyException {
		sigSpi.engineInitSign(privatekey);
	}

	public void update(byte byte0) throws SignatureException {
		sigSpi.engineUpdate(byte0);
	}

	public void update(byte abyte0[], int i, int j)	throws SignatureException {
		sigSpi.engineUpdate(abyte0, i, j);
	}

	public byte[] sign() throws SignatureException {
		return sigSpi.engineSign();
	}

	public int sign(byte abyte0[], int i, int j) throws SignatureException {
		byte[] buffer = sign();
		System.arraycopy(buffer, 0, abyte0, i, j);
		return buffer.length;
	}

	public boolean verify(byte abyte0[]) throws SignatureException {
		return sigSpi.engineVerify(abyte0);
	}

	public void setParameter(String s, Object obj) throws InvalidParameterException {
		sigSpi.engineSetParameter(s, obj);
	}

	public void setParameter(AlgorithmParameterSpec algorithmparameterspec) throws InvalidAlgorithmParameterException {
		sigSpi.engineSetParameter("Parameter", "Value");
	}

	public Object getParameter(String s) throws InvalidParameterException	{
		return sigSpi.engineGetParameter(s);
	}}