package jason.client;

import javax.crypto.*;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class XORCipher extends CipherSpi {
  private byte[] key;
  private int keyIndex;
  private String mode;
	private String padding;

  public static final int BLOCKSIZE = 8;

  public XORCipher() {
    super();
    key = new byte[8];
  }

  public int engineGetBlockSize() {
    return BLOCKSIZE;
  }

	public int engineGetKeySize(Key key) throws InvalidKeyException {
		if (key instanceof XORKey)
			return ((XORKey) key).getEncoded().length;
		else
			throw new InvalidKeyException ("XORKey expected");
	}

  public void engineSetMode(String mode) throws NoSuchAlgorithmException {
  	this.mode = mode;
  }

  public byte[] engineGetIV() {
    return null;
  }

  public int engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
    return engineUpdate(input, inputOffset, inputLength, output, outputOffset);
  }

  public int engineGetOutputSize(int inputLength) {
    return inputLength;
  }

  public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLength) throws IllegalBlockSizeException, BadPaddingException {
    return engineUpdate(input, inputOffset, inputLength);
  }

  public AlgorithmParameters engineGetParameters() {
    return null;
  }

  public void engineInit(int mode, Key key, SecureRandom random) throws InvalidKeyException {
		byte[] data = key.getEncoded();
		System.arraycopy(data, 0, this.key, 0, data.length);
		keyIndex = 0;
  }

  public void engineInit(int mode, Key key, AlgorithmParameters parms, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
		byte[] data = key.getEncoded();
		System.arraycopy(data, 0, this.key, 0, data.length);
		keyIndex = 0;
  }

  public void engineInit(int mode, Key key, AlgorithmParameterSpec parms, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
		byte[] data = key.getEncoded();
		System.arraycopy(data, 0, this.key, 0, data.length);
		keyIndex = 0;
  }

  public int engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException {
    for (int i=inputOffset; i<inputOffset+inputLength; i++) {
      output[outputOffset++] = (byte) (input[i] ^ key[keyIndex]);
//      key[keyIndex] ^= output[outputOffset++];
      keyIndex = (keyIndex+1) % key.length;
    }
    return inputLength;
  }

  public byte[] engineUpdate(byte[] input, int inputOffset, int inputLength) {
    byte[] result = new byte[engineGetOutputSize(inputLength)];
    int outputLength;
    try {
      outputLength = engineUpdate(input, inputOffset, inputLength, result, 0);
    }
    catch (ShortBufferException e) {
      outputLength = 0;
    }
    if (result.length == outputLength)
      return result;
    else {
      byte[] cropped = new byte[outputLength];
      System.arraycopy(result, 0, cropped, 0, outputLength);
      return cropped;
    }
  }

  public void engineSetPadding(String padding) throws NoSuchPaddingException {
		this.padding = padding;
  }
}