package example.client;

import com.sun.javacard.javax.smartcard.rmiclient.*;
import jason.client.*;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.security.SecureRandom;
import javacard.security.KeyBuilder;
import example.purse.Purse;

public class Personalize {
	public static final byte[] aid = {0x33, 0x04, 0x00, 0x00, 0x00, 0x00};
	public static final byte ROLE_CARD = (byte) 0;

	public static void main(String[] args) throws Exception {
		SecureCardAccessor cardAccessor = new SecureCardAccessor();

		cardAccessor.setRemote("localhost", 8080);
		System.out.println("RMI connecting....");
		JavaCardRMIConnect javaCardRMIConnect = new JavaCardRMIConnect(cardAccessor);
		System.out.println("selectApplet");
		javaCardRMIConnect.selectApplet(aid);

		System.out.println("Initializing SecureRandom...");
		SecureRandom random = new SecureRandom();
		KeyStore keyStore = new KeyStore();

		System.out.println("MERCHANT:");
		byte[] buffer = new byte[16];
		random.nextBytes(buffer);
		XORPrivateKey privateKey = new XORPrivateKey(buffer);
		XORPublicKey publicKey = new XORPublicKey(privateKey);
		System.out.println("\tPrivateKey = " + arrayToString(privateKey.getEncoded()));
		System.out.println("\tPublicKey  = " + arrayToString(publicKey.getEncoded()));
		keyStore.setKey(Purse.ROLE_MERCHANT, privateKey, "XOR");
		System.out.print("\tSending public key MERCHANT...  ");
		if (cardAccessor.putKey(Purse.ROLE_MERCHANT, (byte) 0x89, publicKey, KeyBuilder.TYPE_DES))
			System.out.println("successfull");
		else
			System.out.println("failed");

		System.out.println("BANK:");
		buffer = new byte[16];
		random.nextBytes(buffer);
		privateKey = new XORPrivateKey(buffer);
		publicKey = new XORPublicKey(privateKey);
		System.out.println("\tPrivateKey = " + arrayToString(privateKey.getEncoded()));
		System.out.println("\tPublicKey  = " + arrayToString(publicKey.getEncoded()));
		keyStore.setKey(Purse.ROLE_BANK, privateKey, "XOR");
		System.out.print("\tSending public key BANK...  ");
		if (cardAccessor.putKey(Purse.ROLE_BANK, (byte) 0x89, publicKey, KeyBuilder.TYPE_DES))
			System.out.println("successfull");
		else
			System.out.println("failed");

		System.out.println("OWNER");
		buffer = new byte[16];
		random.nextBytes(buffer);
		privateKey = new XORPrivateKey(buffer);
		publicKey = new XORPublicKey(privateKey);
		System.out.println("\tPrivateKey = " + arrayToString(privateKey.getEncoded()));
		System.out.println("\tPublicKey  = " + arrayToString(publicKey.getEncoded()));
		keyStore.setKey(Purse.ROLE_OWNER, privateKey, "XOR");
		System.out.print("\tSending public key OWNER...  ");
		if (cardAccessor.putKey(Purse.ROLE_OWNER, (byte) 0x89, publicKey, KeyBuilder.TYPE_DES))
			System.out.println("successfull");
		else
			System.out.println("failed");

		System.out.println("CARD:");
		buffer = new byte[16];
		random.nextBytes(buffer);
		privateKey = new XORPrivateKey(buffer);
		publicKey = new XORPublicKey(privateKey);
		System.out.println("\tPrivateKey = " + arrayToString(privateKey.getEncoded()));
		System.out.println("\tPublicKey  = " + arrayToString(publicKey.getEncoded()));
		keyStore.setKey(ROLE_CARD, publicKey, "XOR");
		System.out.print("\tSending private key CARD...  ");
		if (cardAccessor.putKey(ROLE_CARD, (byte) 0x88, privateKey, KeyBuilder.TYPE_DES))
			System.out.println("successfull");
		else
			System.out.println("failed");

		System.out.println("Writing keystore.dat...");
		ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream("keystore.dat"));
		output.writeObject(keyStore);
		output.close();
	}

	private static String arrayToString(byte[] data) {
		StringBuffer buffer = new StringBuffer();
		if (data != null)
			for (int i=0; i<data.length; i++) {
				String str = Integer.toHexString(data[i] & 0xFF);
				if (str.length() < 2)
					buffer.append('0');
				buffer.append(str);
				buffer.append(' ');
			}
		return buffer.toString();
	}
}