package javacard.security;

public class XORKey implements DESKey {
  public static final byte KEYLENGTH = (byte) 8;

  private byte[] key;
  private boolean initialized;

  public XORKey() {
    key = new byte[KEYLENGTH];
    initialized = false;
  }

  public void setKey(byte[] keyData, short offset) throws CryptoException, NullPointerException, ArrayIndexOutOfBoundsException {
    for (short i=0; i<KEYLENGTH; i++)
      key[i] = keyData[(short) (i+offset)];
    initialized = true;
  }

  public byte getKey(byte[] keyData, short offset) {
    for (short i=0; i<KEYLENGTH; i++)
      keyData[(short) (i+offset)] = key[i];
    return KEYLENGTH;
  }

  public boolean isInitialized() {
    return initialized;
  }

  public void clearKey() {
    for (short i=0; i<KEYLENGTH; i++)
      key[i] = (byte) 0;
  }

  public byte getType() {
    return KeyBuilder.TYPE_DES;
  }

  public short getSize() {
    return (short) (8*KEYLENGTH);
  }
}