package javacardx.crypto;

import javacard.security.CryptoException;
import javacard.security.Key;

public abstract class Cipher {
  public static final byte MODE_DECRYPT = (byte) 0;
  public static final byte MODE_ENCRYPT = (byte) 1;
  public static final byte ALG_XOR = (byte) 0x50;

  protected Cipher() {
  }

  public static final Cipher getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
    return new XORCipher();
    //return null;
  }

  public abstract void init(Key theKey, byte theMode) throws CryptoException;

  public abstract void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException;

  public abstract byte getAlgorithm();

  public abstract short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException;

  public abstract short update(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException;
}
