package jason.terminal;

import java.io.IOException;
import java.rmi.Naming;
import java.rmi.server.UnicastRemoteObject;
import opencard.core.service.*;
import opencard.core.terminal.CardTerminalException;

public class Main {
	public static void main(String[] args) throws Exception {
		SmartCard.start();
		CardRequest cardRequest = new CardRequest(CardRequest.ANYCARD, null, RemoteCardAccessor.class);
		SmartCard smartCard = SmartCard.waitForCard(cardRequest);
		RemoteCardAccessor remoteCardAccessor = (RemoteCardAccessor) smartCard.getCardService(RemoteCardAccessor.class, true);
		UnicastRemoteObject.exportObject(remoteCardAccessor);
		Naming.rebind("//localhost:8080/RemoteCardAccessor", remoteCardAccessor);
		System.out.println("RemoteCardAccessor is running.");
		System.out.println("Press enter to shutdown the terminal.");
		new ShutdownThread().start();
	}

	static class ShutdownThread extends Thread {
		public void run() {
			try {
				while (System.in.available() <= 0)
					sleep(1000);
			}
			catch (IOException ioe) {}
			catch (InterruptedException ie) {}
			try {
				SmartCard.shutdown();
			}
			catch (CardTerminalException cte) {
				System.err.println("Could not shutdown terminal");
			}
			System.out.println("Terminal is shutdown");
			System.exit(0);
		}
	}
}